/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.jar;

import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.ejb.descriptors.xml.InqmyEjbGenerator;
import com.sap.engine.deploy.ejb.descriptors.xml.XMLPersistentGenerator;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.w3c.dom.Document;

public class MakeEjbJar
extends JarUtils {
    private Vector additionalFiles = null;
    private EJBJarDescriptor jarDescr = null;
    private DynamicClassLoader loader = null;
    private Vector names = new Vector();
    private boolean additionalMode = false;
    private StandardDOMWriter writer = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public MakeEjbJar() {
        this.initXMLToolkit();
    }

    public MakeEjbJar(EJBJarDescriptor jar, DynamicClassLoader loader) {
        this.initXMLToolkit();
        this.jarDescr = jar;
        this.loader = loader;
    }

    public void setDescriptors(Vector descriptors) {
        Object[] ejbDescriptors = new DeploymentDescriptor[descriptors.size()];
        descriptors.copyInto(ejbDescriptors);
        this.jarDescr.setDescriptors((DeploymentDescriptor[])ejbDescriptors);
    }

    public void setDescriptors(DeploymentDescriptor[] descriptors) {
        this.jarDescr.setDescriptors(descriptors);
    }

    public void makeJar(String jarName) throws IOException {
        this.initNames();
        this.makeJarFromFiles(jarName, this.getAllFiles());
    }

    public void makeJar(String jarName, String additional) throws IOException {
        this.initNames();
        this.setAdditionalPaths(additional);
        this.makeJarFromFiles(jarName, this.getAllFiles());
    }

    private void initNames() {
        String className = "";
        DeploymentDescriptor dsd = null;
        DeploymentDescriptor[] descriptors = this.jarDescr.getDDescriptors();
        if (descriptors != null && descriptors.length != 0) {
            int i = 0;
            while (i < descriptors.length) {
                dsd = descriptors[i];
                if (dsd != null) {
                    className = dsd.getRemoteInterface();
                    if (className != null && !className.trim().equals("")) {
                        this.names.addElement(className);
                    }
                    if ((className = dsd.getLocalInterface()) != null && !className.trim().equals("")) {
                        this.names.addElement(className);
                    }
                    if ((className = dsd.getRemoteHomeInterface()) != null && !className.trim().equals("")) {
                        this.names.addElement(className);
                    }
                    if ((className = dsd.getLocalHomeInterface()) != null && !className.trim().equals("")) {
                        this.names.addElement(className);
                    }
                    if ((className = dsd.getClassName()) != null && !className.trim().equals("")) {
                        this.names.addElement(className);
                    }
                    if (dsd instanceof EntityDescriptor && (className = ((EntityDescriptor)dsd).getPrimaryKeyClass().trim()) != null && !className.equals("") && !this.isUserDefinedClass(className)) {
                        this.names.addElement(className);
                    }
                }
                ++i;
            }
        }
    }

    public void writeAdditionalEntries(JarOutputStream zip) throws IOException {
        block18: {
            EJB20DescriptorDocument doc = new EJB20DescriptorDocument();
            DeploymentDescriptor[] descriptors = this.jarDescr.getDDescriptors();
            Document document = null;
            byte[] buffer = null;
            JarEntry zEntry = null;
            CRC32 crc = null;
            try {
                if (this.jarDescr == null) {
                    throw new BaseIOException("xml_ejb_4105");
                }
                try {
                    document = doc.loadEJBJarDescriptor(this.jarDescr);
                }
                catch (IllegalArgumentException e) {
                    throw new BaseIOException("xml_ejb_4106", new String[]{e.toString()}, (Throwable)e);
                }
                String tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "tmp_ejb_descr0.xml" + System.currentTimeMillis();
                File tmpFile = new File(tmpFileName);
                this.writer.write(document, tmpFileName, "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>", "UTF-8");
                zEntry = new JarEntry("META-INF/ejb-jar.xml");
                buffer = this.getBytes(new FileInputStream(tmpFileName));
                if (buffer != null) {
                    zEntry.setMethod(0);
                    zEntry.setSize(buffer.length);
                    crc = new CRC32();
                    crc.update(buffer);
                    zEntry.setCrc(crc.getValue());
                    zip.putNextEntry(zEntry);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                    tmpFile.delete();
                    this.addDirEntries(zip, zEntry.getName());
                }
                if (!this.hasManifest(this.additionalFiles)) {
                    zEntry = new JarEntry("META-INF/MANIFEST.MF");
                    zEntry.setSize(0L);
                    crc = new CRC32();
                    buffer = new byte[]{};
                    crc.update(buffer);
                    zEntry.setCrc(crc.getValue());
                    zip.putNextEntry(zEntry);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                }
                if (!this.additionalMode) break block18;
                InqmyEjbGenerator document2 = new InqmyEjbGenerator();
                XMLPersistentGenerator document3 = new XMLPersistentGenerator();
                document = document2.generateXML(this.jarDescr);
                if (document != null && document.getDocumentElement() != null) {
                    tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "ejb-j2ee-engine0.xml" + System.currentTimeMillis();
                    tmpFile = new File(tmpFileName);
                    this.writer.write(document, tmpFileName, "<!DOCTYPE ejb-j2ee-engine SYSTEM 'ejb-j2ee-engine.dtd'>", "UTF-8");
                    zEntry = new JarEntry("META-INF/ejb-j2ee-engine.xml");
                    buffer = this.getBytes(new FileInputStream(tmpFile));
                    if (buffer != null) {
                        zEntry.setMethod(0);
                        zEntry.setSize(buffer.length);
                        crc = new CRC32();
                        crc.update(buffer);
                        zEntry.setCrc(crc.getValue());
                        zip.putNextEntry(zEntry);
                        zip.write(buffer, 0, buffer.length);
                        zip.closeEntry();
                        tmpFile.delete();
                        this.addDirEntries(zip, zEntry.getName());
                    }
                }
                if (!this.hasCMPBeans(this.jarDescr)) break block18;
                tmpFileName = SystemProperties.getProperty((String)"user.dir") + File.separator + "persisntent0.xml" + System.currentTimeMillis();
                tmpFile = new File(tmpFileName);
                Document doc1 = document3.generateDocument(this.jarDescr);
                this.writer.write(doc1, tmpFileName, " <!DOCTYPE persistent-ejb-map SYSTEM 'persistent.dtd'>", "UTF-8");
                zEntry = new JarEntry("META-INF/persisntent.xml");
                buffer = this.getBytes(new FileInputStream(tmpFileName));
                if (buffer == null) break block18;
                zEntry.setMethod(0);
                zEntry.setSize(buffer.length);
                crc = new CRC32();
                crc.update(buffer);
                zEntry.setCrc(crc.getValue());
                zip.putNextEntry(zEntry);
                zip.write(buffer, 0, buffer.length);
                zip.closeEntry();
                tmpFile.delete();
                this.addDirEntries(zip, zEntry.getName());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new BaseIOException("xml_ejb_4107", new String[]{e.toString()}, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getBytes(InputStream in) throws IOException {
        int c;
        if (in == null) {
            return null;
        }
        byte[] buff = null;
        ByteArrayOutputStream b = null;
        b = in.available() > 1 ? new ByteArrayOutputStream(in.available()) : new ByteArrayOutputStream();
        BufferedInputStream bin = new BufferedInputStream(in);
        while ((c = bin.read()) != -1) {
            void var3_6;
            b.write((int)var3_6);
        }
        b.flush();
        b.close();
        bin.close();
        buff = b.toByteArray();
        in.close();
        return buff;
    }

    private boolean isUserDefinedClass(String className) {
        if (className == null) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Integer == null ? (class$java$lang$Integer = MakeEjbJar.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || className.equalsIgnoreCase("int")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Byte == null ? (class$java$lang$Byte = MakeEjbJar.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || className.equalsIgnoreCase("byte")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Character == null ? (class$java$lang$Character = MakeEjbJar.class$("java.lang.Character")) : class$java$lang$Character).getName()) || className.equalsIgnoreCase("char")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Short == null ? (class$java$lang$Short = MakeEjbJar.class$("java.lang.Short")) : class$java$lang$Short).getName()) || className.equalsIgnoreCase("short")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Long == null ? (class$java$lang$Long = MakeEjbJar.class$("java.lang.Long")) : class$java$lang$Long).getName()) || className.equalsIgnoreCase("long")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Double == null ? (class$java$lang$Double = MakeEjbJar.class$("java.lang.Double")) : class$java$lang$Double).getName()) || className.equalsIgnoreCase("double")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Float == null ? (class$java$lang$Float = MakeEjbJar.class$("java.lang.Float")) : class$java$lang$Float).getName()) || className.equalsIgnoreCase("float")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$String == null ? (class$java$lang$String = MakeEjbJar.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Boolean == null ? (class$java$lang$Boolean = MakeEjbJar.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || className.equalsIgnoreCase("boolean")) {
            return false;
        }
        return !className.equalsIgnoreCase((class$java$lang$Object == null ? (class$java$lang$Object = MakeEjbJar.class$("java.lang.Object")) : class$java$lang$Object).getName());
    }

    public boolean isAdditionalMode() {
        return this.additionalMode;
    }

    public void setAdditionalMode(boolean additionalMode) {
        this.additionalMode = additionalMode;
    }

    public Vector getAdditionalFiles() {
        return this.additionalFiles;
    }

    public void setAdditionalFiles(Vector additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    private boolean hasCMPBeans(EJBJarDescriptor archDescr) {
        DeploymentDescriptor[] descr = archDescr.getDDescriptors();
        int i = 0;
        while (i < descr.length) {
            if (descr[i] instanceof CMPEntityDescriptor) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Vector getAllFiles() {
        Vector result = new Vector();
        if (this.additionalFiles != null) {
            String entryInAdditionalFiles = null;
            String entryInDependances = null;
            boolean nothingToDo = false;
            int i = 0;
            while (i < this.additionalFiles.size()) {
                entryInAdditionalFiles = ((InfoObject)this.additionalFiles.elementAt(i)).getEntryName().replace('\\', '/');
                nothingToDo = false;
                int j = 0;
                while (j < result.size()) {
                    entryInDependances = ((InfoObject)result.elementAt(j)).getEntryName().replace('\\', '/');
                    if (entryInAdditionalFiles.equals(entryInDependances)) {
                        nothingToDo = true;
                    }
                    ++j;
                }
                if (!nothingToDo) {
                    result.add(this.additionalFiles.elementAt(i));
                }
                ++i;
            }
        }
        return result;
    }

    protected boolean hasManifest(Vector infos) {
        if (infos == null) {
            return false;
        }
        InfoObject inf = null;
        int i = 0;
        while (i < infos.size()) {
            inf = (InfoObject)infos.elementAt(i);
            if (inf != null && inf.getEntryName() != null) {
                if (inf.getEntryName().equalsIgnoreCase("meta-inf/Manifest.mf")) {
                    return true;
                }
                if (inf.getEntryName().equalsIgnoreCase("meta-inf\\Manifest.mf")) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.writer = new StandardDOMWriter();
        Thread.currentThread().setContextClassLoader(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

