/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.dbstorage;

import com.sap.engine.deploy.ejb.descriptors.dbstorage.FieldColumnMap;
import com.sap.engine.deploy.ejb.descriptors.dbstorage.FinderDescriptor;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentStorageEditor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentStorageProperties;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGenerator;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGeneratorsHolder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RDBMSStorageProperties
extends PersistentStorageProperties {
    private StatementGeneratorsHolder holder = null;
    private AbstractSchema schema = null;
    private FinderDescriptor[] finderDescriptors = null;
    private com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor[] newFinderDescr = null;
    private FieldColumnMap[] fieldColumnMaps = null;
    private CMPEntityDescriptor cmpDescr = null;
    private EJBJarDescriptor jarDescr = null;
    private String poolName = null;
    private String tableName = null;
    private boolean tableOwner = false;
    private int cacheSize = 0;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public RDBMSStorageProperties() {
    }

    public RDBMSStorageProperties(String pool, String table, boolean owner, int cache, FieldColumnMap[] fields, FinderDescriptor[] finders) {
        this.poolName = pool;
        this.tableName = table;
        this.fieldColumnMaps = fields;
        this.finderDescriptors = finders;
    }

    public void setJarDescriptor(EJBJarDescriptor jarDescr) {
        if (this.jarDescr != jarDescr) {
            this.jarDescr = jarDescr;
            this.schema = jarDescr.getAbstractSchema();
            this.holder = new StatementGeneratorsHolder(this.schema);
        }
    }

    public void init(EntityDescriptor entityDescr) {
        PersistentField[] pkCmp = null;
        PersistentField[] cmp = null;
        int pos = 0;
        this.cmpDescr = (CMPEntityDescriptor)entityDescr;
        StatementGenerator generator = this.holder.getStatementGenerator(this.cmpDescr.getId());
        this.poolName = this.schema.getDBProperties().getDataSourceName();
        this.tableName = this.cmpDescr.getTableName();
        pkCmp = generator.getPKCmpInfo();
        cmp = generator.getCmpInfo();
        this.fieldColumnMaps = new FieldColumnMap[pkCmp.length + cmp.length];
        int i = 0;
        while (i < pkCmp.length) {
            this.fieldColumnMaps[pos++] = new FieldColumnMap(pkCmp[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < cmp.length) {
            this.fieldColumnMaps[pos++] = new FieldColumnMap(cmp[i2]);
            ++i2;
        }
        this.newFinderDescr = this.cmpDescr.getFinderDescriptors();
        this.finderDescriptors = new FinderDescriptor[this.newFinderDescr.length];
        int i3 = 0;
        while (i3 < this.newFinderDescr.length) {
            this.finderDescriptors[i3] = new FinderDescriptor(this.newFinderDescr[i3]);
            ++i3;
        }
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(boolean isOwner) {
        this.tableOwner = isOwner;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public FieldColumnMap[] getFieldColumnMaps() {
        return this.fieldColumnMaps;
    }

    public void setFieldColumnMaps(FieldColumnMap[] maps) {
        this.fieldColumnMaps = maps;
        if (this.fieldColumnMaps != null && this.tableName != null && !this.tableName.trim().equals("")) {
            int j = 0;
            while (j < this.fieldColumnMaps.length) {
                if (this.fieldColumnMaps[j] != null && (this.fieldColumnMaps[j].getTable() == null || this.fieldColumnMaps[j].getTable().trim().equals(""))) {
                    this.fieldColumnMaps[j].setTable(this.tableName);
                }
                ++j;
            }
        }
    }

    public FieldColumnMap getFieldColumnMaps(int index) {
        return this.fieldColumnMaps[index];
    }

    public void setFieldColumnMaps(int index, FieldColumnMap map) {
        if (this.fieldColumnMaps == null || index >= this.fieldColumnMaps.length) {
            FieldColumnMap[] aFieldColumnMaps = new FieldColumnMap[index + 1];
            if (this.fieldColumnMaps != null) {
                int j = 0;
                while (j < this.fieldColumnMaps.length) {
                    aFieldColumnMaps[j] = this.fieldColumnMaps[j];
                    if (aFieldColumnMaps[j].getTable().equals("")) {
                        aFieldColumnMaps[j].setTable(this.tableName);
                    }
                    ++j;
                }
            }
            this.fieldColumnMaps = aFieldColumnMaps;
        }
        this.fieldColumnMaps[index] = map;
    }

    public FieldColumnMap getFieldColumnMap(Field field) {
        if (this.fieldColumnMaps == null) {
            return null;
        }
        int i = 0;
        while (i < this.fieldColumnMaps.length) {
            if (this.equals(field, this.fieldColumnMaps[i].getField())) {
                return this.fieldColumnMaps[i];
            }
            ++i;
        }
        return null;
    }

    public FieldColumnMap getFieldColumnMap(String fieldName) {
        if (this.fieldColumnMaps == null || fieldName == null) {
            return null;
        }
        int i = 0;
        while (i < this.fieldColumnMaps.length) {
            if (fieldName.equals(this.fieldColumnMaps[i].getName())) {
                return this.fieldColumnMaps[i];
            }
            ++i;
        }
        return null;
    }

    public void addFieldColumnMap(FieldColumnMap fieldMap) {
        FieldColumnMap fcm = this.getFieldColumnMap(fieldMap.getName());
        if (fcm != null) {
            fcm = fieldMap;
        } else {
            int i = this.fieldColumnMaps == null ? 0 : this.fieldColumnMaps.length;
            this.setFieldColumnMaps(i, fieldMap);
        }
    }

    public FinderDescriptor[] getFinderDescriptors() {
        return this.finderDescriptors;
    }

    public void setFinderDescriptors(FinderDescriptor[] fds) {
        this.finderDescriptors = fds;
    }

    public FinderDescriptor getFinderDescriptors(int index) {
        return this.finderDescriptors[index];
    }

    public void setFinderDescriptors(int index, FinderDescriptor fd) {
        if (this.finderDescriptors == null || index >= this.finderDescriptors.length) {
            FinderDescriptor[] aFinderDescriptors = new FinderDescriptor[index + 1];
            if (this.finderDescriptors != null) {
                int j = 0;
                while (j < this.finderDescriptors.length) {
                    aFinderDescriptors[j] = this.finderDescriptors[j];
                    ++j;
                }
            }
            this.finderDescriptors = aFinderDescriptors;
        }
        this.finderDescriptors[index] = fd;
    }

    public FinderDescriptor getFinderDescriptor(MethodEntry method) {
        if (this.finderDescriptors == null) {
            return null;
        }
        int i = 0;
        while (i < this.finderDescriptors.length) {
            if (method.equals(this.finderDescriptors[i].getMethodEntry())) {
                return this.finderDescriptors[i];
            }
            ++i;
        }
        return null;
    }

    public void addFinderDescriptor(FinderDescriptor fd) {
        FinderDescriptor afd = this.getFinderDescriptor(fd.getMethodEntry());
        if (afd != null) {
            afd = fd;
        } else {
            int i = this.finderDescriptors == null ? 0 : this.finderDescriptors.length;
            this.setFinderDescriptors(i, fd);
        }
    }

    public String getStorageName() {
        return "RDB Storage";
    }

    public String getStorageClassName() {
        return "com.sap.engine.deploy.ejb.descriptors.dbstorage.RDBMSStorageProperties";
    }

    public String getElementDTD() {
        String element_dtd = "<!ELEMENT RDBStorageProps (FieldColumnMap*, rdbFinderDescriptor*)>\n<!ATTLIST RDBStorageProps PoolName CDATA \"\" TableName CDATA \"\">\n<!ELEMENT FieldColumnMap (#PCDATA)>\n<!ATTLIST FieldColumnMap Field CDATA \"\" Table CDATA \"\" Column CDATA \"\" Key CDATA \"\">\n<!ELEMENT rdbFinderDescriptor (MethodArgument*)>\n<!ATTLIST rdbFinderDescriptor MethodName CDATA \"\" Criteria CDATA \"\" >\n<!ELEMENT MethodArgument (#PCDATA)>";
        return element_dtd;
    }

    public String getMainElementTag() {
        return "RDBStorageProps";
    }

    public Element getPersistentStorageAsElement(Document doc) {
        return this.initRDBStorage(doc);
    }

    public void setPersistentStorageAsElement(Element el, EntityDescriptor ed) {
    }

    public PersistentStorageEditor getStorageEditor() {
        return null;
    }

    public boolean isCorrect() {
        return true;
    }

    public CMPEntityDescriptor getUpdated() {
        Vector<PersistentField> vPKCmp = new Vector<PersistentField>();
        Vector<PersistentField> vCmp = new Vector<PersistentField>();
        this.schema.getDBProperties().setDataSourceName(this.poolName);
        this.cmpDescr.setTableName(this.tableName);
        PersistentField cmp = null;
        int i = 0;
        while (i < this.fieldColumnMaps.length) {
            cmp = this.fieldColumnMaps[i].getUpdated();
            if (this.fieldColumnMaps[i].getKey() == 1) {
                vPKCmp.addElement(cmp);
            } else {
                vCmp.addElement(cmp);
            }
            ++i;
        }
        this.cmpDescr.setPKCmpFields(vPKCmp.toArray(new PersistentField[vPKCmp.size()]));
        this.cmpDescr.setCmpFields(vCmp.toArray(new PersistentField[vCmp.size()]));
        if (this.finderDescriptors != null) {
            int i2 = 0;
            while (i2 < this.finderDescriptors.length) {
                this.newFinderDescr[i2] = this.finderDescriptors[i2].getUpdated();
                ++i2;
            }
            this.cmpDescr.setFinderDescriptors(this.newFinderDescr);
        }
        return this.cmpDescr;
    }

    public Object clone() {
        int i;
        RDBMSStorageProperties clone = new RDBMSStorageProperties();
        clone.setPoolName(this.poolName);
        clone.setTableName(this.tableName);
        clone.setTableOwner(this.tableOwner);
        clone.setCacheSize(this.cacheSize);
        if (this.fieldColumnMaps != null) {
            FieldColumnMap[] fcm = new FieldColumnMap[this.fieldColumnMaps.length];
            i = 0;
            while (i < fcm.length) {
                fcm[i] = this.fieldColumnMaps[i] != null ? (FieldColumnMap)this.fieldColumnMaps[i].clone() : null;
                ++i;
            }
            clone.setFieldColumnMaps(fcm);
        } else {
            clone.setFieldColumnMaps(null);
        }
        if (this.finderDescriptors != null) {
            FinderDescriptor[] fd = new FinderDescriptor[this.finderDescriptors.length];
            i = 0;
            while (i < fd.length) {
                if (this.finderDescriptors[i] != null) {
                    fd[i] = (FinderDescriptor)this.finderDescriptors[i].clone();
                }
                ++i;
            }
            clone.setFinderDescriptors(fd);
        } else {
            clone.setFinderDescriptors(null);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            RDBMSStorageProperties sp = (RDBMSStorageProperties)obj;
            if (!this.poolName.equals(sp.poolName)) {
                return false;
            }
            if (!this.tableName.equals(sp.tableName)) {
                return false;
            }
            if (this.tableOwner != sp.tableOwner && this.cacheSize != sp.cacheSize) {
                return false;
            }
            if (!this.equals(this.fieldColumnMaps, sp.fieldColumnMaps)) {
                return false;
            }
            return this.equals(this.finderDescriptors, sp.finderDescriptors);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean equals(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getType().getName().equals(field2.getType().getName());
    }

    private boolean equals(Method m1, Method m2) {
        Class<?>[] p2;
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getDeclaringClass().getName().equals(m2.getDeclaringClass().getName())) {
            return false;
        }
        Class<?>[] p1 = m1.getParameterTypes();
        if (p1.length != (p2 = m2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < p1.length) {
            if (!p1[i].getName().equals(p2[i].getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equals(FieldColumnMap[] map1, FieldColumnMap[] map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.length != map2.length) {
            return false;
        }
        int i = 0;
        while (i < map1.length) {
            boolean match = false;
            int j = 0;
            while (!match && j < map2.length) {
                if (map1[i].equals(map2[j])) {
                    match = true;
                }
                ++j;
            }
            if (!match) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean equals(FinderDescriptor[] fd1, FinderDescriptor[] fd2) {
        if (fd1 != null && fd1.length == 0) {
            fd1 = null;
        }
        if (fd2 != null && fd2.length == 0) {
            fd2 = null;
        }
        if (fd1 == null && fd2 == null) {
            return true;
        }
        if (fd1 == null || fd2 == null) {
            return false;
        }
        if (fd1.length != fd2.length) {
            return false;
        }
        int i = 0;
        while (i < fd1.length) {
            boolean match = false;
            int j = 0;
            while (!match && j < fd2.length) {
                if (fd1[i].equals(fd2[j])) {
                    match = true;
                }
                ++j;
            }
            if (!match) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Element initRDBStorage(Document document) {
        Element propsElement = document.createElement("RDBStorageProps");
        propsElement.setAttribute("PoolName", this.poolName);
        propsElement.setAttribute("TableName", this.tableName);
        this.initFieldMaps(propsElement, document);
        this.initRDBFinderDescriptors(propsElement, document);
        return propsElement;
    }

    private void initFieldMaps(Element rdbms, Document document) {
        if (this.fieldColumnMaps == null) {
            return;
        }
        int i = 0;
        while (i < this.fieldColumnMaps.length) {
            this.initFieldMap(rdbms, this.fieldColumnMaps[i], document);
            ++i;
        }
    }

    private void initFieldMap(Element rdbms, FieldColumnMap fieldmap, Document document) {
        Element fcmElement = document.createElement("FieldColumnMap");
        String value = fieldmap.getName();
        fcmElement.setAttribute("Field", value);
        value = fieldmap.getTable();
        fcmElement.setAttribute("Table", value);
        value = fieldmap.getColumn();
        fcmElement.setAttribute("Column", value);
        value = Integer.toString(fieldmap.getKey());
        fcmElement.setAttribute("Key", value);
        rdbms.appendChild(fcmElement);
    }

    private void initRDBFinderDescriptors(Element rdbms, Document document) {
        if (this.finderDescriptors == null) {
            return;
        }
        int i = 0;
        while (i < this.finderDescriptors.length) {
            this.initRDBFinderDescriptor(rdbms, this.finderDescriptors[i], document);
            ++i;
        }
    }

    private void initRDBFinderDescriptor(Element rdbms, FinderDescriptor fd, Document document) {
        if (fd == null) {
            return;
        }
        if (fd.getMethodName() != null && (fd.getMethodName().equals("findByPrimaryKey") || fd.getMethodName().equals("findAll"))) {
            return;
        }
        Element fdElement = document.createElement("rdbFinderDescriptor");
        String value = fd.getMethodName();
        fdElement.setAttribute("MethodName", value);
        value = fd.getCriteria();
        fdElement.setAttribute("Criteria", value);
        String[] params = fd.getParameters();
        Element paramEl = null;
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                paramEl = document.createElement("MethodArgument");
                paramEl.appendChild(document.createTextNode(params[i]));
                fdElement.appendChild(paramEl);
                ++i;
            }
        }
        rdbms.appendChild(fdElement);
    }

    private String[] loadMethodParamsAsString(Element fdElement) {
        NodeList list = fdElement.getElementsByTagName("MethodArgument");
        if (list == null) {
            return null;
        }
        String[] res = new String[list.getLength()];
        int i = 0;
        while (i < list.getLength()) {
            Element next = (Element)list.item(i);
            res[i] = next.getFirstChild().getNodeValue().trim();
            ++i;
        }
        return res;
    }

    public Class getPrimaryTypeClass(String className) {
        if (className == null) {
            return null;
        }
        if (className.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = RDBMSStorageProperties.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = RDBMSStorageProperties.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = RDBMSStorageProperties.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = RDBMSStorageProperties.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals((class$java$lang$Character == null ? (class$java$lang$Character = RDBMSStorageProperties.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
            return class$java$lang$Character == null ? (class$java$lang$Character = RDBMSStorageProperties.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals((class$java$lang$Short == null ? (class$java$lang$Short = RDBMSStorageProperties.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
            return class$java$lang$Short == null ? (class$java$lang$Short = RDBMSStorageProperties.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals((class$java$lang$Long == null ? (class$java$lang$Long = RDBMSStorageProperties.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
            return class$java$lang$Long == null ? (class$java$lang$Long = RDBMSStorageProperties.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals((class$java$lang$Double == null ? (class$java$lang$Double = RDBMSStorageProperties.class$("java.lang.Double")) : class$java$lang$Double).getName())) {
            return class$java$lang$Double == null ? (class$java$lang$Double = RDBMSStorageProperties.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals((class$java$lang$Float == null ? (class$java$lang$Float = RDBMSStorageProperties.class$("java.lang.Float")) : class$java$lang$Float).getName())) {
            return class$java$lang$Float == null ? (class$java$lang$Float = RDBMSStorageProperties.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals((class$java$lang$String == null ? (class$java$lang$String = RDBMSStorageProperties.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return class$java$lang$String == null ? (class$java$lang$String = RDBMSStorageProperties.class$("java.lang.String")) : class$java$lang$String;
        }
        if (className.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = RDBMSStorageProperties.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = RDBMSStorageProperties.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

