/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.ejb.descriptors.dbstorage;

import com.sap.engine.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.FieldEntry;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import java.io.Serializable;
import java.lang.reflect.Field;
import javax.naming.Name;

public class FieldColumnMap
implements Serializable,
Cloneable {
    static final long serialVersionUID = -6790430905453405238L;
    public static final int NO_KEY = 0;
    public static final int PRIMARY_KEY = 1;
    public static final int FOREIGN_KEY = 2;
    private RPersistentFieldMap cmpMap = null;
    private PersistentField cmpInfo = null;
    private Name foreignKeyEJBName = null;
    private FieldEntry field = null;
    private String column = "";
    private int key = 0;

    public FieldColumnMap(EntityDescriptor dd) {
    }

    public FieldColumnMap(String _field, String _table, String _column, int _key) {
        this.field = new FieldEntry();
        this.field.setName(_field);
        this.column = _column;
        this.key = _key;
        if (this.key < 0 || this.key > 2) {
            throw new BaseIllegalArgumentException("xml_ejb_4058", new Object[]{String.valueOf(this.key)});
        }
    }

    public FieldColumnMap(String _field, String _column, int _key) {
        this.field = new FieldEntry();
        this.field.setName(_field);
        this.column = _column;
        this.key = _key;
        if (this.key < 0 || this.key > 2) {
            throw new BaseIllegalArgumentException("xml_ejb_4058", new Object[]{String.valueOf(this.key)});
        }
    }

    public FieldColumnMap(String _field, String _table, String _column, int _key, EntityDescriptor dd) {
        this.field = new FieldEntry();
        this.field.setName(_field);
        this.column = _column;
        this.key = _key;
        if (this.key < 0 || this.key > 2) {
            throw new BaseIllegalArgumentException("xml_ejb_4058", new Object[]{String.valueOf(this.key)});
        }
    }

    public FieldColumnMap(Field _field, String _table, String _column, int _key, EntityDescriptor dd) {
        this.field = new FieldEntry(_field);
        this.column = _column;
        this.key = _key;
        if (this.key < 0 || this.key > 2) {
            throw new BaseIllegalArgumentException("xml_ejb_4058", new Object[]{String.valueOf(this.key)});
        }
    }

    public FieldColumnMap(PersistentField cmpInfo) {
        this.cmpInfo = cmpInfo;
        this.cmpMap = cmpInfo.getFieldDBMap();
        this.column = this.cmpMap.getColumnName();
        this.key = this.cmpMap.getKey();
        this.field = new FieldEntry();
        this.field.setName(cmpInfo.getFieldName());
    }

    public Field getField() {
        return this.field.getField();
    }

    public FieldEntry getFieldEntry() {
        return this.field;
    }

    public void setField(Field field) {
        this.field.setField(field);
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getTable() {
        return null;
    }

    public String getName() {
        if (this.field == null) {
            return null;
        }
        return this.field.getName();
    }

    public void setTable(String table) {
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public boolean isPrimaryKey() {
        return this.key == 1;
    }

    public boolean isForeignKey() {
        return this.key == 2;
    }

    public Name getForeignKeyEJBName() {
        return this.foreignKeyEJBName;
    }

    public void setForeignKeyEJBName(Name name) {
        this.foreignKeyEJBName = name;
    }

    public PersistentField getUpdated() {
        RPersistentFieldMap map = new RPersistentFieldMap();
        map.setColumnName(this.column);
        map.setKey(this.key);
        map.setColumnType(this.key);
        PersistentField pf = new PersistentField();
        pf.setFieldName(this.field.getName());
        pf.setFieldDBMap(map);
        return pf;
    }

    public RPersistentFieldMap getCmpMap() {
        return this.cmpMap;
    }

    public void setCmpMap(RPersistentFieldMap cmpMap) {
        this.cmpMap = cmpMap;
    }

    public PersistentField getCmpInfo() {
        return this.cmpInfo;
    }

    public void setCmpInfo(PersistentField cmpInfo) {
        this.cmpInfo = cmpInfo;
    }

    public void setField(FieldEntry field) {
        this.field = field;
    }

    public Object clone() {
        FieldColumnMap clone = new FieldColumnMap(this.cmpInfo);
        clone.setKey(this.key);
        clone.setField(this.field == null ? null : (FieldEntry)this.field.clone());
        clone.setForeignKeyEJBName(this.foreignKeyEJBName == null ? null : (Name)this.foreignKeyEJBName.clone());
        clone.setColumn(this.column == null ? null : new String(this.column));
        clone.setCmpInfo(this.cmpInfo == null ? null : (PersistentField)this.cmpInfo.clone());
        clone.setCmpMap(this.cmpMap == null ? null : (RPersistentFieldMap)this.cmpMap.clone());
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FieldColumnMap)) {
            return false;
        }
        FieldColumnMap fcm = (FieldColumnMap)obj;
        if (this.field != null ? !this.field.equals(fcm.field) : fcm.field != null) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.cmpInfo, fcm.getCmpInfo())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.cmpMap, fcm.getCmpMap())) {
            return false;
        }
        return this.column.equals(fcm.column) && this.key == fcm.key && this.equals(this.foreignKeyEJBName, fcm.foreignKeyEJBName);
    }

    private boolean equals(Name n1, Name n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return true;
        }
        return n1.equals(n2);
    }

    public boolean equals(Field field1, Field field2) {
        if (field1 == null && field2 == null) {
            return true;
        }
        if (field1 == null || field2 == null) {
            return false;
        }
        return field1.getName().equals(field2.getName()) && field1.getType().getName().equals(field2.getType().getName());
    }
}

