/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.components;

import com.sap.engine.deploy.components.J2EEArchive;
import com.sap.engine.deploy.components.J2EEComponentsGenerator;
import com.sap.engine.deploy.components.J2EEGeneratorException;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.gui.mapping.MappingObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class J2EEGeneratorDoc {
    private Document document = null;
    private String prjDir;
    private StandardDOMParser parser = null;
    private StandardDOMWriter writer = null;
    private static final String DIR_INCLUDED = "YES";
    private static final String DIR_NOT_INCLUDED = "NO";
    private static final String dtd = "<!DOCTYPE j2ee-components-generator [\n<!ELEMENT j2ee-components-generator (project-dir?, archive*)>\n<!ELEMENT project-dir (#PCDATA)>\n<!ELEMENT archive (file-name, archive-descriptor, files*, directories*, additional-classpath)>\n<!ELEMENT file-name (#PCDATA)>\n<!ELEMENT archive-descriptor (file-location)>\n<!ATTLIST archive-descriptor type CDATA #REQUIRED>\n<!ELEMENT file-location (#PCDATA)>\n<!ELEMENT files (entry-name, file-path)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT file-path (#PCDATA)>\n<!ELEMENT directories (dir-path, extension-mapping*, included, excluded-files?)>\n<!ELEMENT dir-path (#PCDATA)>\n<!ELEMENT included (#PCDATA)>\n<!ELEMENT extension-mapping (ext, mapping)>\n<!ELEMENT ext (#PCDATA)>\n<!ELEMENT mapping (#PCDATA)>\n<!ELEMENT excluded-files (#PCDATA)>\n<!ELEMENT additional-classpath (#PCDATA)>\n]>";

    public J2EEGeneratorDoc() {
        this.initDocument();
    }

    private void initDocument() {
        this.document = StandardDOMParser.createDocument();
    }

    public void loadJ2EEArchive(J2EEArchive[] arch) {
        Element mainElement;
        if (arch == null) {
            return;
        }
        if (this.document == null) {
            this.initDocument();
        }
        if (this.document.getDocumentElement() == null) {
            mainElement = this.document.createElement("j2ee-components-generator");
            this.document.appendChild(mainElement);
        } else {
            mainElement = this.document.getDocumentElement();
        }
        this.removeAllElementsByName(mainElement, "archive");
        int i = 0;
        while (i < arch.length) {
            Element archiveElement = this.createSimpleElement(mainElement, "archive");
            this.loadArchive(archiveElement, arch[i]);
            ++i;
        }
    }

    public void loadProjectDir(String dir) {
        Element mainElement;
        if (this.document == null) {
            this.initDocument();
        }
        if (this.document.getDocumentElement() == null) {
            mainElement = this.document.createElement("j2ee-components-generator");
            this.document.appendChild(mainElement);
        } else {
            mainElement = this.document.getDocumentElement();
        }
        this.prjDir = dir;
        this.removeAllElementsByName(mainElement, "project-dir");
        if (dir == null) {
            this.createSimpleElement(mainElement, "project-dir", "");
        } else {
            this.createSimpleElement(mainElement, "project-dir", dir);
        }
    }

    public String getPrjXMLDir() {
        NodeList archList = this.document.getElementsByTagName("project-dir");
        int archListLength = archList.getLength();
        if (archListLength == 0) {
            return null;
        }
        return this.getElementValue((Element)archList.item(0));
    }

    private void loadArchive(Element archEl, J2EEArchive arch) {
        if (archEl == null || arch == null) {
            return;
        }
        if (arch.getFileName() != null) {
            this.createSimpleElement(archEl, "file-name", arch.getFileName());
        }
        Element archDescrElement = this.createSimpleElement(archEl, "archive-descriptor");
        if (arch.getDescriptorType() != null) {
            archDescrElement.setAttribute("type", arch.getDescriptorType());
        }
        if (arch.getDescriptorLocation() != null) {
            this.createSimpleElement(archDescrElement, "file-location", arch.getDescriptorLocation());
        }
        if (arch.getFilesFileInfo() != null) {
            this.laodFileInfo(archEl, arch.getFilesFileInfo());
        }
        if (arch.getMappingObjects() != null) {
            this.loadDirMappings(archEl, arch.getMappingObjects());
        }
        if (arch.getAddClasspath() != null) {
            this.createSimpleElement(archEl, "additional-classpath", arch.getAddClasspath());
        }
    }

    private void loadDirMappings(Element archEl, MappingObject[] mappingsObj) {
        Element dirElement = null;
        Element extMapElement = null;
        Element extElement = null;
        Element mapElement = null;
        Object exludedFiles = null;
        Vector excludedExt = null;
        Properties mappings = null;
        Enumeration keysEnum = null;
        String keyExt = null;
        Object mapValue = null;
        String included = null;
        String exclExt = null;
        int i = 0;
        while (i < mappingsObj.length) {
            dirElement = this.createSimpleElement(archEl, "directories");
            this.createSimpleElement(dirElement, "dir-path", this.getRelativePath(mappingsObj[i].getFilePath()));
            included = mappingsObj[i].isIncluded() ? DIR_INCLUDED : DIR_NOT_INCLUDED;
            mappings = mappingsObj[i].getMappings();
            if (mappings != null) {
                extMapElement = this.createSimpleElement(dirElement, "extension-mapping");
                keysEnum = ((Hashtable)mappings).keys();
                while (keysEnum.hasMoreElements()) {
                    keyExt = (String)keysEnum.nextElement();
                    extElement = this.createSimpleElement(extMapElement, "ext", keyExt);
                    mapElement = this.createSimpleElement(extMapElement, "mapping", mappings.getProperty(keyExt));
                }
            }
            this.createSimpleElement(dirElement, "included", included);
            excludedExt = mappingsObj[i].getExcludedFilters();
            if (excludedExt != null) {
                if (exclExt == null) {
                    exclExt = new String("");
                }
                int j = 0;
                while (j < excludedExt.size()) {
                    exclExt = exclExt + (String)excludedExt.elementAt(j) + ";";
                    ++j;
                }
                this.createSimpleElement(dirElement, "excluded-files", exclExt);
                exclExt = null;
            }
            ++i;
        }
    }

    private void laodFileInfo(Element archEl, InfoObject[] fileInfo) {
        Element filesElement = null;
        int i = 0;
        while (i < fileInfo.length) {
            filesElement = this.createSimpleElement(archEl, "files");
            this.createSimpleElement(filesElement, "entry-name", fileInfo[i].getEntryName());
            this.createSimpleElement(filesElement, "file-path", this.getRelativePath(fileInfo[i].getFilePath()));
            ++i;
        }
    }

    public J2EEArchive[] getJ2EEComponentArchive() throws J2EEGeneratorException {
        if (this.document == null) {
            return null;
        }
        Element mainElement = this.document.getDocumentElement();
        if (mainElement == null) {
            return null;
        }
        NodeList archList = this.document.getElementsByTagName("archive");
        int archListLength = archList.getLength();
        if (archListLength == 0) {
            return null;
        }
        J2EEArchive[] archive = new J2EEArchive[archListLength];
        J2EEArchive ar = new J2EEArchive();
        Element archiveEl = null;
        Element fileNameEl = null;
        Element archDescrEl = null;
        Element addClasspathEl = null;
        Element fileLocationEl = null;
        int i = 0;
        while (i < archListLength) {
            archive[i] = new J2EEArchive();
            archiveEl = (Element)archList.item(i);
            fileNameEl = (Element)this.getFirstChild(archiveEl, "file-name");
            if (fileNameEl != null) {
                archive[i].setFileName(this.getAbsolutePath(this.getElementValue(fileNameEl)));
            }
            if ((archDescrEl = (Element)this.getFirstChild(archiveEl, "archive-descriptor")) != null) {
                fileLocationEl = (Element)this.getFirstChild(archDescrEl, "file-location");
                if (fileLocationEl != null) {
                    archive[i].setDescriptorLocation(this.getAbsolutePath(this.getElementValue(fileLocationEl)));
                }
                try {
                    archive[i].setDescriptorType(archDescrEl.getAttribute("type"));
                }
                catch (IllegalArgumentException iaex) {
                    throw new J2EEGeneratorException("ID91004: Wrong descriptor type: \n" + iaex.getMessage());
                }
            }
            this.getFilesElement(archive[i], archiveEl);
            this.getDirElements(archive[i], archiveEl);
            addClasspathEl = (Element)this.getFirstChild(archiveEl, "additional-classpath");
            if (addClasspathEl != null) {
                archive[i].setAddClasspath(this.getElementValue(addClasspathEl));
            }
            ++i;
        }
        return archive;
    }

    private void getDirElements(J2EEArchive arch, Element el) {
        NodeList dirList = el.getElementsByTagName("directories");
        int dirListLength = dirList.getLength();
        Vector<String> exclFilesV = null;
        MappingObject[] mappObj = new MappingObject[dirListLength];
        int i = 0;
        while (i < dirListLength) {
            String exclExt;
            int j;
            exclFilesV = new Vector<String>();
            Element dirElement = (Element)dirList.item(i);
            Element dirPathEl = (Element)this.getFirstChild(dirElement, "dir-path");
            String dirPath = this.getElementValue(dirPathEl);
            Element inclEl = (Element)this.getFirstChild(dirElement, "included");
            String included = this.getElementValue(inclEl);
            boolean isIncluded = included != null && included.trim().equals(DIR_INCLUDED);
            NodeList extMapList = dirElement.getElementsByTagName("extension-mapping");
            Properties extMapProp = new Properties();
            if (extMapList != null) {
                j = 0;
                while (j < extMapList.getLength()) {
                    Element extMapElement = (Element)extMapList.item(j);
                    NodeList extList = extMapElement.getElementsByTagName("ext");
                    NodeList mapList = extMapElement.getElementsByTagName("mapping");
                    int k = 0;
                    while (k < extList.getLength()) {
                        String mapValue = this.getElementValue((Element)mapList.item(k));
                        String extKey = this.getElementValue((Element)extList.item(k));
                        if (extKey != null && mapValue != null) {
                            extMapProp.setProperty(extKey, mapValue);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            exclFilesV.removeAllElements();
            Element exludedFiles = (Element)this.getFirstChild(dirElement, "excluded-files");
            if (exludedFiles != null && (exclExt = this.getElementValue(exludedFiles)) != null) {
                StringTokenizer extTok = new StringTokenizer(exclExt, ";");
                int tokLen = extTok.countTokens();
                j = 0;
                while (j < tokLen) {
                    String nextTok = extTok.nextToken();
                    if (nextTok != null || !nextTok.equals("")) {
                        exclFilesV.add(nextTok);
                    }
                    ++j;
                }
            }
            mappObj[i] = new MappingObject(this.getAbsolutePath(dirPath), extMapProp, isIncluded);
            mappObj[i].setExcludedFilters(exclFilesV);
            ++i;
        }
        arch.setMappingObjects(mappObj);
    }

    private void getFilesElement(J2EEArchive arch, Element el) {
        NodeList filesList = el.getElementsByTagName("files");
        int length = filesList.getLength();
        String[] entryName = new String[length];
        String[] filePath = new String[length];
        Vector<InfoObject> fileInfo = new Vector<InfoObject>();
        InfoObject info = null;
        int i = 0;
        while (i < filesList.getLength()) {
            Element fileEl = (Element)filesList.item(i);
            Element entryNameEl = (Element)this.getFirstChild(fileEl, "entry-name");
            Element filePathEl = (Element)this.getFirstChild(fileEl, "file-path");
            filePath[i] = this.getElementValue(filePathEl);
            entryName[i] = this.getElementValue(entryNameEl);
            if (filePath[i] != null && filePath[i] != "") {
                info = new InfoObject(entryName[i], this.getAbsolutePath(filePath[i]));
                fileInfo.add(info);
            }
            ++i;
        }
        arch.setFilesFileInfo(fileInfo);
    }

    /*
     * Loose catch block
     */
    public void readFromXMLFile(String fileName) throws J2EEGeneratorException {
        block12: {
            FileInputStream xMLfis = null;
            BufferedInputStream xmlStream = null;
            this.document = null;
            xMLfis = new FileInputStream(fileName);
            xmlStream = new BufferedInputStream(xMLfis);
            StandardDOMParser parser = new StandardDOMParser();
            parser.setSystemId(fileName);
            this.document = parser.parse((InputStream)xmlStream);
            Object var7_6 = null;
            try {
                if (xmlStream != null) {
                    xmlStream.close();
                }
                if (xMLfis != null) {
                    xMLfis.close();
                }
                break block12;
            }
            catch (IOException ioex) {
                new J2EEComponentsGenerator().toLog("\u201cError occurs at stream closing for BufferedInputStream or FileInputStream while reading from XML file: " + fileName + ".");
            }
            break block12;
            {
                catch (IOException ioex) {
                    throw new J2EEGeneratorException("ID91001: Could not read XML file: " + fileName + "\n" + ioex.getMessage());
                }
                catch (SAXException saxex) {
                    throw new J2EEGeneratorException("ID91002:Wrong XML format: " + fileName + "\n" + saxex.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (xmlStream != null) {
                        xmlStream.close();
                    }
                    if (xMLfis != null) {
                        xMLfis.close();
                    }
                }
                catch (IOException ioex) {
                    new J2EEComponentsGenerator().toLog("\u201cError occurs at stream closing for BufferedInputStream or FileInputStream while reading from XML file: " + fileName + ".");
                }
                throw throwable;
            }
        }
        Element docElement = this.document.getDocumentElement();
    }

    public String writeToXMLFile(String fileName) {
        StandardDOMWriter writer = new StandardDOMWriter();
        if (!fileName.endsWith(".xml")) {
            fileName = fileName + ".xml";
        }
        try {
            writer.write(this.document, fileName, dtd, "UTF-8");
            return fileName;
        }
        catch (IOException e) {
            new J2EEComponentsGenerator().toLog("\u201cError occurs while write to XML file: " + fileName + "\n" + e.toString());
            return null;
        }
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private Element createSimpleElement(Element parent, String tag, String value) {
        Element newEl = this.document.createElement(tag);
        newEl.appendChild(this.document.createTextNode(value));
        parent.appendChild(newEl);
        return newEl;
    }

    private Element createSimpleElement(Element parent, String tag) {
        Element newEl = this.document.createElement(tag);
        parent.appendChild(newEl);
        return newEl;
    }

    private String getElementValue(Element el) {
        if (el == null) {
            return null;
        }
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    private void removeAllElementsByName(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        int i = 0;
        while (i < list.getLength()) {
            el.removeChild(list.item(i));
            ++i;
        }
    }

    private String getAbsolutePath(String path) {
        File absFile;
        File f;
        String dir;
        if (this.prjDir == null || path.startsWith(".")) {
            dir = this.getPrjXMLDir();
            if (dir == null || dir.trim().equals("") || path.startsWith(".")) {
                return path;
            }
        } else {
            dir = this.prjDir;
        }
        String returnValue = (f = new File(path)).isAbsolute() && !path.startsWith(File.separator) ? f.getAbsolutePath() : ((absFile = new File(dir, path)).exists() ? absFile.getAbsolutePath() : (f.exists() ? f.getAbsolutePath() : absFile.getAbsolutePath()));
        return returnValue;
    }

    private String getRelativePath(String path) {
        String prjDir = this.getPrjXMLDir();
        if (prjDir == null) {
            return null;
        }
        int dirLength = prjDir.length();
        String relativName = path.indexOf(prjDir) == 0 ? path.substring(dirLength) : path;
        return relativName;
    }
}

