/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy.components;

import com.sap.engine.deploy.components.J2EEGeneratorException;
import com.sap.engine.deploy.ejb.descriptors.jar.MakeEjbJar;
import com.sap.engine.deploy.ejb.descriptors.xml.EJB20DescriptorDocument;
import com.sap.engine.deploy.ejb.descriptors.xml.EJBJarParser;
import com.sap.engine.deploy.tool.JarHelper;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.jar.DependenceJarUtils;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.lang.DynamicClassLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.MakeClientJar;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.jar.MakeJar;
import com.sap.engine.services.connector.jca.deploy.descriptor.jar.MakeRar;
import com.sap.engine.services.deploy.converter.EJBConverter;
import com.sap.engine.services.deploy.converter.WebConverter;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.jar.MakeWar;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipFile;
import javax.ejb.MessageDrivenBean;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class J2EEComponentsGenerator {
    protected Hashtable archiveDescriptors = new Hashtable();
    protected Hashtable additionalFiles = new Hashtable();
    protected Hashtable classpath = new Hashtable();
    protected boolean logStarted = false;
    private DependenceJarUtils dependences = null;
    private RandomAccessFile out = null;
    private String logFileName = null;
    static final String logSeparator = "***********************************************************";
    private static final SimpleDateFormat logfileDateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private boolean hasLogFile = true;
    protected String globalPath = null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public J2EEComponentsGenerator() {
    }

    public J2EEComponentsGenerator(RandomAccessFile out) {
        this.setLog(out);
    }

    public J2EEComponentsGenerator(String s) {
        this.startLog(s);
    }

    public void addNewArchive(String archiveName, int type) {
        switch (type) {
            case 4: {
                WebDeploymentDescriptor descr = new WebDeploymentDescriptor();
                descr.setDisplayName(archiveName);
                this.archiveDescriptors.put(archiveName, descr);
                this.toLog("Decriptor of " + archiveName + " updated.");
                break;
            }
            case 1: {
                EJBJarDescriptor jar = new EJBJarDescriptor();
                jar.setDisplayName(archiveName);
                this.archiveDescriptors.put(archiveName, jar);
                this.toLog("Decriptor of " + archiveName + " updated");
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                ApplicationClientDescriptor clientJar = new ApplicationClientDescriptor();
                clientJar.setDisplayName(archiveName);
                this.archiveDescriptors.put(archiveName, clientJar);
                this.toLog("Descriptor of " + archiveName + " updated.");
                break;
            }
            case 5: {
                JCDescriptor clientJar = new JCDescriptor();
                clientJar.setDisplayName(archiveName);
                this.archiveDescriptors.put(archiveName, clientJar);
                this.toLog("Descriptor of " + archiveName + " updated.");
                break;
            }
        }
    }

    public void loadExistingArchive(String filePath) throws J2EEGeneratorException {
        ArchiveDescriptor arch = null;
        JarHelper jHelper = new JarHelper(filePath);
        int type = -1;
        try {
            type = jHelper.getJarComponentType(filePath);
        }
        catch (Exception exc) {
            this.toLog("ERROR : The jar file is not correct " + exc.getMessage());
            throw new J2EEGeneratorException("ID91005 Jar file is not recognized as a J2EE Component " + filePath);
        }
        switch (type) {
            case 1: {
                this.addNewArchive(filePath, 1);
                arch = (ArchiveDescriptor)this.archiveDescriptors.get(filePath);
                try {
                    ((EJBJarDescriptor)arch).setDescriptors(jHelper.loadDescriptorsFromArchive(filePath));
                    if (jHelper.getErrors().isEmpty()) break;
                    Vector err = jHelper.getErrors();
                    int i = 0;
                    while (i < err.size()) {
                        this.toLog((String)err.get(i));
                        ++i;
                    }
                    break;
                }
                catch (Exception exc) {
                    this.toLog("ERROR : Could not load EJB archive because of error " + exc.getMessage());
                    throw new J2EEGeneratorException("ID91006 Could not load EJB archive " + filePath + " because of " + exc.getMessage());
                }
            }
            case 4: {
                this.addNewArchive(filePath, 4);
                arch = (ArchiveDescriptor)this.archiveDescriptors.get(filePath);
                try {
                    ((WebDeploymentDescriptor)arch).setDescriptors(jHelper.loadDescriptorsFromArchive(filePath));
                    break;
                }
                catch (Exception exc) {
                    this.toLog("ERROR : Could not load web archive because of error " + exc.getMessage());
                    throw new J2EEGeneratorException("ID91006 Could not load web archive " + filePath + " because of " + exc.getMessage());
                }
            }
            case 3: {
                this.addNewArchive(filePath, 3);
                arch = (ArchiveDescriptor)this.archiveDescriptors.get(filePath);
                break;
            }
            case 5: {
                this.addNewArchive(filePath, 5);
                ArchiveDescriptor archiveDescriptor = (ArchiveDescriptor)this.archiveDescriptors.get(filePath);
            }
        }
    }

    public void addComponent(String archiveName, Descriptor descr) {
        Descriptor[] descriptors = null;
        ArchiveDescriptor archive = null;
        if (this.archiveDescriptors != null && this.archiveDescriptors.size() > 0 && (archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName)) != null) {
            descriptors = archive.getDescriptors();
            archive.setDescriptors(archive.addElement(descriptors, descr));
            this.toLog("A new component " + descr.getName() + " is added to archive " + archiveName);
        }
    }

    public void removeArchive(String archiveName) {
        if (archiveName != null && this.archiveDescriptors.remove(archiveName) != null) {
            this.toLog("Archive  with name " + archiveName + " is removed from table of archives>");
        }
    }

    public void removeComponentFromArchive(String archiveName, String componentName) {
        ArchiveDescriptor archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName);
        Descriptor[] descrs = null;
        if (archive != null && this.archiveDescriptors.contains(archive)) {
            this.toLog("Starting remove of components in archive " + archiveName + "...");
            descrs = archive.getDescriptors();
            int index = archive.containsElement(descrs, componentName);
            if (index > -1) {
                archive.setDescriptors(archive.removeElement(descrs, descrs[index]));
            }
        }
    }

    public void moveArchiveDescriptor(String fromArchiveName, String toArchiveName, String compName) {
        this.toLog("Moving descriptor " + compName + " from archive " + fromArchiveName + " to " + toArchiveName + "starts ...");
        ArchiveDescriptor archive1 = (ArchiveDescriptor)this.archiveDescriptors.get(fromArchiveName);
        ArchiveDescriptor archive2 = (ArchiveDescriptor)this.archiveDescriptors.get(toArchiveName);
        Descriptor value = null;
        Descriptor[] descrs1 = null;
        Descriptor[] descrs2 = null;
        if (archive1 != null && archive1.containsElement(descrs1 = archive1.getDescriptors(), compName) > -1) {
            value = descrs1[archive1.containsElement(descrs1, compName)];
            if (archive2 != null) {
                descrs2 = archive2.getDescriptors();
                int index = archive2.containsElement(descrs2, compName);
                if (index > -1) {
                    archive2.replaceElement(descrs2, index, value);
                    archive1.removeElement(descrs1, value);
                } else {
                    archive2.setDescriptors(archive2.addElement(descrs2, value));
                    archive1.setDescriptors(archive1.removeElement(descrs1, value));
                }
            }
        }
    }

    public Descriptor getDescriptor(String archiveName, String componentName) {
        Descriptor[] descriptors = null;
        ArchiveDescriptor archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName);
        if (archive != null) {
            if (archive instanceof EJBJarDescriptor) {
                descriptors = ((EJBJarDescriptor)archive).getDescriptors();
            } else if (archive instanceof WebDeploymentDescriptor) {
                descriptors = ((WebDeploymentDescriptor)archive).getDescriptors();
            } else if (archive instanceof ApplicationClientDescriptor) {
                // empty if block
            }
            int index = archive.containsElement(descriptors, componentName);
            if (index > -1) {
                return descriptors[index];
            }
        }
        this.toLog("ERROR : Descriptor with name " + componentName + " is not found in " + archiveName + ".");
        return null;
    }

    public void setDescriptor(String archiveName, String componentName, Descriptor descr) {
        ArchiveDescriptor archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName);
        Descriptor[] descriptors = null;
        if (archive != null) {
            descriptors = archive.getDescriptors();
            int index = archive.containsElement(descriptors, componentName);
            if (index == -1) {
                archive.addElement(descriptors, descr);
                this.toLog("The descriptor with name " + componentName + " is added to archive " + archiveName);
                Descriptor[] newValues = archive.addElement(descriptors, descr);
                archive.setDescriptors(newValues);
            } else {
                archive.replaceElement(descriptors, index, descr);
                this.toLog("The descriptor with name " + componentName + " is replaced in the archive " + archiveName);
            }
        }
    }

    public void replaceDescriptor(String jarName, String componentName, String xmlFile) throws J2EEGeneratorException {
        Descriptor[] descrs;
        int index;
        ArchiveDescriptor archive = this.getArchive(jarName);
        if (archive != null && (index = archive.containsElement(descrs = archive.getDescriptors(), componentName)) > -1) {
            try {
                if (archive instanceof EJBJarDescriptor) {
                    EJBJarDescriptor jar1 = this.getConvertedEJBDescriptor((ClassLoader)this.classpath.get(jarName), xmlFile);
                    descrs[index] = jar1.getDescriptor(componentName);
                } else if (archive instanceof WebDeploymentDescriptor) {
                    WebDeploymentDescriptor jar1 = this.getConvertedWebDescriptor(xmlFile);
                    descrs[index] = jar1.getDescriptor(componentName);
                }
                archive.setDescriptors(archive.replaceElement(descrs, index, descrs[index]));
                this.toLog("Descriptor with name " + componentName + " is found and replaced with descriptor from xml file " + xmlFile);
            }
            catch (Exception exc) {
                this.toLog("ERROR : The replacement did not succeed because of error : " + exc.getMessage());
                throw new J2EEGeneratorException("ID91007 The replacement of descriptor did not succeed because of error : " + exc.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean makeArchive(String archiveName) throws IOException {
        block41: {
            block37: {
                block39: {
                    block40: {
                        block38: {
                            archive = this.getArchive(archiveName);
                            this.toLog("Make archive operation starting ...");
                            withWarnings = false;
                            if (archive == null) break block37;
                            tempFile1 = new File(archiveName);
                            tempFile1.getParentFile().mkdirs();
                            tempFile = new File(archiveName + System.currentTimeMillis());
                            if (!tempFile1.exists()) {
                                tempFile = null;
                            } else {
                                tempFile.getParentFile().mkdirs();
                                FileUtils.copyFile(tempFile1, tempFile);
                            }
                            errorEntry = null;
                            if (!(archive instanceof EJBJarDescriptor)) break block38;
                            errorEntry = this.hasDuplicateEntry((Vector)this.additionalFiles.get(archiveName), 1);
                            if (errorEntry != null) {
                                this.toLog("ERROR : Archive will not be made.\n You tried to put duplicate entry in the archive: " + archiveName + ".\n Remove duplicate entry: " + errorEntry + " in additonal files and directories, and try again.");
                                throw new IOException("ID91008: Archive will not be made. You tried to put duplicate entry in \n the archive: " + archiveName + ". Remove duplicate entry: " + errorEntry + "\n in additonal files and directories, and try again.");
                            }
                            errorEntry = this.hasDuplBeanClassEntries((Vector)this.additionalFiles.get(archiveName), (DeploymentDescriptor[])archive.getDescriptors(), this.globalPath);
                            if (errorEntry != null) {
                                this.toLog("ERROR : Archive will not be made.\n You tried to put duplicate entry of bean classes in the archive: " + errorEntry + ".\n Remove duplicate entry in additonal files and directories, and try again.");
                                throw new IOException("ID91009: Archive will not be made. You tried to put duplicate entry of bean classes in \n the archive: " + errorEntry + ". Remove duplicate entry " + "\n in additonal files and directories, and try again.");
                            }
                            if (archive.getDescriptors() == null || archive.getDescriptors().length == 0) {
                                this.toLog("ERROR : There are no Beans in JAR File: " + archiveName + ".");
                                throw new IOException("ID91010: There are no Beans in JAR File.");
                            }
                            makeEJB = new MakeEjbJar((EJBJarDescriptor)archive, (DynamicClassLoader)this.classpath.get(archiveName));
                            makeEJB.setDescriptors((DeploymentDescriptor[])archive.getDescriptors());
                            makeEJB.setAdditionalPaths(this.globalPath);
                            makeEJB.setAdditionalFiles((Vector)this.additionalFiles.get(archiveName));
                            makeEJB.makeJar(archiveName);
                            zipFileChecker = new ZipFile(archiveName);
                            enZip = zipFileChecker.entries();
                            if (!enZip.hasMoreElements()) {
                                this.toLog("ERROR : There are no Beans in JAR File.");
                                zipFileChecker.close();
                                delFile = new File(archiveName);
                                this.restore(delFile, tempFile);
                                throw new IOException("ID91010: There are no Beans in JAR File.");
                            }
                            isEmpty = true;
                            comparableValue = "";
                            while (enZip.hasMoreElements()) {
                                comparableValue = enZip.nextElement().getName();
                                if (comparableValue.toLowerCase().equals("meta-inf/ejb-jar.xml") || comparableValue.toLowerCase().equals("meta-inf/storage.xml") || comparableValue.toLowerCase().equals("meta-inf/manifest.mf")) continue;
                                isEmpty = false;
                            }
                            if (isEmpty) {
                                this.toLog("WARNING : There are no Beans in JAR File.");
                                withWarnings = true;
                            }
                            ddArray = (DeploymentDescriptor[])archive.getDescriptors();
                            entryFileName = "";
                            ii = 0;
                            while (ii < ddArray.length) {
                                entryFileName = ddArray[ii].getClassName().replace('.', '/') + ".class";
                                if (zipFileChecker.getEntry(entryFileName) == null) {
                                    this.toLog("WARNING : There is no BeanClass with name " + entryFileName + " in JAR.");
                                    withWarnings = true;
                                }
                                if (!(ddArray[ii] instanceof MessageDrivenBean)) {
                                    pairIntrf = null;
                                    if (ddArray[ii].getRemoteHomeInterface() != null && ddArray[ii].getRemoteInterface() != null) {
                                        entryFileName = ddArray[ii].getRemoteHomeInterface().replace('.', '/') + ".class";
                                        pairIntrf = ddArray[ii].getRemoteInterface().replace('.', '/') + ".class";
                                        if (zipFileChecker.getEntry(entryFileName) == null && zipFileChecker.getEntry(pairIntrf) != null) {
                                            this.toLog("WARNING : There is no RemoteHomeInterface class  with name " + entryFileName + " in JAR.");
                                            withWarnings = true;
                                        }
                                        entryFileName = ddArray[ii].getRemoteInterface().replace('.', '/') + ".class";
                                        pairIntrf = ddArray[ii].getRemoteHomeInterface().replace('.', '/') + ".class";
                                        if (zipFileChecker.getEntry(entryFileName) == null && zipFileChecker.getEntry(pairIntrf) != null) {
                                            this.toLog("WARNING : There is no RemoteInterface class with name " + entryFileName + " in JAR.");
                                            withWarnings = true;
                                        }
                                    }
                                    if (ddArray[ii].getLocalHomeInterface() != null && ddArray[ii].getLocalInterface() != null) {
                                        entryFileName = ddArray[ii].getLocalHomeInterface().replace('.', '/') + ".class";
                                        pairIntrf = ddArray[ii].getLocalInterface().replace('.', '/') + ".class";
                                        if (zipFileChecker.getEntry(entryFileName) == null && zipFileChecker.getEntry(pairIntrf) != null) {
                                            this.toLog("WARNING : There is no LocalHomeInterface class  with name " + entryFileName + " in JAR.");
                                            withWarnings = true;
                                        }
                                        entryFileName = ddArray[ii].getLocalInterface().replace('.', '/') + ".class";
                                        pairIntrf = ddArray[ii].getLocalHomeInterface().replace('.', '/') + ".class";
                                        if (zipFileChecker.getEntry(entryFileName) == null && zipFileChecker.getEntry(pairIntrf) != null) {
                                            this.toLog("WARNING : There is no LocalInterface class  with name " + entryFileName + " in JAR.");
                                            withWarnings = true;
                                        }
                                    }
                                }
                                if (ddArray[ii] instanceof EntityDescriptor && this.isUserDefinedClass(entryFileName = ((EntityDescriptor)ddArray[ii]).getPrimaryKeyClass()) && zipFileChecker.getEntry(entryFileName = entryFileName.replace('.', '/') + ".class") == null) {
                                    this.toLog("WARNING : PrimaryKey Class is Missing in JAR: " + entryFileName);
                                    withWarnings = true;
                                }
                                ++ii;
                            }
                            zipFileChecker.close();
                            this.toLog("EJB jar is made.");
                            break block39;
                        }
                        if (!(archive instanceof WebDeploymentDescriptor)) break block40;
                        errorEntry = this.hasDuplicateEntry((Vector)this.additionalFiles.get(archiveName), 4);
                        if (errorEntry != null) {
                            this.toLog("ERROR : Archive will not be made.\n You tried to put duplicate entry in the archive: " + archiveName + ".\n Remove duplicate entry: " + errorEntry + " in additonal files and directories, and try again.");
                            throw new IOException("ID91008: Archive will not be made. You tried to put duplicate entry in \n the archive: " + archiveName + ". Remove duplicate entry: " + errorEntry + "\n in additonal files and directories, and try again.");
                        }
                        makeWar = new MakeWar((WebDeploymentDescriptor)archive);
                        makeWar.switchSimple(true);
                        if (this.additionalFiles.get(archiveName) != null) {
                            makeWar.setInfoObjects((Vector)this.additionalFiles.get(archiveName));
                            makeWar.makeJar(archiveName, (Vector)this.additionalFiles.get(archiveName));
                        } else {
                            makeWar.makeJar(archiveName, new Vector<E>());
                        }
                        isEmpty = true;
                        zip = new ZipFile(archiveName);
                        enZip = zip.entries();
                        entry1 = null;
                        while (enZip.hasMoreElements()) {
                            entry1 = enZip.nextElement();
                            if (entry1.getName().equalsIgnoreCase("web-inf/web.xml") || entry1.getName().equalsIgnoreCase("meta-inf/service.properties") || entry1.getName().equalsIgnoreCase("service.properties") || entry1.getName().equalsIgnoreCase("meta-inf/manifest.mf")) continue;
                            isEmpty = false;
                        }
                        if (isEmpty) {
                            this.toLog("WARNING :  War file " + archiveName + " contains only web.xml and no additional files.");
                        }
                        zip.close();
                        this.toLog("Web war is made.");
                        break block39;
                    }
                    if (!(archive instanceof ApplicationClientDescriptor)) ** GOTO lbl132
                    errorEntry = this.hasDuplicateEntry((Vector)this.additionalFiles.get(archiveName), 3);
                    if (errorEntry != null) {
                        this.toLog("ERROR : Archive will not be made.\n You tried to put duplicate entry in the archive: " + archiveName + ".\n Remove duplicate entry in additonal files and directories, and try again.");
                        throw new IOException("ID91008: Archive will not be made. You tried to put duplicate entry in \n the archive: " + archiveName + ". Remove duplicate entry " + "\n in additonal files and directories, and try again.");
                    }
                    makeClient = new MakeClientJar((ApplicationClientDescriptor)archive);
                    makeClient.setInfoObjects((Vector)this.additionalFiles.get(archiveName));
                    if ((Vector)this.additionalFiles.get(archiveName) != null) {
                        makeClient.makeJar(archiveName, (Vector)this.additionalFiles.get(archiveName));
                        this.toLog("Client Jar is made.");
                    } else {
                        this.toLog("ERROR: Can not make Client Jar with name " + archiveName + ".\n There are no additional files in the jar.");
                        throw new IOException("ID91016: Can not make Client Jar with name " + archiveName + ".\n There are no additional files in the jar.");
lbl132:
                        // 1 sources

                        if (archive instanceof JCDescriptor) {
                            errorEntry = this.hasDuplicateEntry((Vector)this.additionalFiles.get(archiveName), 5);
                            if (errorEntry != null) {
                                this.toLog("ERROR : Archive will not be made.\n You tried to put duplicate entry: " + errorEntry + " in the archive: " + archiveName + ".\n Remove duplicate entry in additonal files and directories, and try again.");
                                throw new IOException("ID91008: Archive will not be made. You tried to put duplicate entry in \n the archive: " + archiveName + ". Remove duplicate entry: " + errorEntry + "\n in additonal files and directories, and try again.");
                            }
                            addFiles = (Vector)this.additionalFiles.get(archiveName);
                            classFiles = new Vector<E>();
                            restFiles = new Vector<E>();
                            if (addFiles != null) {
                                j = 0;
                                while (j < addFiles.size()) {
                                    if (addFiles.get(j) != null) {
                                        if (((InfoObject)addFiles.get(j)).getEntryName().endsWith(".class")) {
                                            classFiles.add(addFiles.get(j));
                                        } else {
                                            restFiles.add(addFiles.get(j));
                                        }
                                    }
                                    ++j;
                                }
                            }
                            makeJarOfClasses = new MakeJar();
                            jarName = archiveName.substring(0, archiveName.lastIndexOf(46)) + ".jar";
                            makeJarOfClasses.setInfoObjects(classFiles);
                            makeJarOfClasses.makeJar(jarName, classFiles);
                            if (new File(jarName).isFile()) {
                                restFiles.add(new InfoObject(jarName.substring(jarName.lastIndexOf(File.separatorChar) + 1), jarName));
                            }
                            makeConnector = new MakeRar((JCDescriptor)archive);
                            makeConnector.setInfoObjects(restFiles);
                            if ((Vector)this.additionalFiles.get(archiveName) != null) {
                                makeConnector.makeJar(archiveName, restFiles);
                                this.toLog("Connector Rar is made.");
                            } else {
                                this.toLog("ERROR: Can not make Connector Rar with name " + archiveName + ".\n There are no additional files in the jar.");
                                throw new IOException("ID91016: Can not make Connector Rar with name " + archiveName + ".\n There are no additional files in the jar.");
                            }
                        }
                    }
                }
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
                break block41;
            }
            this.toLog("ERROR : There is no jar with name " + archiveName + " in Components Generator.");
            throw new IOException("ID91017 : There is no jar with name " + archiveName + " in Components Generator.");
        }
        return withWarnings;
    }

    private String hasDuplicateEntry(Vector infoes, int type) {
        if (infoes == null || infoes.size() < 2) {
            return null;
        }
        String descriptorEntry1 = "";
        String descriptorEntry2 = "";
        switch (type) {
            case 1: {
                descriptorEntry1 = "META-INF\\ejb-jar.xml";
                descriptorEntry2 = "META-INF/ejb-jar.xml";
                break;
            }
            case 4: {
                descriptorEntry1 = "WEB-INF\\web.xml";
                descriptorEntry2 = "WEB-INF/web.xml";
                break;
            }
            case 3: {
                descriptorEntry1 = "META-INF\\application-client.xml";
                descriptorEntry2 = "META-INF/application-client.xml";
                break;
            }
            case 5: {
                descriptorEntry1 = "META-INF\\ra.xml";
                descriptorEntry2 = "META-INF/ra.xml";
                break;
            }
        }
        String entry = null;
        String filePath = null;
        int size = infoes.size() - 1;
        int i = 0;
        while (i < infoes.size()) {
            entry = ((InfoObject)infoes.elementAt(i)).getEntryName();
            filePath = ((InfoObject)infoes.elementAt(i)).getFilePath();
            if (entry.equalsIgnoreCase(descriptorEntry1) || entry.equalsIgnoreCase(descriptorEntry2)) {
                infoes.remove(infoes.elementAt(i));
                --i;
            } else {
                int j = i + 1;
                while (j < infoes.size()) {
                    if (entry.equals(((InfoObject)infoes.elementAt(j)).getEntryName()) && filePath.equals(((InfoObject)infoes.elementAt(j)).getFilePath())) {
                        infoes.remove(infoes.elementAt(j));
                    } else if (entry.equals(((InfoObject)infoes.elementAt(j)).getEntryName())) {
                        return entry;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public void addAdditionalFiles(String archiveName, InfoObject[] infoes) {
        ArchiveDescriptor archive = this.getArchive(archiveName);
        Vector<InfoObject> infoValues = new Vector<InfoObject>();
        if (archive != null && infoes != null) {
            int i = 0;
            while (i < infoes.length) {
                if (!new File(infoes[i].getFilePath()).exists()) {
                    this.toLog("ERROR : Additional file not found: " + infoes[i].getFilePath());
                }
                infoValues.addElement(infoes[i]);
                ++i;
            }
            this.additionalFiles.put(archiveName, infoValues);
            this.toLog("Additional files added.");
        }
    }

    public void addAdditionalFiles(String archiveName, String[] filePaths, String[] entryNames) {
        if (filePaths != null && entryNames != null && filePaths.length == entryNames.length) {
            int i = 0;
            while (i < entryNames.length) {
                if (!new File(filePaths[i]).exists()) {
                    this.toLog("ERROR : Additional file not found: " + filePaths[i]);
                }
                this.addAdditionalFiles(archiveName, filePaths[i], entryNames[i]);
                ++i;
            }
        }
    }

    public void addAdditionalFiles(String archiveName, String filePath, String entryName) {
        if (!new File(filePath).exists()) {
            this.toLog("ERROR : Additional file not found: " + filePath);
        }
        InfoObject info = new InfoObject(entryName, filePath);
        Vector<InfoObject> infoes = (Vector<InfoObject>)this.additionalFiles.get(archiveName);
        if (infoes == null) {
            infoes = new Vector<InfoObject>();
        }
        infoes.addElement(info);
        this.additionalFiles.put(archiveName, infoes);
    }

    public void addAdditionalClassPath(String archiveName, String[] paths) {
        String path = null;
        DynamicClassLoader loader = (DynamicClassLoader)this.classpath.get(archiveName);
        if (paths != null && paths.length > 0) {
            path = paths[0];
            int i = 1;
            while (i < paths.length) {
                path = path + File.pathSeparator + paths[i];
                ++i;
            }
        } else {
            path = "";
        }
        this.globalPath = path;
        if (loader == null) {
            loader = new DynamicClassLoader(path, this.getClass().getClassLoader());
        } else {
            loader.addClasspath(path);
        }
        this.classpath.put(archiveName, loader);
    }

    public void setArchiveDescriptor(String archiveName, ArchiveDescriptor archive) {
        this.archiveDescriptors.put(archiveName, archive);
    }

    public void setArchiveDescriptor(String archiveName, String xmlFileLocation) throws J2EEGeneratorException {
        ArchiveDescriptor archive = null;
        archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName);
        if (!new File(xmlFileLocation).exists()) {
            throw new J2EEGeneratorException("ID91003 XML file of the arcive descriptor does not exists: " + xmlFileLocation);
        }
        if (archive != null) {
            if (archive instanceof EJBJarDescriptor) {
                try {
                    ClassLoader loader = (ClassLoader)this.classpath.get(archiveName);
                    archive = this.getConvertedEJBDescriptor(loader, xmlFileLocation);
                }
                catch (Exception e) {
                    throw new J2EEGeneratorException(e.getMessage());
                }
            } else if (archive instanceof WebDeploymentDescriptor) {
                archive = this.getConvertedWebDescriptor(xmlFileLocation);
            } else {
                archive.loadFromFile(xmlFileLocation);
            }
        }
        if (archive != null) {
            this.setArchiveDescriptor(archiveName, archive);
        }
    }

    public ArchiveDescriptor getArchive(String archiveName) {
        ArchiveDescriptor archive = (ArchiveDescriptor)this.archiveDescriptors.get(archiveName);
        if (archive != null) {
            return archive;
        }
        return null;
    }

    public Hashtable getAdditionalTable() {
        return this.additionalFiles;
    }

    public String loadStackTrace(Exception ex) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(out);
        ex.printStackTrace(stream);
        String result = out.toString();
        stream.close();
        try {
            out.close();
        }
        catch (IOException ioe) {
            this.toLog("Cannot close ByteArrayOutputStream for Exception message:\n" + result);
        }
        return result;
    }

    public void toLog(String str) {
        try {
            if (!this.logStarted) {
                this.startLog();
            }
            String dateString = logfileDateFormat.format(new Date()) + " -  ";
            StringBuffer emptyStringBuffer = new StringBuffer(dateString.length());
            int i = 0;
            while (i < dateString.length()) {
                emptyStringBuffer.append(' ');
                ++i;
            }
            String emptyString = emptyStringBuffer.toString();
            StringTokenizer st = new StringTokenizer(str, "\n\r");
            String s = "";
            if (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = dateString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                } else {
                    s = dateString + st.nextToken();
                    System.out.println(s);
                }
            }
            while (st.hasMoreTokens()) {
                if (this.hasLogFile) {
                    s = emptyString + st.nextToken() + "\n";
                    this.out.write(s.getBytes());
                    continue;
                }
                s = emptyString + st.nextToken();
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR :\n    Could not start logging. Exception occurred:");
            e.printStackTrace();
            System.out.println("\n");
        }
    }

    public void setLog(RandomAccessFile out) {
        this.out = out;
        this.logStarted = true;
    }

    public void startLog(String s) {
        this.logFileName = s;
        if (s == null) {
            this.logStarted = true;
            this.toLog(logSeparator);
        } else {
            try {
                File f = new File(s);
                f.delete();
                this.out = new RandomAccessFile(s, "rw");
                this.out.seek(this.out.length());
                this.logStarted = true;
                this.toLog("***********************************************************\n");
            }
            catch (Exception e) {
                System.out.println("ERROR : \n   Could not start logging. Exception occurred:");
                e.printStackTrace();
                System.out.println("\n");
            }
        }
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void startLog() {
        System.out.println("Starting log to:   j2ee_generator_log.txt");
        this.startLog("j2ee_generator_log.txt");
    }

    public void stopLog() {
        try {
            this.toLog("***********************************************************\n\r ");
            this.logStarted = false;
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception e) {
            System.out.println("ERROR :\n Generic exception while closing log: " + e.getMessage());
        }
    }

    public boolean isUserDefinedClass(String className) {
        if (className == null) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Integer == null ? (class$java$lang$Integer = J2EEComponentsGenerator.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || className.equalsIgnoreCase("int")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Byte == null ? (class$java$lang$Byte = J2EEComponentsGenerator.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || className.equalsIgnoreCase("byte")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Character == null ? (class$java$lang$Character = J2EEComponentsGenerator.class$("java.lang.Character")) : class$java$lang$Character).getName()) || className.equalsIgnoreCase("char")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Short == null ? (class$java$lang$Short = J2EEComponentsGenerator.class$("java.lang.Short")) : class$java$lang$Short).getName()) || className.equalsIgnoreCase("short")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Long == null ? (class$java$lang$Long = J2EEComponentsGenerator.class$("java.lang.Long")) : class$java$lang$Long).getName()) || className.equalsIgnoreCase("long")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Double == null ? (class$java$lang$Double = J2EEComponentsGenerator.class$("java.lang.Double")) : class$java$lang$Double).getName()) || className.equalsIgnoreCase("double")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Float == null ? (class$java$lang$Float = J2EEComponentsGenerator.class$("java.lang.Float")) : class$java$lang$Float).getName()) || className.equalsIgnoreCase("float")) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$String == null ? (class$java$lang$String = J2EEComponentsGenerator.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return false;
        }
        if (className.equalsIgnoreCase((class$java$lang$Boolean == null ? (class$java$lang$Boolean = J2EEComponentsGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || className.equalsIgnoreCase("boolean")) {
            return false;
        }
        return !className.equalsIgnoreCase((class$java$lang$Object == null ? (class$java$lang$Object = J2EEComponentsGenerator.class$("java.lang.Object")) : class$java$lang$Object).getName());
    }

    private void restore(File fileToRestore, File tmpFile) {
        if (fileToRestore == null || tmpFile == null) {
            return;
        }
        if (tmpFile.exists()) {
            if (fileToRestore.exists()) {
                fileToRestore.delete();
            }
            try {
                FileUtils.copyFile(tmpFile, fileToRestore);
                tmpFile.delete();
            }
            catch (IOException e) {
                this.toLog("Error occurs in work with: " + tmpFile + " and " + fileToRestore + " files.\n " + "Possible reasons can be \"File " + tmpFile + " not copied.\" or \"File " + tmpFile + " cannot be deleted.\".");
            }
        }
    }

    public void setHasLogFile(boolean type) {
        this.hasLogFile = type;
    }

    public boolean getHasLogFile() {
        return this.hasLogFile;
    }

    public void doStuffy() {
        this.archiveDescriptors.clear();
        this.classpath.clear();
        this.additionalFiles.clear();
    }

    private String hasDuplBeanClassEntries(Vector additionalFiles, DeploymentDescriptor[] descriptors, String classPath) {
        if (this.dependences == null) {
            this.dependences = new DependenceJarUtils();
        }
        if (additionalFiles == null || descriptors == null) {
            return null;
        }
        Vector<String> classes = new Vector<String>();
        String className = null;
        int i = 0;
        while (i < descriptors.length) {
            classes.add(descriptors[i].getClassName().replace('.', '/') + ".class");
            if (descriptors[i].getRemoteHomeInterface() != null) {
                classes.add(descriptors[i].getRemoteHomeInterface().replace('.', '/') + ".class");
            }
            if (descriptors[i].getRemoteInterface() != null) {
                classes.add(descriptors[i].getRemoteInterface().replace('.', '/') + ".class");
            }
            if (descriptors[i].getLocalHomeInterface() != null) {
                classes.add(descriptors[i].getLocalHomeInterface().replace('.', '/') + ".class");
            }
            if (descriptors[i].getLocalInterface() != null) {
                classes.add(descriptors[i].getLocalInterface().replace('.', '/') + ".class");
            }
            if (descriptors[i] instanceof EntityDescriptor && (className = ((EntityDescriptor)descriptors[i]).getPrimaryKeyClass()) != null && !className.equals("") && this.isUserDefinedClass(className)) {
                classes.addElement(className.replace('.', '/') + ".class");
            }
            ++i;
        }
        this.dependences.setAdditionalPaths(classPath);
        Vector allDependences = this.dependences.getInfoClasses(classes);
        String entryInAdditionalFiles = null;
        String entryInDependances = null;
        boolean nothingToDo = false;
        int i2 = 0;
        while (i2 < additionalFiles.size()) {
            entryInAdditionalFiles = ((InfoObject)additionalFiles.elementAt(i2)).getEntryName().replace('\\', '/');
            nothingToDo = false;
            int j = 0;
            while (j < allDependences.size()) {
                entryInDependances = ((InfoObject)allDependences.elementAt(j)).getEntryName().replace('\\', '/');
                if (entryInAdditionalFiles.equals(entryInDependances)) {
                    nothingToDo = true;
                }
                ++j;
            }
            if (!nothingToDo) {
                allDependences.add(additionalFiles.elementAt(i2));
            }
            ++i2;
        }
        return this.hasDuplicateEntry(allDependences, 0);
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, String xmlFileLocation) throws J2EEGeneratorException {
        return this.getConvertedEJBDescriptor(loader, xmlFileLocation, false);
    }

    public EJBJarDescriptor getConvertedEJBDescriptor(ClassLoader loader, String xmlFileLocation, boolean complince) throws J2EEGeneratorException {
        Document document = null;
        EJBJarDescriptor result = new EJBJarDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new J2EEGeneratorException("Can not parse ejb-jar.xml. Reason : " + io.toString());
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new J2EEGeneratorException("Can not parse ejb-jar.xml. Reason : " + ioe.toString());
        }
        catch (Exception ex) {
            throw new J2EEGeneratorException("Can not parse ejb-jar.xml. Reason : " + ex.toString());
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd") > 0) {
            EJBConverter converter = new EJBConverter();
            converter.setLoader(loader);
            try {
                result = (EJBJarDescriptor)converter.parseDocument(document);
                converter.applyChanges(result);
            }
            catch (Exception e) {
                throw new J2EEGeneratorException("Can not parse ejb-jar.xml. Reason : " + e.toString());
            }
        }
        try {
            EJBJarParser parser = new EJBJarParser();
            if (!complince) {
                parser.setCompliance(complince);
            }
            result = parser.parseXml(document, new Vector(), loader, null);
            RMappingTool rTool = new RMappingTool(result.getAbstractSchema());
            try {
                rTool.createSchemaMapping();
            }
            catch (Exception rTex) {
                if (complince) {
                    throw rTex;
                }
            }
        }
        catch (Exception e) {
            throw new J2EEGeneratorException("Can not parse ejb-jar.xml. Reason : " + e.toString());
        }
        return result;
    }

    public WebDeploymentDescriptor getConvertedWebDescriptor(String xmlFileLocation) throws J2EEGeneratorException {
        Document document = null;
        WebDeploymentDescriptor result = new WebDeploymentDescriptor();
        BufferedInputStream buffer = null;
        try {
            buffer = new BufferedInputStream(new FileInputStream(xmlFileLocation));
        }
        catch (IOException io) {
            throw new J2EEGeneratorException("Can not parse web.xml. Reason : " + io.toString());
        }
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlFileLocation);
            document = domParser.parse((InputStream)buffer);
            buffer.close();
        }
        catch (IOException ioe) {
            throw new J2EEGeneratorException("Can not parse web.xml. Reason : " + ioe.toString());
        }
        catch (Exception ex) {
            throw new J2EEGeneratorException("Can not parse web.xml. Reason : " + ex.toString());
        }
        DocumentType dt = document.getDoctype();
        String dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        if (dt != null && (dtd = dt.getSystemId()) == null) {
            dtd = "<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>";
        }
        if (dtd.equals("<!DOCTYPE web-app [\n<!ELEMENT web-app (icon?, display-name?, description?, distributable?,\n context-param*, filter*, filter-mapping*, listener*, servlet*, servlet-mapping*, session-config?,\n mime-mapping*, welcome-file-list?, error-page*, taglib*,\n resource-ref*, security-constraint*, login-config?,\n security-role*, env-entry*, ejb-ref*, response-status*)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n <!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT distributable EMPTY>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT filter (icon?, filter-name, display-name?, description?, filter-class, init-param*)>\n<!ELEMENT filter-name (#PCDATA)>\n<!ELEMENT filter-class (#PCDATA)>\n<!ELEMENT filter-mapping (filter-name, (url-pattern | servlet-name))>\n<!ELEMENT listener (listener-class)>\n<!ELEMENT listener-class (#PCDATA)>\n<!ELEMENT servlet (icon?, servlet-name, display-name?, description?,\n(servlet-class|jsp-file), init-param*, load-on-startup?, security-role-ref*)>\n<!ELEMENT servlet-name (#PCDATA)>\n<!ELEMENT servlet-class (#PCDATA)>\n<!ELEMENT jsp-file (#PCDATA)>\n<!ELEMENT init-param (param-name, param-value, description?)>\n<!ELEMENT load-on-startup (#PCDATA)>\n<!ELEMENT servlet-mapping (servlet-name, url-pattern)>\n<!ELEMENT url-pattern (#PCDATA)>\n<!ELEMENT session-config (session-timeout?)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT mime-mapping (extension, mime-type)>\n<!ELEMENT extension (#PCDATA)>\n<!ELEMENT mime-type (#PCDATA)>\n<!ELEMENT welcome-file-list (welcome-file+)>\n<!ELEMENT welcome-file (#PCDATA)>\n<!ELEMENT taglib (taglib-uri, taglib-location)>\n<!ELEMENT taglib-uri (#PCDATA)>\n<!ELEMENT taglib-location (#PCDATA)>\n<!ELEMENT error-page ((error-code | exception-type), location)>\n<!ELEMENT error-code (#PCDATA)>\n<!ELEMENT exception-type (#PCDATA)>\n<!ELEMENT location (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT security-constraint (web-resource-collection+,\n auth-constraint?, user-data-constraint?)>\n<!ELEMENT web-resource-collection (web-resource-name, description?,\n url-pattern*, http-method*)>\n<!ELEMENT web-resource-name (#PCDATA)>\n<!ELEMENT http-method (#PCDATA)>\n<!ELEMENT user-data-constraint (description?, transport-guarantee)>\n<!ELEMENT transport-guarantee (#PCDATA)>\n<!ELEMENT auth-constraint (description?, role-name*)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT login-config (auth-method?, realm-name?, form-login-config?)>\n<!ELEMENT realm-name (#PCDATA)>\n<!ELEMENT form-login-config (form-login-page, form-error-page)>\n<!ELEMENT form-login-page (#PCDATA)>\n<!ELEMENT form-error-page (#PCDATA)>\n<!ELEMENT auth-method (#PCDATA)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-value?,\n env-entry-type)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home,\n   remote,ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n <!ELEMENT response-status (code, description)>\n <!ELEMENT code (#PCDATA)>\n]>") || dtd.indexOf("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") > 0) {
            WebConverter converter = new WebConverter();
            try {
                result = (WebDeploymentDescriptor)converter.parseDocument(document);
                converter.applyChanges(result);
            }
            catch (Exception e) {
                throw new J2EEGeneratorException("Can not parse web.xml. Reason : " + e.toString());
            }
        }
        try {
            result.loadFromDocument(document);
        }
        catch (Exception e) {
            throw new J2EEGeneratorException("Can not parse web.xml. Reason : " + e.toString());
        }
        return result;
    }

    public String[] checkDescriptor(ClassLoader loader, EJBJarDescriptor ejbJarDescr, String xmlFile) {
        EJB20DescriptorDocument doc = new EJB20DescriptorDocument(false);
        Document document = doc.loadEJBJarDescriptor(ejbJarDescr);
        Vector errors = doc.getErrors();
        if (errors == null || errors.size() == 0) {
            return null;
        }
        Object[] temp = new String[errors.size()];
        errors.copyInto(temp);
        return temp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

