/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.deploy;

import com.sap.engine.deploy.components.XMLComponentsGenerator;
import com.sap.engine.deploy.generator.EARGeneratorException;
import com.sap.engine.deploy.generator.XMLEarGenerator;
import com.sap.engine.deploy.manager.DeployManagerImpl;
import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.DeployPrjDocument;
import com.sap.engine.deploy.tool.gui.MakeAllStatusWindow;
import com.sap.engine.services.deploy.container.WarningException;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;

public class QuickDeploy
extends Thread {
    protected String theXML = null;
    String[] tabsXMLLocations = null;
    String[] tabNames = null;
    private String projectName;
    private Frame frame;
    private boolean cancel = false;
    private MakeAllStatusWindow makeAll;
    private int numberOfTabs = -1;
    public String errMessage = "";

    public QuickDeploy(Frame frame, String projectName) {
        this.frame = frame;
        this.projectName = projectName;
    }

    public void run() {
        try {
            this.readXML();
        }
        catch (Exception e) {
            this.errMessage = "Could not perform Make All of the project because of " + e.getMessage();
            this.makeAll.nextPhase(11);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readXML() throws IOException {
        block14: {
            this.theXML = this.projectName;
            DeployPrjDocument projectDocument = new DeployPrjDocument();
            projectDocument.readXMLPrjFile(this.projectName);
            this.tabsXMLLocations = projectDocument.getXMLLocationsTabs();
            this.tabNames = projectDocument.getTabsNames();
            File f = new File(this.projectName);
            String projDir = f.getParentFile().getAbsolutePath();
            if (this.tabNames == null) break block14;
            String tabName = null;
            this.numberOfTabs = this.tabNames.length;
            try {
                int i = 0;
                while (i < this.tabNames.length) {
                    block16: {
                        block17: {
                            block15: {
                                tabName = this.tabNames[i];
                                if (!tabName.equals("J2EE Components")) break block15;
                                if (!this.cancel) {
                                    this.makeAll.nextPhase(1);
                                    this.generateArchives(projDir + File.separator + this.tabsXMLLocations[i], f.getParent() + f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf(File.separator), f.getAbsolutePath().lastIndexOf(".")));
                                    break block16;
                                } else {
                                    this.cancel = false;
                                    this.makeAll.nextPhase(5);
                                    break;
                                }
                            }
                            if (!tabName.equals("Assembler")) break block17;
                            if (!this.cancel) {
                                this.makeAll.nextPhase(2);
                                this.generateEAR(projDir + File.separator + this.tabsXMLLocations[i], f.getParent() + f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf(File.separator), f.getAbsolutePath().lastIndexOf(".")));
                                break block16;
                            } else {
                                this.cancel = false;
                                this.makeAll.nextPhase(5);
                                break;
                            }
                        }
                        if (tabName.equals("Deployer")) {
                            if (this.cancel) {
                                this.makeAll.nextPhase(5);
                                this.cancel = false;
                                break;
                            }
                            this.makeAll.nextPhase(3);
                            this.deployEAR(projDir + File.separator + this.tabsXMLLocations[i], f.getParent() + f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf(File.separator), f.getAbsolutePath().lastIndexOf(".")));
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                try {
                    this.makeAll.nextPhase(10);
                    Thread.currentThread();
                    Thread.sleep(500L);
                    throw e;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                throw e;
            }
            this.makeAll.nextPhase(4);
            return;
        }
        try {
            this.makeAll.nextPhase(9);
            Thread.currentThread();
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    public void generateArchives(String xmlLocation, String projDir) throws IOException {
        String logFile = projDir + File.separator + "j2ee_generator_log.txt";
        XMLComponentsGenerator xmlGenerator = new XMLComponentsGenerator(xmlLocation, logFile);
        xmlGenerator.makeArchive();
    }

    public void generateEAR(String xmlLocation, String projDir) throws IOException {
        XMLEarGenerator xm = new XMLEarGenerator();
        String logFile = projDir + File.separator + "ear_generator_log.txt";
        try {
            if (!xm.generateEar(xmlLocation, logFile)) {
                throw new IOException("Could not generate Ear. See Log for details. ");
            }
            System.out.println("Ear generated successfully...");
        }
        catch (EARGeneratorException e) {
            throw new IOException("Could not generate Ear. See Log for details. (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Could not generate Ear. See Log for details. (" + e.getMessage() + ")");
        }
    }

    public void deployEAR(String xmlLocation, String projDir) throws IOException {
        try {
            String newProjDir = projDir;
            if (new File(ApplicationInformationProvider.concatPath(projDir, "deployer")).exists()) {
                newProjDir = ApplicationInformationProvider.concatPath(projDir, "deployer");
            }
            DeployManagerImpl dm = new DeployManagerImpl(xmlLocation);
            dm.setLog(newProjDir + File.separator + "deployer_log.txt");
            dm.deploy();
            System.out.println("Done.");
        }
        catch (Exception eMain) {
            if (eMain instanceof WarningException) {
                System.out.println("Done.");
            }
            throw new IOException("NOT Deployed !!! Look at Log-file for errors..." + eMain.getMessage());
        }
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public void setMakeAllStatusWindow(MakeAllStatusWindow makeAll) {
        this.makeAll = makeAll;
    }

    public int getNumberOfTabs() {
        return this.numberOfTabs;
    }
}

