/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFilter {
    private static final int FILTER_COUNT = 10;
    private JarFile jarFile;
    private String jarName;
    private Manifest manifest;
    private String[] filter;
    private int count;
    private int depth;
    private int first;
    private int second;
    private boolean isActive;

    public JarFilter(String jarName) throws IOException {
        if (jarName == null) {
            throw new IOException("Jar name is null");
        }
        this.jarName = jarName;
        this.jarFile = new JarFile(jarName);
        try {
            this.manifest = this.jarFile.getManifest();
        }
        catch (Exception e) {
            this.manifest = null;
        }
        this.isActive = true;
        this.filter = new String[10];
        this.count = 0;
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            String packageName = null;
            int index = entryName.lastIndexOf(47);
            packageName = index != -1 ? entryName.substring(0, index) : entryName;
            this.addEntry(packageName);
        }
        if (this.isActive) {
            String[] newFilter = new String[this.count];
            System.arraycopy(this.filter, 0, newFilter, 0, this.count);
            this.filter = newFilter;
        }
    }

    public void print() {
        if (this.isActive) {
            int i = 0;
            while (i < this.filter.length) {
                System.out.println(i + " " + this.filter[i]);
                ++i;
            }
        }
    }

    public boolean accept(String name) {
        if (!this.isActive) {
            return true;
        }
        int i = 0;
        while (i < this.filter.length) {
            if (name.startsWith(this.filter[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JarFile getJar() {
        return this.jarFile;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void open() throws IOException {
        this.jarFile = new JarFile(this.jarName);
    }

    private void addEntry(String entry) {
        if (!this.isActive) {
            return;
        }
        if (this.count < 10) {
            this.filter[this.count++] = entry;
            int maxDepth = -1;
            int pos = -1;
            int i = 0;
            while (i < this.count - 1) {
                int m = this.getEqualLength(this.filter[i], this.filter[this.count - 1]);
                if (m == -1) {
                    if (this.filter[i].length() > this.filter[this.count - 1].length()) {
                        this.filter[i] = this.filter[this.count - 1];
                        this.filter[--this.count] = null;
                        this.recheck(i);
                    } else {
                        this.filter[--this.count] = null;
                    }
                    return;
                }
                if (m > maxDepth) {
                    maxDepth = m;
                    pos = i;
                }
                ++i;
            }
            if (maxDepth > this.depth) {
                this.depth = maxDepth;
                this.first = pos;
                this.second = this.count - 1;
            }
        } else {
            String name = entry;
            int maxDepth = -1;
            int pos = -1;
            int i = 0;
            while (i < 10) {
                int m = this.getEqualLength(this.filter[i], name);
                if (m == -1) {
                    if (this.filter[i].length() > name.length()) {
                        this.filter[i] = name;
                        this.recheck(i);
                    }
                    return;
                }
                if (m > maxDepth) {
                    maxDepth = m;
                    pos = i;
                }
                ++i;
            }
            if (maxDepth > this.depth) {
                this.filter[pos] = name.substring(0, maxDepth);
                this.recheck(pos);
            } else {
                this.merge();
                if (this.isActive) {
                    this.filter[this.second] = name;
                    this.recheck(this.first);
                    this.calculate();
                }
            }
        }
    }

    private int getEqualLength(String a, String b) {
        if (a.length() > b.length()) {
            String c = b;
            b = a;
            a = c;
        }
        int i = 0;
        while (i < a.length()) {
            if (a.charAt(i) != b.charAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void merge() {
        this.calculate();
        if (this.filter[this.first].length() > this.filter[this.second].length()) {
            String c = this.filter[this.first];
            this.filter[this.first] = this.filter[this.second];
            this.filter[this.second] = c;
        }
        if (this.filter[this.first].length() > this.depth) {
            this.filter[this.first] = this.filter[this.first].substring(0, this.depth);
        }
        if (this.depth == 0) {
            this.isActive = false;
            this.filter = null;
        }
    }

    private void calculate() {
        this.depth = -1;
        int i = 0;
        while (i < this.count) {
            int j = i + 1;
            while (j < this.count) {
                int m = this.getEqualLength(this.filter[i], this.filter[j]);
                if (m != -1 && m > this.depth) {
                    this.depth = m;
                    this.first = i;
                    this.second = j;
                }
                ++j;
            }
            ++i;
        }
    }

    private void recheck(int pos) {
        int i = 0;
        while (i < this.count) {
            if (i != pos && this.filter[i].startsWith(this.filter[pos])) {
                if (i < pos) {
                    this.filter[i] = this.filter[pos];
                    this.filter[pos] = this.filter[--this.count];
                    pos = i;
                    this.filter[this.count] = null;
                } else {
                    this.filter[i] = this.filter[--this.count];
                    this.filter[this.count] = null;
                    --i;
                }
            }
            ++i;
        }
    }
}

