/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import com.sap.engine.boot.CoverageMethodModifier;
import com.sap.engine.boot.ModificationFactory;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.CFSerializer;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import java.io.IOException;

public class CoverageClassModifier {
    protected static String S_TRACER = "com/sap/engine/boot/CoverageTracer";
    private final CFFactory factory;
    private final CFParser parser;
    private final CFSerializer serializer;
    private final CoverageMethodModifier methodModifier = new CoverageMethodModifier();
    private Instruction[] instruction = new Instruction[65536];
    private LocalVariable[] lv;

    public CoverageClassModifier() {
        this.factory = CFFactory.getThreadLocalInstance();
        this.parser = this.factory.createCFParser();
        this.serializer = this.factory.createCFSerializer();
        this.lv = new LocalVariable[5];
        int i = 0;
        while (i < this.lv.length) {
            this.lv[i] = this.factory.createLocalVariable(i);
            ++i;
        }
    }

    public String[][] getInfoFor(byte[] classData) throws IOException {
        String[][] res = new String[2][];
        ClassFile cf = this.parser.parse(classData, null);
        if (cf.isInterface()) {
            return null;
        }
        MethodInfo[] methods = cf.getMethodsArray();
        String className = cf.getName().replace('/', '.');
        res[0] = new String[1];
        res[0][0] = className;
        res[1] = new String[methods.length];
        int i = 0;
        while (i < methods.length) {
            MethodInfo m = methods[i];
            res[1][i] = m.getName() + m.getDescriptor();
            ++i;
        }
        return res;
    }

    public byte[] modify(byte[] classData, String className) throws IOException {
        if (!ModificationFactory.accept(className)) {
            return classData;
        }
        CoverageClassModifier coverageClassModifier = this;
        synchronized (coverageClassModifier) {
            ClassFile cf = this.parser.parse(classData, null);
            if (cf.isInterface()) {
                byte[] byArray = classData;
                return byArray;
            }
            this.modifyClass(cf);
            byte[] byArray = this.serializer.serializeToByteArray(cf, null);
            return byArray;
        }
    }

    private void modifyClass(ClassFile cf) {
        MethodInfo[] methods = cf.getMethodsArray();
        String className = cf.getName().replace('/', '.');
        CPInfo cpcTracer = cf.createCPInfoClass(S_TRACER);
        CPInfo cpmMethodStart = cf.createCPInfoMemberRef(10, cpcTracer, "methodStart", "(I)V");
        int nMethods = methods.length;
        MethodInfo[] modifiedMethods = new MethodInfo[methods.length];
        int nModifiedMethods = 0;
        int i = 0;
        while (i < nMethods) {
            MethodInfo m = methods[i];
            CodeAttribute ca = m.getCodeAttribute();
            boolean mustModify = ca != null;
            if (mustModify) {
                int index = 0;
                String[] stringArray = ModificationFactory.NAMES;
                synchronized (stringArray) {
                    ModificationFactory.NAMES[ModificationFactory.COUNT_OF_ALL_METHODS] = className + ":" + m.getName() + m.getDescriptor();
                    index = ModificationFactory.COUNT_OF_ALL_METHODS++;
                }
                this.methodModifier.modifyMethod(cf, m, index, this.instruction, cpmMethodStart);
                modifiedMethods[nModifiedMethods] = methods[i];
                ++nModifiedMethods;
            }
            ++i;
        }
    }
}

