/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.entapplication;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.Descriptors;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    File pluginRoot;
    DirsAndFiles daf;
    int br = 0;
    FileCreator fCreator;
    int currentStep;
    private IBuildInfo buildInfo;
    Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$entapplication$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$entapplication$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.entapplication.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$entapplication$CreateBuildFileAction));
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$entapplication$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public BuildActionResult execute() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        this.loc.infoT("Enterprise Application Plugin starts creating the build file");
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        Descriptors descriptors = new Descriptors();
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        this.fCreator.setStrContext("dc_gen_variantDir", this.daf.getGenVariantDir());
        HashMap buildOptions = this.daf.getBuildOptions();
        this.fCreator.setHashMapContext("dc_build_options", buildOptions);
        List sourceDirs = this.daf.getSourceDirs();
        this.fCreator.setListContext("dc_source_dirs", sourceDirs);
        int i = 0;
        while (i < sourceDirs.size()) {
            String sourceFolderName = (String)sourceDirs.get(i);
            if (sourceFolderName.equalsIgnoreCase("META-INF")) {
                this.fCreator.setStrContext("dc_meta_inf_dir", sourceFolderName);
            } else {
                this.loc.infoT("error: only META-INF beneath the root is allowed!");
            }
            ++i;
        }
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_depend_assemblyDirs", assDep);
        List compDep = this.daf.getDependencies();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                String name = dep.getComponent().getName();
                String vendor = dep.getComponent().getVendor();
                ComponentType type = null;
                DCReference dcRef = dep.getComponent();
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                if (type == null) {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", ""));
                    continue;
                }
                allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType()));
            }
        }
        this.fCreator.setListContext("dc_all_dep", allDep);
        this.fCreator.setStrContext("dc_gen_temp_dir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_deploy_dir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deploy_file", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        try {
            this.fCreator.setStrContext("compiler_executable_path", this.buildInfo.getCompilerExecutable());
        }
        catch (NoSuchMethodError ex) {
            String msg = "pluginhandler does not supply getCompilerExecutable";
            this.loc.traceThrowableT(300, msg, (Throwable)ex);
        }
        String ddDirName = this.daf.getTempDir();
        String ddFileName = ddDirName + File.separator + "sda-dd.xml";
        try {
            descriptors.genSdaXml(ddFileName);
        }
        catch (IOException io) {
            String msg = "error generating sda-dd.xml";
            this.loc.traceThrowableT(500, msg, (Throwable)io);
        }
        this.fCreator.setStrContext("sda_descriptor_file", ddFileName);
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        if (this.br != 2 && this.br != 3 && this.daf.checkAssDependencies()) {
            this.fCreator.createBuildFile();
        } else {
            String errMsg = "";
            LogFile log = new LogFile();
            if (!this.daf.checkAssDependencies()) {
                errMsg = this.daf.getErrorMsgAss();
                this.br = 2;
            }
            log.setErrorMessage(errMsg);
            log.writeLogFile(this.daf.getLogFile());
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

