/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.util;

import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class ToolTipHandler {
    private Shell parentShell;
    private Shell tipShell;
    private Label tipLabelImage;
    private Label tipLabelText;
    private Widget tipWidget;
    private Point tipPosition;

    public ToolTipHandler(Shell parent) {
        Display display = parent.getDisplay();
        this.parentShell = parent;
        this.tipShell = new Shell(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipLabelImage = new Label((Composite)this.tipShell, 0);
        this.tipLabelImage.setForeground(display.getSystemColor(28));
        this.tipLabelImage.setBackground(display.getSystemColor(29));
        this.tipLabelImage.setLayoutData((Object)new GridData(772));
        this.tipLabelText = new Label((Composite)this.tipShell, 0);
        this.tipLabelText.setForeground(display.getSystemColor(28));
        this.tipLabelText.setBackground(display.getSystemColor(29));
        this.tipLabelText.setLayoutData((Object)new GridData(772));
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ToolTipHandler.this.tipShell.isVisible()) {
                    ToolTipHandler.this.tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (ToolTipHandler.this.tipShell.isVisible()) {
                    ToolTipHandler.this.tipShell.setVisible(false);
                }
                ToolTipHandler.this.tipWidget = null;
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                if (widget instanceof Table) {
                    Table w = (Table)widget;
                    widget = w.getItem(pt);
                }
                if (widget == null) {
                    ToolTipHandler.this.tipShell.setVisible(false);
                    ToolTipHandler.this.tipWidget = null;
                    return;
                }
                if (widget == ToolTipHandler.this.tipWidget) {
                    return;
                }
                ToolTipHandler.this.tipWidget = widget;
                ToolTipHandler.this.tipPosition = control.toDisplay(pt);
                String text = (String)widget.getData("TOOLTIP_TEXT");
                Image image = (Image)widget.getData("TOOLTIP_IMAGE");
                ToolTipHandler.this.tipLabelText.setText(text != null ? text : "");
                ToolTipHandler.this.tipLabelImage.setImage(image);
                ToolTipHandler.this.tipShell.pack();
                ToolTipHandler.this.setHoverLocation(ToolTipHandler.this.tipShell, ToolTipHandler.this.tipPosition);
                if (TableUtil.stringIsEmpty(text)) {
                    ToolTipHandler.this.tipShell.setVisible(false);
                } else {
                    ToolTipHandler.this.tipShell.setVisible(true);
                }
            }
        });
    }

    private void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

