/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.util;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtColumnChecker;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtSimpleTypeChecker;
import com.sap.dictionary.designtime.DtSimpleTypeExpanded;
import com.sap.dictionary.designtime.DtStructureColumnChecker;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtIndexField;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.sql.sqlparser.SQLKeywords;
import com.tssap.dii.dtri.actions.file.FileAddAction;
import com.tssap.dii.dtri.actions.file.FileCheckoutAction;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class TableUtil {
    private static Vector mFieldMessages = new Vector();
    private static int indexFieldCheck = -1;
    private static int indexSimpleTypeCheck = -1;

    public static boolean stringIsEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    public static String getNotNullString(Object object) {
        String string = (String)object;
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        return string;
    }

    public static boolean checkValidConstraint(String builtInType, String constraint) {
        HashSet hValidConstraints = DtSimpleTypeChecker.getValidConstraints((String)builtInType);
        if (hValidConstraints == null) {
            return false;
        }
        Object[] oValidConstraints = ((AbstractCollection)hValidConstraints).toArray();
        int i = 0;
        while (i < oValidConstraints.length) {
            if (oValidConstraints[i].toString().equals(constraint)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getBuiltInTypes() {
        HashSet hBuiltInTypes = DtTypeInfo.getBuiltInTypes();
        Object[] oBuiltInTypes = ((AbstractCollection)hBuiltInTypes).toArray();
        TreeSet<String> tBuiltInTypes = new TreeSet<String>();
        int i = 0;
        while (i < oBuiltInTypes.length) {
            String builtInType = (String)oBuiltInTypes[i];
            if (builtInType != null && !builtInType.equalsIgnoreCase("boolean")) {
                tBuiltInTypes.add(builtInType);
            }
            ++i;
        }
        tBuiltInTypes.add("");
        oBuiltInTypes = tBuiltInTypes.toArray();
        String[] builtInTypes = new String[oBuiltInTypes.length];
        int i2 = 0;
        while (i2 < oBuiltInTypes.length) {
            builtInTypes[i2] = (String)oBuiltInTypes[i2];
            ++i2;
        }
        return builtInTypes;
    }

    public static String[] getBuiltInTypesForStructures() {
        HashSet hBuiltInTypes = DtTypeInfo.getBuiltInTypes();
        Object[] oBuiltInTypes = ((AbstractCollection)hBuiltInTypes).toArray();
        TreeSet<String> tBuiltInTypes = new TreeSet<String>();
        int i = 0;
        while (i < oBuiltInTypes.length) {
            String builtInType = (String)oBuiltInTypes[i];
            if (builtInType != null) {
                tBuiltInTypes.add(builtInType);
            }
            ++i;
        }
        tBuiltInTypes.add("");
        oBuiltInTypes = tBuiltInTypes.toArray();
        String[] builtInTypes = new String[oBuiltInTypes.length];
        int i2 = 0;
        while (i2 < oBuiltInTypes.length) {
            builtInTypes[i2] = (String)oBuiltInTypes[i2];
            ++i2;
        }
        return builtInTypes;
    }

    public static Object[] getSimpleTypeAttributes(DtSimpleType dtSimpleType) {
        String builtInType = null;
        String string = null;
        Object notNull = null;
        Object dtDbProperty = null;
        Object[] attributes = new Object[11];
        DtSimpleTypeExpanded dtSimpleTypeExpanded = null;
        dtSimpleTypeExpanded = new DtSimpleTypeExpanded(dtSimpleType, false);
        attributes[3] = dtSimpleType.getPackage();
        if (attributes[3] == null) {
            attributes[3] = "";
        }
        if ((builtInType = dtSimpleTypeExpanded.getBuiltInType()) == null) {
            builtInType = "";
        }
        attributes[5] = builtInType;
        int ld = dtSimpleTypeExpanded.getLength();
        if (ld <= 0) {
            ld = dtSimpleTypeExpanded.getTotalDigits();
        }
        if (ld <= 0) {
            ld = dtSimpleTypeExpanded.getMaxLength();
        }
        if (ld > 0) {
            attributes[6] = new Integer(ld);
        }
        if ((ld = dtSimpleTypeExpanded.getFractionDigits()) > 0) {
            attributes[7] = new Integer(ld);
        }
        if ((string = dtSimpleTypeExpanded.getDescription()) == null) {
            string = "";
        }
        attributes[10] = string;
        attributes[8] = new Boolean(dtSimpleTypeExpanded.getNotNull());
        string = dtSimpleTypeExpanded.getDbDefault();
        if (string == null) {
            string = "";
        }
        attributes[9] = string;
        return attributes;
    }

    public static Object[] getSimpleTypeAttributes(String packageName, String simpleType, DtDictionaryRoot dtDictionaryRoot) {
        DtSimpleType dtSimpleType = null;
        try {
            dtSimpleType = dtDictionaryRoot.getSimpleType(packageName, simpleType);
            if (dtSimpleType == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return TableUtil.getSimpleTypeAttributes(dtSimpleType);
    }

    public static Object[] getFieldAttributes(DtField dtField) {
        String builtInType = null;
        String string = null;
        Object[] attributes = new Object[11];
        builtInType = dtField.getBuiltInType();
        if (builtInType == null) {
            builtInType = "";
        }
        attributes[5] = builtInType;
        int ld = dtField.getLength();
        if (ld <= 0) {
            ld = dtField.getTotalDigits();
        }
        if (ld > 0) {
            attributes[6] = new Integer(ld);
        }
        if ((ld = dtField.getFractionDigits()) > 0) {
            attributes[7] = new Integer(ld);
        }
        if ((string = dtField.getDescription()) == null) {
            string = "";
        }
        attributes[10] = string;
        attributes[8] = dtField.getNotNull() == BooleanEnum.FALSE ? new Boolean(false) : new Boolean(true);
        string = dtField.getDbDefault();
        if (string == null) {
            string = "";
        }
        attributes[9] = string;
        return attributes;
    }

    public static boolean fieldNameIsValid(AbstractTableFieldsTableModel tableFieldsTableModel, String fieldName, int index, boolean showIndexInMessage) {
        mFieldMessages.clear();
        if (TableUtil.stringIsEmpty(fieldName)) {
            if (showIndexInMessage) {
                mFieldMessages.addElement(MessagePool.getMessage((String)"Row &: Name is missing", (String)Integer.toString(index)));
            } else {
                mFieldMessages.addElement("Specify the name");
            }
            return false;
        }
        if (tableFieldsTableModel instanceof TableFieldsTableModel && SQLKeywords.isKeyword((String)fieldName)) {
            mFieldMessages.addElement(MessagePool.getMessage((String)"Name & is reserved", (String)fieldName));
        }
        if (tableFieldsTableModel instanceof TableFieldsTableModel) {
            DtColumnChecker dtColumnChecker = new DtColumnChecker();
            if (!dtColumnChecker.nameIsOk(fieldName)) {
                HashMap hMessages = dtColumnChecker.getMessages();
                if (hMessages != null && !hMessages.isEmpty()) {
                    Set kMessages = hMessages.keySet();
                    Object[] oMessages = kMessages.toArray();
                    mFieldMessages.addElement(oMessages[0]);
                } else {
                    mFieldMessages.addElement(MessagePool.getMessage((String)"Name & contains invalid characters", (String)fieldName));
                }
            }
        } else {
            DtStructureColumnChecker dtStructureColumnChecker = new DtStructureColumnChecker();
            if (!dtStructureColumnChecker.nameIsOk(fieldName)) {
                HashMap hMessages = dtStructureColumnChecker.getMessages();
                if (hMessages != null && !hMessages.isEmpty()) {
                    Set kMessages = hMessages.keySet();
                    Object[] oMessages = kMessages.toArray();
                    mFieldMessages.addElement(oMessages[0]);
                } else {
                    mFieldMessages.addElement(MessagePool.getMessage((String)"Name & contains invalid characters", (String)fieldName));
                }
            }
        }
        if (tableFieldsTableModel.tableHasField(fieldName, index)) {
            mFieldMessages.addElement(MessagePool.getMessage((String)"Name & occurs more than once", (String)fieldName));
        }
        return mFieldMessages.isEmpty();
    }

    public static Vector getFieldMessages() {
        return mFieldMessages;
    }

    public synchronized Vector checkTableColumn(AbstractTableFieldsTableModel tableFieldsTableModel, int index, DtDictionaryRoot dtDictionaryRoot, boolean checkLength, boolean showIndexInMessage, boolean startRowWizard) {
        int j;
        Vector messages = new Vector();
        Vector tMessages = null;
        Object message = null;
        String fieldName = null;
        String simpleType = null;
        String packageName = null;
        String builtInType = null;
        Object dtSimpleType = null;
        int i = 0;
        Integer integer = null;
        Object tableItem = null;
        if (index < 0 || index >= tableFieldsTableModel.getRowCount()) {
            return null;
        }
        fieldName = TableUtil.getFieldName(tableFieldsTableModel, index);
        tMessages = TableUtil.checkFieldName(tableFieldsTableModel, fieldName, index, showIndexInMessage);
        if (tMessages != null) {
            j = 0;
            while (j < tMessages.size()) {
                messages.addElement(tMessages.get(j));
                ++j;
            }
        }
        simpleType = (String)tableFieldsTableModel.getValueAt(index, 4);
        packageName = (String)tableFieldsTableModel.getValueAt(index, 3);
        if (!TableUtil.stringIsEmpty(simpleType)) {
            tMessages = TableUtil.checkSimpleType(packageName, simpleType, dtDictionaryRoot);
            if (tMessages != null) {
                j = 0;
                while (j < tMessages.size()) {
                    messages.addElement(tMessages.get(j));
                    ++j;
                }
            }
        } else if (checkLength && !TableUtil.stringIsEmpty(builtInType = (String)tableFieldsTableModel.getValueAt(index, 5))) {
            integer = (Integer)tableFieldsTableModel.getValueAt(index, 6);
            i = integer != null ? Integer.valueOf(integer.toString()) : 0;
            if (i > 0 && (tMessages = TableUtil.checkLength(builtInType, i)) != null) {
                j = 0;
                while (j < tMessages.size()) {
                    messages.addElement(tMessages.get(j));
                    ++j;
                }
            }
            if ((i = (integer = (Integer)tableFieldsTableModel.getValueAt(index, 7)) != null ? Integer.valueOf(integer.toString()) : 0) > 0 && (tMessages = TableUtil.checkLength(builtInType, i)) != null) {
                j = 0;
                while (j < tMessages.size()) {
                    messages.addElement(tMessages.get(j));
                    ++j;
                }
            }
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages;
    }

    public static Vector checkSimpleType(String packageName, String simpleType, DtDictionaryRoot dtDictionaryRoot) {
        Vector<String> messages;
        block5: {
            messages = new Vector<String>();
            DtSimpleType dtSimpleType = null;
            if (TableUtil.stringIsEmpty(simpleType)) {
                return null;
            }
            try {
                dtSimpleType = dtDictionaryRoot.getSimpleType(packageName, simpleType);
                if (dtSimpleType == null) {
                    throw new NullPointerException();
                }
            }
            catch (Exception ex) {
                if (dtSimpleType != null) break block5;
                messages.addElement(MessagePool.getMessage((String)"Simple type & does not exist in package &", (String)simpleType, (String)packageName));
            }
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages;
    }

    public static Vector checkFieldName(AbstractTableFieldsTableModel tableFieldsTableModel, String fieldName, int index, boolean showIndexInMessage) {
        Vector messages = null;
        if (!TableUtil.fieldNameIsValid(tableFieldsTableModel, fieldName, index, showIndexInMessage)) {
            messages = TableUtil.getFieldMessages();
        }
        return messages;
    }

    public static Vector checkLength(String builtInType, int length) {
        Vector<String> messages = new Vector<String>();
        if (TableUtil.stringIsEmpty(builtInType) || length <= 0) {
            return null;
        }
        if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
            messages.addElement(MessagePool.getMessage((String)"Length is not allowed for built-in type &", (String)builtInType));
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages;
    }

    public static Vector checkDecimals(String builtInType, int decimals) {
        Vector<String> messages = new Vector<String>();
        if (TableUtil.stringIsEmpty(builtInType) || decimals <= 0) {
            return null;
        }
        if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
            messages.addElement(MessagePool.getMessage((String)"Decimals are not allowed for built-in type &", (String)builtInType));
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages;
    }

    private static String getFieldName(AbstractTableFieldsTableModel tableFieldsTableModel, int index) {
        String fieldName = (String)tableFieldsTableModel.getValueAt(index, 1);
        if (fieldName == null) {
            fieldName = "";
        }
        return fieldName;
    }

    public static String getJdbcType(String builtInType, int length, DatabaseEnum[] databaseEnum) {
        if (TableUtil.stringIsEmpty(builtInType) || databaseEnum == null || databaseEnum != null && databaseEnum.length == 0) {
            return null;
        }
        ArrayList jdbcTypeInfo = DdMapping.getJdbcTypeInfo((String)builtInType, (int)length, (DatabaseEnum[])databaseEnum);
        int i = 0;
        while (i < jdbcTypeInfo.size()) {
            if (((DtTypeInfoForDatabase)jdbcTypeInfo.get(i)).getDatabaseName().compareTo("DEFAULT") == 0) {
                return ((DtTypeInfoForDatabase)jdbcTypeInfo.get(i)).getJavaSqlTypeName();
            }
            ++i;
        }
        return null;
    }

    public static DatabaseEnum[] getDatabaseEnum() {
        Vector<DatabaseEnum> vDatabases = new Vector<DatabaseEnum>();
        Enumeration e = DatabaseEnum.enumerate();
        while (e.hasMoreElements()) {
            vDatabases.addElement((DatabaseEnum)e.nextElement());
        }
        DatabaseEnum[] databases = new DatabaseEnum[vDatabases.size()];
        vDatabases.toArray(databases);
        if (vDatabases.isEmpty()) {
            return null;
        }
        return databases;
    }

    public static String checkDbDefault(String dbDefault, String builtInType, int length, int decimals) {
        String message = "";
        String jdbcType = "";
        if (dbDefault != null && dbDefault.length() > 0) {
            jdbcType = TableUtil.getJdbcType(builtInType, length, TableUtil.getDatabaseEnum());
            ArrayList jdbcTypes = DtTypeInfo.getJdbcTypesWithoutDefault();
            if (jdbcType == null) {
                return MessagePool.getMessage((String)"Built-in type & does not exist", (String)builtInType);
            }
            Iterator iter = ((AbstractList)jdbcTypes).iterator();
            while (iter.hasNext()) {
                String jdbcType2 = (String)iter.next();
                if (!jdbcType.equalsIgnoreCase(jdbcType2)) continue;
                return MessagePool.getMessage((String)"DB default is not allowed for JDBC type &", (String)jdbcType);
            }
        }
        if (TableUtil.stringIsEmpty(message = DtSimpleTypeChecker.checkDbDefaultContent((String)dbDefault, (String)builtInType, (String)jdbcType))) {
            message = DtSimpleTypeChecker.checkStringFieldContent((String)"", (String)builtInType, (String)dbDefault, (String)"");
        }
        if (TableUtil.stringIsEmpty(message)) {
            message = DtSimpleTypeChecker.checkStringValueLength((String)builtInType, (String)dbDefault, (int)0, (int)0, (int)length, (String)"");
        }
        if (TableUtil.stringIsEmpty(message) && length > 0) {
            message = DtSimpleTypeChecker.checkDecimalFormat((String)dbDefault, (int)length, (int)decimals, (String)builtInType, (String)"");
        }
        if (TableUtil.stringIsEmpty(message)) {
            return null;
        }
        String template = TableUtil.getDbDefaultTemplate(builtInType, length, decimals);
        if (template == null) {
            return message;
        }
        return message + "\n" + MessagePool.getMessage((String)"Enter value in the format &", (String)template);
    }

    public static String getDbDefaultTemplate(String builtInType, int length, int decimals) {
        if (TableUtil.stringIsEmpty(builtInType)) {
            return null;
        }
        String template = builtInType.equals("date") ? null : (builtInType.equals("time") ? null : (builtInType.equals("timestamp") ? null : (builtInType.equals("boolean") ? null : (TableUtil.checkValidConstraint(builtInType, "totalDigits") ? DtHelper.getNumberTemplate((int)length, (int)decimals) : null))));
        return template;
    }

    public static String getDbDefault(String builtInType, int length, int decimals) {
        String jdbcType = TableUtil.getJdbcType(builtInType, length, TableUtil.getDatabaseEnum());
        if (!TableUtil.stringIsEmpty(jdbcType)) {
            return DtTypeInfo.getDefaultDefault((String)jdbcType);
        }
        return null;
    }

    public static void setToolTipInfo(TableItem tableItem, Vector messages, boolean showError) {
        String text = "";
        Image image = null;
        Image image0 = null;
        if (messages.isEmpty()) {
            return;
        }
        if (showError) {
            tableItem.setForeground(new Color((Device)tableItem.getDisplay(), 255, 0, 0));
            image = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_ERROR_TSK");
        } else {
            tableItem.setForeground(new Color((Device)tableItem.getDisplay(), 0, 0, 255));
            image = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_WARN_TSK");
        }
        tableItem.setData("TOOLTIP_IMAGE", (Object)image);
        int i = 0;
        while (i < messages.size()) {
            if (i != 0) {
                text = text.concat(", ");
            }
            text = text.concat((String)messages.get(i));
            ++i;
        }
        tableItem.setData("TOOLTIP_TEXT", (Object)text);
        image0 = image;
        tableItem.setImage(0, image0);
    }

    public static void resetToolTipInfo(TableItem tableItem) {
        tableItem.setForeground(new Color((Device)tableItem.getDisplay(), 0, 0, 0));
        tableItem.setData("TOOLTIP_IMAGE", null);
        tableItem.setData("TOOLTIP_TEXT", null);
        tableItem.setImage(0, null);
    }

    public static void dbIndexDeletionCheck(String fieldName, DtDbTable dtDbTable) {
        DtDbIndex[] indexes = dtDbTable.getDbIndexes();
        int i = 0;
        while (i < dtDbTable.getDbIndexCount()) {
            DtIndexField[] field = indexes[i].getIndexFields();
            int j = 0;
            while (j < indexes[i].getIndexFieldCount()) {
                if (field[j].getName().compareTo(fieldName) == 0 && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)MessagePool.getMessage((String)"Column & is in index &. Do you want to delete this column from the index?", (String)fieldName, (String)indexes[i].getName()))) {
                    try {
                        TableUtil.checkDtrState(field[j].getIndex());
                        field[j].delete();
                        int l = j + 1;
                        while (l < field.length) {
                            field[l].setPosition(l - 1);
                            ++l;
                        }
                    }
                    catch (DeleteException e2) {
                        TableEditorPlugin.tracer.error("delete index", (Throwable)e2);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void checkDtrState(DtDbIndex dtDbIndex) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(dtDbIndex.getMetamodel().getName());
        if (project == null) {
            return;
        }
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            return;
        }
        if (!DtrHelper.isUserLoggedOn((IProject)project) && !DtrHelper.logon((IProject)project)) {
            return;
        }
        UniqueName uname = ModelAccess.createModelUniqueName((String)dtDbIndex.getMetamodel().getName());
        Model lModel = ModelAccess.getModel((UniqueName)uname);
        if (lModel == null) {
            return;
        }
        FileAddAction addAction = new FileAddAction();
        UniqueName dbTableUname = DataSourceManager.createUniqueName((DevelopmentObject)dtDbIndex, (String)"DbIndex", (String)"Local Dictionary");
        Element element = lModel.findElement(dbTableUname);
        Element[] elements = new Element[]{element};
        if (addAction.isEnabled(elements)) {
            addAction.run(elements);
            return;
        }
        FileCheckoutAction checkoutAction = new FileCheckoutAction();
        if (checkoutAction.isEnabled(elements)) {
            checkoutAction.run(elements);
            return;
        }
    }
}

