/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.service;

import com.sap.dictionary.tools.tableeditor.service.SimpletypeContentProvider;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeLabelProvider;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SimpletypeSelectionDialog
extends TitleAreaDialog {
    private Shell mShell;
    private TreeViewer mViewer;
    private DtSimpleType mSimpleType;
    private DtDictionaryRoot[] mDictionariesRoot;
    private String mTitle;
    private String mDescription;
    private SimpletypeSelection mSimpletypeSelection;

    public SimpletypeSelectionDialog(SimpletypeSelection simpletypeSelection, DtDictionaryRoot dictionaryRoot, Shell shell) {
        super(shell);
        this.mShell = shell;
        this.mSimpletypeSelection = simpletypeSelection;
        this.mTitle = this.mSimpletypeSelection.titleText;
        this.mDescription = this.mSimpletypeSelection.subtitleText;
        this.mDictionariesRoot = new DtDictionaryRoot[]{dictionaryRoot};
    }

    public SimpletypeSelectionDialog(SimpletypeSelection simpletypeSelection, DtDictionaryRoot[] dictionariesRoot, Shell shell) {
        super(shell);
        this.mShell = shell;
        this.mSimpletypeSelection = simpletypeSelection;
        this.mTitle = this.mSimpletypeSelection.titleText;
        this.mDescription = this.mSimpletypeSelection.subtitleText;
        this.mDictionariesRoot = dictionariesRoot;
    }

    public DtSimpleType getSimpleType() {
        return this.mSimpleType;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        this.mViewer = new TreeViewer(contents);
        this.mViewer.setContentProvider((IContentProvider)new SimpletypeContentProvider());
        this.mViewer.setLabelProvider((IBaseLabelProvider)new SimpletypeLabelProvider(this.mSimpletypeSelection));
        this.mViewer.setInput((Object)new SimpletypeContentProvider.DictionaryRoot(this.mDictionariesRoot));
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.mViewer.getControl().setLayoutData((Object)data);
        this.mViewer.expandToLevel(2);
        this.mViewer.setSelection(null);
        this.mViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SimpletypeSelectionDialog.super.getButton(0) != null) {
                    if (!event.getSelection().isEmpty()) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        if (selection != null && selection.size() > 0) {
                            Object data = selection.getFirstElement();
                            if (data instanceof DtSimpleType) {
                                SimpletypeSelectionDialog.this.mSimpleType = (DtSimpleType)data;
                                SimpletypeSelectionDialog.super.getButton(0).setEnabled(true);
                            } else {
                                SimpletypeSelectionDialog.super.getButton(0).setEnabled(false);
                            }
                        }
                    } else {
                        SimpletypeSelectionDialog.super.getButton(0).setEnabled(false);
                    }
                }
            }
        });
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object data = selection.getFirstElement();
                if (data != null && data instanceof DtSimpleType) {
                    SimpletypeSelectionDialog.this.mSimpleType = (DtSimpleType)data;
                    SimpletypeSelectionDialog.this.close();
                }
            }
        });
        return contents;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }
}

