/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.service;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SimpletypeContentProvider
implements ITreeContentProvider,
DevelopmentObjectObserver {
    private static Object[] EMPTY_ARRAY = new Object[0];
    DtSimpleType[] mSimpleTypes;
    List mRootEntries;
    TreeViewer mViewer;
    DtDictionaryRoot[] mDictionariesRoot;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DtDictionaryRoot) {
            try {
                this.mSimpleTypes = ((DtDictionaryRoot)parentElement).getSimpleTypes();
            }
            catch (LoadException e) {
                TableEditorPlugin.tracer.error("get simple type", (Throwable)e);
            }
            this.mRootEntries = this.getRootEntries(this.mSimpleTypes);
            return this.mRootEntries.toArray();
        }
        if (parentElement instanceof SimpleTypePackage) {
            Object[] st = ((SimpleTypePackage)parentElement).getSimpleTypes();
            Arrays.sort(st, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((DtSimpleType)arg0).getName().compareTo(((DtSimpleType)arg1).getName());
                }

                public boolean equals(Object arg0) {
                    return false;
                }
            });
            return st;
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof DtDictionaryRoot) {
            return null;
        }
        if (element instanceof SimpleTypePackage) {
            return ((SimpleTypePackage)element).getRoot();
        }
        if (element instanceof DtSimpleType) {
            return null;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof DictionaryRoot) {
            this.mDictionariesRoot = ((DictionaryRoot)inputElement).getDictionaries();
        }
        return this.mDictionariesRoot;
    }

    public void dispose() {
        if (this.mDictionariesRoot != null) {
            int i = 0;
            while (i < this.mDictionariesRoot.length) {
                this.mDictionariesRoot[0].detachGlobalObserver((DevelopmentObjectObserver)this);
                ++i;
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        int i;
        DtDictionaryRoot[] roots;
        this.mViewer = (TreeViewer)viewer;
        if (oldInput != null && oldInput instanceof DictionaryRoot) {
            roots = ((DictionaryRoot)oldInput).getDictionaries();
            i = 0;
            while (i < roots.length) {
                roots[i].detachGlobalObserver((DevelopmentObjectObserver)this);
                ++i;
            }
        }
        if (newInput != null) {
            roots = ((DictionaryRoot)newInput).getDictionaries();
            i = 0;
            while (i < roots.length) {
                roots[i].attachGlobalObserver((DevelopmentObjectObserver)this);
                ++i;
            }
        }
    }

    public void update(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof DtDictionaryRoot) {
            this.mViewer.refresh((Object)event.getModifiedObject());
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    private List getRootEntries(DtSimpleType[] types) {
        String packageName;
        ArrayList<SimpleTypePackage> entries = new ArrayList<SimpleTypePackage>();
        int i = 0;
        while (i < types.length) {
            String typeName;
            if (!types[i].hasLogicalDictionary() && !(typeName = types[i].getName()).equals("") && (typeName.charAt(0) >= 'A' && typeName.charAt(0) <= 'Z' || typeName.charAt(0) >= 'a' && typeName.charAt(0) <= 'z')) {
                String stName;
                packageName = types[i].getPackage();
                boolean createPackage = true;
                if (!(packageName == null || packageName.equals("com.sap.dictionary") || packageName.equals("com.sap.dictionary.predefined.objecttypes") || packageName.equals("com.sap.dictionary.predefined.currency") && !(stName = types[i].getName()).equals("currency") && !stName.equals("currencyNormalized"))) {
                    int j = 0;
                    while (j < entries.size()) {
                        SimpleTypePackage thePackage = (SimpleTypePackage)entries.get(j);
                        if (thePackage.getPackageName().equals(packageName)) {
                            thePackage.addType(types[i]);
                            createPackage = false;
                            break;
                        }
                        ++j;
                    }
                    if (createPackage) {
                        entries.add(new SimpleTypePackage(types[i]));
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < types.length) {
            packageName = types[i2].getPackage();
            if (packageName == null) {
                entries.add((SimpleTypePackage)types[i2]);
            }
            ++i2;
        }
        Collections.sort(entries, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((SimpleTypePackage)arg0).getPackageName().compareTo(((SimpleTypePackage)arg1).getPackageName());
            }

            public boolean equals(Object arg0) {
                return false;
            }
        });
        return entries;
    }

    public static class DictionaryRoot {
        private DtDictionaryRoot[] mDictionaries;

        public DictionaryRoot(DtDictionaryRoot dictionary) {
            this.mDictionaries = new DtDictionaryRoot[]{dictionary};
        }

        public DictionaryRoot(DtDictionaryRoot[] dictionaries) {
            this.mDictionaries = dictionaries;
        }

        public DtDictionaryRoot[] getDictionaries() {
            return this.mDictionaries;
        }
    }

    public static class SimpleTypePackage {
        private String mPackageName;
        private List mTypes = new ArrayList();
        private DtDictionaryRoot mRoot;

        public SimpleTypePackage(DtSimpleType type) {
            this.mPackageName = type.getPackage();
            this.mTypes.add(type);
            this.mRoot = type.getDictionary();
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public DtDictionaryRoot getRoot() {
            return this.mRoot;
        }

        public void addType(DtSimpleType type) {
            this.mTypes.add(type);
        }

        public DtSimpleType[] getSimpleTypes() {
            DtSimpleType[] types = new DtSimpleType[this.mTypes.size()];
            return this.mTypes.toArray(types);
        }
    }
}

