/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.jdbc;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.tableeditor.util.DatabaseVendorMapping;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class JDBCTypeAdvancedWizardPage
extends WizardPage {
    private CellEditor cellEditor;
    private Table table;
    private TableEditor tableEditor;
    private String[] types;
    private DatabaseEnum[] list;
    private String type;
    private int length;
    private ArrayList jdbcTypeInfoList;
    private ArrayList jdbcTypeListFromMetamodel;

    protected JDBCTypeAdvancedWizardPage(DatabaseEnum[] list, ArrayList jdbcTypeListFromMetamodel, String type, int length, String pageName) {
        super(pageName);
        this.setTitle("Database Specific JDBC Type Selection");
        this.setDescription("Warning: Table cannot be deployed on all database systems");
        this.list = list;
        this.jdbcTypeListFromMetamodel = jdbcTypeListFromMetamodel;
        this.type = type;
        this.length = length;
    }

    protected JDBCTypeAdvancedWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        this.table = new Table(root, 67584);
        gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 50;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.table, 0);
        col1.setText("DB System");
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(this.table, 0);
        col2.setText("JDBC Type");
        col2.setWidth(100);
        if (this.jdbcTypeListFromMetamodel != null && this.jdbcTypeListFromMetamodel.size() > 0) {
            this.jdbcTypeInfoList = this.jdbcTypeListFromMetamodel;
            ArrayList temp = DdMapping.getJdbcTypeInfo((String)this.type, (int)this.length, (DatabaseEnum[])this.list);
            int i = 0;
            while (i < temp.size()) {
                String db = ((DtTypeInfoForDatabase)temp.get(i)).getDatabaseName();
                if (db.compareTo("DEFAULT") == 0) {
                    DtTypeInfoForDatabase ti = (DtTypeInfoForDatabase)temp.get(i);
                    this.jdbcTypeInfoList.add(ti);
                    break;
                }
                ++i;
            }
        } else {
            this.jdbcTypeInfoList = DdMapping.getJdbcTypeInfo((String)this.type, (int)this.length, (DatabaseEnum[])this.list);
        }
        Arrays.sort(this.list, new Comparator(){

            public int compare(Object o1, Object o2) {
                DatabaseEnum de1 = (DatabaseEnum)o1;
                DatabaseEnum de2 = (DatabaseEnum)o2;
                return de1.toString().compareTo(de2.toString());
            }
        });
        String defaultType = "";
        boolean def = true;
        int i = 0;
        while (i < this.list.length) {
            defaultType = "";
            def = true;
            TableItem item = new TableItem(this.table, 0);
            item.setText(DatabaseVendorMapping.toPresentation(this.list[i].toString()));
            int j = 0;
            while (j < this.jdbcTypeInfoList.size()) {
                String db = ((DtTypeInfoForDatabase)this.jdbcTypeInfoList.get(j)).getDatabaseName();
                if (db.compareTo(this.list[i].toString().toUpperCase()) == 0) {
                    item.setText(1, ((DtTypeInfoForDatabase)this.jdbcTypeInfoList.get(j)).getJavaSqlTypeName());
                    def = false;
                    break;
                }
                if (db.compareTo("DEFAULT") == 0) {
                    defaultType = ((DtTypeInfoForDatabase)this.jdbcTypeInfoList.get(j)).getJavaSqlTypeName();
                }
                ++j;
            }
            if (def) {
                item.setText(1, defaultType);
            }
            ++i;
        }
        this.tableEditor = new TableEditor(this.table);
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = JDBCTypeAdvancedWizardPage.this.table.getItem(pt);
                if (item == null) {
                    return;
                }
                int columns = JDBCTypeAdvancedWizardPage.this.table.getColumnCount();
                int i = 0;
                while (i < columns) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt) && i == 1) {
                        JDBCTypeAdvancedWizardPage.this.handleSelect(event);
                    }
                    ++i;
                }
            }
        });
        Button but = new Button(root, 8);
        but.setText("Restore defaults");
        but.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                JDBCTypeAdvancedWizardPage.this.jdbcTypeInfoList = DdMapping.getJdbcTypeInfo((String)JDBCTypeAdvancedWizardPage.this.type, (int)JDBCTypeAdvancedWizardPage.this.length, (DatabaseEnum[])JDBCTypeAdvancedWizardPage.this.list);
                JDBCTypeAdvancedWizardPage.this.table.removeAll();
                String defaultType = "";
                boolean def = true;
                int i = 0;
                while (i < JDBCTypeAdvancedWizardPage.this.list.length) {
                    defaultType = "";
                    def = true;
                    TableItem item = new TableItem(JDBCTypeAdvancedWizardPage.this.table, 0);
                    item.setText(DatabaseVendorMapping.toPresentation(JDBCTypeAdvancedWizardPage.this.list[i].toString()));
                    int j = 0;
                    while (j < JDBCTypeAdvancedWizardPage.this.jdbcTypeInfoList.size()) {
                        String db = ((DtTypeInfoForDatabase)JDBCTypeAdvancedWizardPage.this.jdbcTypeInfoList.get(j)).getDatabaseName();
                        if (db.compareTo(JDBCTypeAdvancedWizardPage.this.list[i].toString().toUpperCase()) == 0) {
                            item.setText(1, ((DtTypeInfoForDatabase)JDBCTypeAdvancedWizardPage.this.jdbcTypeInfoList.get(j)).getJavaSqlTypeName());
                            def = false;
                            break;
                        }
                        if (db.compareTo("DEFAULT") == 0) {
                            defaultType = ((DtTypeInfoForDatabase)JDBCTypeAdvancedWizardPage.this.jdbcTypeInfoList.get(j)).getJavaSqlTypeName();
                        }
                        ++j;
                    }
                    if (def) {
                        item.setText(1, defaultType);
                    }
                    ++i;
                }
            }
        });
    }

    private void handleSelect(Event event) {
        TableItem[] sel;
        if (this.cellEditor != null) {
            this.deactivateCellEditor();
        }
        if ((sel = this.table.getSelection()).length == 0) {
            return;
        }
        this.activateCellEditor(sel[0]);
    }

    void deactivateCellEditor() {
        Integer index = (Integer)((ComboBoxCellEditor)this.cellEditor).getValue();
        TableItem sel = this.tableEditor.getItem();
        int selectedItem = (Integer)this.cellEditor.getValue();
        this.tableEditor.setEditor(null, null, 1);
        if (this.cellEditor != null) {
            DtTypeInfoForDatabase info;
            this.cellEditor.deactivate();
            sel.setText(1, this.types[selectedItem]);
            String selDb = DatabaseVendorMapping.toInternal(sel.getText(0));
            boolean found = false;
            int i = 0;
            while (i < this.jdbcTypeInfoList.size()) {
                info = (DtTypeInfoForDatabase)this.jdbcTypeInfoList.get(i);
                if (info.getDatabaseName().toUpperCase().equals(selDb.toUpperCase())) {
                    info.setJavaSqlTypeName(this.types[selectedItem]);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                info = new DtTypeInfoForDatabase(selDb, this.types[selectedItem], "");
                this.jdbcTypeInfoList.add(info);
            }
            this.cellEditor = null;
        }
    }

    private void activateCellEditor(TableItem item) {
        this.table.showSelection();
        TableItem[] sel = this.table.getSelection();
        ArrayList list = DdMapping.getAllowedJdbcTypes((String)item.getText(1), (DatabaseEnum)DatabaseEnum.valueOf((String)DatabaseVendorMapping.toInternal(item.getText())));
        if (list != null) {
            this.types = new String[list.size()];
            int selectionIndex = 0;
            int i = 0;
            while (i < list.size()) {
                this.types[i] = (String)list.get(i);
                if (this.types[i].compareTo(item.getText(1)) == 0) {
                    selectionIndex = i;
                }
                ++i;
            }
            this.cellEditor = new ComboBoxCellEditor((Composite)this.table, this.types);
            this.cellEditor.setValue((Object)new Integer(selectionIndex));
        }
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableEditor.grabHorizontal = layout.grabHorizontal;
        this.tableEditor.minimumWidth = layout.minimumWidth;
        this.tableEditor.setEditor(control, item, 1);
        this.cellEditor.setFocus();
        this.cellEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                JDBCTypeAdvancedWizardPage.this.deactivateCellEditor();
            }

            public void cancelEditor() {
                JDBCTypeAdvancedWizardPage.this.cellEditor.deactivate();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
    }

    public ArrayList getJdbcTypeInfos() {
        return this.jdbcTypeInfoList;
    }
}

