/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexwizard;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.preference.NSPreferencePage;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewIndexWizardPage
extends WizardPage {
    private static final String ERROR = "Error";
    private Text propValue;
    public Text propText;
    private DtDbTable mDtDbTable;

    protected NewIndexWizardPage(String pageName, DtDbTable dtDbTable) {
        super(pageName);
        this.setTitle("New Index");
        this.setDescription("Enter the name of the new index");
        this.mDtDbTable = dtDbTable;
    }

    protected NewIndexWizardPage(String pageName, String title, ImageDescriptor titleImage, DtDbTable dtDbTable) {
        super(pageName, title, titleImage);
        this.mDtDbTable = dtDbTable;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        new Label(root, 0).setText("Index name:");
        this.propValue = new Text(root, 2052);
        GridData gd2 = new GridData(256);
        gd2.grabExcessHorizontalSpace = true;
        this.propValue.setLayoutData((Object)gd2);
        this.setPageComplete(false);
        this.propValue.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String temp = NewIndexWizardPage.this.propValue.getText();
                temp = temp.toUpperCase();
                NewIndexWizardPage.this.propValue.setText(temp);
                NewIndexWizardPage.this.checkIndex();
            }
        });
        this.propValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewIndexWizardPage.this.propValue.getText().length() > 0) {
                    NewIndexWizardPage.this.setPageComplete(true);
                    NewIndexWizardPage.this.setErrorMessage(null);
                } else {
                    NewIndexWizardPage.this.setPageComplete(false);
                    NewIndexWizardPage.this.setErrorMessage("Specify the name of the index");
                }
            }
        });
        IPreferenceStore store = TsmodelDictionaryPlugin.getDefault().getPreferenceStore();
        this.propValue.setText(store.getString(NSPreferencePage.nskey));
        this.propValue.selectAll();
        this.propValue.setFocus();
    }

    public Object[] getPropertyObjects() {
        return new Object[]{this.propValue.getText()};
    }

    private void checkIndex() {
        String message = DictionaryObjectChecker.checkIndexName((String)this.propValue.getText(), null, (char)'A');
        this.updateStatus(message);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

