/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexwizard;

import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexTableModel;
import com.sap.dictionary.tools.tableeditor.indexwizard.NewIndexWizardPage;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import java.util.HashSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewIndexWizard
extends Wizard
implements INewWizard {
    private TableIndexTableModel mTableModel;
    private String mProjectName;
    private static final String C_INDEX_WIZARD_PAGE = "C_INDICES";

    protected NewIndexWizard(TableIndexTableModel indexTableModel, String projectName) {
        this.mTableModel = indexTableModel;
        this.mProjectName = projectName;
        this.addPage((IWizardPage)new NewIndexWizardPage(C_INDEX_WIZARD_PAGE, this.mTableModel.mDtDbTable));
    }

    public boolean performFinish() {
        Object[] prop = ((NewIndexWizardPage)this.getPage(C_INDEX_WIZARD_PAGE)).getPropertyObjects();
        String indexName = (String)prop[0];
        HashSet<String> indexes = new HashSet<String>();
        indexes.add(indexName);
        String message = DictionaryObjectChecker.checkProjectHasIndex((String)this.mProjectName, indexes);
        if (!TableUtil.stringIsEmpty(message)) {
            ((WizardPage)this.getPage(C_INDEX_WIZARD_PAGE)).setErrorMessage(message);
            return false;
        }
        if (NameServerUtil.isNameReservedOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)indexName, (boolean)false)) {
            return false;
        }
        if (NameServerUtil.isPrefixValidOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)indexName, (WizardPage)((WizardPage)this.getPage(C_INDEX_WIZARD_PAGE)), (boolean)true)) {
            this.mTableModel.addRow(prop);
            this.mTableModel.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

