/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexes;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.outline.OutlinePage;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtIndexField;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import javax.swing.table.DefaultTableModel;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class TableIndexTableModel
extends DefaultTableModel {
    public DtDbTable mDtDbTable;
    private OutlinePage outline;

    public TableIndexTableModel(DtDbTable dbTable) {
        this.mDtDbTable = dbTable;
    }

    public void setOutlinePage(OutlinePage out) {
        this.outline = out;
    }

    public void addRow(Object[] obj) {
        Object[] fobj = obj;
        if (!this.mDtDbTable.hasDbIndex((String)fobj[0])) {
            try {
                try {
                    DtDbIndex index = this.mDtDbTable.createDbIndex((String)fobj[0]);
                    boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
                    if (isAutoBuilding) {
                        try {
                            IWorkspaceDescription descr = ResourcesPlugin.getWorkspace().getDescription();
                            descr.setAutoBuilding(false);
                            ResourcesPlugin.getWorkspace().setDescription(descr);
                        }
                        catch (CoreException e) {
                            TableEditorPlugin.tracer.error("set workspace description", (Throwable)e);
                        }
                    }
                    MetamodelManager.saveAllMetaData((Metamodel)this.mDtDbTable.getMetamodel());
                    long time = System.currentTimeMillis();
                    while (System.currentTimeMillis() - time < 1000L) {
                        if (Display.getDefault().readAndDispatch()) continue;
                        Display.getDefault().sleep();
                    }
                    try {
                        IWorkspaceDescription descr = ResourcesPlugin.getWorkspace().getDescription();
                        descr.setAutoBuilding(isAutoBuilding);
                        ResourcesPlugin.getWorkspace().setDescription(descr);
                    }
                    catch (CoreException e) {
                        TableEditorPlugin.tracer.error("set workspace description", (Throwable)e);
                    }
                }
                catch (CreateException e) {
                    if (e.getMessage().indexOf("already exists") > -1) {
                        TableMessageHandler.sendErrorMessage("Error", "Index already exists in another table");
                    } else {
                        TableMessageHandler.sendErrorMessage("Metadata API", "Index could not be created");
                    }
                    throw new CoreException((IStatus)new Status(4, "4711", 0, "error tableeditor", (Throwable)e));
                }
            }
            catch (CoreException e) {
                TableEditorPlugin.tracer.error("create index workspace thread", (Throwable)e);
                return;
            }
        }
        if (this.outline != null) {
            this.outline.updateIndexes();
        }
        super.addRow(obj);
    }

    public void removeRow(int row) {
        try {
            if (row >= this.getRowCount() || row == -1) {
                return;
            }
            this.mDtDbTable.getDbIndex((String)super.getValueAt(row, 0)).delete();
            MetamodelManager.saveAllMetaData((Metamodel)this.mDtDbTable.getMetamodel());
            if (this.outline != null) {
                this.outline.updateIndexes();
            }
        }
        catch (DeleteException e) {
            TableEditorPlugin.tracer.error("removeRow", (Throwable)e);
        }
        super.removeRow(row);
    }

    public boolean isCellEditable(int row, int column) {
        String predefinedAction = this.mDtDbTable.getPredefinedAction();
        if (predefinedAction != null && predefinedAction.equals("DROP")) {
            return false;
        }
        return false;
    }

    public void setValueAt(Object obj, int row, int col) {
        super.setValueAt(obj, row, col);
    }

    public void setUniqueFlag(int row, boolean flag) {
        this.mDtDbTable.getDbIndex((String)super.getValueAt(row, 0)).setUnique(flag);
    }

    public boolean getUniqueFlag(int row) {
        return this.mDtDbTable.getDbIndex((String)super.getValueAt(row, 0)).getUnique();
    }

    public boolean isIndexReadOnly(int row) {
        return this.mDtDbTable.getDbIndex((String)super.getValueAt(row, 0)).isReadOnly();
    }

    public void renameIndex(String oldIndex, String newIndex) {
        DtDbIndex index = this.mDtDbTable.getDbIndex(oldIndex);
        if (index != null) {
            DtIndexField[] fields = index.getIndexFields();
            try {
                DtDbIndex indexNew = this.mDtDbTable.createDbIndex(newIndex);
                indexNew.setUnique(index.getUnique());
                int i = 0;
                while (i < index.getIndexFieldCount()) {
                    indexNew.createIndexField(fields[i].getName());
                    ++i;
                }
                index.delete();
                if (this.outline != null) {
                    this.outline.updateIndexes();
                }
            }
            catch (CreateException e) {
                TableEditorPlugin.tracer.error("rename", (Throwable)e);
            }
            catch (DeleteException e2) {
                TableEditorPlugin.tracer.error("rename", (Throwable)e2);
            }
        }
    }
}

