/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexes;

import com.sap.dictionary.tools.tableeditor.indexes.TableIndexForm;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexTableModel;
import com.sap.dictionary.tools.tableeditor.indexwizard.NewIndexWizardAction;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.TableSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableIndexSection
extends TableSection {
    private static final int BUTTON_NEW = 0;
    private static final int BUTTON_DELETE = 1;
    public boolean tableDirty = false;
    private TableIndexForm mForm = null;
    private TableIndexTableModel mTableModel = null;
    private DtDbTable mDtDbTable = null;

    public TableIndexSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, boolean[] buttonsEnabled, TableIndexForm form, DtDbTable dtDbTable) {
        super(tableModel, widgetFactory, title, description, buttons, buttonsEnabled);
        this.mForm = form;
        this.mTableModel = (TableIndexTableModel)tableModel;
        this.mDtDbTable = dtDbTable;
        this.initIndexTableModel();
        this.mTableModel.addTableModelListener(new SectionTableModelListener());
        this.addButtonClickedListener(new ButtonClickedListener());
    }

    public void initIndexTableModel() {
        DtDbIndex dbIndex = null;
        DtDbIndex[] dbIndexes = this.mDtDbTable.getDbIndexes();
        ArrayList<DtDbIndex> indexList = new ArrayList<DtDbIndex>();
        int i = 0;
        while (i < this.mDtDbTable.getDbIndexCount()) {
            if (dbIndexes.length > i) {
                dbIndex = dbIndexes[i];
                indexList.add(dbIndex);
            }
            ++i;
        }
        Collections.sort(indexList, new NameComparator());
        Iterator elements = indexList.iterator();
        if (this.mDtDbTable.getDbIndexCount() > 0) {
            while (elements.hasNext()) {
                dbIndex = (DtDbIndex)elements.next();
                this.mForm.addTableRow(dbIndex.getName());
            }
        }
    }

    public int getSelectionIndex() {
        return super.getSelectionIndex();
    }

    private static class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object e1, Object e2) {
            String s1 = ((DtDbIndex)e1).getName();
            String s2 = ((DtDbIndex)e2).getName();
            return s1.compareTo(s2);
        }
    }

    private class SectionTableModelListener
    implements TableModelListener {
        private SectionTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            TableIndexSection.this.mForm.getEditor().setDataChanged();
        }
    }

    private class ButtonClickedListener
    implements IButtonClickedListener {
        private ButtonClickedListener() {
        }

        public void buttonClicked(ButtonClickedEvent e) {
            switch (e.getIndex()) {
                case 0: {
                    int rowCountOld = TableIndexSection.this.mTableModel.getRowCount();
                    String projectName = TableIndexSection.this.mForm.getEditor().getMetamodel().getName();
                    NewIndexWizardAction action = new NewIndexWizardAction();
                    action.run(TableIndexSection.this.mTableModel, projectName);
                    int rowCountNew = TableIndexSection.this.mTableModel.getRowCount();
                    if (rowCountNew <= rowCountOld) break;
                    TableIndexSection.this.getTableViewer().getTable().setFocus();
                    TableIndexSection.this.getTableViewer().getTable().setSelection(rowCountOld);
                    TableIndexSection.this.mForm.setSelectedName(TableIndexSection.this.getTableViewer().getTable().getItem(rowCountOld).getText(0));
                    TableIndexSection.this.mForm.fillIndexPage(rowCountOld);
                    break;
                }
                case 1: {
                    int[] selIndex = TableIndexSection.this.getTableViewer().getTable().getSelectionIndices();
                    int i = TableIndexSection.this.getTableViewer().getTable().getSelectionCount() - 1;
                    while (i >= 0) {
                        TableIndexSection.this.mTableModel.removeRow(selIndex[i]);
                        --i;
                    }
                    TableIndexSection.this.mTableModel.fireTableDataChanged();
                    ((TableIndexSection)TableIndexSection.this).mForm.indexFieldSection.setDescription("Define columns for index");
                    int i2 = ((TableIndexSection)TableIndexSection.this).mForm.indexFieldTableModel.getRowCount() - 1;
                    while (i2 >= 0) {
                        ((TableIndexSection)TableIndexSection.this).mForm.indexFieldTableModel.removeRow(i2);
                        --i2;
                    }
                    break;
                }
            }
            if (TableIndexSection.this.mTableModel.getRowCount() == 1) {
                TableIndexSection.this.getTableViewer().getTable().setFocus();
                TableIndexSection.this.getTableViewer().getTable().setSelection(0);
                TableIndexSection.this.mForm.setSelectedName(TableIndexSection.this.getTableViewer().getTable().getItem(0).getText(0));
            }
        }
    }
}

