/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexes;

import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.databasewizard.DatabaseWizard;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.indexes.IndexMenuProvider;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexFieldSection;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexFieldTableModel;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexSection;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.form.SectionForm;
import com.tssap.util.ui.glpc.section.SimpleSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TableIndexForm
extends SectionForm {
    public TableIndexSection indexSection;
    public TableIndexTableModel indexTableModel = null;
    public TableIndexFieldSection indexFieldSection;
    public TableIndexFieldTableModel indexFieldTableModel = null;
    public TableEditor mEditor = null;
    private Button mUnique;
    private static String mSelectedIndexName;
    private Button mSel;
    private Button mEdit;
    private static TracerI tracer;
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexForm;

    public TableIndexForm(IWidgetFactory widgetFactory, int columns, String title, TableEditor editor) {
        super(widgetFactory, columns, true, title);
        this.mEditor = editor;
    }

    public void initSectionForm(IGridLayoutPane glp) {
        this.createIndexSection(glp);
        IGridLayoutPane rightSide = glp.addGridLayoutPane(1, glp.createGridLayoutData(4, 4, true, true, 1, 1));
        this.createIndexFieldsSection(rightSide);
        this.createAttributesSection(rightSide);
    }

    private void createIndexSection(IGridLayoutPane glp) {
        boolean[] buttonsEnabled = new boolean[11];
        this.setIndexTableModel();
        int i = 0;
        while (i < buttonsEnabled.length) {
            buttonsEnabled[i] = !this.mEditor.isReadOnly();
            ++i;
        }
        this.indexSection = new TableIndexSection(this.indexTableModel, (IWidgetFactory)new LiteWidgetFactory(), "Indexes", "Define indexes for the table", new String[]{"New...", "Delete"}, buttonsEnabled, this, this.mEditor.mDtDbTable);
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.indexSection, glp.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setReadOnlyColors();
        if (!this.mEditor.isReadOnly()) {
            this.indexSection.addMenuProvider(new IndexMenuProvider(this.indexTableModel, this));
        }
        this.indexSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int idx = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndex();
                TableIndexForm.this.fillIndexPage(idx);
            }
        });
        this.indexTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                int idx;
                if (arg0.getType() == 0 && (idx = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndex()) >= 0) {
                    String newIndexName = (String)TableIndexForm.this.indexTableModel.getValueAt(idx, 0);
                    boolean doit = false;
                    int i = 0;
                    while (i < newIndexName.length()) {
                        if (Character.isLowerCase(newIndexName.charAt(i))) {
                            doit = true;
                            break;
                        }
                        ++i;
                    }
                    if (doit) {
                        newIndexName = newIndexName.toUpperCase();
                        TableIndexForm.this.indexTableModel.setValueAt(newIndexName, idx, 0);
                    }
                    if (mSelectedIndexName != null && newIndexName.compareTo(mSelectedIndexName) != 0) {
                        TableIndexForm.this.indexTableModel.renameIndex(mSelectedIndexName, newIndexName);
                    }
                }
            }
        });
        this.indexSection.getTableViewer().getTableViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean readOnly = false;
                if (e.character == '\u007f') {
                    int[] sel = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndices();
                    int i = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionCount() - 1;
                    while (i >= 0) {
                        if (!TableIndexForm.this.mEditor.isReadOnly() && !TableIndexForm.this.indexTableModel.isIndexReadOnly(sel[i])) {
                            TableIndexForm.this.indexTableModel.removeRow(sel[i]);
                            readOnly = true;
                        }
                        --i;
                    }
                    if (readOnly) {
                        TableIndexForm.this.indexFieldSection.setDescription("Define columns for index");
                        int i2 = TableIndexForm.this.indexFieldTableModel.getRowCount() - 1;
                        while (i2 >= 0) {
                            TableIndexForm.this.indexFieldTableModel.removeRow(i2);
                            --i2;
                        }
                    }
                }
            }
        });
    }

    public void setReadOnlyColors() {
        int i = 0;
        while (i < this.indexTableModel.getRowCount()) {
            if (this.indexTableModel.isIndexReadOnly(i)) {
                this.indexSection.getTableViewer().getTable().getItem(i).setForeground(Display.getCurrent().getSystemColor(15));
            } else {
                this.indexSection.getTableViewer().getTable().getItem(i).setForeground(Display.getCurrent().getSystemColor(2));
            }
            ++i;
        }
    }

    public void fillIndexPage(int idx) {
        if (this.indexTableModel.getRowCount() == 0) {
            return;
        }
        if (idx < 0) {
            return;
        }
        if (idx >= this.indexTableModel.getRowCount()) {
            return;
        }
        mSelectedIndexName = (String)this.indexTableModel.getValueAt(idx, 0);
        this.indexFieldSection.setDescription(MessagePool.getMessage((String)"Define columns for index &", (String)mSelectedIndexName));
        try {
            if (this.indexTableModel.isIndexReadOnly(idx)) {
                this.indexFieldSection.setButtonEnabled(0, false);
                this.indexFieldSection.setButtonEnabled(1, false);
                this.indexFieldSection.setButtonEnabled(2, false);
                this.indexFieldSection.setButtonEnabled(3, false);
                this.mUnique.setEnabled(false);
                this.mSel.setEnabled(false);
                this.indexSection.setButtonEnabled(1, false);
                if (AbstractTableEditor.mStatusItem.isVisible()) {
                    AbstractTableEditor.mStatusItem.setText("Read-only");
                }
            } else {
                this.indexFieldSection.setButtonEnabled(0, true);
                this.indexFieldSection.setButtonEnabled(1, true);
                this.indexFieldSection.setButtonEnabled(2, true);
                this.indexFieldSection.setButtonEnabled(3, true);
                this.mUnique.setEnabled(true);
                this.mSel.setEnabled(true);
                if (!this.mEditor.isReadOnly()) {
                    this.indexSection.setButtonEnabled(1, true);
                }
                if (AbstractTableEditor.mStatusItem.isVisible()) {
                    AbstractTableEditor.mStatusItem.setText("Writable");
                }
            }
            this.mUnique.setSelection(this.indexTableModel.getUniqueFlag(idx));
            AbstractTableFieldsTableModel tableModel = this.mEditor.getTableFieldsSectionForm().getTableFieldsTableModel();
            this.mEditor.isLoading = true;
            this.indexFieldTableModel.fillTableModel(idx, this.indexTableModel, (TableFieldsTableModel)tableModel);
            if (this.indexTableModel.isIndexReadOnly(idx)) {
                Table table = this.indexFieldSection.getTableViewer().getTable();
                int i = 0;
                while (i < this.indexFieldTableModel.getRowCount()) {
                    table.getItem(i).setForeground(Display.getCurrent().getSystemColor(15));
                    ++i;
                }
            } else {
                this.indexFieldSection.getTableViewer().getTable().setEnabled(true);
            }
            this.mEditor.isLoading = false;
        }
        catch (NullPointerException e2) {
            tracer.error("index field", (Throwable)e2);
        }
        DtDbIndex dbIndex = this.indexTableModel.mDtDbTable.getDbIndex(mSelectedIndexName);
        if (dbIndex.getNoCreationOnDatabaseCount() > 0) {
            this.mEdit.setEnabled(true);
            this.mSel.setSelection(true);
        } else {
            this.mEdit.setEnabled(false);
            this.mSel.setSelection(false);
        }
    }

    private void createIndexFieldsSection(IGridLayoutPane glp) {
        boolean[] buttonsEnabled = new boolean[11];
        this.setIndexFieldTableModel();
        int i = 0;
        while (i < buttonsEnabled.length) {
            buttonsEnabled[i] = !this.mEditor.isReadOnly();
            ++i;
        }
        this.indexFieldSection = new TableIndexFieldSection(this.indexFieldTableModel, (IWidgetFactory)new LiteWidgetFactory(), "Columns", "Define columns for index", new String[]{"New...", "Delete", "Up", "Down"}, buttonsEnabled, this);
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.indexFieldSection, glp.createGridLayoutData(4, 4, true, true, 1, 1));
        this.indexFieldSection.getTableViewer().getTableViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    int idx = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndex();
                    String indexName = (String)TableIndexForm.this.indexTableModel.getValueAt(idx, 0);
                    int[] selIndex = TableIndexForm.this.indexFieldSection.getTableViewer().getTable().getSelectionIndices();
                    int i = TableIndexForm.this.indexFieldSection.getTableViewer().getTable().getSelectionCount() - 1;
                    while (i >= 0) {
                        if (!TableIndexForm.this.indexTableModel.isIndexReadOnly(idx)) {
                            TableIndexForm.this.indexFieldTableModel.removeRow(indexName, selIndex[i]);
                        }
                        --i;
                    }
                    TableIndexForm.this.indexFieldTableModel.fireTableDataChanged();
                }
            }
        });
    }

    private void createAttributesSection(IGridLayoutPane glp) {
        SimpleSection attrSection = new SimpleSection((IWidgetFactory)new LiteWidgetFactory(), 2, false, "Attributes", "");
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)attrSection, glp.createGridLayoutData(1, 1, 1, 1));
        this.mUnique = attrSection.getClientArea().addCheckBox("Unique");
        if (this.mEditor.isReadOnly()) {
            this.mUnique.setEnabled(false);
        }
        this.mUnique.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int row = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndex();
                if (row >= 0) {
                    TableIndexForm.this.indexTableModel.setUniqueFlag(row, TableIndexForm.this.mUnique.getSelection());
                    TableIndexForm.this.mEditor.setDataChanged();
                } else {
                    if (TableIndexForm.this.mUnique.getSelection()) {
                        TableIndexForm.this.mUnique.setSelection(false);
                    } else {
                        TableIndexForm.this.mUnique.setSelection(true);
                    }
                    TableMessageHandler.sendInformationMessage("Index", "Select an index");
                }
                if (TableIndexForm.this.mEditor.outlinePage != null) {
                    TableIndexForm.this.mEditor.outlinePage.updateIndexes();
                }
            }
        });
        attrSection.getClientArea().addTextLabel("");
        this.mSel = attrSection.getClientArea().addCheckBox("Do not create index on selected database systems");
        if (this.mEditor.isReadOnly()) {
            this.mSel.setEnabled(false);
        }
        this.mEdit = attrSection.getClientArea().addPushButton("Edit...");
        this.mEdit.setEnabled(false);
        this.mSel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int row = TableIndexForm.this.indexSection.getTableViewer().getTable().getSelectionIndex();
                if (row >= 0) {
                    if (TableIndexForm.this.mSel.getSelection()) {
                        TableIndexForm.this.mEdit.setEnabled(true);
                    } else {
                        TableIndexForm.this.mEdit.setEnabled(false);
                        DtDbIndex dbIndex = TableIndexForm.this.indexTableModel.mDtDbTable.getDbIndex(mSelectedIndexName);
                        DtNoCreateCondition[] temp = dbIndex.getNoCreationOnDatabases();
                        int i = 0;
                        while (i < temp.length) {
                            try {
                                temp[i].delete();
                            }
                            catch (DeleteException e2) {
                                TableEditorPlugin.tracer.error("delete no creation on database", (Throwable)e2);
                            }
                            ++i;
                        }
                    }
                    TableIndexForm.this.mEditor.setDataChanged();
                } else {
                    TableIndexForm.this.mSel.setSelection(false);
                    TableMessageHandler.sendInformationMessage("Index", "Select an index");
                }
            }
        });
        this.mEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DatabaseWizard dbWizard = new DatabaseWizard(TableIndexForm.this.indexTableModel.mDtDbTable, mSelectedIndexName, TableIndexForm.this.mEditor.getTableFieldsSectionForm().getTableFieldsTableModel());
                WizardDialog wizardDialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dbWizard);
                wizardDialog.open();
                TableIndexForm.this.mEditor.setDataChanged();
            }
        });
    }

    public void setIndexTableModel() {
        this.indexTableModel = new TableIndexTableModel(this.mEditor.mDtDbTable);
        this.indexTableModel.addColumn("Index Name");
    }

    public void setIndexFieldTableModel() {
        this.indexFieldTableModel = new TableIndexFieldTableModel(this.mEditor.mDtDbTable);
        this.indexFieldTableModel.addColumn("Column Name");
        this.indexFieldTableModel.addColumn("Description");
    }

    public void addTableRow(String sval) {
        Object dictDbIndex = null;
        Object[] lrow = new Object[]{sval};
        this.indexTableModel.addRow(lrow);
    }

    public TableEditor getEditor() {
        return this.mEditor;
    }

    public void clearAll() {
        while (this.indexTableModel.getRowCount() > 0) {
            this.indexTableModel.removeRow(0);
        }
    }

    public void setSelectedName(String name) {
        mSelectedIndexName = name;
    }

    public TableIndexSection getIndexSection() {
        return this.indexSection;
    }

    public TableIndexFieldSection getIndexFieldSection() {
        return this.indexFieldSection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexForm == null ? (class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexForm = TableIndexForm.class$("com.sap.dictionary.tools.tableeditor.indexes.TableIndexForm")) : class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexForm));
    }
}

