/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexes;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexTableModel;
import com.sap.dictionary.tools.tableeditor.outline.OutlinePage;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtIndexField;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import javax.swing.table.DefaultTableModel;

public class TableIndexFieldTableModel
extends DefaultTableModel {
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexFieldSection == null ? (class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexFieldSection = TableIndexFieldTableModel.class$("com.sap.dictionary.tools.tableeditor.indexes.TableIndexFieldSection")) : class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexFieldSection));
    public DtDbTable mDtDbTable;
    private OutlinePage outline;
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$indexes$TableIndexFieldSection;

    public TableIndexFieldTableModel(DtDbTable dbTable) {
        this.mDtDbTable = dbTable;
    }

    public void setOutlinePage(OutlinePage out) {
        this.outline = out;
    }

    public boolean isCellEditable(int row, int column) {
        String predefinedAction = this.mDtDbTable.getPredefinedAction();
        if (predefinedAction != null && predefinedAction.equals("DROP")) {
            return false;
        }
        return false;
    }

    public void addRow(String indexName, Object[] obj) {
        super.addRow(obj);
        try {
            DtDbIndex index = this.mDtDbTable.getDbIndex(indexName);
            int pos = index.getIndexFieldCount();
            DtIndexField field = index.createIndexField((String)obj[0]);
            field.setPosition(pos);
            if (this.outline != null) {
                this.outline.updateIndexes();
            }
        }
        catch (CreateException e) {
            TableEditorPlugin.tracer.error("create index field", (Throwable)e);
        }
    }

    public void removeRow(String indexName, int row) {
        try {
            this.mDtDbTable.getDbIndex(indexName).getIndexField((String)super.getValueAt(row, 0)).delete();
            if (this.outline != null) {
                this.outline.updateIndexes();
            }
        }
        catch (DeleteException e) {
            tracer.error("remove index field", (Throwable)e);
        }
        super.removeRow(row);
        int i = 0;
        while (i < this.getRowCount()) {
            this.setPosition(indexName, (String)super.getValueAt(i, 0), i);
            ++i;
        }
    }

    public void fillTableModel(int row, TableIndexTableModel indexTableModel, TableFieldsTableModel tableModel) {
        String indexName = (String)indexTableModel.getValueAt(row, 0);
        DtDbIndex index = this.mDtDbTable.getDbIndex(indexName);
        DtIndexField[] fields = index.getIndexFields();
        int i = super.getRowCount() - 1;
        while (i >= 0) {
            super.removeRow(i);
            --i;
        }
        int i2 = 0;
        while (i2 < index.getIndexFieldCount()) {
            String fieldName = null;
            int j = 0;
            while (j < index.getIndexFieldCount()) {
                if (fields[j].getPosition() == i2) {
                    fieldName = fields[j].getName();
                    break;
                }
                ++j;
            }
            String description = null;
            int j2 = 0;
            while (j2 < tableModel.getRowCount()) {
                if (fieldName.compareTo((String)tableModel.getValueAt(j2, 1)) == 0) {
                    description = (String)tableModel.getValueAt(j2, 10);
                    break;
                }
                ++j2;
            }
            super.addRow(new Object[]{fieldName, description});
            ++i2;
        }
    }

    public void setPosition(String indexName, String indexField, int pos) {
        DtDbIndex index = this.mDtDbTable.getDbIndex(indexName);
        DtIndexField field = index.getIndexField(indexField);
        field.setPosition(pos);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

