/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.indexes;

import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexFieldTableModel;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexForm;
import com.sap.dictionary.tools.tableeditor.indexwizard.NewIndexFieldWizardAction;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.glpc.section.TableSection;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableIndexFieldSection
extends TableSection {
    private static final int BUTTON_NEW = 0;
    private static final int BUTTON_DELETE = 1;
    private static final int BUTTON_UP = 2;
    private static final int BUTTON_DOWN = 3;
    private TableIndexForm mForm = null;
    private TableIndexFieldTableModel mTableModel = null;

    public TableIndexFieldSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, TableIndexForm form) {
        super(tableModel, widgetFactory, title, description, buttons);
        this.mForm = form;
        this.mTableModel = (TableIndexFieldTableModel)tableModel;
        this.mTableModel.addTableModelListener(new SectionTableModelListener());
        this.addButtonClickedListener(new ButtonClickedListener());
    }

    public TableIndexFieldSection(TableModel tableModel, IWidgetFactory widgetFactory, String title, String description, String[] buttons, boolean[] buttonsEnabled, TableIndexForm form) {
        super(tableModel, widgetFactory, title, description, buttons, buttonsEnabled);
        this.mForm = form;
        this.mTableModel = (TableIndexFieldTableModel)tableModel;
        this.mTableModel.addTableModelListener(new SectionTableModelListener());
        this.addButtonClickedListener(new ButtonClickedListener());
    }

    public int getSelectionIndex() {
        return super.getSelectionIndex();
    }

    private class SectionTableModelListener
    implements TableModelListener {
        private SectionTableModelListener() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!((TableIndexFieldSection)TableIndexFieldSection.this).mForm.getEditor().isLoading) {
                TableIndexFieldSection.this.mForm.getEditor().setDataChanged();
            }
        }
    }

    private class ButtonClickedListener
    implements IButtonClickedListener {
        private ButtonClickedListener() {
        }

        public void buttonClicked(ButtonClickedEvent e) {
            block15: {
                block14: {
                    if (((TableIndexFieldSection)TableIndexFieldSection.this).mForm.indexSection.getTableViewer().getTable().getSelectionCount() != 1) break block14;
                    int idx = ((TableIndexFieldSection)TableIndexFieldSection.this).mForm.indexSection.getTableViewer().getTable().getSelectionIndex();
                    String indexName = (String)((TableIndexFieldSection)TableIndexFieldSection.this).mForm.indexTableModel.getValueAt(idx, 0);
                    switch (e.getIndex()) {
                        case 0: {
                            NewIndexFieldWizardAction action = new NewIndexFieldWizardAction();
                            action.run((TableFieldsTableModel)((TableIndexFieldSection)TableIndexFieldSection.this).mForm.mEditor.getTableFieldsSectionForm().getTableFieldsTableModel(), TableIndexFieldSection.this.mTableModel, indexName);
                            break;
                        }
                        case 1: {
                            int[] selIndex = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionIndices();
                            int i = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionCount() - 1;
                            while (i >= 0) {
                                TableIndexFieldSection.this.mTableModel.removeRow(indexName, selIndex[i]);
                                --i;
                            }
                            TableIndexFieldSection.this.mTableModel.fireTableDataChanged();
                            break;
                        }
                        case 2: {
                            int selCount = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionCount();
                            int[] sel = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionIndices();
                            int i = 0;
                            while (i < selCount) {
                                if (sel[i] > 0) {
                                    TableIndexFieldSection.this.mTableModel.moveRow(sel[i], sel[i], sel[i] - 1);
                                }
                                int n = i++;
                                sel[n] = sel[n] - 1;
                            }
                            TableIndexFieldSection.this.getTableViewer().getTable().setSelection(sel);
                            int i2 = 0;
                            while (i2 < TableIndexFieldSection.this.mTableModel.getRowCount()) {
                                String fieldName = (String)TableIndexFieldSection.this.mTableModel.getValueAt(i2, 0);
                                TableIndexFieldSection.this.mTableModel.setPosition(indexName, fieldName, i2);
                                ++i2;
                            }
                            break block15;
                        }
                        case 3: {
                            int selCount2 = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionCount();
                            int[] sel2 = TableIndexFieldSection.this.getTableViewer().getTable().getSelectionIndices();
                            int i = selCount2 - 1;
                            while (i >= 0) {
                                if (sel2[i] < TableIndexFieldSection.this.getTableViewer().getTable().getItemCount() - 1) {
                                    TableIndexFieldSection.this.mTableModel.moveRow(sel2[i], sel2[i], sel2[i] + 1);
                                }
                                int n = i--;
                                sel2[n] = sel2[n] + 1;
                            }
                            TableIndexFieldSection.this.getTableViewer().getTable().setSelection(sel2);
                            int i3 = 0;
                            while (i3 < TableIndexFieldSection.this.mTableModel.getRowCount()) {
                                String fieldName = (String)TableIndexFieldSection.this.mTableModel.getValueAt(i3, 0);
                                TableIndexFieldSection.this.mTableModel.setPosition(indexName, fieldName, i3);
                                ++i3;
                            }
                            break block15;
                        }
                    }
                    break block15;
                }
                TableMessageHandler.sendErrorMessage("Error", "Select an index");
            }
            if (((TableIndexFieldSection)TableIndexFieldSection.this).mForm.mEditor.outlinePage != null) {
                ((TableIndexFieldSection)TableIndexFieldSection.this).mForm.mEditor.outlinePage.updateIndexes();
            }
        }
    }
}

