/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fieldwizard;

import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TableRenameColumnWizardPage
extends WizardPage {
    private static final String PAGE_DESCR = "Enter the new column name";
    private AbstractTableFieldsTableModel mTableFieldsTableModel;
    private int mRow;
    private Text mNewFieldName;
    private Text mOldFieldName;
    private String mPageTitle;
    private String mPageDescription;
    private String mLabelOld;
    private String mLabelNew;
    private boolean mWithMessage;

    public TableRenameColumnWizardPage(String pageName, AbstractTableFieldsTableModel tableFieldsTableModel, int row, String pageTitle, String pageDescription, String labelOld, String labelNew, boolean withMessage) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mRow = row;
        this.mPageTitle = pageTitle;
        this.mPageDescription = pageDescription;
        this.mLabelOld = labelOld;
        this.mLabelNew = labelNew;
        this.mWithMessage = withMessage;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(this.mLabelOld);
        this.mOldFieldName = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mOldFieldName.setLayoutData((Object)gridData);
        this.mOldFieldName.setEditable(false);
        label = new Label(composite, 0);
        label.setText(this.mLabelNew);
        this.mNewFieldName = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mNewFieldName.setLayoutData((Object)gridData);
        this.mNewFieldName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableRenameColumnWizardPage.this.updateStatus(null);
            }
        });
        this.mNewFieldName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String temp = TableRenameColumnWizardPage.this.mNewFieldName.getText();
                temp = temp.toUpperCase();
                TableRenameColumnWizardPage.this.mNewFieldName.setText(temp);
                TableRenameColumnWizardPage.this.checkFieldName(temp);
            }
        });
        this.initialize();
        this.setControl((Control)composite);
        this.mNewFieldName.setFocus();
        this.mNewFieldName.selectAll();
    }

    private void initialize() {
        String fieldName = null;
        fieldName = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 1);
        if (TableUtil.stringIsEmpty(fieldName)) {
            fieldName = "";
        }
        this.mNewFieldName.setText(fieldName);
        this.mOldFieldName.setText(fieldName);
        if (this.mWithMessage) {
            this.setMessage("Changing the column name will delete the content\nof this column in the database");
        }
    }

    protected String getNewFieldName() {
        return this.mNewFieldName.getText();
    }

    protected String getOldFieldName() {
        return this.mOldFieldName.getText();
    }

    private void checkFieldName(String fieldName) {
        Vector messages = null;
        if (TableUtil.fieldNameIsValid(this.mTableFieldsTableModel, fieldName, this.mRow, false)) {
            this.updateStatus(null);
        } else {
            messages = TableUtil.getFieldMessages();
            this.updateStatus((String)messages.get(0));
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

