/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fieldwizard;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fieldwizard.TableRenameColumnWizardPage;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtImportFromOtherStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtInclusiveField;
import com.sap.ide.metamodel.dictionary.datatype.DtJoin;
import com.sap.ide.metamodel.dictionary.datatype.DtJoinCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtSelectionRestriction;
import com.sap.ide.metamodel.dictionary.datatype.DtSelectionRestrictionCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class TableRenameColumnWizard
extends Wizard
implements INewWizard {
    private AbstractTableFieldsTableModel mTableFieldsTableModel;
    private TableRenameColumnWizardPage mTableRenameRowWizardPage;
    private int mRow;
    private String mPageTitle;
    private String mPageDescription;
    private String mLabelOld;
    private String mLabelNew;
    private boolean mWithMessage;

    protected TableRenameColumnWizard(AbstractTableFieldsTableModel tableFieldsTableModel, int row, String pageTitle, String pageDescription, String labelOld, String labelNew, boolean withMessage) {
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mRow = row;
        this.mPageTitle = pageTitle;
        this.mPageDescription = pageDescription;
        this.mLabelOld = labelOld;
        this.mLabelNew = labelNew;
        this.mWithMessage = withMessage;
    }

    public void addPages() {
        this.mTableRenameRowWizardPage = new TableRenameColumnWizardPage("Rename Column", this.mTableFieldsTableModel, this.mRow, this.mPageTitle, this.mPageDescription, this.mLabelOld, this.mLabelNew, this.mWithMessage);
        this.addPage((IWizardPage)this.mTableRenameRowWizardPage);
    }

    public boolean performFinish() {
        Vector messages = null;
        Object[] row = new Object[11];
        String oldFieldName = this.mTableRenameRowWizardPage.getOldFieldName();
        String newFieldName = this.mTableRenameRowWizardPage.getNewFieldName();
        if (oldFieldName != null && newFieldName != null && oldFieldName.equalsIgnoreCase(newFieldName)) {
            return true;
        }
        if (!TableUtil.fieldNameIsValid(this.mTableFieldsTableModel, this.mTableRenameRowWizardPage.getNewFieldName(), this.mRow, false)) {
            messages = TableUtil.getFieldMessages();
            this.mTableRenameRowWizardPage.setErrorMessage((String)messages.get(0));
            return false;
        }
        if (!TableUtil.stringIsEmpty(this.mTableRenameRowWizardPage.getNewFieldName())) {
            this.mTableFieldsTableModel.setValueAt(this.mTableRenameRowWizardPage.getNewFieldName(), this.mRow, 1);
            if (this.mTableFieldsTableModel instanceof TableFieldsTableModel) {
                try {
                    Hashtable<DtDbView, Boolean> questions = new Hashtable<DtDbView, Boolean>();
                    DtDictionaryRoot root = this.mTableFieldsTableModel.getDictionaryRoot();
                    DtDbView[] dtDbViews = root.getViews();
                    int i = 0;
                    while (i < dtDbViews.length) {
                        DtStructureElement[] elements = dtDbViews[i].getStructureElements();
                        int j = 0;
                        while (j < elements.length) {
                            Boolean v;
                            Object value;
                            boolean ret;
                            if (elements[j] instanceof DtImportFromOtherStructure) {
                                DtImportFromOtherStructure im = (DtImportFromOtherStructure)elements[j];
                                DtInclusiveField inclField = im.getInclusiveField(oldFieldName);
                                if (inclField != null) {
                                    ret = false;
                                    value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to rename all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        try {
                                            int pos = inclField.getPosition();
                                            String newName = inclField.getNewName();
                                            inclField.delete();
                                            DtInclusiveField inc = im.createInclusiveField(newFieldName);
                                            inc.setNewName(newName);
                                            inc.setPosition(pos);
                                        }
                                        catch (DeleteException e) {
                                            TableEditorPlugin.tracer.error("delete incl field", (Throwable)e);
                                        }
                                        catch (CreateException e2) {
                                            TableEditorPlugin.tracer.error("create new incl field", (Throwable)e2);
                                        }
                                    }
                                }
                            } else if (elements[j] instanceof DtField) {
                                DtField field = (DtField)elements[j];
                                DtDbView dtDbView = (DtDbView)field.getParent();
                                if (field.getName().equals(oldFieldName)) {
                                    ret = false;
                                    value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to rename all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        try {
                                            String jdbcTypeName = field.getJdbcTypeName();
                                            int length = field.getLength();
                                            BooleanEnum notnull = field.getNotNull();
                                            int pos = field.getPosition();
                                            field.delete();
                                            field = dtDbView.createStructureElementAsDtField(newFieldName);
                                            field.setJdbcTypeName(jdbcTypeName);
                                            field.setLength(length);
                                            field.setNotNull(notnull);
                                            field.setPosition(pos);
                                        }
                                        catch (DeleteException e) {
                                            TableEditorPlugin.tracer.error("delete dtfield", (Throwable)e);
                                        }
                                        catch (CreateException e2) {
                                            TableEditorPlugin.tracer.error("create dt field", (Throwable)e2);
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                        String tableName = this.mTableFieldsTableModel.getStructure().getName();
                        DtJoin[] joins = dtDbViews[i].getJoins();
                        int k = 0;
                        while (k < joins.length) {
                            DtJoinCondition[] conds = joins[k].getConditions();
                            int j2 = 0;
                            while (j2 < conds.length) {
                                Boolean v;
                                Object value;
                                boolean ret;
                                if (joins[k].getTabnameL().equals(tableName) && conds[j2].getFieldnameL().equals(oldFieldName)) {
                                    ret = false;
                                    value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to rename all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        conds[j2].setFieldnameL(newFieldName);
                                    }
                                }
                                if (joins[k].getTabnameR().equals(tableName) && conds[j2].getFieldnameR().equals(oldFieldName)) {
                                    ret = false;
                                    value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to rename all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        conds[j2].setFieldnameR(newFieldName);
                                    }
                                }
                                ++j2;
                            }
                            ++k;
                        }
                        DtSelectionRestriction res = dtDbViews[i].getSelectionRestriction();
                        if (res != null) {
                            DtSelectionRestrictionCondition[] conds = res.getConditions();
                            int j3 = 0;
                            while (j3 < conds.length) {
                                if (conds[j3].getTabname().equals(tableName) && conds[j3].getFieldname().equals(oldFieldName)) {
                                    boolean ret = false;
                                    Object value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        Boolean v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to rename all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        conds[j3].setFieldname(newFieldName);
                                    }
                                }
                                ++j3;
                            }
                        }
                        ++i;
                    }
                }
                catch (LoadException e) {
                    TableEditorPlugin.tracer.error("get db views", (Throwable)e);
                }
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

