/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fieldwizard;

import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TableEditRowWizardPage_old
extends WizardPage {
    private static final String PAGE_DESCR_CREATE = "Enter the field attributes";
    private static final String PAGE_DESCR_EDIT = "Change the field attributes";
    private TableFieldsTableModel mTableFieldsTableModel;
    private DtDictionaryRoot mDtDictionaryRoot;
    private char mAction;
    private int mRow;
    private Text mFieldName;
    private Text mPackageName;
    private Text mSimpleType;
    private Combo mBuiltInType;
    private Text mLength;
    private Text mDecimals;
    private Text mDescription;
    private Button mKey;
    private Button mNotNull;
    private Button mBrowse;

    public TableEditRowWizardPage_old(String pageName, TableFieldsTableModel tableFieldsTableModel, char action, int row, DtDictionaryRoot dtDictionaryRoot) {
        super(pageName);
        if (action == 'E') {
            this.setTitle("Edit Column");
            this.setDescription(PAGE_DESCR_EDIT);
        } else {
            this.setTitle("Create a Column");
            this.setDescription(PAGE_DESCR_CREATE);
        }
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mAction = action;
        this.mRow = row;
        this.mDtDictionaryRoot = dtDictionaryRoot;
    }

    public TableEditRowWizardPage_old(String pageName, String title, ImageDescriptor titleImage, TableFieldsTableModel tableFieldsTableModel, char action, int row, DtDictionaryRoot dtDictionaryRoot) {
        super(pageName, title, titleImage);
        if (action == 'E') {
            this.setTitle("Edit Column");
            this.setDescription(PAGE_DESCR_EDIT);
        } else {
            this.setTitle("Create a Column");
            this.setDescription(PAGE_DESCR_CREATE);
        }
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mAction = action;
        this.mRow = row;
        this.mDtDictionaryRoot = dtDictionaryRoot;
    }

    public void createControl_old(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        Label label = new Label(composite, 0);
        label.setText("Column Name");
        this.mFieldName = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        this.mFieldName.setLayoutData((Object)gridData);
        this.mFieldName.setEditable(false);
        label = new Label(composite, 0);
        label.setText("Simple Type Package");
        this.mPackageName = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mPackageName.setLayoutData((Object)gridData);
        this.mPackageName.setEditable(false);
        this.mPackageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.simpleTypeChanged();
            }
        });
        label = new Label(composite, 0);
        label.setText("Simple Type");
        this.mSimpleType = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mSimpleType.setLayoutData((Object)gridData);
        this.mSimpleType.setEditable(false);
        this.mSimpleType.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableEditRowWizardPage_old.this.simpleTypeChanged();
            }
        });
        this.mBrowse = new Button(composite, 8);
        this.mBrowse.setText("Browse...");
        this.mBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditRowWizardPage_old.this.searchSimpleType();
            }
        });
        label = new Label(composite, 0);
        label.setText("Built-In Type");
        String[] builtInTypes = TableUtil.getBuiltInTypes();
        this.mBuiltInType = new Combo(composite, 0);
        this.mBuiltInType.setItems(builtInTypes);
        this.mBuiltInType.setEnabled(false);
        gridData = new GridData(768);
        this.mBuiltInType.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Length");
        this.mLength = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mLength.setLayoutData((Object)gridData);
        this.mLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.lengthChanged();
            }
        });
        label = new Label(composite, 0);
        label.setText("Decimals");
        this.mDecimals = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mDecimals.setLayoutData((Object)gridData);
        this.mDecimals.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.decimalsChanged();
            }
        });
        this.mKey = new Button(composite, 32);
        this.mKey.setText("Key");
        this.mNotNull = new Button(composite, 32);
        this.mNotNull.setText("Not Null");
        label = new Label(composite, 0);
        label.setText("Description");
        this.mDescription = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mDescription.setLayoutData((Object)gridData);
        this.initialize();
        this.setControl((Control)composite);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        IGridLayoutPane gridLayoutPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)3);
        gridLayoutPane.addTextLabel("Column Name");
        this.mFieldName = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("Simple Type Package");
        this.mPackageName = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mPackageName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableEditRowWizardPage_old.this.simpleTypeChanged();
            }
        });
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("Simple Type");
        this.mSimpleType = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mSimpleType.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableEditRowWizardPage_old.this.simpleTypeChanged();
            }
        });
        this.mBrowse = gridLayoutPane.addPushButton("Browse...");
        this.mBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditRowWizardPage_old.this.searchSimpleType();
            }
        });
        gridLayoutPane.addTextLabel("Built-In Type");
        String[] builtInTypes = TableUtil.getBuiltInTypes();
        this.mBuiltInType = gridLayoutPane.addComboBox(builtInTypes, true);
        this.mBuiltInType.setLayoutData((Object)new GridData(768));
        this.mBuiltInType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.builtInTypeChanged();
            }
        });
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("Length");
        this.mLength = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.lengthChanged();
            }
        });
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("Decimals");
        this.mDecimals = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mDecimals.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage_old.this.decimalsChanged();
            }
        });
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("Description");
        this.mDescription = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        gridLayoutPane.addTextLabel("");
        this.mKey = gridLayoutPane.addCheckBox("Key", false);
        gridLayoutPane.addTextLabel("");
        gridLayoutPane.addTextLabel("");
        this.mNotNull = gridLayoutPane.addCheckBox("Not Null", false);
        this.initialize();
        this.setControl((Control)composite);
    }

    private void initialize() {
        String string = null;
        if (this.mAction != 'E') {
            this.mFieldName.setText("NEW_COLUMN");
            this.mNotNull.setSelection(true);
            return;
        }
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 1);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mFieldName.setText(string);
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 3);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mPackageName.setText(string);
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 4);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mSimpleType.setText(string);
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 5);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mBuiltInType.setText(string);
        Object object = this.mTableFieldsTableModel.getValueAt(this.mRow, 6);
        string = object != null ? object.toString() : "";
        this.mLength.setText(string);
        object = this.mTableFieldsTableModel.getValueAt(this.mRow, 7);
        string = object != null ? object.toString() : "";
        this.mDecimals.setText(string);
        if (this.mTableFieldsTableModel.getValueAt(this.mRow, 8) != null) {
            if (Boolean.valueOf(this.mTableFieldsTableModel.getValueAt(this.mRow, 8).toString()).booleanValue()) {
                this.mNotNull.setSelection(true);
            } else {
                this.mNotNull.setSelection(false);
            }
        } else {
            this.mNotNull.setSelection(false);
        }
        if (this.mTableFieldsTableModel.getValueAt(this.mRow, 2) != null) {
            if (Boolean.valueOf(this.mTableFieldsTableModel.getValueAt(this.mRow, 2).toString()).booleanValue()) {
                this.mKey.setSelection(true);
            } else {
                this.mKey.setSelection(false);
            }
        } else {
            this.mKey.setSelection(false);
        }
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 10);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mDescription.setText(string);
        if (!TableUtil.stringIsEmpty(this.getSimpleType())) {
            this.setSimpleTypeAttributesEditable(false);
        }
    }

    public String getFieldName() {
        return this.mFieldName.getText();
    }

    public String getPackageName() {
        return this.mPackageName.getText();
    }

    public String getSimpleType() {
        return this.mSimpleType.getText();
    }

    public String getBuiltInType() {
        return this.mBuiltInType.getText();
    }

    public Integer getLength() {
        String string = this.mLength.getText();
        if (!TableUtil.stringIsEmpty(string)) {
            return new Integer(string);
        }
        return null;
    }

    public Integer getDecimals() {
        String string = this.mDecimals.getText();
        if (!TableUtil.stringIsEmpty(string)) {
            return new Integer(string);
        }
        return null;
    }

    public Boolean getKey() {
        return new Boolean(this.mKey.getSelection());
    }

    public Boolean getNotNull() {
        return new Boolean(this.mNotNull.getSelection());
    }

    public String getFieldDescription() {
        return this.mDescription.getText();
    }

    private void simpleTypeChanged() {
        DtSimpleType dtSimpleType;
        String simpleType = null;
        String packageName = null;
        Object[] simpleTypeAttributes = new Object[11];
        simpleType = this.getSimpleType();
        packageName = this.getPackageName();
        if (TableUtil.stringIsEmpty(simpleType)) {
            this.setSimpleTypeAttributesEditable(true);
        } else {
            this.setSimpleTypeAttributesEditable(false);
        }
        if (TableUtil.stringIsEmpty(simpleType) && TableUtil.stringIsEmpty(packageName)) {
            this.updateStatus(null);
            return;
        }
        if (TableUtil.stringIsEmpty(packageName)) {
            this.updateStatus("Please specify a package");
            return;
        }
        try {
            dtSimpleType = this.mDtDictionaryRoot.getSimpleType(packageName, simpleType);
            if (dtSimpleType == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception e) {
            this.updateStatus("Simple Type " + packageName + " " + simpleType + " does not exist");
            return;
        }
        simpleTypeAttributes = TableUtil.getSimpleTypeAttributes(dtSimpleType);
        this.mBuiltInType.setText(simpleTypeAttributes[5].toString());
        if (simpleTypeAttributes[6] != null) {
            this.mLength.setText(simpleTypeAttributes[6].toString());
        } else {
            this.mLength.setText("");
        }
        if (simpleTypeAttributes[7] != null) {
            this.mDecimals.setText(simpleTypeAttributes[7].toString());
        } else {
            this.mDecimals.setText("");
        }
        this.mDescription.setText(simpleTypeAttributes[10].toString());
        this.mNotNull.setSelection(((Boolean)simpleTypeAttributes[8]).booleanValue());
        this.updateStatus(null);
    }

    private void lengthChanged() {
        String length = this.mLength.getText();
        int i = 0;
        while (i < length.length()) {
            if (!Character.isDigit(length.charAt(i))) {
                this.updateStatus("Length has to be numerical");
                return;
            }
            ++i;
        }
        this.updateStatus(null);
    }

    private void decimalsChanged() {
        String decimals = this.mDecimals.getText();
        int i = 0;
        while (i < decimals.length()) {
            if (!Character.isDigit(decimals.charAt(i))) {
                this.updateStatus("Decimals have to be numerical");
                return;
            }
            ++i;
        }
        this.updateStatus(null);
    }

    private void builtInTypeChanged() {
        String builtInType = this.getBuiltInType();
        this.mLength.setEditable(true);
        this.mDecimals.setEditable(true);
        if (!TableUtil.stringIsEmpty(builtInType)) {
            if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                this.mLength.setText("");
                this.mLength.setEditable(false);
            }
            if (!TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                this.mDecimals.setText("");
                this.mDecimals.setEditable(false);
            }
        }
    }

    private void searchSimpleType() {
        SimpletypeSelection selection = new SimpletypeSelection(this.mDtDictionaryRoot, this.getShell());
        if (selection.open()) {
            this.mPackageName.setText(selection.getSimpleType().getPackage());
            this.mSimpleType.setText(selection.getSimpleType().getName());
        }
        this.simpleTypeChanged();
    }

    private void setSimpleTypeAttributesEditable(boolean isEditable) {
        this.mBuiltInType.setEnabled(isEditable);
        this.mLength.setEditable(isEditable);
        this.mDecimals.setEditable(isEditable);
        this.mNotNull.setEnabled(isEditable);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

