/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fieldwizard;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.jdbc.JDBCTypeAdvancedWizard;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.AdvancedTextInput;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TableEditRowWizardPage
extends WizardPage {
    private AbstractTableFieldsTableModel mTableFieldsTableModel;
    private DtDictionaryRoot mDtDictionaryRoot;
    private char mAction;
    private int mRow;
    private Text mFieldName;
    private Combo mBuiltInType;
    private Text mJDBCType;
    private Button mAdvanced;
    private Text mLength;
    private Text mDecimals;
    private Text mDescription;
    private Button mKey;
    private Button mNotNull;
    private Button mBrowse;
    private AdvancedTextInput mDbDefault;
    private Combo mReferenceField;
    private Text mFieldName2;
    private Text mPackageName2;
    private Text mSimpleType2;
    private Text mBuiltInType2;
    private Text mJDBCType2;
    private Text mLength2;
    private Text mDecimals2;
    private Text mDescription2;
    private Button mKey2;
    private Button mNotNull2;
    private Button mBrowse2;
    private AdvancedTextInput mDbDefault2;
    private Combo mReferenceField2;
    private boolean advancedPermissions = false;
    private DatabaseEnum[] selectedDbs;
    private ArrayList jdbcTypeListFromMetamodel;
    private String mOldBuiltinType;
    private String mOldLength;
    private String[][] mMessages = new String[8][2];
    private static final int CHECK_FIELD = 0;
    private static final int CHECK_SIMPLE = 1;
    private static final int CHECK_BUILTIN = 2;
    private static final int CHECK_LENGTH = 3;
    private static final int CHECK_DECIMALS = 4;
    private static final int CHECK_JDBC = 5;
    private static final int CHECK_DEFAULT = 6;
    private static final int CHECK_REF_FIELD = 7;
    private static final String ERROR = "E";
    private static final String WARNING = "W";
    private boolean mKeyVisible = true;
    private String mFieldLabelText = "Column name:";
    private String mDefaultFieldName = "NEW_COLUMN";
    private boolean mReadOnly;

    public TableEditRowWizardPage(String pageName, AbstractTableFieldsTableModel tableFieldsTableModel, char action, int row, DtDictionaryRoot dtDictionaryRoot, boolean advancedPermissions, DatabaseEnum[] selectedDbs, ArrayList jdbcTypeListFromMetamodel, boolean keyVisible, String fieldLabelText, String pageTitle, String pageDescription, String defaultFieldName, boolean readOnly) {
        super(pageName);
        this.setTitle(pageTitle);
        this.setDescription(pageDescription);
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mAction = action;
        this.mRow = row;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.advancedPermissions = advancedPermissions;
        this.selectedDbs = selectedDbs;
        this.jdbcTypeListFromMetamodel = jdbcTypeListFromMetamodel;
        this.mKeyVisible = keyVisible;
        this.mFieldLabelText = fieldLabelText;
        this.mDefaultFieldName = defaultFieldName;
        this.mReadOnly = readOnly;
    }

    public TableEditRowWizardPage(String pageName, String title, ImageDescriptor titleImage, AbstractTableFieldsTableModel tableFieldsTableModel, char action, int row, DtDictionaryRoot dtDictionaryRoot, boolean keyVisible, String fieldLabelText, boolean readonly) {
        super(pageName, title, titleImage);
        if (action == 'E') {
            this.setTitle("Edit Column");
            this.setDescription("Change the column attributes");
        } else {
            this.setTitle("Create a Column");
            this.setDescription("Enter the column attributes");
        }
        this.mTableFieldsTableModel = tableFieldsTableModel;
        this.mAction = action;
        this.mRow = row;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.mKeyVisible = keyVisible;
        this.mFieldLabelText = fieldLabelText;
        this.mReadOnly = readonly;
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridLayout.numColumns = 1;
        CTabFolder tabFolder = new CTabFolder(parent, 2048);
        tabFolder.setLayout((Layout)new GridLayout());
        CTabItem tabItem1 = new CTabItem(tabFolder, 0);
        tabItem1.setText("Built-In Type");
        CTabItem tabItem2 = new CTabItem(tabFolder, 0);
        tabItem2.setText("Simple Type");
        tabItem1.setControl((Control)this.createBuiltInTypeTabFolder(tabFolder));
        tabItem2.setControl((Control)this.createSimpleTypeTabFolder(tabFolder));
        this.initialize();
        this.createListeners();
        tabFolder.setSelection(tabItem2);
        tabFolder.redraw();
        this.setControl((Control)tabFolder);
        tabFolder.setSelection(tabItem1);
        this.mFieldName.setFocus();
        if (this.mAction != 'E') {
            this.mFieldName.selectAll();
        }
        if (this.mReadOnly) {
            this.setWidgetsReadOnly();
        }
    }

    private void setWidgetsReadOnly() {
        this.mFieldName.setEnabled(false);
        this.mBuiltInType.setEnabled(false);
        this.mJDBCType.setEnabled(false);
        if (this.mAdvanced != null) {
            this.mAdvanced.setEnabled(false);
        }
        this.mLength.setEnabled(false);
        this.mDecimals.setEnabled(false);
        this.mDescription.setEnabled(false);
        this.mKey.setEnabled(false);
        this.mNotNull.setEnabled(false);
        if (this.mBrowse != null) {
            this.mBrowse.setEnabled(false);
        }
        this.mDbDefault.setEditable(false);
        if (this.mReferenceField != null) {
            this.mReferenceField.setEnabled(false);
        }
        this.mFieldName2.setEnabled(false);
        this.mPackageName2.setEnabled(false);
        this.mSimpleType2.setEnabled(false);
        this.mBuiltInType2.setEnabled(false);
        this.mJDBCType2.setEnabled(false);
        this.mLength2.setEnabled(false);
        this.mDecimals2.setEnabled(false);
        this.mDescription2.setEnabled(false);
        this.mKey2.setEnabled(false);
        this.mNotNull2.setEnabled(false);
        this.mBrowse2.setEnabled(false);
        this.mDbDefault2.setEditable(false);
        if (this.mReferenceField2 != null) {
            this.mReferenceField2.setEnabled(false);
        }
    }

    private Composite createBuiltInTypeTabFolder(CTabFolder tabFold) {
        Composite tabFolderPage = new Composite((Composite)tabFold, 0);
        GridLayout layout3 = new GridLayout();
        tabFolderPage.setLayout((Layout)layout3);
        tabFolderPage.setLayoutData((Object)new GridData(784));
        layout3.numColumns = 3;
        this.createFieldName(tabFolderPage);
        this.createBuiltInType(tabFolderPage);
        this.createJDBCType(tabFolderPage);
        this.createLength(tabFolderPage);
        this.createDecimals(tabFolderPage);
        this.createDescription(tabFolderPage);
        if (!this.mKeyVisible) {
            this.createReferenceField(tabFolderPage);
        }
        this.createDbDefault(tabFolderPage);
        this.createKey(tabFolderPage);
        this.createNotNull(tabFolderPage);
        return tabFolderPage;
    }

    private Composite createSimpleTypeTabFolder(CTabFolder tabFolder) {
        Composite tabFolderPage = new Composite((Composite)tabFolder, 0);
        GridLayout layout3 = new GridLayout();
        tabFolderPage.setLayout((Layout)layout3);
        tabFolderPage.setLayoutData((Object)new GridData(784));
        layout3.numColumns = 3;
        this.createFieldName2(tabFolderPage);
        this.createSimpleType(tabFolderPage);
        this.createBuiltInType2(tabFolderPage);
        this.createJDBCType2(tabFolderPage);
        this.createLength2(tabFolderPage);
        this.createDecimals2(tabFolderPage);
        this.createDescription2(tabFolderPage);
        if (!this.mKeyVisible) {
            this.createReferenceField2(tabFolderPage);
        }
        this.createDbDefault2(tabFolderPage);
        this.createKey2(tabFolderPage);
        this.createNotNull2(tabFolderPage);
        return tabFolderPage;
    }

    private void createFieldName(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText(this.mFieldLabelText);
        this.mFieldName = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mFieldName.setLayoutData((Object)gridData);
        if (this.mAction == 'E') {
            this.mFieldName.setEditable(false);
        }
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createBuiltInType(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Built-in type:");
        this.mBuiltInType = new Combo(tabFolderPage, 0);
        String[] builtInTypes = null;
        builtInTypes = this.mKeyVisible ? TableUtil.getBuiltInTypes() : TableUtil.getBuiltInTypesForStructures();
        this.mBuiltInType.setItems(builtInTypes);
        this.mBuiltInType.setEnabled(true);
        this.mBuiltInType.setLayoutData((Object)new GridData(768));
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createJDBCType(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("JDBC type:");
        this.mJDBCType = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mJDBCType.setLayoutData((Object)gridData);
        this.mJDBCType.setEditable(false);
        if (!this.advancedPermissions) {
            new Label(tabFolderPage, 0).setText("");
        } else {
            this.mAdvanced = new Button(tabFolderPage, 0);
            this.mAdvanced.setText("Advanced...");
        }
    }

    private void createLength(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Length:");
        this.mLength = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mLength.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createDecimals(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Decimals:");
        this.mDecimals = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDecimals.setLayoutData((Object)gridData);
        this.mDecimals.setTextLimit(2);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createDescription(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Description:");
        this.mDescription = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDescription.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createKey(Composite tabFolderPage) {
        this.mKey = new Button(tabFolderPage, 32);
        this.mKey.setText("Key");
        this.mKey.setSelection(false);
        this.mKey.setVisible(this.mKeyVisible);
        Label label = new Label(tabFolderPage, 0);
        label.setText("");
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createNotNull(Composite tabFolderPage) {
        this.mNotNull = new Button(tabFolderPage, 32);
        this.mNotNull.setText("Not Null");
        this.mNotNull.setSelection(true);
        Label label = new Label(tabFolderPage, 0);
        label.setText("");
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createFieldName2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText(this.mFieldLabelText);
        this.mFieldName2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mFieldName2.setLayoutData((Object)gridData);
        if (this.mAction == 'E') {
            this.mFieldName2.setEditable(false);
        }
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createSimpleType(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Simple type package:");
        this.mPackageName2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mPackageName2.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
        label = new Label(tabFolderPage, 0);
        label.setText("Simple type:");
        this.mSimpleType2 = new Text(tabFolderPage, 2052);
        gridData = new GridData(768);
        this.mSimpleType2.setLayoutData((Object)gridData);
        this.mBrowse2 = new Button(tabFolderPage, 8);
        this.mBrowse2.setText("Browse...");
    }

    private void createDbDefault(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("DB default:");
        this.mDbDefault = new AdvancedTextInput(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDbDefault.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createReferenceField(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Reference element:");
        this.mReferenceField = new Combo(tabFolderPage, 0);
        if (this.getReferenceFields() != null) {
            this.mReferenceField.setItems(this.getReferenceFields());
        }
        this.mReferenceField.setEnabled(false);
        this.mReferenceField.setLayoutData((Object)new GridData(768));
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createBuiltInType2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Built-in type:");
        this.mBuiltInType2 = new Text(tabFolderPage, 2052);
        this.mBuiltInType2.setEditable(false);
        this.mBuiltInType2.setLayoutData((Object)new GridData(768));
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createJDBCType2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("JDBC type:");
        this.mJDBCType2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mJDBCType2.setLayoutData((Object)gridData);
        this.mJDBCType2.setEditable(false);
        new Label(tabFolderPage, 0).setText("");
    }

    private void createLength2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Length:");
        this.mLength2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mLength2.setLayoutData((Object)gridData);
        this.mLength2.setEditable(false);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createDecimals2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Decimals:");
        this.mDecimals2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDecimals2.setLayoutData((Object)gridData);
        this.mDecimals2.setEditable(false);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createDbDefault2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("DB default:");
        this.mDbDefault2 = new AdvancedTextInput(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDbDefault2.setEditable(false);
        this.mDbDefault2.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createReferenceField2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Reference element:");
        this.mReferenceField2 = new Combo(tabFolderPage, 0);
        if (this.getReferenceFields() != null) {
            this.mReferenceField2.setItems(this.getReferenceFields());
        }
        this.mReferenceField2.setEnabled(false);
        this.mReferenceField2.setLayoutData((Object)new GridData(768));
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createKey2(Composite tabFolderPage) {
        this.mKey2 = new Button(tabFolderPage, 32);
        this.mKey2.setText("Key");
        this.mKey2.setSelection(false);
        this.mKey2.setVisible(this.mKeyVisible);
        Label label = new Label(tabFolderPage, 0);
        label.setText("");
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createNotNull2(Composite tabFolderPage) {
        this.mNotNull2 = new Button(tabFolderPage, 32);
        this.mNotNull2.setText("Not Null");
        this.mNotNull2.setSelection(true);
        this.mNotNull2.setEnabled(false);
        Label label = new Label(tabFolderPage, 0);
        label.setText("");
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void createDescription2(Composite tabFolderPage) {
        Label label = new Label(tabFolderPage, 0);
        label.setText("Description:");
        this.mDescription2 = new Text(tabFolderPage, 2052);
        GridData gridData = new GridData(768);
        this.mDescription2.setEditable(false);
        this.mDescription2.setLayoutData((Object)gridData);
        label = new Label(tabFolderPage, 0);
        label.setText("");
    }

    private void initialize() {
        String string = null;
        String packageName = null;
        String simpleType = null;
        Object object = null;
        if (this.mAction != 'E') {
            this.mFieldName.setText(this.getNewFieldName());
            this.mNotNull.setSelection(true);
            return;
        }
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 1);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mFieldName.setText(string);
        this.mFieldName2.setText(string);
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 5);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mBuiltInType.setText(string);
        this.mBuiltInType2.setText(string);
        object = this.mTableFieldsTableModel.getValueAt(this.mRow, 6);
        string = object != null ? object.toString() : "";
        this.mLength.setText(string);
        this.mLength2.setText(string);
        object = this.mTableFieldsTableModel.getValueAt(this.mRow, 7);
        string = object != null ? object.toString() : "";
        this.mDecimals.setText(string);
        this.mDecimals2.setText(string);
        if (this.mTableFieldsTableModel.getValueAt(this.mRow, 8) != null) {
            if (Boolean.valueOf(this.mTableFieldsTableModel.getValueAt(this.mRow, 8).toString()).booleanValue()) {
                this.mNotNull.setSelection(true);
            } else {
                this.mNotNull.setSelection(false);
            }
        } else {
            this.mNotNull.setSelection(false);
        }
        this.mNotNull2.setSelection(this.mNotNull.getSelection());
        if (this.mTableFieldsTableModel.getValueAt(this.mRow, 2) != null) {
            if (Boolean.valueOf(this.mTableFieldsTableModel.getValueAt(this.mRow, 2).toString()).booleanValue()) {
                this.mKey.setSelection(true);
            } else {
                this.mKey.setSelection(false);
            }
        } else {
            this.mKey.setSelection(false);
        }
        this.mKey2.setSelection(this.mKey.getSelection());
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 9);
        if (string == null) {
            string = "";
        }
        this.mDbDefault.setText(string);
        this.mDbDefault2.setText(string);
        string = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 10);
        if (TableUtil.stringIsEmpty(string)) {
            string = "";
        }
        this.mDescription.setText(string);
        this.mDescription2.setText(string);
        packageName = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 3);
        if (TableUtil.stringIsEmpty(packageName)) {
            packageName = "";
        }
        this.mPackageName2.setText(packageName);
        simpleType = (String)this.mTableFieldsTableModel.getValueAt(this.mRow, 4);
        if (TableUtil.stringIsEmpty(simpleType)) {
            simpleType = "";
        }
        this.mSimpleType2.setText(simpleType);
        this.setJDBCType();
        this.checkFieldName(this.mFieldName.getText());
        if (!TableUtil.stringIsEmpty(packageName) || !TableUtil.stringIsEmpty(simpleType)) {
            DtSimpleType dtSimpleType = this.getSimpleType(packageName, simpleType);
        }
        this.builtInTypeChanged(false);
        if (!this.mKeyVisible) {
            DtField curField;
            this.mReferenceField.setText("");
            String curFieldName = this.getFieldName();
            if (curFieldName != null && !curFieldName.equals("") && (curField = (DtField)this.mTableFieldsTableModel.getStructure().getStructureElement(curFieldName)) != null) {
                DtField refField = curField.getRefField();
                String refFieldName = "";
                if (refField != null) {
                    refFieldName = refField.getName();
                }
                if (this.mReferenceField != null) {
                    this.mReferenceField.setText(refFieldName);
                    this.mReferenceField2.setText(refFieldName);
                }
            }
            if (!this.mReferenceField.getText().equals("")) {
                this.mReferenceField.setEnabled(true);
                this.mReferenceField2.setEnabled(true);
            }
        }
    }

    public String getFieldName() {
        return this.mFieldName.getText();
    }

    public String getPackageName() {
        return this.mPackageName2.getText();
    }

    public String getSimpleTypeName() {
        return this.mSimpleType2.getText();
    }

    public String getBuiltInType() {
        return this.mBuiltInType.getText();
    }

    public String[] getReferenceFields() {
        DtStructureExpanded structExpanded;
        ArrayList refFieldsArray;
        if (this.mTableFieldsTableModel.getStructure() != null && (refFieldsArray = (structExpanded = new DtStructureExpanded(this.mTableFieldsTableModel.getStructure())).getReferenceFieldCandidates()).size() > 0) {
            Object[] oRefFields = refFieldsArray.toArray();
            String[] refFields = new String[oRefFields.length];
            int i = 0;
            while (i < oRefFields.length) {
                refFields[i] = (String)oRefFields[i];
                ++i;
            }
            return refFields;
        }
        return null;
    }

    public ArrayList getReferenceFieldsList() {
        if (this.mTableFieldsTableModel.getStructure() != null) {
            DtStructureExpanded structExpanded = new DtStructureExpanded(this.mTableFieldsTableModel.getStructure());
            return structExpanded.getReferenceFieldCandidates();
        }
        return null;
    }

    public Integer getLength() {
        String string = this.mLength.getText();
        if (!TableUtil.stringIsEmpty(string)) {
            try {
                return new Integer(string);
            }
            catch (Exception e) {
                TableEditorPlugin.tracer.error("parse str to integer", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public Integer getDecimals() {
        String string = this.mDecimals.getText();
        if (!TableUtil.stringIsEmpty(string)) {
            try {
                return new Integer(string);
            }
            catch (Exception e) {
                TableEditorPlugin.tracer.error("parse str to integer", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public Boolean getKey() {
        return new Boolean(this.mKey.getSelection());
    }

    public Boolean getNotNull() {
        return new Boolean(this.mNotNull.getSelection());
    }

    public String getFieldDescription() {
        return this.mDescription.getText();
    }

    public String getDbDefault() {
        return this.mDbDefault.getText();
    }

    public String getReferenceField() {
        if (this.mReferenceField == null) {
            return null;
        }
        return this.mReferenceField.getText();
    }

    private void deactivateNotNull() {
        this.mNotNull.setSelection(false);
        this.mNotNull.setEnabled(false);
        this.mNotNull2.setSelection(false);
        this.mNotNull2.setEnabled(false);
    }

    private void checkNotNull() {
        if (this.mKey.getSelection() && TableUtil.stringIsEmpty(this.mSimpleType2.getText()) && !TableUtil.stringIsEmpty(this.mBuiltInType.getText())) {
            this.mNotNull.setSelection(true);
            this.mNotNull2.setSelection(true);
            this.mNotNull.setEnabled(false);
            this.mDbDefault.setEditable(true);
        } else {
            this.mNotNull.setEnabled(true);
        }
        if (this.mBuiltInType.getText().equals("boolean")) {
            this.mNotNull.setVisible(false);
            this.mNotNull2.setVisible(false);
            this.mNotNull.setSelection(false);
            this.mNotNull2.setSelection(false);
        } else {
            this.mNotNull.setVisible(true);
            this.mNotNull2.setVisible(true);
        }
    }

    private boolean isDbDefaultEditable() {
        String builtInType = this.getBuiltInType();
        if (builtInType == null) {
            builtInType = "";
        }
        boolean isEditable = TableUtil.stringIsEmpty(this.mSimpleType2.getText()) && !TableUtil.stringIsEmpty(builtInType);
        if (builtInType.equalsIgnoreCase("date") || builtInType.equalsIgnoreCase("time") || builtInType.equalsIgnoreCase("timestamp") || builtInType.equalsIgnoreCase("boolean")) {
            isEditable = false;
        }
        return isEditable;
    }

    private void activateNotNull() {
        this.mNotNull.setEnabled(true);
    }

    private void simpleTypeChanged() {
        String simpleType = null;
        String packageName = null;
        Object messages = null;
        Object[] simpleTypeAttributes = new Object[11];
        simpleType = this.getSimpleTypeName();
        packageName = this.getPackageName();
        this.checkNotNull();
        this.mDbDefault.setEditable(this.isDbDefaultEditable());
        if (TableUtil.stringIsEmpty(simpleType) && TableUtil.stringIsEmpty(packageName)) {
            this.checkDbDefault(true, false);
            this.updateStatus(null, null, 1);
            return;
        }
        DtSimpleType dtSimpleType = this.getSimpleType(packageName, simpleType);
        if (dtSimpleType == null) {
            return;
        }
        simpleTypeAttributes = TableUtil.getSimpleTypeAttributes(dtSimpleType);
        this.mBuiltInType2.setText(simpleTypeAttributes[5].toString());
        this.mBuiltInType.setText(simpleTypeAttributes[5].toString());
        if (simpleTypeAttributes[6] != null) {
            this.mLength2.setText(simpleTypeAttributes[6].toString());
            this.mLength.setText(simpleTypeAttributes[6].toString());
        } else {
            this.mLength2.setText("");
            this.mLength.setText("");
        }
        if (simpleTypeAttributes[7] != null) {
            this.mDecimals2.setText(simpleTypeAttributes[7].toString());
            this.mDecimals.setText(simpleTypeAttributes[7].toString());
        } else {
            this.mDecimals2.setText("");
            this.mDecimals.setText("");
        }
        this.mDescription2.setText(simpleTypeAttributes[10].toString());
        this.mDescription.setText(simpleTypeAttributes[10].toString());
        this.mDbDefault2.setText(simpleTypeAttributes[9].toString());
        this.mDbDefault.setText(simpleTypeAttributes[9].toString());
        this.mNotNull2.setSelection(((Boolean)simpleTypeAttributes[8]).booleanValue());
        this.mNotNull.setSelection(((Boolean)simpleTypeAttributes[8]).booleanValue());
        this.updateStatus(null, null, 1);
        if (this.mReferenceField != null && this.mReferenceField2 != null) {
            if (this.mBuiltInType2.getText().equalsIgnoreCase("decimal")) {
                if (this.mReferenceField2.getText().equals("") && this.getReferenceFields() == null) {
                    this.mReferenceField.setEnabled(false);
                    this.mReferenceField2.setEnabled(false);
                } else {
                    this.mReferenceField.setEnabled(true);
                    this.mReferenceField2.setEnabled(true);
                }
            } else {
                this.mReferenceField.setEnabled(false);
                this.mReferenceField.setText("");
                this.mReferenceField2.setEnabled(false);
                this.mReferenceField2.setText("");
            }
        }
    }

    protected DtSimpleType getSimpleType(String packageName, String simpleType) {
        Vector messages = null;
        if (TableUtil.stringIsEmpty(packageName)) {
            this.updateStatus("Specify a package or delete simple type", ERROR, 1);
            return null;
        }
        try {
            DtSimpleType dtSimpleType = this.mDtDictionaryRoot.getSimpleType(packageName, simpleType);
            if (dtSimpleType == null) {
                throw new NullPointerException();
            }
            if (dtSimpleType.hasLogicalDictionary()) {
                this.updateStatus("SimpleType is imported from external dictionary. It can't be used as reference type", ERROR, 1);
                return null;
            }
            if (packageName.equals("com.sap.dictionary") || packageName.equals("com.sap.dictionary.predefined.objecttypes")) {
                this.updateStatus(MessagePool.getMessage((String)"The predefined internal types in package & are excluded from usage. Please use a built-in type instead", (String)packageName), ERROR, 1);
                return null;
            }
            return dtSimpleType;
        }
        catch (Exception e) {
            messages = TableUtil.checkSimpleType(packageName, simpleType, this.mDtDictionaryRoot);
            if (messages != null) {
                this.updateStatus((String)messages.get(0), ERROR, 1);
            } else {
                this.updateStatus(MessagePool.getMessage((String)"Simple type & does not exist in package &", (String)simpleType, (String)packageName), ERROR, 1);
            }
            return null;
        }
    }

    protected boolean checkDecimals() {
        String decimals = this.mDecimals.getText();
        int i = 0;
        while (i < decimals.length()) {
            if (!Character.isDigit(decimals.charAt(i))) {
                this.updateStatus("Decimals have to be numerical", ERROR, 4);
                return false;
            }
            ++i;
        }
        if (decimals.length() > 0) {
            try {
                Integer integer = new Integer(decimals);
            }
            catch (Exception e) {
                this.updateStatus("Decimals are invalid", ERROR, 4);
                return false;
            }
        }
        this.updateStatus(null, null, 4);
        return true;
    }

    protected boolean checkLength() {
        String length = this.mLength.getText();
        int i = 0;
        while (i < length.length()) {
            if (!Character.isDigit(length.charAt(i))) {
                this.updateStatus("Length has to be numerical", ERROR, 3);
                return false;
            }
            ++i;
        }
        if (length.length() > 0) {
            try {
                Integer integer = new Integer(length);
            }
            catch (Exception e) {
                this.updateStatus("Length is invalid", ERROR, 3);
                return false;
            }
        }
        this.updateStatus(null, null, 3);
        return true;
    }

    protected boolean checkTotalDigits() {
        String builtInType = this.getBuiltInType();
        if (TableUtil.stringIsEmpty(builtInType)) {
            return true;
        }
        int length = 0;
        if (this.checkLength() && this.mLength.getText().length() > 0) {
            length = Integer.valueOf(this.mLength.getText());
        }
        if (TableUtil.checkValidConstraint(builtInType, "totalDigits") && length == 0) {
            this.updateStatus("Length has to be specified", ERROR, 3);
            return false;
        }
        this.updateStatus(null, null, 3);
        return true;
    }

    protected boolean checkBuiltInType() {
        boolean isValid;
        String builtInType = this.getBuiltInType();
        String[] builtInTypes = null;
        builtInTypes = this.mKeyVisible ? TableUtil.getBuiltInTypes() : TableUtil.getBuiltInTypesForStructures();
        if (!TableUtil.stringIsEmpty(builtInType)) {
            isValid = false;
            int i = 0;
            while (i < builtInTypes.length) {
                if (builtInType.equals(builtInTypes[i])) {
                    isValid = true;
                    break;
                }
                ++i;
            }
        } else {
            isValid = true;
        }
        if (isValid) {
            this.updateStatus(null, null, 2);
        } else {
            this.updateStatus(MessagePool.getMessage((String)"Built-in type & is not allowed for tables", (String)builtInType), ERROR, 2);
        }
        return isValid;
    }

    protected boolean checkReferenceField() {
        String refFieldName = this.getReferenceField();
        if (refFieldName != null && !refFieldName.equals("")) {
            DtField refField = (DtField)this.mTableFieldsTableModel.getStructure().getStructureElement(refFieldName);
            if (refField == null) {
                this.updateStatus(MessagePool.getMessage((String)"Reference element & does not exist", (String)refFieldName), ERROR, 7);
                return false;
            }
            ArrayList refFieldsList = this.getReferenceFieldsList();
            if (refFieldsList.contains(refFieldName)) {
                this.updateStatus(null, null, 7);
                return true;
            }
            this.updateStatus(MessagePool.getMessage((String)"Reference element & is invalid. Use a structure element of type 'currency' or 'currencyNormalized'", (String)refFieldName), ERROR, 7);
            return false;
        }
        this.updateStatus(null, null, 7);
        return true;
    }

    private void builtInTypeChanged(boolean setDbDefaultProposal) {
        String builtInType = this.getBuiltInType();
        String[] builtInTypes = null;
        builtInTypes = this.mKeyVisible ? TableUtil.getBuiltInTypes() : TableUtil.getBuiltInTypesForStructures();
        this.mLength.setEditable(true);
        this.mDecimals.setEditable(true);
        if (!TableUtil.stringIsEmpty(builtInType)) {
            if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                this.mLength.setText("");
                this.mLength2.setText("");
                this.mLength.setEditable(false);
                this.mLength2.setEditable(false);
            }
            if (!TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                this.mDecimals.setText("");
                this.mDecimals2.setText("");
                this.mDecimals.setEditable(false);
                this.mDecimals2.setEditable(false);
            }
            if (TableUtil.stringIsEmpty(this.mSimpleType2.getText())) {
                this.mPackageName2.setText("");
            }
            this.checkNotNull();
        } else {
            this.mLength.setText("");
            this.mLength2.setText("");
            this.mDecimals.setText("");
            this.mDecimals2.setText("");
            this.mPackageName2.setEditable(true);
        }
        this.checkDbDefault(setDbDefaultProposal, false);
        this.mDbDefault.setEditable(this.isDbDefaultEditable());
        this.checkBuiltInType();
        if (this.mReferenceField != null && this.mReferenceField2 != null) {
            if (this.mBuiltInType.getText().equalsIgnoreCase("decimal")) {
                if (this.mReferenceField.getText().equals("") && this.getReferenceFields() == null) {
                    this.mReferenceField.setEnabled(false);
                    this.mReferenceField2.setEnabled(false);
                } else {
                    this.mReferenceField.setEnabled(true);
                    this.mReferenceField2.setEnabled(true);
                }
            } else {
                this.mReferenceField.setEnabled(false);
                this.mReferenceField.setText("");
                this.mReferenceField2.setEnabled(false);
                this.mReferenceField2.setText("");
            }
        }
    }

    private boolean isNotNullAllowed() {
        ArrayList JdbcTypesWithoutDefault = null;
        ArrayList jdbcTypeInfo = null;
        String jdbcTypeName = null;
        String builtInType = null;
        DtTypeInfoForDatabase dtTypeInfoForDatabase = null;
        int length = 0;
        JdbcTypesWithoutDefault = DtTypeInfo.getJdbcTypesWithoutDefault();
        jdbcTypeName = this.mJDBCType.getText();
        if (!TableUtil.stringIsEmpty(jdbcTypeName) && JdbcTypesWithoutDefault.contains(jdbcTypeName)) {
            return false;
        }
        if (this.jdbcTypeListFromMetamodel != null && this.jdbcTypeListFromMetamodel.size() > 0) {
            jdbcTypeInfo = this.jdbcTypeListFromMetamodel;
        } else {
            builtInType = this.getBuiltInType();
            if (TableUtil.stringIsEmpty(builtInType)) {
                return true;
            }
            length = this.getLength() != null ? this.getLength() : 0;
            jdbcTypeInfo = DdMapping.getJdbcTypeInfo((String)builtInType, (int)length, (DatabaseEnum[])this.mTableFieldsTableModel.getDatabases());
        }
        if (jdbcTypeInfo == null || jdbcTypeInfo != null && jdbcTypeInfo.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < jdbcTypeInfo.size()) {
            dtTypeInfoForDatabase = (DtTypeInfoForDatabase)jdbcTypeInfo.get(i);
            if (JdbcTypesWithoutDefault.contains(dtTypeInfoForDatabase.getJavaSqlTypeName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void searchSimpleType() {
        SimpletypeSelection selection = new SimpletypeSelection(this.mDtDictionaryRoot, this.getShell());
        boolean diagSel = selection.open();
        if (diagSel) {
            this.mPackageName2.setEditable(true);
            this.mPackageName2.setText(selection.getSimpleType().getPackage());
            this.mSimpleType2.setText(selection.getSimpleType().getName());
        }
        this.simpleTypeChanged();
        if (diagSel) {
            this.mPackageName2.setText(selection.getSimpleType().getPackage());
            this.mSimpleType2.setText(selection.getSimpleType().getName());
        }
    }

    private void setSimpleTypeAttributesEditable(boolean isEditable) {
        this.mBuiltInType2.setEnabled(isEditable);
        this.mDecimals2.setEnabled(isEditable);
        this.mNotNull2.setEnabled(isEditable);
        this.mDescription2.setEnabled(isEditable);
    }

    private void checkFieldName(String fieldName) {
        Vector messages = null;
        int index = this.mAction == 'E' ? this.mRow : -1;
        if (TableUtil.fieldNameIsValid(this.mTableFieldsTableModel, fieldName, index, false)) {
            this.updateStatus(null, null, 0);
        } else {
            messages = TableUtil.getFieldMessages();
            this.updateStatus((String)messages.get(0), ERROR, 0);
        }
    }

    protected boolean checkDbDefault(boolean setProposal, boolean sendMessage) {
        this.updateStatus(null, null, 6);
        if (!TableUtil.stringIsEmpty(this.getSimpleTypeName()) || !TableUtil.stringIsEmpty(this.getPackageName())) {
            return true;
        }
        String dbDefault = this.mDbDefault.getText();
        if (dbDefault == null) {
            dbDefault = "";
        }
        if (dbDefault.length() == 0 && !setProposal) {
            return true;
        }
        String builtInType = this.getBuiltInType();
        if (builtInType == null) {
            builtInType = "";
        }
        if (builtInType.equalsIgnoreCase("date") || builtInType.equalsIgnoreCase("time") || builtInType.equalsIgnoreCase("timestamp") || builtInType.equalsIgnoreCase("boolean")) {
            this.mDbDefault.setText("");
            this.mDbDefault2.setText("");
            return true;
        }
        int length = 0;
        if (this.checkLength() && this.mLength.getText().length() > 0) {
            length = Integer.valueOf(this.mLength.getText());
        }
        int decimals = 0;
        if (this.checkDecimals() && this.mDecimals.getText().length() > 0) {
            decimals = Integer.valueOf(this.mDecimals.getText());
        }
        if (dbDefault.length() == 0 && setProposal && TableUtil.stringIsEmpty(this.mSimpleType2.getText()) && this.mNotNull.getSelection()) {
            this.setDbDefaultProposal(this.getBuiltInType(), length, decimals);
            return true;
        }
        String message = TableUtil.checkDbDefault(dbDefault, this.getBuiltInType(), length, decimals);
        if (!TableUtil.stringIsEmpty(message)) {
            if (sendMessage) {
                this.updateStatus(message, ERROR, 6);
                return false;
            }
            this.setDbDefaultProposal(this.getBuiltInType(), length, decimals);
            return true;
        }
        return true;
    }

    private void setDbDefaultProposal(String builtInType, int length, int decimals) {
        String dbDefault = TableUtil.getDbDefault(this.getBuiltInType(), length, decimals);
        if (dbDefault == null) {
            dbDefault = "";
        }
        this.mDbDefault.setText(dbDefault);
        this.mDbDefault2.setText(dbDefault);
    }

    private String getNewFieldName() {
        String PREFIX;
        String fieldName = null;
        String counter = "1";
        fieldName = PREFIX = this.mDefaultFieldName;
        boolean tableHasField = this.mTableFieldsTableModel.tableHasField(fieldName, -1);
        block0: while (tableHasField) {
            counter = Integer.toString(Integer.valueOf(counter) + 1);
            fieldName = PREFIX + counter;
            tableHasField = false;
            int i = 0;
            while (i < this.mTableFieldsTableModel.getRowCount()) {
                if (fieldName.equalsIgnoreCase(this.mTableFieldsTableModel.getFieldName(i))) {
                    tableHasField = true;
                    continue block0;
                }
                ++i;
            }
        }
        return fieldName;
    }

    private void createListeners() {
        this.createFieldNameListener();
        this.createBuiltInTypeListener();
        this.createJDBCTypeListener();
        this.createLengthListener();
        this.createDecimalsListener();
        this.createDescriptionListener();
        if (!this.mKeyVisible) {
            this.createReferenceFieldListener();
            this.createReferenceField2Listener();
        }
        this.createDbDefaultListener();
        this.createKeyListener();
        this.createNotNullListener();
        this.createSimpleTypeListener();
    }

    private void createFieldNameListener() {
        this.mFieldName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (TableEditRowWizardPage.this.mFieldName.getText().compareTo(TableEditRowWizardPage.this.mFieldName2.getText()) != 0) {
                    TableEditRowWizardPage.this.mFieldName2.setText(TableEditRowWizardPage.this.mFieldName.getText());
                }
                TableEditRowWizardPage.this.updateStatus(null, null, 0);
                TableEditRowWizardPage.this.checkFieldName(TableEditRowWizardPage.this.mFieldName.getText().toUpperCase());
            }
        });
        this.mFieldName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String temp = TableEditRowWizardPage.this.mFieldName.getText();
                temp = temp.toUpperCase();
                TableEditRowWizardPage.this.mFieldName.setText(temp);
                TableEditRowWizardPage.this.checkFieldName(temp);
            }
        });
        this.mFieldName2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (TableEditRowWizardPage.this.mFieldName.getText().compareTo(TableEditRowWizardPage.this.mFieldName2.getText()) != 0) {
                    TableEditRowWizardPage.this.mFieldName.setText(TableEditRowWizardPage.this.mFieldName2.getText());
                }
                TableEditRowWizardPage.this.updateStatus(null, null, 0);
                TableEditRowWizardPage.this.checkFieldName(TableEditRowWizardPage.this.mFieldName.getText().toUpperCase());
            }
        });
        this.mFieldName2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String temp = TableEditRowWizardPage.this.mFieldName2.getText();
                temp = temp.toUpperCase();
                TableEditRowWizardPage.this.mFieldName2.setText(temp);
                TableEditRowWizardPage.this.checkFieldName(temp);
            }
        });
    }

    private void createBuiltInTypeListener() {
        this.mBuiltInType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage.this.builtInTypeChanged(true);
                if (TableEditRowWizardPage.this.mOldBuiltinType != null && !TableEditRowWizardPage.this.mOldBuiltinType.equals(TableEditRowWizardPage.this.mBuiltInType.getText()) && TableEditRowWizardPage.this.mOldBuiltinType.length() > 0 && TableEditRowWizardPage.this.jdbcTypeListFromMetamodel != null) {
                    TableEditRowWizardPage.this.jdbcTypeListFromMetamodel.clear();
                    TableEditRowWizardPage.this.mTableFieldsTableModel.deleteInternalJdbcTypeInfo(TableEditRowWizardPage.this.mFieldName.getText());
                }
                TableEditRowWizardPage.this.setJDBCType();
                if (TableEditRowWizardPage.this.mBuiltInType.getText().compareTo(TableEditRowWizardPage.this.mBuiltInType2.getText()) != 0) {
                    TableEditRowWizardPage.this.mBuiltInType2.setText(TableEditRowWizardPage.this.mBuiltInType.getText());
                    TableEditRowWizardPage.this.mPackageName2.setText("");
                    TableEditRowWizardPage.this.mSimpleType2.setText("");
                }
                TableEditRowWizardPage.this.mOldBuiltinType = TableEditRowWizardPage.this.mBuiltInType.getText();
            }
        });
    }

    private void setJDBCType() {
        int length = 0;
        boolean lengthIsValid = this.checkLength();
        if (lengthIsValid && this.mLength.getText().length() > 0) {
            length = Integer.valueOf(this.mLength.getText());
        }
        if (lengthIsValid && this.mBuiltInType.getText().length() > 0) {
            String javaSqlName = TableUtil.getJdbcType(this.mBuiltInType.getText(), length, this.selectedDbs);
            if (!TableUtil.stringIsEmpty(javaSqlName)) {
                this.mJDBCType.setText(javaSqlName);
                this.mJDBCType2.setText(javaSqlName);
            } else {
                this.mJDBCType.setText("");
                this.mJDBCType2.setText("");
            }
        } else {
            this.mJDBCType.setText("");
            this.mJDBCType2.setText("");
        }
    }

    private void createJDBCTypeListener() {
        this.mJDBCType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String message = DdMapping.getTypeUsingDescription((String)TableEditRowWizardPage.this.mJDBCType.getText());
                String messageType = TableUtil.stringIsEmpty(message) ? null : TableEditRowWizardPage.WARNING;
                TableEditRowWizardPage.this.updateStatus(message, messageType, 5);
            }
        });
        if (this.advancedPermissions) {
            this.mAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    super.widgetSelected(arg0);
                    boolean lengthIsValid = TableEditRowWizardPage.this.checkLength();
                    if (lengthIsValid && TableEditRowWizardPage.this.mJDBCType.getText().length() > 0) {
                        int length = 0;
                        if (TableEditRowWizardPage.this.mLength.getText().length() > 0) {
                            length = Integer.valueOf(TableEditRowWizardPage.this.mLength.getText());
                        }
                        JDBCTypeAdvancedWizard wiz = new JDBCTypeAdvancedWizard(TableEditRowWizardPage.this.selectedDbs, TableEditRowWizardPage.this.jdbcTypeListFromMetamodel, TableEditRowWizardPage.this.mBuiltInType.getText(), length);
                        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz);
                        dialog.open();
                        TableEditRowWizardPage.this.mTableFieldsTableModel.setInternalJdbcTypeInfos(TableEditRowWizardPage.this.mFieldName.getText(), wiz.getJdbcTypeInfos());
                        TableEditRowWizardPage.this.jdbcTypeListFromMetamodel = wiz.getJdbcTypeInfos();
                    }
                }
            });
        }
    }

    private void createLengthListener() {
        this.mLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean lengthIsValid = TableEditRowWizardPage.this.checkLength();
                if (TableEditRowWizardPage.this.mOldLength != null && !TableEditRowWizardPage.this.mOldLength.equals(TableEditRowWizardPage.this.mLength.getText()) && TableEditRowWizardPage.this.mOldLength.length() > 0 && TableEditRowWizardPage.this.jdbcTypeListFromMetamodel != null) {
                    TableEditRowWizardPage.this.jdbcTypeListFromMetamodel.clear();
                }
                int length = 0;
                if (lengthIsValid && TableEditRowWizardPage.this.mLength.getText().length() > 0) {
                    length = Integer.valueOf(TableEditRowWizardPage.this.mLength.getText());
                }
                if (lengthIsValid && TableEditRowWizardPage.this.mBuiltInType.getText().length() > 0) {
                    ArrayList list = DdMapping.getJdbcTypeInfo((String)TableEditRowWizardPage.this.mBuiltInType.getText(), (int)length, (DatabaseEnum[])TableEditRowWizardPage.this.selectedDbs);
                    int i = 0;
                    while (i < list.size()) {
                        if (((DtTypeInfoForDatabase)list.get(i)).getDatabaseName().compareTo("DEFAULT") == 0) {
                            String javaSqlName = ((DtTypeInfoForDatabase)list.get(i)).getJavaSqlTypeName();
                            if (javaSqlName != null) {
                                TableEditRowWizardPage.this.mJDBCType.setText(javaSqlName);
                                TableEditRowWizardPage.this.mJDBCType2.setText(javaSqlName);
                            }
                            break;
                        }
                        ++i;
                    }
                } else {
                    TableEditRowWizardPage.this.mJDBCType.setText("");
                    TableEditRowWizardPage.this.mJDBCType2.setText("");
                }
                if (TableEditRowWizardPage.this.mLength.getText().compareTo(TableEditRowWizardPage.this.mLength2.getText()) != 0) {
                    TableEditRowWizardPage.this.mLength2.setText(TableEditRowWizardPage.this.mLength.getText());
                    if (lengthIsValid) {
                        TableEditRowWizardPage.this.mPackageName2.setText("");
                        TableEditRowWizardPage.this.mSimpleType2.setText("");
                    }
                }
                TableEditRowWizardPage.this.mOldLength = TableEditRowWizardPage.this.mLength.getText();
            }
        });
        this.mLength.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e2) {
                super.focusLost(e2);
                TableEditRowWizardPage.this.checkLength();
                TableEditRowWizardPage.this.checkDbDefault(true, false);
            }
        });
    }

    private void createDecimalsListener() {
        this.mDecimals.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean decimalsAreValid = TableEditRowWizardPage.this.checkDecimals();
                if (TableEditRowWizardPage.this.mDecimals.getText().compareTo(TableEditRowWizardPage.this.mDecimals2.getText()) != 0) {
                    TableEditRowWizardPage.this.mDecimals2.setText(TableEditRowWizardPage.this.mDecimals.getText());
                    if (decimalsAreValid) {
                        TableEditRowWizardPage.this.mPackageName2.setText("");
                        TableEditRowWizardPage.this.mSimpleType2.setText("");
                    }
                }
            }
        });
        this.mDecimals.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e2) {
                super.focusLost(e2);
                TableEditRowWizardPage.this.checkDecimals();
                TableEditRowWizardPage.this.checkDbDefault(true, false);
            }
        });
    }

    private void createDescriptionListener() {
        this.mDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (TableEditRowWizardPage.this.mDescription.getText().compareTo(TableEditRowWizardPage.this.mDescription2.getText()) != 0) {
                    TableEditRowWizardPage.this.mDescription2.setText(TableEditRowWizardPage.this.mDescription.getText());
                    TableEditRowWizardPage.this.mPackageName2.setText("");
                    TableEditRowWizardPage.this.mSimpleType2.setText("");
                }
            }
        });
        this.mDescription.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TableEditRowWizardPage.this.mDbDefault.setFocus();
                    e.doit = false;
                }
            }
        });
        this.mDescription2.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TableEditRowWizardPage.this.mDbDefault2.setFocus();
                    e.doit = false;
                }
            }
        });
    }

    private void createReferenceFieldListener() {
        if (this.mReferenceField == null) {
            return;
        }
        this.mReferenceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableEditRowWizardPage.this.mReferenceField.getText().compareTo(TableEditRowWizardPage.this.mReferenceField2.getText()) != 0) {
                    TableEditRowWizardPage.this.mReferenceField2.setText(TableEditRowWizardPage.this.mReferenceField.getText());
                }
                TableEditRowWizardPage.this.updateStatus(null, null, 7);
            }
        });
    }

    private void createReferenceField2Listener() {
        if (this.mReferenceField == null) {
            return;
        }
        this.mReferenceField2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableEditRowWizardPage.this.mReferenceField.getText().compareTo(TableEditRowWizardPage.this.mReferenceField2.getText()) != 0) {
                    TableEditRowWizardPage.this.mReferenceField.setText(TableEditRowWizardPage.this.mReferenceField2.getText());
                }
                TableEditRowWizardPage.this.updateStatus(null, null, 7);
            }
        });
    }

    private void createDbDefaultListener() {
        this.mDbDefault.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableEditRowWizardPage.this.mDbDefault.getText().compareTo(TableEditRowWizardPage.this.mDbDefault2.getText()) != 0) {
                    TableEditRowWizardPage.this.mDbDefault2.setText(TableEditRowWizardPage.this.mDbDefault.getText());
                }
                TableEditRowWizardPage.this.checkDbDefault(false, true);
            }
        });
        this.mDbDefault.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                TableEditRowWizardPage.this.checkDbDefault(false, true);
            }
        });
        this.mDbDefault.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TableEditRowWizardPage.this.mKey.setFocus();
                    e.doit = false;
                }
            }
        });
    }

    private void createKeyListener() {
        this.mKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                super.widgetSelected(arg0);
                if (TableEditRowWizardPage.this.mKey.getSelection() != TableEditRowWizardPage.this.mKey2.getSelection()) {
                    TableEditRowWizardPage.this.mKey2.setSelection(TableEditRowWizardPage.this.mKey.getSelection());
                }
                TableEditRowWizardPage.this.checkNotNull();
                if (TableEditRowWizardPage.this.mNotNull.getSelection() && TableEditRowWizardPage.this.mKey.getSelection()) {
                    TableEditRowWizardPage.this.checkDbDefault(true, false);
                }
            }
        });
        this.mKey.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    TableEditRowWizardPage.this.mNotNull.setFocus();
                    e.doit = false;
                } else if (e.detail == 8) {
                    TableEditRowWizardPage.this.mDbDefault.setFocus();
                    e.doit = false;
                }
            }
        });
        this.mKey2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                super.widgetSelected(arg0);
                if (TableEditRowWizardPage.this.mKey.getSelection() != TableEditRowWizardPage.this.mKey2.getSelection()) {
                    TableEditRowWizardPage.this.mKey.setSelection(TableEditRowWizardPage.this.mKey2.getSelection());
                }
                TableEditRowWizardPage.this.checkNotNull();
            }
        });
        this.mKey2.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    TableEditRowWizardPage.this.mNotNull2.setFocus();
                    e.doit = false;
                }
            }
        });
    }

    private void createNotNullListener() {
        this.mNotNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                super.widgetSelected(arg0);
                if (TableEditRowWizardPage.this.mNotNull.getSelection() != TableEditRowWizardPage.this.mNotNull2.getSelection()) {
                    TableEditRowWizardPage.this.mNotNull2.setSelection(TableEditRowWizardPage.this.mNotNull.getSelection());
                    TableEditRowWizardPage.this.mPackageName2.setText("");
                    TableEditRowWizardPage.this.mSimpleType2.setText("");
                }
                TableEditRowWizardPage.this.mDbDefault.setEditable(TableEditRowWizardPage.this.isDbDefaultEditable());
                TableEditRowWizardPage.this.checkDbDefault(true, false);
            }
        });
        this.mNotNull.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    TableEditRowWizardPage.this.mKey.setFocus();
                    e.doit = false;
                }
            }
        });
    }

    private void createSimpleTypeListener() {
        this.mPackageName2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableEditRowWizardPage.this.simpleTypeChanged();
            }
        });
        this.mSimpleType2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TableEditRowWizardPage.this.mPackageName2.setEditable(true);
            }

            public void focusLost(FocusEvent e) {
                TableEditRowWizardPage.this.simpleTypeChanged();
            }
        });
        this.mSimpleType2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableEditRowWizardPage.this.simpleTypeChanged();
            }
        });
        this.mBrowse2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableEditRowWizardPage.this.searchSimpleType();
            }
        });
    }

    private void updateStatus(String message, String messageType, int index) {
        String error = null;
        String warning = null;
        this.mMessages[index][0] = message;
        this.mMessages[index][1] = messageType;
        if (TableUtil.stringIsEmpty(message)) {
            int i = 0;
            while (i < this.mMessages.length) {
                if (i != index && !TableUtil.stringIsEmpty(this.mMessages[i][0])) {
                    if (this.mMessages[i][1].equalsIgnoreCase(ERROR)) {
                        error = this.mMessages[i][0];
                        break;
                    }
                    if (this.mMessages[i][1].equalsIgnoreCase(WARNING)) {
                        warning = this.mMessages[i][0];
                    }
                }
                ++i;
            }
            if (!TableUtil.stringIsEmpty(error)) {
                message = error;
            } else if (!TableUtil.stringIsEmpty(warning)) {
                message = warning;
            }
        }
        if (messageType == ERROR || !TableUtil.stringIsEmpty(error)) {
            this.setMessage(null);
            this.setErrorMessage(message);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setMessage(message);
            this.setPageComplete(true);
        }
    }
}

