/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.tools.exception.NestableException;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.TableEditorPreferencePage;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableSection;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsContextMenuProvider;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtIndexField;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.ui.glpc.section.IMenuProvider;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TableFieldsTableSection
extends AbstractTableFieldsTableSection {
    private TableFieldsSectionForm mTableFieldsSectionForm = null;
    private TableFieldsTableModel mTableFieldsTableModel = null;
    private DtDbTable mDtDbTable = null;

    public TableFieldsTableSection(TableFieldsTableModel tableModel, IWidgetFactory widgetFactory, String title, String description, TableFieldsSectionForm form, String tableName, DtDbTable dtDbTable, DtDictionaryRoot dtDictionaryRoot, boolean[] buttonsEnabled) {
        super(tableModel, widgetFactory, title, description, form, tableName, (DtStructure)dtDbTable, dtDictionaryRoot, buttonsEnabled);
        this.mTableFieldsSectionForm = form;
        this.mTableName = tableName;
        this.mTableFieldsTableModel = tableModel;
        this.mDtDbTable = dtDbTable;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.addTableFieldsTableSection(this);
        try {
            this.initTableModel();
        }
        catch (LoadException e1) {
            TableMessageHandler.sendErrorMessage("Metadata API", "Error initTableModel: " + e1.getMessage() + "/ " + ((Object)((Object)e1)).getClass().toString());
            throw new NestableException((Throwable)e1);
        }
        catch (Exception e2) {
            TableMessageHandler.sendErrorMessage("Metadata API", "Error in loading table: " + e2.getMessage() + "/ " + e2.getClass().toString());
            throw new NestableException((Throwable)e2);
        }
        if (!this.mTableFieldsSectionForm.getEditor().isReadOnly()) {
            this.addMenuProvider(new TableFieldsContextMenuProvider(this){

                public void addItems(Menu menu) {
                    super.addItems(menu);
                    TableFieldsTableSection.this.addContextMenuForNavigation(menu);
                }
            });
        } else {
            this.addMenuProvider(new IMenuProvider(){

                public void addItems(Menu menu) {
                    TableFieldsTableSection.this.addContextMenuForNavigation(menu);
                }
            });
        }
        this.mTableFieldsTableModel.addTableModelListener(new AbstractTableFieldsTableSection.FieldsTableModelListener());
        this.addButtonClickedListener(new AbstractTableFieldsTableSection.ButtonClickedListener());
        IPreferenceStore store = TableEditorPlugin.getDefault().getPreferenceStore();
        int[] widths = new int[]{10, 100, 30, 115, 100, 73, 45, 60, 50, 70, 230};
        if (!store.getBoolean(TableEditorPreferencePage.key)) {
            widths[9] = 0;
        }
        this.setColumnWidths(widths);
    }

    protected TableFieldsTableModel getTableFieldsTableModel() {
        return this.mTableFieldsTableModel;
    }

    public void deleteColumns() {
        Object index = null;
        String newFieldName = null;
        int mSelectionCount = this.getTableViewer().getTable().getSelectionCount();
        if (mSelectionCount <= 0) {
            TableMessageHandler.sendInformationMessage("Delete Column", "Select a valid row");
            return;
        }
        int[] mSelectionIndices = this.getTableSelectionIndices();
        if (mSelectionIndices == null) {
            return;
        }
        int k = mSelectionIndices.length - 1;
        while (k >= 0) {
            newFieldName = (String)this.mTableFieldsTableModel.getValueAt(mSelectionIndices[k], 1);
            TableUtil.dbIndexDeletionCheck(newFieldName, this.mDtDbTable);
            this.mTableFieldsTableModel.removeRow(mSelectionIndices[k]);
            --k;
        }
        this.mTableFieldsSectionForm.mSelectionIndex = -1;
        this.mSelFieldname = "";
    }

    protected void renameIndexFields(String newFieldName) {
        DtDbIndex[] index = this.mDtDbTable.getDbIndexes();
        int i = 0;
        while (i < this.mDtDbTable.getDbIndexCount()) {
            DtIndexField[] field = index[i].getIndexFields();
            int j = 0;
            while (j < index[i].getIndexFieldCount()) {
                if (this.mSelFieldname != null && field[j].getName().compareTo(this.mSelFieldname) == 0 && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)MessagePool.getMessage((String)"Column & is in index &. Do you want to delete this column from the index and insert a new column?", (String)this.mSelFieldname, (String)index[i].getName()))) {
                    try {
                        int pos = field[j].getPosition();
                        TableUtil.checkDtrState(field[j].getIndex());
                        field[j].delete();
                        DtIndexField ifield = index[i].createIndexField(newFieldName);
                        ifield.setPosition(pos);
                    }
                    catch (DeleteException e2) {
                        TableMessageHandler.sendInformationMessage("Metadata API", MessagePool.getMessage((String)"Column & of index & could not be deleted", (String)this.mSelFieldname, (String)index[i].getName()));
                    }
                    catch (CreateException e3) {
                        TableMessageHandler.sendInformationMessage("Metadata API", MessagePool.getMessage((String)"Column & of index & could not be created", (String)newFieldName, (String)index[i].getName()));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public TableFieldsSectionForm getTableFieldsSectionForm() {
        return this.mTableFieldsSectionForm;
    }

    protected DtStructure getStructure() {
        return this.mDtDbTable;
    }
}

