/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fieldwizard.TableEditRowActionDelegate;
import com.sap.dictionary.tools.tableeditor.fieldwizard.TableRenameColumnActionDelegate;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;

public class TableFieldsTableModel
extends AbstractTableFieldsTableModel {
    private static Object[] columnNames = new Object[]{" ", "Column Name", "Key", "Simple Type Package", "Simple Type", "Built-In Type", "Length", "Decimals", "Not Null", "DB Default", "Description"};
    private DtDbTable mDtDbTable;

    public TableFieldsTableModel(TableFieldsSectionForm form, DtDictionaryRoot dtDictionaryRoot, boolean advancedPermissions, DtDbTable dtTable) {
        super(form, dtDictionaryRoot, advancedPermissions, (DtStructure)dtTable, columnNames);
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.advancedPermissions = advancedPermissions;
        this.mDtDbTable = dtTable;
    }

    protected void editRow(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage("Edit Column", "Select a valid row");
            return;
        }
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty(fieldName)) {
            TableMessageHandler.sendErrorMessage("Edit Column", MessagePool.getMessage((String)"Enter a column name", (String)Integer.toString(index)));
            return;
        }
        DatabaseEnum[] selectedDbs = this.getSelectedDbSystems();
        DtDbTypeInfo[] info = ((DtField)this.mDtDbTable.getStructureElement(fieldName)).getTypeInfos();
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        if (info.length > 0) {
            int i = 0;
            while (i < info.length) {
                DtTypeInfoForDatabase typeInfo = new DtTypeInfoForDatabase(info[i].getDatabase().toString(), info[i].getJdbcTypeName(), info[i].getDatabaseTypeName());
                list.add(typeInfo);
                ++i;
            }
        }
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        tableEditRowActionDelegate.run(this, 'E', index, this.mDtDictionaryRoot, this.advancedPermissions, selectedDbs, list, true, "Column name:", "Edit Column", "Change the column attributes", "NEW_COLUMN", this.mDtDbTable.isReadOnly());
    }

    protected void renameColumn(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage("Rename Column", "Select a valid row");
            return;
        }
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty(fieldName)) {
            TableMessageHandler.sendErrorMessage("Rename Column", MessagePool.getMessage((String)"Enter a column name", (String)Integer.toString(index)));
            return;
        }
        TableRenameColumnActionDelegate tableRenameColumnActionDelegate = new TableRenameColumnActionDelegate();
        tableRenameColumnActionDelegate.run(this, index, "Rename Column", "Enter the new column name", "Old column name:", "New column name:", true);
    }

    protected Object[] fillRow(DtStructureElement dtStructureElement) throws LoadException {
        DtField dtField = null;
        DtDataType dtDataType = null;
        DtSimpleType dtSimpleType = null;
        DtPrimaryKey dtPrimaryKey = null;
        Object[] attributes = new Object[11];
        Object[] row = new Object[11];
        if (!(dtStructureElement instanceof DtField)) {
            throw new LoadException("DtStructure: Only fields are supported");
        }
        System.arraycopy(AbstractTableFieldsTableModel.emptyRow, 0, row, 0, 11);
        dtField = (DtField)dtStructureElement;
        row[1] = dtField.getName();
        if (dtField.getBuiltInType() == null) {
            dtDataType = dtField.getReferencedType();
            if (dtDataType != null) {
                row[4] = dtDataType.getName();
            }
        } else {
            dtDataType = null;
        }
        if (dtDataType != null && !(dtDataType instanceof DtSimpleType)) {
            throw new LoadException("Referenced type is not a simple type");
        }
        if (dtDataType instanceof DtSimpleType && dtDataType != null) {
            dtSimpleType = (DtSimpleType)dtDataType;
            attributes = TableUtil.getSimpleTypeAttributes(dtSimpleType);
            row[3] = attributes[3];
            row[5] = attributes[5];
            row[6] = attributes[6];
            row[7] = attributes[7];
            row[10] = attributes[10];
            row[8] = attributes[8];
            row[9] = attributes[9];
        } else if (dtDataType == null) {
            attributes = TableUtil.getFieldAttributes(dtField);
            row[5] = attributes[5];
            row[6] = attributes[6];
            row[7] = attributes[7];
            row[10] = attributes[10];
            row[8] = attributes[8];
            row[9] = attributes[9];
        }
        dtPrimaryKey = this.mDtDbTable.getPrimaryKey();
        row[2] = dtPrimaryKey != null && dtPrimaryKey.hasKeyElement(dtStructureElement) ? new Boolean(true) : new Boolean(false);
        return row;
    }

    protected void insertRowViaWizard(int index) {
        int numOfRows = this.getRowCount();
        if (index < 0 || index >= numOfRows) {
            TableMessageHandler.sendErrorMessage("Insert", "Select a valid row");
            return;
        }
        String fieldName = (String)this.getValueAt(index, 1);
        if (TableUtil.stringIsEmpty(fieldName)) {
            TableMessageHandler.sendErrorMessage("Insert Column", MessagePool.getMessage((String)"Enter a column name", (String)Integer.toString(index)));
            return;
        }
        DatabaseEnum[] selectedDbs = this.getSelectedDbSystems();
        DtDbTypeInfo[] info = ((DtField)this.mDtDbTable.getStructureElement(fieldName)).getTypeInfos();
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        if (info.length > 0) {
            int i = 0;
            while (i < info.length) {
                DtTypeInfoForDatabase typeInfo = new DtTypeInfoForDatabase(info[i].getDatabase().toString(), info[i].getJdbcTypeName(), info[i].getDatabaseTypeName());
                list.add(typeInfo);
                ++i;
            }
        }
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        tableEditRowActionDelegate.run(this, 'I', index, this.mDtDictionaryRoot, this.advancedPermissions, selectedDbs, list, true, "Column name:", "Create a Column", "Enter the column attributes", "NEW_COLUMN", this.mDtDbTable.isReadOnly());
    }

    protected void addRowViaWizard() {
        TableEditRowActionDelegate tableEditRowActionDelegate = new TableEditRowActionDelegate();
        tableEditRowActionDelegate.run(this, 'A', -1, this.mDtDictionaryRoot, this.advancedPermissions, this.getSelectedDbSystems(), null, true, "Column name:", "Create a Column", "Enter the column attributes", "NEW_COLUMN", this.mDtDbTable.isReadOnly());
    }

    protected boolean setKeyElement(DtStructureElement dtStructureElement, boolean isKeyElement) {
        DtStructureElement[] dtStructureElements = null;
        TreeMap<Integer, DtStructureElement> tKeyElements = null;
        DtPrimaryKey dtPrimaryKey = this.mDtDbTable.getPrimaryKey();
        if (dtPrimaryKey == null && !isKeyElement) {
            return true;
        }
        int numOfKeyElements = dtPrimaryKey != null ? dtPrimaryKey.getKeyElementCount() : 0;
        if (numOfKeyElements > 0) {
            dtStructureElements = dtPrimaryKey.getKeyElements();
        }
        tKeyElements = new TreeMap<Integer, DtStructureElement>();
        int i = 0;
        while (i < numOfKeyElements) {
            tKeyElements.put(new Integer(dtStructureElements[i].getPosition()), dtStructureElements[i]);
            ++i;
        }
        if (isKeyElement) {
            tKeyElements.put(new Integer(dtStructureElement.getPosition()), dtStructureElement);
        } else {
            tKeyElements.remove(new Integer(dtStructureElement.getPosition()));
        }
        if (dtPrimaryKey != null) {
            dtPrimaryKey.removeAllKeyElements();
        }
        Collection keyElements = tKeyElements.values();
        if (dtPrimaryKey == null && keyElements.size() > 0) {
            try {
                this.mDtDbTable.createPrimaryKey();
                dtPrimaryKey = this.mDtDbTable.getPrimaryKey();
            }
            catch (CreateException e) {
                TableMessageHandler.sendErrorMessage("Metadata API", "Primary key could not be created");
                TableEditorPlugin.tracer.error("create primary key", (Throwable)e);
                return false;
            }
        }
        if (keyElements.size() > 0) {
            int position = 0;
            Iterator iter = keyElements.iterator();
            while (iter.hasNext()) {
                DtStructureElement element = (DtStructureElement)iter.next();
                dtPrimaryKey.addKeyElement(element, position);
                ++position;
            }
        } else if (dtPrimaryKey != null) {
            try {
                dtPrimaryKey.delete();
            }
            catch (DeleteException e) {
                TableMessageHandler.sendErrorMessage("Metadata API", "Primary key could not be deleted");
                TableEditorPlugin.tracer.error("delete primary key", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void removeKeyElement(DtStructureElement dtStructureElement) {
        DtPrimaryKey dtPrimaryKey = this.mDtDbTable.getPrimaryKey();
        if (dtPrimaryKey == null) {
            return;
        }
        if (dtPrimaryKey.hasKeyElement(dtStructureElement)) {
            dtPrimaryKey.removeKeyElement(dtStructureElement);
        }
    }

    protected void checkPrimaryKey() {
        DtPrimaryKey dtPrimaryKey = this.mDtDbTable.getPrimaryKey();
        if (dtPrimaryKey != null && dtPrimaryKey.getKeyElementCount() <= 0) {
            try {
                dtPrimaryKey.delete();
            }
            catch (DeleteException e) {
                TableMessageHandler.sendErrorMessage("Metadata API", "Primary key could not be deleted");
                TableEditorPlugin.tracer.error("delete primary key", (Throwable)e);
            }
        }
    }

    protected DatabaseEnum[] getSelectedDbSystems() {
        int i;
        DtNoCreateCondition[] cond = this.mDtDbTable.getNoCreationOnDatabases();
        Enumeration enumeration = DatabaseEnum.enumerate();
        ArrayList<DatabaseEnum> selectedDbSystem = new ArrayList<DatabaseEnum>();
        boolean no = false;
        while (enumeration.hasMoreElements()) {
            DatabaseEnum db = (DatabaseEnum)enumeration.nextElement();
            no = false;
            i = 0;
            while (i < cond.length) {
                DatabaseEnum noDbSystem = cond[i].getDatabase();
                if (noDbSystem.toString().compareTo(db.toString()) == 0) {
                    no = true;
                    break;
                }
                ++i;
            }
            if (no) continue;
            selectedDbSystem.add(db);
        }
        DatabaseEnum[] selectedDbs = new DatabaseEnum[selectedDbSystem.size()];
        i = 0;
        while (i < selectedDbSystem.size()) {
            selectedDbs[i] = (DatabaseEnum)selectedDbSystem.get(i);
            ++i;
        }
        return selectedDbs;
    }

    public DtStructure getStructure() {
        return this.mDtDbTable;
    }
}

