/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.tools.exception.NestableException;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableSection;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableSection;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.section.SimpleSection;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.lfsupport.DefaultWidgetFactory;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;

public class TableFieldsSectionForm
extends AbstractTableFieldsSectionForm {
    public Vector tableEditorDbDefaultInputFieldVector = new Vector();

    public TableFieldsSectionForm(IWidgetFactory widgetFactory, int columns, String title, TableEditor editor, String table, DtDbTable dtDbTable, DtDictionaryRoot dtDictionaryRoot) {
        super(widgetFactory, columns, title, editor, table, (DtStructure)dtDbTable, dtDictionaryRoot);
    }

    public TableFieldsSectionForm(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, TableEditor editor, String table, DtDbTable dtDbTable, DtDictionaryRoot dtDictionaryRoot) {
        super(widgetFactory, columns, equalColumns, title, editor, table, (DtStructure)dtDbTable, dtDictionaryRoot);
    }

    protected AbstractTableFieldsTableModel createFieldsTableModel() {
        return new TableFieldsTableModel(this, this.mDtDictionaryRoot, this.getEditor().superUser, (DtDbTable)this.mDtDbTable);
    }

    protected void createHeaderSection(IGridLayoutPane glp) {
        Object predefinedAction = null;
        this.mHeaderSection = new SimpleSection((IWidgetFactory)new DefaultWidgetFactory(), 4, false, "General Information", this.getHeaderSubtitle());
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.mHeaderSection, glp.createGridLayoutData(4, 1, 1, 1));
        this.mHeaderSection.getClientArea().addTextLabel(this.getHeaderLabelText() + ":");
        this.mTableName = this.mHeaderSection.getClientArea().addTextField(this.mTable, true, this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        this.mEditableIcon = this.mHeaderSection.getClientArea().addTextLabel("");
        this.mEditableInfo = this.mHeaderSection.getClientArea().addTextLabel("", this.mHeaderSection.getClientArea().createGridLayoutData(1, 1, true, false, 1, 1));
        this.setDeletedInfo();
        this.addPackageFieldToHeader();
        this.mHeaderSection.getClientArea().addTextLabel("Description:");
        this.mTableDescription = this.mHeaderSection.getClientArea().addTextField("", this.mEditor.isReadOnly(), this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        this.mHeaderSection.getClientArea().addTextLabel("");
        this.mHeaderSection.getClientArea().addTextLabel("");
        final Button checkbox = this.mHeaderSection.getClientArea().addCheckBox("Multi-client enabled");
        checkbox.setToolTipText("Multi-client-enabled tables can be accessed by multiple clients simultaneously without affecting \nthe data of the other clients. Each multi-client-enabled table has a column, the client column, that \nindicates to which client the corresponding records belong.");
        checkbox.setSelection(this.mDtDbTable.getMultiClientEnabled());
        if (this.mEditor.isReadOnly()) {
            checkbox.setEnabled(false);
        } else {
            checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    boolean selected = checkbox.getSelection();
                    TableFieldsSectionForm.this.mDtDbTable.setMultiClientEnabled(selected);
                }
            });
        }
        try {
            this.initHeaderSection();
        }
        catch (Exception e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"Error in loading metadata: &", (String)(e.getMessage() + "/ " + e.getClass().toString())));
            throw new NestableException((Throwable)e);
        }
        this.mTableDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String description = "";
                if (TableFieldsSectionForm.this.mEditor.isReadOnly()) {
                    return;
                }
                TableFieldsSectionForm.this.mEditor.setDataChanged();
                description = TableFieldsSectionForm.this.getTableDescription();
                if (TableUtil.stringIsEmpty(description)) {
                    TableFieldsSectionForm.this.mDtDbTable.setDescription(null);
                } else {
                    TableFieldsSectionForm.this.mDtDbTable.setDescription(description);
                }
                TableFieldsSectionForm.this.mTableDescription.setFocus();
            }
        });
    }

    protected AbstractTableFieldsTableSection createFieldsTableSection() {
        boolean[] buttonsEnabled = new boolean[11];
        int i = 0;
        while (i < buttonsEnabled.length) {
            buttonsEnabled[i] = !this.mEditor.isReadOnly();
            ++i;
        }
        return new TableFieldsTableSection((TableFieldsTableModel)this.mTableFieldsTableModel, (IWidgetFactory)new DefaultWidgetFactory(), "Columns", "Define the columns of the table", this, this.mTable, (DtDbTable)this.mDtDbTable, this.mDtDictionaryRoot, buttonsEnabled);
    }

    public AbstractTableFieldsTableModel getTableFieldsTableModel() {
        return this.mTableFieldsTableModel;
    }

    public AbstractTableFieldsTableSection getTableSection() {
        return this.mTableFieldsTableSection;
    }

    protected void setDeletedInfo() {
        String predefinedAction = null;
        if (this.mEditor.isReadOnly()) {
            this.mEditableIcon.setImage(SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_WARN_TSK"));
            predefinedAction = ((DtDbTable)this.mDtDbTable).getPredefinedAction();
            if (predefinedAction != null && predefinedAction.equals("DROP")) {
                this.mEditableInfo.setText("Table is deleted");
            } else {
                this.mEditableInfo.setText("Table is not editable");
            }
            this.mEditableInfo.setForeground(new Color((Device)this.mEditableInfo.getDisplay(), 255, 0, 0));
        }
    }

    protected String getHeaderSubtitle() {
        return "Describe the table";
    }

    protected String getHeaderLabelText() {
        return "Table";
    }
}

