/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class TableColumnTransfer
extends ByteArrayTransfer {
    private static final TableColumnTransfer instance = new TableColumnTransfer();
    private static final String TYPE_NAME = "tablecolumn-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = Transfer.registerType((String)TYPE_NAME);

    private TableColumnTransfer() {
    }

    public static TableColumnTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof Vector)) {
            return;
        }
        Vector rows = (Vector)data;
        int count = rows.size();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream dataOut = new ObjectOutputStream(out);
            dataOut.writeInt(count);
            int i = 0;
            while (i < count) {
                this.writeResource(dataOut, rows.get(i));
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException e) {
            TableEditorPlugin.tracer.error("TableColumnTransfer, javaToNative", (Throwable)e);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            int count = in.readInt();
            Vector[] results = new Vector[count];
            int i = 0;
            while (i < count) {
                results[i] = new Vector(this.readResource(in));
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            TableEditorPlugin.tracer.error("native to java", (Throwable)e);
            return null;
        }
    }

    private List readResource(ObjectInputStream dataIn) throws IOException, ClassCastException, ClassNotFoundException {
        List row = (List)dataIn.readObject();
        return row;
    }

    private void writeResource(ObjectOutputStream dataOut, Object obj) throws IOException {
        dataOut.writeObject(obj);
    }
}

