/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class MyDefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public MyDefaultTableModel() {
        this(0, 0);
    }

    private static Vector newVector(int size) {
        Vector v = new Vector(size);
        v.setSize(size);
        return v;
    }

    public MyDefaultTableModel(int rowCount, int columnCount) {
        this(MyDefaultTableModel.newVector(columnCount), rowCount);
    }

    public MyDefaultTableModel(Vector columnNames, int rowCount) {
        this.setDataVector(MyDefaultTableModel.newVector(rowCount), columnNames);
    }

    public MyDefaultTableModel(Object[] columnNames, int rowCount) {
        this(MyDefaultTableModel.convertToVector(columnNames), rowCount);
    }

    public MyDefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public MyDefaultTableModel(Object[][] data, Object[] columnNames) {
        this.setDataVector(data, columnNames);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    private static Vector nonNullVector(Vector v) {
        return v != null ? v : new Vector();
    }

    public void setDataVector(Vector dataVector, Vector columnIdentifiers) {
        this.dataVector = MyDefaultTableModel.nonNullVector(dataVector);
        this.columnIdentifiers = MyDefaultTableModel.nonNullVector(columnIdentifiers);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setDataVector(Object[][] dataVector, Object[] columnIdentifiers) {
        this.setDataVector(MyDefaultTableModel.convertToVector(dataVector), MyDefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    private void justifyRows(int from, int to) {
        this.dataVector.setSize(this.getRowCount());
        int i = from;
        while (i < to) {
            if (this.dataVector.elementAt(i) == null) {
                this.dataVector.setElementAt(new Vector(), i);
            }
            ((Vector)this.dataVector.elementAt(i)).setSize(this.getColumnCount());
            ++i;
        }
    }

    public void newRowsAdded(TableModelEvent e) {
        this.justifyRows(e.getFirstRow(), e.getLastRow() + 1);
        this.fireTableChanged(e);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setNumRows(int rowCount) {
        int old = this.getRowCount();
        if (old == rowCount) {
            return;
        }
        this.dataVector.setSize(rowCount);
        if (rowCount <= old) {
            this.fireTableRowsDeleted(rowCount, old - 1);
        } else {
            this.justifyRows(old, rowCount);
            this.fireTableRowsInserted(old, rowCount - 1);
        }
    }

    public void setRowCount(int rowCount) {
        this.setNumRows(rowCount);
    }

    public void addRow(Vector rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    public void addRow(Object[] rowData) {
        this.addRow(MyDefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.insertElementAt(rowData, row);
        this.justifyRows(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, MyDefaultTableModel.convertToVector(rowData));
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : MyDefaultTableModel.gcd(j, i % j);
    }

    private static void rotate(Vector v, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = MyDefaultTableModel.gcd(size, r);
        int i = 0;
        while (i < g) {
            int to = i;
            Object tmp = v.elementAt(a + to);
            int from = (to + r) % size;
            while (from != i) {
                v.setElementAt(v.elementAt(a + from), a + to);
                to = from;
                from = (to + r) % size;
            }
            v.setElementAt(tmp, a + to);
            ++i;
        }
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        MyDefaultTableModel.rotate(this.dataVector, first, last + 1, shift);
        this.fireTableRowsUpdated(first, last);
    }

    public void removeRow(int row) {
        this.dataVector.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.setDataVector(this.dataVector, columnIdentifiers);
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        this.setColumnIdentifiers(MyDefaultTableModel.convertToVector(newIdentifiers));
    }

    public void setColumnCount(int columnCount) {
        this.columnIdentifiers.setSize(columnCount);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (Vector)null);
    }

    public void addColumn(Object columnName, Vector columnData) {
        this.columnIdentifiers.addElement(columnName);
        if (columnData != null) {
            int columnSize = columnData.size();
            if (columnSize > this.getRowCount()) {
                this.dataVector.setSize(columnSize);
            }
            this.justifyRows(0, this.getRowCount());
            int newColumn = this.getColumnCount() - 1;
            int i = 0;
            while (i < columnSize) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.setElementAt(columnData.elementAt(i), newColumn);
                ++i;
            }
        } else {
            this.justifyRows(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName, Object[] columnData) {
        this.addColumn(columnName, MyDefaultTableModel.convertToVector(columnData));
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        Object id = null;
        if (column < this.columnIdentifiers.size()) {
            id = this.columnIdentifiers.elementAt(column);
        }
        return id == null ? super.getColumnName(column) : id.toString();
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        if (row > -1 && this.dataVector.size() > row) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            return rowVector.elementAt(column);
        }
        return null;
    }

    public void setValueAt(Object aValue, int row, int column) {
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        Object oldValue = rowVector.get(column);
        if (oldValue != null && !oldValue.equals(aValue) || oldValue == null && aValue != null) {
            rowVector.setElementAt(aValue, column);
            this.fireTableCellUpdated(row, column);
        }
    }

    public void setValueAtWithoutTableChangedEvent(Object aValue, int row, int column) {
        if (row >= this.dataVector.size()) {
            return;
        }
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        Object oldValue = rowVector.get(column);
        if (oldValue != null && !oldValue.equals(aValue) || oldValue == null && aValue != null) {
            rowVector.setElementAt(aValue, column);
        }
    }

    protected static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.addElement(anArray[i]);
            ++i;
        }
        return v;
    }

    protected static Vector convertToVector(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        int i = 0;
        while (i < anArray.length) {
            v.addElement(MyDefaultTableModel.convertToVector(anArray[i]));
            ++i;
        }
        return v;
    }
}

