/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.tools.tableeditor.CopyPasteColoumnsHelper;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableEditorTableSection;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditSimpleTypeInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.AdvancedTextInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.StructureTypeEnum;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.glpc.section.ButtonClickedEvent;
import com.tssap.util.ui.glpc.section.IButtonClickedListener;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTableFieldsTableSection
extends TableEditorTableSection {
    protected static String[] mButtons = new String[]{"Add Column", "Insert Column", "Edit Column", "Delete Column", "Up", "Down", "Copy", "Paste"};
    protected static final int BUTTON_ADD = 0;
    protected static final int BUTTON_INSERT = 1;
    protected static final int BUTTON_EDIT = 2;
    protected static final int BUTTON_DELETE = 3;
    protected static final int BUTTON_UP = 4;
    protected static final int BUTTON_DOWN = 5;
    protected static final int BUTTON_COPY = 6;
    protected static final int BUTTON_PASTE = 7;
    public AbstractTableFieldsSectionForm mTableFieldsSectionForm = null;
    public AbstractTableFieldsTableModel mTableFieldsTableModel = null;
    protected DtDictionaryRoot mDtDictionaryRoot;
    protected StructureTypeEnum mStructureType = null;
    protected String mTableName;
    protected Object[] mFieldsTableRow = new Object[11];
    public String mSelFieldname;
    protected int[] mSelectedColumns = null;
    protected static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsTableSection == null ? (class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsTableSection = AbstractTableFieldsTableSection.class$("com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableSection")) : class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsTableSection));
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsTableSection;

    public AbstractTableFieldsTableSection(AbstractTableFieldsTableModel tableModel, IWidgetFactory widgetFactory, String title, String description, AbstractTableFieldsSectionForm form, String tableName, DtStructure dtDbTable, DtDictionaryRoot dtDictionaryRoot, boolean[] buttonsEnabled) {
        super(tableModel, widgetFactory, title, description, new String[0], buttonsEnabled);
        this.mTableFieldsSectionForm = form;
        this.mTableName = tableName;
        this.mTableFieldsTableModel = tableModel;
        this.mDtDictionaryRoot = dtDictionaryRoot;
    }

    protected void initTableModel() throws LoadException {
        int numOfElements = 0;
        DtStructureElement[] dtStructureElements = null;
        TreeMap<Integer, DtStructureElement> structureElements = null;
        if (this.getStructure() == null || this.mTableFieldsSectionForm.getEditor().isDeleted()) {
            return;
        }
        try {
            this.mStructureType = this.getStructure().getStructureType();
        }
        catch (Exception e) {
            this.mStructureType = null;
        }
        numOfElements = this.getStructure().getStructureElementCount();
        if (numOfElements <= 0) {
            return;
        }
        dtStructureElements = this.getStructure().getStructureElements();
        structureElements = new TreeMap<Integer, DtStructureElement>();
        int i = 0;
        while (i < numOfElements) {
            structureElements.put(new Integer(dtStructureElements[i].getPosition()), dtStructureElements[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < numOfElements) {
            this.mFieldsTableRow = this.mTableFieldsTableModel.fillRow((DtStructureElement)structureElements.get(new Integer(i2)));
            this.mTableFieldsTableModel.appendRow(this.mFieldsTableRow);
            ++i2;
        }
    }

    protected void postInitSection(IGridLayoutPane glp) {
        super.postInitSection(glp);
        int i = 0;
        while (i < this.getTableViewer().getTable().getItemCount()) {
            this.addAdvancedInputFieldForDbDefault(i, 2);
            ++i;
        }
    }

    protected void setColumnTypes() {
        this.setColumnType('N', 6, null);
        this.setColumnType('N', 7, null);
        this.setColumnType('B', 2, null);
        this.setColumnType('B', 8, null);
    }

    protected void setColumnType(char colType, int colNum, String[] comboItems) {
        if (colType == 'B') {
            this.getTableViewer().setBooleanColumnHandler(colNum);
        } else if (colType == 'N') {
            this.getTableViewer().setNumerikColumnHandler(colNum);
        }
    }

    protected int getTableSelectionIndex() {
        try {
            return this.getTableViewer().getTable().getSelectionIndex();
        }
        catch (Exception e) {
            tracer.error("gettableselectionindex", (Throwable)e);
            return -1;
        }
    }

    protected int[] getTableSelectionIndices() {
        try {
            if (this.getTableViewer().getTable().isFocusControl()) {
                return this.getTableViewer().getTable().getSelectionIndices();
            }
            return null;
        }
        catch (Exception e) {
            tracer.error("gettableselectionindices", (Throwable)e);
            return null;
        }
    }

    protected boolean save(boolean sendMessages) {
        return true;
    }

    protected boolean setBuiltInType(DtField dtField, String fieldName, String builtInType, int length, int decimals, BooleanEnum notNull, String description, boolean sendMessages) {
        return true;
    }

    protected void setJdbcTypeInfo(DtField dtField, String builtInType, int length) throws CreateException {
    }

    protected boolean fieldNameIsValid(String fieldName, int index, boolean startRowWizard) {
        Vector messages = null;
        if (TableUtil.fieldNameIsValid(this.mTableFieldsTableModel, fieldName, index, true)) {
            return true;
        }
        messages = TableUtil.getFieldMessages();
        TableMessageHandler.sendErrorMessage("Error in Columns", (String)messages.get(0));
        return false;
    }

    protected void addAdvancedInputFieldForDbDefault(int index, int type) {
        if (type == -1) {
            TableEditor lEditor = (TableEditor)this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.elementAt(index);
            int i = this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.size() - 1;
            while (i >= index) {
                lEditor = (TableEditor)this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.elementAt(i);
                lEditor.getEditor().dispose();
                lEditor.dispose();
                this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.removeElementAt(i);
                --i;
            }
            int i2 = index;
            while (i2 < this.getTableViewer().getTable().getItemCount()) {
                this.addAdvancedInputFieldForDbDefault(i2, 2);
                ++i2;
            }
            return;
        }
        if (type == 2) {
            Color blue = Display.getDefault().getSystemColor(10);
            Color white = Display.getDefault().getSystemColor(25);
            final Table table = this.getTableViewer().getTable();
            TableItem lTableItem = table.getItem(index);
            TableEditor editor = new TableEditor(table);
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            final AdvancedTextInput input = new AdvancedTextInput((Composite)table, 4);
            final int ind = index;
            input.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    if (e.character == '\r') {
                        AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(input.getText(), ind, 9);
                    }
                }
            });
            input.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    table.setSelection(ind);
                    if (AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.mEditor.isReadOnly()) {
                        input.setEditable(false);
                        return;
                    }
                    String simpleType = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(ind, 4);
                    String builtintype = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(ind, 5);
                    int length = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getIntegerValue(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(ind, 6));
                    int decimals = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getIntegerValue(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(ind, 7));
                    String template = TableUtil.getDbDefaultTemplate(builtintype, length, decimals);
                    input.setToolTipText(template);
                    if (!TableUtil.stringIsEmpty(simpleType)) {
                        input.setEditable(false);
                        return;
                    }
                    input.setEditable(true);
                }

                public void focusLost(FocusEvent e) {
                    super.focusLost(e);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(input.getText(), ind, 9);
                }
            });
            input.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16) {
                        AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.editNextEditableCell(9, true);
                        e.doit = false;
                    } else if (e.detail == 8) {
                        AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.editNextEditableCell(9, false);
                        e.doit = false;
                    }
                }
            });
            input.setText(lTableItem.getText(9));
            editor.setEditor((Control)input, lTableItem, 9);
            this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.addElement(editor);
        } else if (type == 1) {
            int i = this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.size() - 1;
            while (i >= index) {
                TableEditor lEditor = (TableEditor)this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.elementAt(i);
                lEditor.getEditor().dispose();
                lEditor.dispose();
                this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.removeElementAt(i);
                --i;
            }
            int i3 = index;
            while (i3 < this.getTableViewer().getTable().getItemCount()) {
                this.addAdvancedInputFieldForDbDefault(i3, 2);
                ++i3;
            }
        }
    }

    protected String getFieldName(int index) {
        String fieldName = (String)this.mTableFieldsTableModel.getValueAt(index, 1);
        if (fieldName == null) {
            fieldName = "";
        }
        return fieldName;
    }

    public void copyColumns() {
        CopyPasteColoumnsHelper.copyColumns(this.mTableFieldsSectionForm.mEditor);
    }

    public void cutColumns() {
        CopyPasteColoumnsHelper.cutColumns(this.mTableFieldsSectionForm.mEditor);
    }

    public void pasteColumns() {
        CopyPasteColoumnsHelper.pasteColumns(this.mTableFieldsSectionForm.mEditor);
    }

    public abstract void deleteColumns();

    public void addColumn() {
        this.mSelFieldname = "";
        this.mTableFieldsTableModel.addRowViaWizard();
    }

    public void insertColumn() {
        int selectionCount = this.getTableViewer().getTable().getSelectionCount();
        if (selectionCount != 1) {
            TableMessageHandler.sendInformationMessage("Insert", "Select exactly one row");
            return;
        }
        this.mSelFieldname = "";
        int selectionIndex = this.getTableSelectionIndex();
        if (selectionIndex < 0) {
            TableMessageHandler.sendInformationMessage("Insert", "Select a valid row");
            return;
        }
        this.mTableFieldsTableModel.insertRowViaWizard(selectionIndex);
        if (this.mTableFieldsSectionForm.mSelectionIndex >= 0) {
            ++this.mTableFieldsSectionForm.mSelectionIndex;
        }
    }

    public void editColumn() {
        if (this.getTableViewer().getTable().getSelectionCount() != 1) {
            TableMessageHandler.sendInformationMessage("Edit", "Select exactly one row");
        } else {
            this.mTableFieldsTableModel.editRow(this.getTableSelectionIndex());
        }
    }

    public void renameColumn() {
        if (this.getTableViewer().getTable().getSelectionCount() != 1) {
            TableMessageHandler.sendInformationMessage("Rename", "Select exactly one row");
        } else {
            int index = this.getTableSelectionIndex();
            this.mTableFieldsTableModel.renameColumn(index);
            if (!TableUtil.stringIsEmpty(this.mSelFieldname)) {
                this.mSelFieldname = (String)this.mTableFieldsTableModel.getValueAt(index, 1);
            }
        }
    }

    public void checkFieldName(String fieldName, int index, TableItem tableItem) {
        Vector messages = null;
        String text = "";
        if (!TableUtil.fieldNameIsValid(this.mTableFieldsTableModel, fieldName, index, false)) {
            messages = TableUtil.getFieldMessages();
            TableUtil.setToolTipInfo(tableItem, messages, true);
        } else {
            TableUtil.resetToolTipInfo(tableItem);
        }
    }

    public void moveUp() {
        int selectionCount = this.getTableViewer().getTable().getSelectionCount();
        if (selectionCount > 1) {
            int[] selectionIndices = this.getTableSelectionIndices();
            if (selectionIndices[0] > 0) {
                int i = 0;
                while (i < selectionCount) {
                    this.mTableFieldsTableModel.moveRow(selectionIndices[i], selectionIndices[i], selectionIndices[i] - 1);
                    int n = i++;
                    selectionIndices[n] = selectionIndices[n] - 1;
                }
                this.getTableViewer().getTable().setSelection(selectionIndices);
            }
        } else {
            int selectionIndex = this.getTableSelectionIndex();
            if (selectionIndex > 0) {
                this.mTableFieldsTableModel.moveRow(selectionIndex, selectionIndex, selectionIndex - 1);
                this.getTableViewer().getTable().setSelection(selectionIndex - 1);
            }
        }
    }

    public void moveDown() {
        int selectionCount = this.getTableViewer().getTable().getSelectionCount();
        if (selectionCount > 1) {
            int[] selectionIndices = this.getTableViewer().getTable().getSelectionIndices();
            if (selectionIndices[selectionCount - 1] < this.mTableFieldsTableModel.getRowCount() - 1) {
                int i = selectionCount - 1;
                while (i >= 0) {
                    this.mTableFieldsTableModel.moveRow(selectionIndices[i], selectionIndices[i], selectionIndices[i] + 1);
                    int n = i--;
                    selectionIndices[n] = selectionIndices[n] + 1;
                }
                this.getTableViewer().getTable().setSelection(selectionIndices);
            }
        } else {
            int selectionIndex = this.getTableSelectionIndex();
            if (selectionIndex >= 0 && selectionIndex < this.mTableFieldsTableModel.getRowCount() - 1) {
                this.mTableFieldsTableModel.moveRow(selectionIndex, selectionIndex, selectionIndex + 1);
                this.getTableViewer().getTable().setSelection(selectionIndex + 1);
            }
        }
    }

    protected abstract void renameIndexFields(String var1);

    protected abstract DtStructure getStructure();

    protected void addContextMenuForNavigation(Menu menu) {
        int row = this.mTableFieldsSectionForm.getTableSection().getSelectionIndex();
        final String pack = (String)this.mTableFieldsTableModel.getValueAt(row, 3);
        final String simpleType = (String)this.mTableFieldsTableModel.getValueAt(row, 4);
        if (pack == null || simpleType == null) {
            return;
        }
        if (pack.length() == 0 && simpleType.length() == 0) {
            return;
        }
        MenuItem item = new MenuItem(menu, 0);
        item.setText("Open SimpleType Editor");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IWorkbenchWindow dwindow;
                    IWorkbenchPage page;
                    int row = AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.getTableSection().getSelectionIndex();
                    String ret = DictionaryObjectChecker.checkPackageName((String)pack);
                    if (ret != null) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)ret);
                        return;
                    }
                    DtSimpleType st = AbstractTableFieldsTableSection.this.mDtDictionaryRoot.getSimpleType(pack, simpleType);
                    if (st != null && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
                        DtSimpleType openedSimpleType = null;
                        IEditorPart simpleTypeEditor = null;
                        boolean alreadyOpened = false;
                        IEditorReference[] editorReferences = page.getEditorReferences();
                        int i = 0;
                        while (i < editorReferences.length) {
                            IEditorPart editor = editorReferences[i].getEditor(false);
                            IEditorInput editorInput = editor.getEditorInput();
                            if (editorInput instanceof EditSimpleTypeInput && st == (openedSimpleType = ((EditSimpleTypeInput)editorInput).dictSimpleType)) {
                                alreadyOpened = true;
                                simpleTypeEditor = editor;
                            }
                            ++i;
                        }
                        if (alreadyOpened) {
                            page.bringToTop(simpleTypeEditor);
                            simpleTypeEditor.setFocus();
                        } else {
                            try {
                                page.openEditor((IEditorInput)new EditSimpleTypeInput(AbstractTableFieldsTableSection.this.mDtDictionaryRoot.getMetamodel(), AbstractTableFieldsTableSection.this.mDtDictionaryRoot, st), "com.sap.dictionary.tools.simpletype.SimpletypeEditor", true);
                            }
                            catch (PartInitException e2) {}
                        }
                    }
                }
                catch (LoadException e2) {
                    TableEditorPlugin.tracer.error("open st editor", (Throwable)e2);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ButtonClickedListener
    implements IButtonClickedListener {
        public void buttonClicked(ButtonClickedEvent e) {
            switch (e.getIndex()) {
                case 0: {
                    AbstractTableFieldsTableSection.this.addColumn();
                    break;
                }
                case 1: {
                    AbstractTableFieldsTableSection.this.insertColumn();
                    break;
                }
                case 3: {
                    AbstractTableFieldsTableSection.this.deleteColumns();
                    break;
                }
                case 2: {
                    AbstractTableFieldsTableSection.this.editColumn();
                    break;
                }
                case 6: {
                    AbstractTableFieldsTableSection.this.copyColumns();
                    break;
                }
                case 7: {
                    AbstractTableFieldsTableSection.this.pasteColumns();
                    break;
                }
                case 4: {
                    AbstractTableFieldsTableSection.this.moveUp();
                    break;
                }
                case 5: {
                    AbstractTableFieldsTableSection.this.moveDown();
                }
            }
            AbstractTableFieldsTableSection.this.getTableViewer().getTableViewer().getTable().setFocus();
            AbstractTableFieldsTableSection.this.getTableViewer().getTableViewer().getTable().setEnabled(true);
        }
    }

    public class FieldsTableModelListener
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            int eventType = e.getType();
            int column = e.getColumn();
            if (e.getLastRow() - e.getFirstRow() > 100000) {
                return;
            }
            int i = e.getFirstRow();
            while (i <= e.getLastRow()) {
                if (AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.getEditor().outlinePage != null) {
                    AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.getEditor().outlinePage.updateColumns(i, column, eventType);
                }
                ++i;
            }
            this.updateDbDefaultInputFieldsInTableView(e);
            int index = AbstractTableFieldsTableSection.this.getTableViewer().getTable().getSelectionIndex();
            if (index < 0) {
                return;
            }
            AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.getEditor().setDataChanged();
            if (eventType != 0) {
                return;
            }
            TableItem tableItem = AbstractTableFieldsTableSection.this.getTableViewer().getTable().getItem(index);
            TableUtil.resetToolTipInfo(tableItem);
            DtStructureElement dtStructureElement = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getStructureElement(index);
            if (column == 1) {
                this.fieldNameChanged(index, dtStructureElement, tableItem);
            } else if (column == 3 || column == 4 || column == 5 || column == 8) {
                this.simpleOrBuiltinTypeChanged(index, (DtField)dtStructureElement, column, tableItem);
            } else if (column == 6) {
                this.lengthChanged(index, (DtField)dtStructureElement, tableItem);
            } else if (column == 7) {
                this.decimalsChanged(index, (DtField)dtStructureElement);
            } else if (column == 10) {
                this.descriptionChanged(index, (DtField)dtStructureElement);
            } else if (column == 2) {
                this.keyChanged(index, (DtField)dtStructureElement);
            } else if (column == 9) {
                this.dbDefaultChanged(index, (DtField)dtStructureElement);
            }
        }

        protected void updateDbDefaultInputFieldsInTableView(TableModelEvent e) {
            if (e.getType() == 1) {
                AbstractTableFieldsTableSection.this.addAdvancedInputFieldForDbDefault(e.getFirstRow(), e.getType());
            } else if (e.getType() == 0) {
                if (e.getColumn() == 9) {
                    TableEditor editor = (TableEditor)AbstractTableFieldsTableSection.this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector.elementAt(e.getFirstRow());
                    AdvancedTextInput input = (AdvancedTextInput)editor.getEditor();
                    String dbDefault = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(e.getFirstRow(), 9);
                    if (dbDefault != null) {
                        input.setText(dbDefault);
                    }
                }
            } else if (e.getType() == -1) {
                AbstractTableFieldsTableSection.this.addAdvancedInputFieldForDbDefault(e.getFirstRow(), e.getType());
            }
        }

        protected void fieldNameChanged(int indx, DtStructureElement dtStructureElement, TableItem tableItem) {
            String newFieldName = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 1);
            boolean doit = false;
            int i = 0;
            while (i < newFieldName.length()) {
                if (Character.isLowerCase(newFieldName.charAt(i))) {
                    doit = true;
                    break;
                }
                ++i;
            }
            if (doit) {
                newFieldName = newFieldName.toUpperCase();
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(newFieldName, indx, 1);
                return;
            }
            if (AbstractTableFieldsTableSection.this.mSelFieldname != null && newFieldName.compareTo(AbstractTableFieldsTableSection.this.mSelFieldname) == 0) {
                return;
            }
            AbstractTableFieldsTableSection.this.checkFieldName(newFieldName, indx, tableItem);
            AbstractTableFieldsTableSection.this.renameIndexFields(newFieldName);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.changeFieldName(indx, dtStructureElement, newFieldName);
        }

        protected void simpleOrBuiltinTypeChanged(int indx, DtField dtField, int column, TableItem tableItem) {
            DtSimpleType dtSimpleType = null;
            String simpleType = null;
            String packageName = null;
            String builtInType = null;
            Object text = null;
            Object oldBuiltInType = null;
            Vector messages = null;
            Object[] simpleTypeAttributes = new Object[11];
            simpleType = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 4);
            packageName = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 3);
            builtInType = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getBuiltInType(indx);
            if (!TableUtil.stringIsEmpty(simpleType)) {
                try {
                    dtSimpleType = AbstractTableFieldsTableSection.this.mDtDictionaryRoot.getSimpleType(packageName, simpleType);
                }
                catch (LoadException e) {
                    dtSimpleType = null;
                }
            }
            if (!(column != 4 && column != 3 || TableUtil.stringIsEmpty(simpleType))) {
                if (dtSimpleType != null) {
                    simpleTypeAttributes = TableUtil.getSimpleTypeAttributes(dtSimpleType);
                    if (AbstractTableFieldsTableSection.this.mTableFieldsTableModel instanceof TableFieldsTableModel && ((String)simpleTypeAttributes[5]).equals("boolean")) {
                        TableMessageHandler.sendInformationMessage("Simple Type", MessagePool.getMessage((String)"Built-in type & of simple type & is not allowed for tables", (String)dtSimpleType.getBuiltInType(), (String)dtSimpleType.getName()));
                        AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt("", indx, 4);
                        AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt("", indx, 3);
                        return;
                    }
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[5], indx, 5);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[6], indx, 6);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[7], indx, 7);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[10], indx, 10);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[8], indx, 8);
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[9], indx, 9);
                } else {
                    messages = TableUtil.checkSimpleType(packageName, simpleType, AbstractTableFieldsTableSection.this.mDtDictionaryRoot);
                    if (messages != null) {
                        TableUtil.setToolTipInfo(tableItem, messages, true);
                    }
                }
            } else if (column == 5 && !TableUtil.stringIsEmpty(builtInType)) {
                if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(null, indx, 6);
                }
                if (!TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(null, indx, 7);
                }
                this.checkJdbcTypeRestrictions(builtInType, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getLength(indx), tableItem);
            }
            if (AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getKeyElement(indx) && TableUtil.stringIsEmpty(simpleType) && !TableUtil.stringIsEmpty(builtInType)) {
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(new Boolean(true), indx, 8);
            }
            if (dtSimpleType == null) {
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.checkDbDefault(indx, true);
                if (builtInType.equals("boolean")) {
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(new Boolean(false), indx, 8);
                }
            }
            if (dtField == null) {
                return;
            }
            if (dtSimpleType != null) {
                DtSimpleType dtSimpleTypeOld;
                DtDataType dtDataType = dtField.getReferencedType();
                if (dtDataType instanceof DtSimpleType && dtSimpleType.equals(dtSimpleTypeOld = (DtSimpleType)dtDataType)) {
                    return;
                }
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setReferenceToSimpleType(dtField, packageName, simpleType);
            } else {
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setFieldAttributes(dtField, dtField.getName(), builtInType, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getLength(indx), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDecimals(indx), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getNotNull(indx), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getKeyElement(indx), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDescription(indx), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDbDefault(indx), indx);
            }
            AbstractTableFieldsTableSection.this.getStructure().setStructureType(StructureTypeEnum.FLAT);
        }

        protected void checkJdbcTypeRestrictions(String builtInType, int length, TableItem tableItem) {
            String jdbcType = null;
            String message = null;
            jdbcType = TableUtil.getJdbcType(builtInType, length, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDatabases());
            if (TableUtil.stringIsEmpty(jdbcType)) {
                return;
            }
            message = DdMapping.getTypeUsingDescription((String)jdbcType);
            if (!TableUtil.stringIsEmpty(message)) {
                Vector<String> messages = new Vector<String>();
                messages.addElement(message);
                TableUtil.setToolTipInfo(tableItem, messages, false);
            }
        }

        protected void descriptionChanged(int index, DtField dtField) {
            if (this.columnHasSimpleType(index)) {
                return;
            }
            if (dtField == null) {
                return;
            }
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setDescription(dtField, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDescription(index));
        }

        protected void lengthChanged(int index, DtField dtField, TableItem tableItem) {
            if (this.columnHasSimpleType(index)) {
                return;
            }
            if (dtField == null) {
                return;
            }
            String builtInType = TableUtil.getNotNullString(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(index, 5));
            int length = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getLength(index);
            if (TableUtil.stringIsEmpty(builtInType)) {
                return;
            }
            if (TableUtil.checkValidConstraint(builtInType, "length")) {
                dtField.setLength(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getLength(index));
            } else {
                dtField.setTotalDigits(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getLength(index));
            }
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setJdbcTypeInfo(dtField, builtInType, length);
            this.checkJdbcTypeRestrictions(builtInType, length, tableItem);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.checkDbDefault(index, true);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setDbDefault(dtField, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDbDefault(index), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getNotNull(index), index);
        }

        protected void decimalsChanged(int index, DtField dtField) {
            String builtInType = null;
            if (this.columnHasSimpleType(index)) {
                return;
            }
            if (dtField == null) {
                return;
            }
            builtInType = TableUtil.getNotNullString(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(index, 5));
            if (TableUtil.stringIsEmpty(builtInType)) {
                return;
            }
            dtField.setFractionDigits(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDecimals(index));
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.checkDbDefault(index, true);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setDbDefault(dtField, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDbDefault(index), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getNotNull(index), index);
        }

        protected void dbDefaultChanged(int index, DtField dtField) {
            if (this.columnHasSimpleType(index)) {
                return;
            }
            if (dtField == null) {
                return;
            }
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.checkDbDefault(index, false);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setDbDefault(dtField, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDbDefault(index), AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getNotNull(index), index);
        }

        protected void notNullChanged(int index, DtField dtField) {
            boolean isNotNull = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getNotNull(index);
            String dbDefault = AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getDbDefault(index);
            if (!isNotNull) {
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(null, index, 9);
            }
            if (dtField == null) {
                return;
            }
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setNotNull(dtField, isNotNull);
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setDbDefault(dtField, dbDefault, isNotNull, index);
        }

        protected void keyChanged(int index, DtField dtField) {
            if (dtField == null) {
                return;
            }
            AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setKeyElement((DtStructureElement)dtField, AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getKeyElement(index));
            if (AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getKeyElement(index) && TableUtil.stringIsEmpty(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getSimpleType(index)) && !TableUtil.stringIsEmpty(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getBuiltInType(index))) {
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(new Boolean(true), index, 8);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setNotNull(dtField, true);
            }
        }

        protected boolean columnHasSimpleType(int index) {
            return !TableUtil.stringIsEmpty(TableUtil.getNotNullString(AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(index, 4)));
        }

        protected void nonFieldNameChanged(int indx, int column, TableItem tableItem) {
            DtSimpleType dtSimpleType = null;
            String simpleType = null;
            String packageName = null;
            String builtInType = null;
            Object text = null;
            Vector messages = null;
            Object[] simpleTypeAttributes = new Object[11];
            simpleType = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 4);
            packageName = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 3);
            builtInType = (String)AbstractTableFieldsTableSection.this.mTableFieldsTableModel.getValueAt(indx, 5);
            if (!(column != 4 && column != 3 || TableUtil.stringIsEmpty(simpleType))) {
                try {
                    dtSimpleType = AbstractTableFieldsTableSection.this.mDtDictionaryRoot.getSimpleType(packageName, simpleType);
                    if (dtSimpleType == null) {
                        throw new NullPointerException();
                    }
                }
                catch (Exception ex) {
                    messages = TableUtil.checkSimpleType(packageName, simpleType, AbstractTableFieldsTableSection.this.mDtDictionaryRoot);
                    if (messages != null) {
                        TableUtil.setToolTipInfo(tableItem, messages, true);
                    }
                    return;
                }
                simpleTypeAttributes = TableUtil.getSimpleTypeAttributes(dtSimpleType);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[5], indx, 5);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[6], indx, 6);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[7], indx, 7);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[10], indx, 10);
                AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(simpleTypeAttributes[8], indx, 8);
            } else if (column == 5 && !TableUtil.stringIsEmpty(builtInType)) {
                if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(null, indx, 6);
                }
                if (!TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                    AbstractTableFieldsTableSection.this.mTableFieldsTableModel.setValueAt(null, indx, 7);
                }
            }
        }
    }
}

