/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.designtime.DdMapping;
import com.sap.dictionary.designtime.DtTypeInfo;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.MyDefaultTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditSimpleTypeInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTypeInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtImportFromOtherStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtInclusiveField;
import com.sap.ide.metamodel.dictionary.datatype.DtJoin;
import com.sap.ide.metamodel.dictionary.datatype.DtJoinCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtSelectionRestriction;
import com.sap.ide.metamodel.dictionary.datatype.DtSelectionRestrictionCondition;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.FieldTypeEnum;
import com.sap.ide.metamodel.dictionary.datatype.StructureTypeEnum;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTableFieldsTableModel
extends MyDefaultTableModel {
    protected AbstractTableFieldsSectionForm mTableFieldsSectionForm;
    protected DtDictionaryRoot mDtDictionaryRoot;
    protected MessageDialog mMessageDialog;
    protected boolean advancedPermissions;
    protected static Object[] emptyRow = new Object[]{"", "", new Boolean(false), "", "", "", null, null, new Boolean(true), "", ""};
    protected static Object[] initialRow = new Object[]{"", "NEW_COLUMN", new Boolean(false), "", "", "", null, null, new Boolean(true), "", ""};
    protected static final int NUM_EMPTY_ROWS = 10;
    protected HashMap mJdbcTypeInfosMap = new HashMap();
    protected boolean myFlag = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractTableFieldsTableModel(AbstractTableFieldsSectionForm form, DtDictionaryRoot dtDictionaryRoot, boolean advancedPermissions, DtStructure dtTable, Object[] columnNames) {
        super(columnNames, 0);
        this.mTableFieldsSectionForm = form;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.advancedPermissions = advancedPermissions;
    }

    public boolean isCellEditable(int row, int column) {
        Object string = null;
        String simpleType = null;
        String builtInType = null;
        Object dtStructureElement = null;
        boolean isCellEditable = true;
        if (this.mTableFieldsSectionForm.getEditor().isReadOnly()) {
            return false;
        }
        if (column == 0) {
            return false;
        }
        if (column == 1) {
            String time = Long.toString(System.currentTimeMillis());
            time = time.substring(0, time.length() - 4);
            return ((String)this.getValueAt(row, column)).equals(time);
        }
        simpleType = (String)this.getValueAt(row, 4);
        builtInType = (String)this.getValueAt(row, 5);
        if (!TableUtil.stringIsEmpty(simpleType)) {
            if (column == 5 || column == 6 || column == 7 || column == 8 || column == 10 || column == 9) {
                isCellEditable = false;
                if (!this.myFlag) {
                    this.myFlag = true;
                    if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Simple Type", (String)"Do you want to edit the selected simple type?")) {
                        try {
                            IWorkbenchWindow dwindow;
                            IWorkbenchPage page;
                            String pack = (String)this.getValueAt(row, 3);
                            String ret = DictionaryObjectChecker.checkPackageName((String)pack);
                            if (ret != null) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)ret);
                                return isCellEditable;
                            }
                            DtSimpleType st = this.mDtDictionaryRoot.getSimpleType(pack, simpleType);
                            if (st != null && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
                                DtSimpleType openedSimpleType = null;
                                IEditorPart simpleTypeEditor = null;
                                boolean alreadyOpened = false;
                                IEditorReference[] editorReferences = page.getEditorReferences();
                                int i = 0;
                                while (i < editorReferences.length) {
                                    IEditorPart editor = editorReferences[i].getEditor(false);
                                    IEditorInput editorInput = editor.getEditorInput();
                                    if (editorInput instanceof EditSimpleTypeInput && st == (openedSimpleType = ((EditSimpleTypeInput)editorInput).dictSimpleType)) {
                                        alreadyOpened = true;
                                        simpleTypeEditor = editor;
                                    }
                                    ++i;
                                }
                                if (alreadyOpened) {
                                    page.bringToTop(simpleTypeEditor);
                                    simpleTypeEditor.setFocus();
                                } else {
                                    try {
                                        page.openEditor((IEditorInput)new EditSimpleTypeInput(this.mDtDictionaryRoot.getMetamodel(), this.mDtDictionaryRoot, st), "com.sap.dictionary.tools.simpletype.SimpletypeEditor", true);
                                    }
                                    catch (PartInitException e2) {}
                                }
                            }
                        }
                        catch (Exception e) {
                            TableEditorPlugin.tracer.error("open st editor", (Throwable)e);
                        }
                    }
                }
                this.myFlag = false;
            }
        } else if (!TableUtil.stringIsEmpty(builtInType)) {
            if (column == 6) {
                if (!TableUtil.checkValidConstraint(builtInType, "length") && !TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                    isCellEditable = false;
                }
            } else if (column == 7) {
                if (!TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                    isCellEditable = false;
                }
            } else if (column == 8 && this.getKeyElement(row)) {
                isCellEditable = false;
            }
        }
        return isCellEditable;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 6 || columnIndex == 7) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractTableFieldsTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AbstractTableFieldsTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    protected void newRows() {
        int i = 0;
        while (i < 10) {
            this.addRow(emptyRow);
            ++i;
        }
    }

    protected void addInitialRow() {
        this.addRow(initialRow);
    }

    protected void insertInitialRow(int index) {
        this.insertRow(index, initialRow);
    }

    public void removeRowForMove(int index) {
        int numOfRows = this.getRowCount();
        DtStructureElement dtStructureElement = this.getStructureElement(index);
        String fieldName = dtStructureElement.getName();
        if (index >= 0 && index < numOfRows) {
            if (this.deleteColumn(index)) {
                super.removeRow(index);
            }
        } else {
            TableMessageHandler.sendErrorMessage("Delete Row", "Select a valid row");
        }
    }

    public void removeRow(int index) {
        int numOfRows = this.getRowCount();
        DtStructureElement dtStructureElement = this.getStructureElement(index);
        String fieldName = dtStructureElement.getName();
        if (index >= 0 && index < numOfRows) {
            if (this.deleteColumn(index)) {
                super.removeRow(index);
                if (this instanceof TableFieldsTableModel) {
                    try {
                        Hashtable<DtDbView, Boolean> questions = new Hashtable<DtDbView, Boolean>();
                        DtDictionaryRoot root = this.getDictionaryRoot();
                        DtDbView[] dtDbViews = root.getViews();
                        int i = 0;
                        while (i < dtDbViews.length) {
                            DtStructureElement[] elements = dtDbViews[i].getStructureElements();
                            int j = 0;
                            while (j < elements.length) {
                                if (elements[j] instanceof DtImportFromOtherStructure) {
                                    DtImportFromOtherStructure im = (DtImportFromOtherStructure)elements[j];
                                    DtInclusiveField inclField = im.getInclusiveField(fieldName);
                                    if (inclField != null) {
                                        boolean ret = false;
                                        Object value = questions.get(dtDbViews[i]);
                                        if (value != null) {
                                            Boolean v = (Boolean)value;
                                            ret = v;
                                        } else {
                                            ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to delete all column references ?"));
                                            questions.put(dtDbViews[i], new Boolean(ret));
                                        }
                                        if (ret) {
                                            try {
                                                int pos = inclField.getPosition();
                                                String newName = inclField.getNewName();
                                                if (inclField.canDelete()) {
                                                    inclField.delete();
                                                }
                                                if (im.getInclusiveFieldCount() == 0 && im.canDelete()) {
                                                    im.delete();
                                                }
                                                this.resetViewPositions(dtDbViews[i], pos);
                                            }
                                            catch (DeleteException e) {
                                                TableEditorPlugin.tracer.error("delete incl field", (Throwable)e);
                                            }
                                        }
                                    }
                                } else if (elements[j] instanceof DtField) {
                                    boolean ret = false;
                                    Object value = questions.get(dtDbViews[i]);
                                    if (value != null) {
                                        Boolean v = (Boolean)value;
                                        ret = v;
                                    } else {
                                        ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to delete all column references ?"));
                                        questions.put(dtDbViews[i], new Boolean(ret));
                                    }
                                    if (ret) {
                                        DtField field = (DtField)elements[j];
                                        int pos = field.getPosition();
                                        if (field.canDelete()) {
                                            field.delete();
                                        }
                                        this.resetViewPositions(dtDbViews[i], pos);
                                    }
                                }
                                ++j;
                            }
                            String tableName = this.getStructure().getName();
                            DtJoin[] joins = dtDbViews[i].getJoins();
                            int k = 0;
                            while (k < joins.length) {
                                DtJoinCondition[] conds = joins[k].getConditions();
                                int j2 = 0;
                                while (j2 < conds.length) {
                                    Boolean v;
                                    Object value;
                                    boolean ret;
                                    if (joins[k].isValid() && joins[k].getTabnameL().equals(tableName) && conds[j2].getFieldnameL().equals(fieldName)) {
                                        ret = false;
                                        value = questions.get(dtDbViews[i]);
                                        if (value != null) {
                                            v = (Boolean)value;
                                            ret = v;
                                        } else {
                                            ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to delete all column references ?"));
                                            questions.put(dtDbViews[i], new Boolean(ret));
                                        }
                                        if (ret) {
                                            try {
                                                if (conds[j2].canDelete()) {
                                                    conds[j2].delete();
                                                }
                                            }
                                            catch (DeleteException e) {
                                                TableEditorPlugin.tracer.error("delete condition", (Throwable)e);
                                            }
                                        }
                                    }
                                    if (joins[k].isValid() && joins[k].getTabnameR().equals(tableName) && conds[j2].getFieldnameR().equals(fieldName)) {
                                        ret = false;
                                        value = questions.get(dtDbViews[i]);
                                        if (value != null) {
                                            v = (Boolean)value;
                                            ret = v;
                                        } else {
                                            ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to delete all column references ?"));
                                            questions.put(dtDbViews[i], new Boolean(ret));
                                        }
                                        if (ret) {
                                            try {
                                                if (conds[j2].canDelete()) {
                                                    conds[j2].delete();
                                                }
                                            }
                                            catch (DeleteException e) {
                                                TableEditorPlugin.tracer.error("delete condition", (Throwable)e);
                                            }
                                        }
                                    }
                                    ++j2;
                                }
                                ++k;
                            }
                            DtSelectionRestriction res = dtDbViews[i].getSelectionRestriction();
                            if (res != null) {
                                DtSelectionRestrictionCondition[] conds = res.getConditions();
                                int j3 = 0;
                                while (j3 < conds.length) {
                                    if (conds[j3].getTabname().equals(tableName) && conds[j3].getFieldname().equals(fieldName)) {
                                        boolean ret = false;
                                        Object value = questions.get(dtDbViews[i]);
                                        if (value != null) {
                                            Boolean v = (Boolean)value;
                                            ret = v;
                                        } else {
                                            ret = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)("Column is used as reference in db view " + dtDbViews[i].getName() + ". Do you also want to delete all column references ?"));
                                            questions.put(dtDbViews[i], new Boolean(ret));
                                        }
                                        if (ret) {
                                            try {
                                                if (conds[j3].canDelete()) {
                                                    conds[j3].delete();
                                                }
                                            }
                                            catch (DeleteException e) {
                                                TableEditorPlugin.tracer.error("delete selection restriction condition", (Throwable)e);
                                            }
                                        }
                                    }
                                    ++j3;
                                }
                            }
                            ++i;
                        }
                    }
                    catch (LoadException e) {
                        TableEditorPlugin.tracer.error("get db views", (Throwable)e);
                    }
                    catch (DeleteException e2) {
                        TableEditorPlugin.tracer.error("get db views", (Throwable)e2);
                    }
                }
            }
        } else {
            TableMessageHandler.sendErrorMessage("Delete Row", "Select a valid row");
        }
    }

    protected abstract void editRow(int var1);

    protected abstract void renameColumn(int var1);

    public void insertRow(int row, Object[] rowData) {
        if (this.createColumn(row, rowData)) {
            super.insertRow(row, rowData);
        }
    }

    public void addRow(Object[] rowData) {
        if (this.createColumn(this.getRowCount(), rowData)) {
            super.addRow(rowData);
        }
    }

    protected void appendRow(Object[] rowData) {
        super.addRow(rowData);
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        if (startIndex < 0 || startIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (startIndex <= toIndex && toIndex <= endIndex) {
            return;
        }
        boolean shift = toIndex < startIndex;
        int i = startIndex;
        while (i <= endIndex) {
            Object[] row = this.getRow(i);
            this.removeRowForMove(i);
            this.insertRow(toIndex, row);
            if (shift) {
                ++toIndex;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }

    protected void copyRow(int sourceIndex, int targetIndex, String counter) {
        String PREFIX = "COPY";
        int numOfRows = this.getRowCount();
        if (sourceIndex < 0 || sourceIndex >= numOfRows || targetIndex < 0 || targetIndex >= numOfRows) {
            TableMessageHandler.sendInformationMessage("Copy", "Select a valid row");
            return;
        }
        Object[] row = this.getRow(sourceIndex);
        String fieldName = "COPY" + counter + "_" + (String)row[1];
        DtStructureElement dtStructureElement = this.getStructure().getStructureElement(fieldName);
        while (dtStructureElement != null) {
            counter = Integer.toString(Integer.valueOf(counter) + 1);
            fieldName = "COPY" + counter + "_" + (String)row[1];
            dtStructureElement = this.getStructure().getStructureElement(fieldName);
        }
        row[1] = fieldName;
        this.insertRow(targetIndex, row);
    }

    public Object[] getRow(int index) {
        Object[] row = new Object[11];
        int i = 0;
        while (i < this.getColumnCount()) {
            row[i] = this.getValueAt(index, i);
            ++i;
        }
        return row;
    }

    protected abstract Object[] fillRow(DtStructureElement var1) throws LoadException;

    protected abstract void insertRowViaWizard(int var1);

    protected abstract void addRowViaWizard();

    public boolean tableHasField(String fieldName, int index) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.getValueAt(i, 1).equals(fieldName) && i != index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updatePositions(int fromIndex) {
        int i = fromIndex;
        while (i < this.getRowCount()) {
            this.getStructure().getStructureElement(this.getFieldName(i)).setPosition(i);
            ++i;
        }
    }

    protected void updateColumnPositions(int fromIndex) {
        DtStructureElement[] dtStructureElements = this.getStructure().getStructureElements();
        int numOfElements = this.getStructure().getStructureElementCount();
        TreeMap<Integer, DtStructureElement> tStructureElements = new TreeMap<Integer, DtStructureElement>();
        int i = 0;
        while (i < numOfElements) {
            tStructureElements.put(new Integer(dtStructureElements[i].getPosition()), dtStructureElements[i]);
            ++i;
        }
        Collection structureElements = tStructureElements.values();
        int position = 0;
        Iterator iter = structureElements.iterator();
        while (iter.hasNext()) {
            DtStructureElement dtStructureElement = (DtStructureElement)iter.next();
            dtStructureElement.setPosition(position);
            ++position;
        }
    }

    public DtStructureElement getStructureElement(int index) {
        DtStructureElement[] dtStructureElements = this.getStructure().getStructureElements();
        int i = 0;
        while (i < dtStructureElements.length) {
            if (dtStructureElements[i].getPosition() == index) {
                return dtStructureElements[i];
            }
            ++i;
        }
        return null;
    }

    protected void increaseColumnPositions(int fromIndex) {
        DtStructureElement[] dtStructureElements = this.getStructure().getStructureElements();
        int i = 0;
        while (i < dtStructureElements.length) {
            int position = dtStructureElements[i].getPosition();
            if (position >= fromIndex) {
                dtStructureElements[i].setPosition(++position);
            }
            ++i;
        }
    }

    protected void decreaseColumnPositions(int fromIndex) {
        DtStructureElement[] dtStructureElements = this.getStructure().getStructureElements();
        int i = 0;
        while (i < dtStructureElements.length) {
            int position = dtStructureElements[i].getPosition();
            if (position >= fromIndex) {
                dtStructureElements[i].setPosition(--position);
            }
            ++i;
        }
    }

    protected boolean createColumn(int index, Object[] rowData) {
        DtField dtField = null;
        Object dtStructureElement = null;
        String packageName = null;
        String sBuiltInType = null;
        String sSimpleType = null;
        String description = null;
        String fieldName = null;
        String dbDefault = null;
        boolean isNotNull = false;
        boolean isKeyElement = false;
        int length = 0;
        int decimals = 0;
        int i = 0;
        while (i < rowData.length) {
            if (i == 1) {
                fieldName = (String)rowData[i];
            } else if (i == 3) {
                packageName = TableUtil.getNotNullString(rowData[i]);
            } else if (i == 4) {
                sSimpleType = TableUtil.getNotNullString(rowData[i]);
            } else if (i == 5) {
                sBuiltInType = TableUtil.getNotNullString(rowData[i]);
            } else if (i == 6) {
                length = this.getIntegerValue(rowData[i]);
            } else if (i == 7) {
                decimals = this.getIntegerValue(rowData[i]);
            } else if (i == 10) {
                description = TableUtil.getNotNullString(rowData[i]);
            } else if (i == 2) {
                isKeyElement = this.getBooleanValue(rowData[i]);
            } else if (i == 8) {
                isNotNull = this.getBooleanValue(rowData[i]);
            } else if (i == 9 && (dbDefault = (String)rowData[i]) == null) {
                dbDefault = "";
            }
            ++i;
        }
        try {
            dtField = this.getStructure().createStructureElementAsDtField(fieldName);
        }
        catch (CreateException e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"& could not be created: &", (String)fieldName, (String)e.getMessage()));
            TableEditorPlugin.tracer.error("create column", (Throwable)e);
            return false;
        }
        dtField.setPosition(-1);
        this.increaseColumnPositions(index);
        dtField.setPosition(index);
        dtField.setFieldType(FieldTypeEnum.SIMPLE);
        if (!TableUtil.stringIsEmpty(sSimpleType) ? !this.setReferenceToSimpleType(dtField, packageName, sSimpleType) : !this.setFieldAttributes(dtField, fieldName, sBuiltInType, length, decimals, isNotNull, isKeyElement, description, dbDefault, index)) {
            return false;
        }
        if (!this.setKeyElement((DtStructureElement)dtField, isKeyElement)) {
            return false;
        }
        this.setFieldDependantTableAttributes();
        return true;
    }

    protected boolean deleteColumn(int index) {
        DtStructureElement dtStructureElement = null;
        try {
            dtStructureElement = this.getStructureElement(index);
            if (dtStructureElement == null) {
                throw new DeleteException();
            }
            this.setKeyElement(dtStructureElement, false);
            dtStructureElement.delete();
            this.decreaseColumnPositions(index);
        }
        catch (DeleteException e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"& could not be deleted", (String)((String)this.getValueAt(index, 1))));
            TableEditorPlugin.tracer.error("delete column", (Throwable)e);
            return false;
        }
        this.setFieldDependantTableAttributes();
        return true;
    }

    private void resetViewPositions(DtDbView dtDbView, int pos) {
        DtStructureElement[] elements = dtDbView.getStructureElements();
        int i = 0;
        while (i < elements.length) {
            DtField field;
            if (elements[i] instanceof DtImportFromOtherStructure) {
                DtImportFromOtherStructure im = (DtImportFromOtherStructure)elements[i];
                DtInclusiveField[] fields = im.getInclusiveFields();
                int j = 0;
                while (j < fields.length) {
                    if (fields[j].getPosition() > pos) {
                        fields[j].setPosition(fields[j].getPosition() - 1);
                    }
                    ++j;
                }
            } else if (elements[i] instanceof DtField && (field = (DtField)elements[i]).getPosition() > pos) {
                field.setPosition(field.getPosition() - 1);
            }
            ++i;
        }
    }

    public boolean setReferenceToSimpleType(DtField dtField, String packageName, String simpleType) {
        DtSimpleType dtSimpleType = null;
        if (dtField == null) {
            return false;
        }
        try {
            dtSimpleType = this.mDtDictionaryRoot.getSimpleType(packageName, simpleType);
            if (dtSimpleType == null) {
                throw new LoadException();
            }
        }
        catch (LoadException e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"Simple type & does not exist in package &", (String)simpleType, (String)packageName));
            return false;
        }
        this.resetReferenceToSimpleType(dtField);
        this.resetFieldAttributes(dtField);
        this.deleteInternalJdbcTypeInfo(dtField.getName());
        dtField.setReferencedType((DtDataType)dtSimpleType);
        return true;
    }

    protected boolean isNotNullAllowed(DtField dtField) {
        ArrayList JdbcTypesWithoutDefault = null;
        String jdbcTypeName = null;
        DtDbTypeInfo[] dtDbTypeInfos = null;
        JdbcTypesWithoutDefault = DtTypeInfo.getJdbcTypesWithoutDefault();
        jdbcTypeName = dtField.getJdbcTypeName();
        if (!TableUtil.stringIsEmpty(jdbcTypeName) && JdbcTypesWithoutDefault.contains(jdbcTypeName)) {
            return false;
        }
        dtDbTypeInfos = dtField.getTypeInfos();
        int i = 0;
        while (i < dtDbTypeInfos.length) {
            jdbcTypeName = dtDbTypeInfos[i].getJdbcTypeName();
            if (JdbcTypesWithoutDefault.contains(jdbcTypeName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void resetFieldAttributes(DtField dtField) {
        String builtInType = dtField.getBuiltInType();
        if (builtInType != null) {
            if (TableUtil.checkValidConstraint(builtInType, "length")) {
                dtField.setLength(0);
            } else {
                dtField.setTotalDigits(0);
            }
            if (TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                dtField.setFractionDigits(0);
            }
        }
        dtField.setBuiltInType(null);
        dtField.setNotNull(BooleanEnum.NOT_SET);
        dtField.setDbDefault(null);
        this.deleteJdbcTypeInfo(dtField);
    }

    protected void resetReferenceToSimpleType(DtField dtField) {
        if (dtField.hasReferencedType()) {
            dtField.setReferencedType(null);
        }
    }

    protected void deleteJdbcTypeInfo(DtField dtField) {
        dtField.setJdbcTypeName(null);
        DtDbTypeInfo[] dtDbTypeInfos = dtField.getTypeInfos();
        int i = 0;
        while (i < dtDbTypeInfos.length) {
            try {
                dtDbTypeInfos[i].delete();
            }
            catch (DeleteException e) {
                TableMessageHandler.sendInformationMessage("Metadata API", MessagePool.getMessage((String)"JDBC type info & could not be deleted", (String)Integer.toString(i)));
                TableEditorPlugin.tracer.error("delete JdbcTypeInfo", (Throwable)e);
            }
            ++i;
        }
    }

    public boolean changeFieldName(int index, DtStructureElement dtStructureElement, String newFieldName) {
        Object[] attributes = new Object[11];
        if (dtStructureElement == null) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"& does not exist", (String)dtStructureElement.getName()));
            return false;
        }
        try {
            attributes = this.fillRow(dtStructureElement);
        }
        catch (LoadException e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"& could not be read", (String)dtStructureElement.getName()));
            TableEditorPlugin.tracer.error("changeFieldName, fillRow", (Throwable)e);
            return false;
        }
        this.createInternalJdbcTypeInfo((DtField)dtStructureElement, newFieldName);
        attributes[1] = newFieldName;
        if (!this.createColumn(index, attributes)) {
            return false;
        }
        this.deleteColumn(index + 1);
        return true;
    }

    protected abstract boolean setKeyElement(DtStructureElement var1, boolean var2);

    protected abstract void removeKeyElement(DtStructureElement var1);

    public void setNotNull(DtField dtField, boolean isNotNull) {
        if (isNotNull) {
            dtField.setNotNull(BooleanEnum.TRUE);
        } else {
            dtField.setNotNull(BooleanEnum.FALSE);
        }
    }

    public void setDbDefault(DtField dtField, String dbDefault, boolean isNotNull, int row) {
        if (dbDefault != null && dbDefault.length() > 0) {
            dtField.setDbDefault(dbDefault);
        } else {
            dtField.setDbDefault(null);
            if (this.getRowCount() > row) {
                this.setValueAt("", row, 9);
            }
        }
    }

    public void setDescription(DtField dtField, String description) {
        String oldDescription = null;
        oldDescription = dtField.getDescription();
        if (!description.equals(oldDescription)) {
            if (TableUtil.stringIsEmpty(description)) {
                dtField.setDescription(null);
            } else {
                dtField.setDescription(description);
            }
        }
    }

    protected void setFieldDependantTableAttributes() {
        this.getStructure().setStructureType(StructureTypeEnum.FLAT);
    }

    protected void checkPrimaryKey() {
    }

    public void checkDbDefault(int index, boolean setProposal) {
        if (!TableUtil.stringIsEmpty(this.getSimpleType(index))) {
            return;
        }
        String builtInType = this.getBuiltInType(index);
        int length = this.getLength(index);
        int decimals = this.getDecimals(index);
        if (builtInType.equalsIgnoreCase("date") || builtInType.equalsIgnoreCase("time") || builtInType.equalsIgnoreCase("timestamp") || builtInType.equalsIgnoreCase("boolean")) {
            this.setValueAt("", index, 9);
            return;
        }
        if (this.getDbDefault(index) != null && this.getDbDefault(index).length() == 0 && setProposal && this.getNotNull(index)) {
            this.setDbDefaultProposal(index);
            return;
        }
        if (!TableUtil.stringIsEmpty(TableUtil.checkDbDefault(this.getDbDefault(index), builtInType, length, decimals))) {
            this.setDbDefaultProposal(index);
        }
    }

    protected void setDbDefaultProposal(int index) {
        this.setValueAt(TableUtil.getDbDefault(this.getBuiltInType(index), this.getLength(index), this.getDecimals(index)), index, 9);
    }

    public int getLength(int index) {
        return this.getIntegerValue(this.getValueAt(index, 6));
    }

    public int getDecimals(int index) {
        return this.getIntegerValue(this.getValueAt(index, 7));
    }

    public String getDescription(int index) {
        return TableUtil.getNotNullString((String)this.getValueAt(index, 10));
    }

    public String getDbDefault(int index) {
        String value = (String)this.getValueAt(index, 9);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public String getFieldName(int index) {
        return TableUtil.getNotNullString((String)this.getValueAt(index, 1));
    }

    public String getBuiltInType(int index) {
        return TableUtil.getNotNullString((String)this.getValueAt(index, 5));
    }

    protected String getSimpleType(int index) {
        return TableUtil.getNotNullString((String)this.getValueAt(index, 4));
    }

    public boolean getNotNull(int index) {
        return this.getBooleanValue(this.getValueAt(index, 8));
    }

    public boolean getKeyElement(int index) {
        return this.getBooleanValue(this.getValueAt(index, 2));
    }

    protected int getIntegerValue(Object object) {
        if (object != null) {
            return Integer.valueOf(object.toString());
        }
        return 0;
    }

    protected boolean getBooleanValue(Object object) {
        if (object != null) {
            return Boolean.valueOf(object.toString()) != false;
        }
        return false;
    }

    public boolean setFieldAttributes(DtField dtField, String fieldName, String builtInType, int length, int decimals, boolean isNotNull, boolean isKeyElement, String description, String dbDefault, int row) {
        Object dtSimpleType = null;
        this.resetReferenceToSimpleType(dtField);
        try {
            dtField.setReferencedType((DtDataType)this.mDtDictionaryRoot.getSimpleType("com.sap.dictionary", builtInType));
        }
        catch (LoadException e) {
            TableEditorPlugin.tracer.error("setReferencedType" + builtInType, (Throwable)e);
        }
        this.resetFieldAttributes(dtField);
        this.setDescription(dtField, description);
        if (!TableUtil.stringIsEmpty(builtInType)) {
            if (!this.setJdbcTypeInfo(dtField, builtInType, length)) {
                return false;
            }
            if (isKeyElement) {
                isNotNull = true;
            }
            boolean hasAttributeLength = false;
            if (length > 0) {
                if (TableUtil.checkValidConstraint(builtInType, "length")) {
                    hasAttributeLength = true;
                } else if (!TableUtil.checkValidConstraint(builtInType, "totalDigits")) {
                    length = 0;
                }
            }
            if (decimals > 0 && !TableUtil.checkValidConstraint(builtInType, "fractionDigits")) {
                decimals = 0;
            }
            dtField.setBuiltInType(builtInType);
            if (length > 0) {
                if (hasAttributeLength) {
                    dtField.setLength(length);
                } else {
                    dtField.setTotalDigits(length);
                }
            }
            if (decimals > 0) {
                dtField.setFractionDigits(decimals);
            }
            this.setNotNull(dtField, isNotNull);
            this.setDbDefault(dtField, dbDefault, isNotNull, row);
        }
        return true;
    }

    public DatabaseEnum[] getDatabases() {
        return this.getSelectedDbSystems();
    }

    public boolean setJdbcTypeInfo(DtField dtField, String builtInType, int length) {
        int i;
        Object dtDbTypeInfos = null;
        ArrayList jdbcTypeInfo = null;
        DtTypeInfoForDatabase dtTypeInfoForDatabase = null;
        DtDbTypeInfo dtDbTypeInfo = null;
        DatabaseEnum database = null;
        String sDatabase = null;
        DatabaseEnum[] lDatabases = this.getDatabases();
        Object temp = this.mJdbcTypeInfosMap.get(dtField.getName());
        if (temp != null) {
            jdbcTypeInfo = (ArrayList)temp;
            boolean deleteFlag = true;
            i = 0;
            while (i < jdbcTypeInfo.size()) {
                DtTypeInfoForDatabase tifd = (DtTypeInfoForDatabase)jdbcTypeInfo.get(i);
                if (!tifd.getDatabaseName().equals("DEFAULT")) {
                    deleteFlag = false;
                    break;
                }
                ++i;
            }
            if (deleteFlag) {
                DtDbTypeInfo[] infos = dtField.getTypeInfos();
                int i2 = 0;
                while (i2 < infos.length) {
                    try {
                        infos[i2].delete();
                    }
                    catch (DeleteException e) {
                        TableEditorPlugin.tracer.error("metamodel delete", (Throwable)e);
                    }
                    ++i2;
                }
            }
        } else {
            DtDbTypeInfo[] infos = dtField.getTypeInfos();
            i = 0;
            while (i < infos.length) {
                try {
                    infos[i].delete();
                }
                catch (DeleteException e) {
                    TableEditorPlugin.tracer.error("metamodel delete", (Throwable)e);
                }
                ++i;
            }
            jdbcTypeInfo = DdMapping.getJdbcTypeInfo((String)builtInType, (int)length, (DatabaseEnum[])lDatabases);
        }
        try {
            int i3 = 0;
            while (i3 < jdbcTypeInfo.size()) {
                dtTypeInfoForDatabase = (DtTypeInfoForDatabase)jdbcTypeInfo.get(i3);
                if (dtTypeInfoForDatabase.getDatabaseName().equalsIgnoreCase("DEFAULT")) {
                    dtField.setJdbcTypeName(dtTypeInfoForDatabase.getJavaSqlTypeName());
                } else {
                    dtDbTypeInfo = dtField.hasTypeInfo(dtTypeInfoForDatabase.getDatabaseName()) ? dtField.getTypeInfo(dtTypeInfoForDatabase.getDatabaseName()) : dtField.createTypeInfo(dtTypeInfoForDatabase.getDatabaseName());
                    sDatabase = dtTypeInfoForDatabase.getDatabaseName();
                    database = null;
                    int j = 0;
                    while (j < lDatabases.length) {
                        if (lDatabases[j].toString().equalsIgnoreCase(sDatabase)) {
                            database = lDatabases[j];
                            break;
                        }
                        ++j;
                    }
                    dtDbTypeInfo.setDatabase(database);
                    dtDbTypeInfo.setJdbcTypeName(dtTypeInfoForDatabase.getJavaSqlTypeName());
                }
                ++i3;
            }
        }
        catch (CreateException e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"JDBC type info for & could not be created", (String)dtField.getName()));
            TableEditorPlugin.tracer.error("create JdbcTypeInfo", (Throwable)e);
            return false;
        }
        return true;
    }

    public void refreshAllJdbcTypeInfos() {
        int i = 0;
        while (i < this.getRowCount()) {
            DtField field = (DtField)this.getStructureElement(i);
            if (field.getBuiltInType() != null) {
                String columnName = this.getColumnName(i);
                String builtintype = this.getBuiltInType(i);
                int length = this.getLength(i);
                this.setJdbcTypeInfo(field, builtintype, length);
            }
            ++i;
        }
    }

    protected abstract DatabaseEnum[] getSelectedDbSystems();

    public void setInternalJdbcTypeInfos(String fieldname, ArrayList list) {
        this.mJdbcTypeInfosMap.put(fieldname, list);
    }

    public void deleteInternalJdbcTypeInfo(String fieldname) {
        this.mJdbcTypeInfosMap.remove(fieldname);
    }

    public void createInternalJdbcTypeInfo(DtField dtField, String fieldname) {
        String oldFieldname = dtField.getName();
        ArrayList list = (ArrayList)this.mJdbcTypeInfosMap.get(oldFieldname);
        if (list != null) {
            this.deleteInternalJdbcTypeInfo(oldFieldname);
            this.setInternalJdbcTypeInfos(fieldname, list);
        }
    }

    public abstract DtStructure getStructure();

    public DtDictionaryRoot getDictionaryRoot() {
        return this.mDtDictionaryRoot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

