/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.fields;

import com.sap.dictionary.tools.exception.NestableException;
import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableSection;
import com.sap.dictionary.tools.tableeditor.fields.MyCCombo;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.service.SimpletypeSelection;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tableeditor.util.ToolTipHandler;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateSimpleTypeAction;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.AdvancedTextInput;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.form.SectionForm;
import com.tssap.util.ui.glpc.section.SimpleSection;
import com.tssap.util.ui.lfsupport.DefaultWidgetFactory;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractTableFieldsSectionForm
extends SectionForm {
    protected DtStructure mDtDbTable = null;
    protected DtDictionaryRoot mDtDictionaryRoot;
    protected AbstractTableEditor mEditor = null;
    public Text mTableDescription = null;
    public Text mTableName = null;
    protected Text mLastModified = null;
    protected AbstractTableFieldsTableModel mTableFieldsTableModel = null;
    public AbstractTableFieldsTableSection mTableFieldsTableSection = null;
    protected String mTable = null;
    protected ToolTipHandler mToolTipHandler;
    protected Label mEditableInfo = null;
    protected Label mEditableIcon = null;
    public int mSelectionIndex = -1;
    protected TableUtil mTableUtil;
    protected SimpleSection mHeaderSection;
    protected static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsSectionForm == null ? (class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsSectionForm = AbstractTableFieldsSectionForm.class$("com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm")) : class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsSectionForm));
    public Vector tableEditorDbDefaultInputFieldVector = new Vector();
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$fields$AbstractTableFieldsSectionForm;

    public AbstractTableFieldsSectionForm(IWidgetFactory widgetFactory, int columns, String title, AbstractTableEditor editor, String table, DtStructure dtDbTable, DtDictionaryRoot dtDictionaryRoot) {
        super(widgetFactory, columns, title);
        this.mEditor = editor;
        this.mTable = table;
        this.mDtDbTable = dtDbTable;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.mTableUtil = new TableUtil();
    }

    public AbstractTableFieldsSectionForm(IWidgetFactory widgetFactory, int columns, boolean equalColumns, String title, AbstractTableEditor editor, String table, DtStructure dtDbTable, DtDictionaryRoot dtDictionaryRoot) {
        super(widgetFactory, columns, equalColumns, title);
        this.mEditor = editor;
        this.mTable = table;
        this.mDtDbTable = dtDbTable;
        this.mDtDictionaryRoot = dtDictionaryRoot;
        this.mTableUtil = new TableUtil();
    }

    public void initSectionForm(IGridLayoutPane glp) {
        this.createHeaderSection(glp);
        this.createFieldsSection(glp);
    }

    protected abstract AbstractTableFieldsTableModel createFieldsTableModel();

    protected abstract AbstractTableFieldsTableSection createFieldsTableSection();

    protected abstract void setDeletedInfo();

    private void createHeaderandAttributesSection(IGridLayoutPane glp) {
        Composite parent = glp.addSimplePane().getComposite();
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayout((Layout)new GridLayout());
        tabFolder.setFont(JFaceResources.getBannerFont());
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText("General Information");
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText("Attributes");
    }

    protected void createHeaderSection(IGridLayoutPane glp) {
        Object predefinedAction = null;
        this.mHeaderSection = new SimpleSection((IWidgetFactory)new DefaultWidgetFactory(), 4, false, "General Information", this.getHeaderSubtitle());
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.mHeaderSection, glp.createGridLayoutData(4, 1, 1, 1));
        this.mHeaderSection.getClientArea().addTextLabel(this.getHeaderLabelText());
        this.mTableName = this.mHeaderSection.getClientArea().addTextField(this.mTable, true, this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        this.mEditableIcon = this.mHeaderSection.getClientArea().addTextLabel("", this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        this.mEditableInfo = this.mHeaderSection.getClientArea().addTextLabel("", this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        this.setDeletedInfo();
        this.addPackageFieldToHeader();
        this.mHeaderSection.getClientArea().addTextLabel("Description:");
        this.mTableDescription = this.mHeaderSection.getClientArea().addTextField("", this.mEditor.isReadOnly(), this.mHeaderSection.getClientArea().createGridLayoutData(4, 2, true, false, 1, 1));
        try {
            this.initHeaderSection();
        }
        catch (Exception e) {
            TableMessageHandler.sendErrorMessage("Metadata API", MessagePool.getMessage((String)"Error in loading metadata: &", (String)(e.getMessage() + "/ " + e.getClass().toString())));
            throw new NestableException((Throwable)e);
        }
        this.mTableDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String description = "";
                if (AbstractTableFieldsSectionForm.this.mEditor.isReadOnly()) {
                    return;
                }
                AbstractTableFieldsSectionForm.this.mEditor.setDataChanged();
                description = AbstractTableFieldsSectionForm.this.getTableDescription();
                if (TableUtil.stringIsEmpty(description)) {
                    AbstractTableFieldsSectionForm.this.mDtDbTable.setDescription(null);
                } else {
                    AbstractTableFieldsSectionForm.this.mDtDbTable.setDescription(description);
                }
                AbstractTableFieldsSectionForm.this.mTableDescription.setFocus();
            }
        });
    }

    protected void addPackageFieldToHeader() {
    }

    protected abstract String getHeaderSubtitle();

    protected abstract String getHeaderLabelText();

    private void createFieldsSection(IGridLayoutPane glp) {
        this.mTableFieldsTableModel = this.createFieldsTableModel();
        boolean[] buttonsEnabled = new boolean[11];
        int i = 0;
        while (i < buttonsEnabled.length) {
            buttonsEnabled[i] = !this.mEditor.isReadOnly();
            ++i;
        }
        this.mTableFieldsTableSection = this.createFieldsTableSection();
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)this.mTableFieldsTableSection, glp.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mTableFieldsTableSection.setColumnTypes();
        this.initToolTip();
        this.registerForEvents();
    }

    private void registerForEvents() {
        this.mTableFieldsTableSection.getTableViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                super.mouseDoubleClick(e);
                AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.editColumn();
            }
        });
        this.mTableFieldsTableSection.getTableViewer().getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!AbstractTableFieldsSectionForm.this.mEditor.isReadOnly()) {
                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setFieldDependantTableAttributes();
                }
            }
        });
        this.mTableFieldsTableSection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTableFieldsSectionForm.this.mSelectionIndex = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getSelectionIndex();
                AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.mSelFieldname = (String)AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getValueAt(AbstractTableFieldsSectionForm.this.mSelectionIndex, 1);
            }
        });
        if (!this.mEditor.isReadOnly()) {
            this.mTableFieldsTableSection.getTableViewer().getTableViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u007f') {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.deleteColumns();
                    }
                    if (e.keyCode == 0x100000B) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().editElement(AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().getElementAt(AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getSelectionIndex()), 0);
                        if (AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().isCellEditorActive()) {
                            CellEditor[] cellEditorArray = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors();
                        }
                    }
                }
            });
        }
        CellEditor[] editors = this.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors();
        if (!this.mEditor.isReadOnly()) {
            editors[1] = new MyTextCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable());
            editors[3] = new MyCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable(), 3, true);
            editors[4] = new MyCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable(), 4, false);
            editors[5] = this instanceof TableFieldsSectionForm ? new MyComboBoxCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable(), TableUtil.getBuiltInTypes()) : new MyComboBoxCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable(), TableUtil.getBuiltInTypesForStructures());
            editors[6] = new MyLengthDecimalsCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable());
            editors[7] = new MyLengthDecimalsCellEditor((Composite)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable());
        }
        final CellEditor[] fEditors = editors;
        int a = 1;
        while (a <= 10) {
            final int i = a;
            if (a != 3 && a != 4 && a != 2 && a != 8) {
                editors[a].getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 16) {
                            e.doit = false;
                            if (i == 1) {
                                if (fEditors[i].getValue() != null) {
                                    AbstractTableFieldsSectionForm.this.editNextEditableCell(i, true);
                                }
                            } else {
                                AbstractTableFieldsSectionForm.this.editNextEditableCell(i, true);
                            }
                        }
                        if (e.detail == 8) {
                            e.doit = false;
                            AbstractTableFieldsSectionForm.this.editNextEditableCell(i, false);
                        }
                    }
                });
            }
            ++a;
        }
        this.mTableFieldsTableSection.getTableViewer().getTableViewer().setCellEditors(editors);
        this.mTableFieldsTableSection.getTableViewer().getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getItem(pt);
                if (item == null) {
                    if (AbstractTableFieldsSectionForm.this.mEditor.isReadOnly()) {
                        return;
                    }
                    String time = Long.toString(System.currentTimeMillis());
                    time = time.substring(0, time.length() - 4);
                    Object[] initialRow = new Object[]{"", time, new Boolean(false), "", "", "", null, null, new Boolean(true), "", ""};
                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.addRow(initialRow);
                    int rows = AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount();
                    TableItem newItem = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getItem(rows - 1);
                    TableItem ptItem = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getItem(pt);
                    if (newItem != ptItem) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.removeRow(rows - 1);
                        return;
                    }
                    if (AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.isCellEditable(rows - 1, 1)) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.mSelFieldname = null;
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().editElement(AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().getElementAt(rows - 1), 1);
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAtWithoutTableChangedEvent("", rows - 1, 1);
                    }
                    return;
                }
                int columns = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getColumnCount();
                int i = 0;
                while (i < columns) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        int index = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().indexOf(item);
                        CellEditor[] editors = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors();
                        if (i != 3 && editors[3].isActivated()) {
                            editors[3].getValue();
                            editors[3].deactivate();
                        }
                        if (i != 4 && editors[4].isActivated()) {
                            editors[4].getValue();
                            editors[4].deactivate();
                        }
                        if (!(editors[i] instanceof CheckboxCellEditor)) {
                            int a = 0;
                            while (a < editors.length) {
                                if (editors[a].isActivated()) {
                                    System.out.println(i);
                                    int col = i;
                                    int row = index;
                                    int count = a;
                                    switch (i) {
                                        case 1: {
                                            break;
                                        }
                                        case 3: 
                                        case 4: {
                                            ((MyCellEditor)editors[a]).setRow(row);
                                        }
                                    }
                                }
                                ++a;
                            }
                        }
                    }
                    ++i;
                }
            }
        });
        final Table table = this.mTableFieldsTableSection.getTableViewer().getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int i = 0;
                while (i < table.getItemCount()) {
                    AdvancedTextInput input;
                    TableEditor editor;
                    if (e.item == table.getItem(i)) {
                        editor = (TableEditor)AbstractTableFieldsSectionForm.this.tableEditorDbDefaultInputFieldVector.elementAt(i);
                        input = (AdvancedTextInput)editor.getEditor();
                        input.setBackground(Display.getDefault().getSystemColor(26));
                        input.setForeground(Display.getDefault().getSystemColor(27));
                    } else {
                        editor = (TableEditor)AbstractTableFieldsSectionForm.this.tableEditorDbDefaultInputFieldVector.elementAt(i);
                        input = (AdvancedTextInput)editor.getEditor();
                        input.setBackground(Display.getDefault().getSystemColor(1));
                        input.setForeground(Display.getDefault().getSystemColor(2));
                    }
                    ++i;
                }
            }
        });
    }

    public AbstractTableEditor getEditor() {
        return this.mEditor;
    }

    protected void setTableDescription(String tableDescription) {
        if (tableDescription == null) {
            tableDescription = "";
        }
        this.mTableDescription.setText(tableDescription);
    }

    protected String getTableDescription() {
        return this.mTableDescription.getText();
    }

    public AbstractTableFieldsTableSection getTableSection() {
        return this.mTableFieldsTableSection;
    }

    public AbstractTableFieldsTableModel getTableFieldsTableModel() {
        return this.mTableFieldsTableModel;
    }

    protected void setPackage(String sPackage) {
    }

    protected void initHeaderSection() {
        String strg = null;
        if (this.mDtDbTable == null) {
            return;
        }
        strg = this.mDtDbTable.getDescription();
        if (!TableUtil.stringIsEmpty(strg)) {
            this.setTableDescription(strg);
        }
    }

    private void tableColumnChanged() {
    }

    protected boolean save(boolean sendMessages) {
        return true;
    }

    private void initToolTip() {
        TableItem tableItem = null;
        Object text = null;
        Vector messages = null;
        Table table = null;
        table = this.mTableFieldsTableSection.getTableViewer().getTable();
        int i = 0;
        while (i < this.mTableFieldsTableModel.getRowCount()) {
            tableItem = table.getItem(i);
            messages = this.mTableUtil.checkTableColumn(this.mTableFieldsTableModel, i, this.mDtDictionaryRoot, true, false, false);
            if (messages == null || messages != null && messages.isEmpty()) {
                TableUtil.resetToolTipInfo(tableItem);
            } else {
                TableUtil.setToolTipInfo(tableItem, messages, true);
            }
            ++i;
        }
        this.mToolTipHandler = new ToolTipHandler(table.getShell());
        this.mToolTipHandler.activateHoverHelp((Control)table);
    }

    protected void editNextEditableCell(int column, boolean next) {
        int row = this.mTableFieldsTableSection.getTableViewer().getTableViewer().getTable().getSelectionIndex();
        if (next) {
            if (column == 10) {
                if (row < this.mTableFieldsTableSection.getTableViewer().getTable().getItemCount() - 1) {
                    this.mTableFieldsTableSection.getTableViewer().getTable().setSelection(row + 1);
                    this.editNextEditableCell(0, true);
                }
                return;
            }
            int i = 1;
            while (i < 11 - column) {
                if (column + i != 2 && column + i != 8) {
                    String string = (String)this.mTableFieldsTableModel.getValueAt(row, 4);
                    if (!TableUtil.stringIsEmpty(string) && column + i == 5) {
                        this.mTableFieldsTableSection.getTableViewer().getTable().setSelection(row + 1);
                        this.editNextEditableCell(0, true);
                        return;
                    }
                    if (this.mTableFieldsTableModel.isCellEditable(row, column + i)) {
                        if (column + i == 3 || column + i == 4) {
                            ((MyCellEditor)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors()[column + i]).setRow(row);
                        }
                        if (column + i == 9) {
                            Vector vec = this.tableEditorDbDefaultInputFieldVector;
                            TableEditor editor = (TableEditor)vec.get(row);
                            editor.getEditor().setFocus();
                        } else {
                            this.mTableFieldsTableSection.getTableViewer().getTableViewer().editElement(this.mTableFieldsTableSection.getTableViewer().getTableViewer().getElementAt(row), column + i);
                        }
                        break;
                    }
                }
                ++i;
            }
        } else {
            if (column == 3) {
                if (row > 0) {
                    this.mTableFieldsTableSection.getTableViewer().getTable().setSelection(row - 1);
                    this.editNextEditableCell(11, false);
                }
                return;
            }
            int i = 1;
            while (i < column) {
                if (column - i != 2 && column - i != 8) {
                    String string = (String)this.mTableFieldsTableModel.getValueAt(row, 4);
                    if (!TableUtil.stringIsEmpty(string) && column - i == 5) break;
                    if (this.mTableFieldsTableModel.isCellEditable(row, column - i)) {
                        if (column - i == 3 || column - i == 4) {
                            ((MyCellEditor)this.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors()[column - i]).setRow(row);
                        }
                        if (column - i == 9) {
                            Vector vec = this.tableEditorDbDefaultInputFieldVector;
                            TableEditor editor = (TableEditor)vec.get(row);
                            editor.getEditor().setFocus();
                        } else {
                            this.mTableFieldsTableSection.getTableViewer().getTableViewer().editElement(this.mTableFieldsTableSection.getTableViewer().getTableViewer().getElementAt(row), column - i);
                        }
                        break;
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyComboBoxCellEditor
    extends CellEditor {
        private String[] items;
        private int selection;
        private MyCCombo comboBox;
        private String lastValue;

        public MyComboBoxCellEditor(Composite parent, String[] items) {
            super(parent);
            Assert.isNotNull((Object)items);
            this.items = items;
            this.selection = 0;
            this.populateComboBoxItems();
        }

        protected Control createControl(Composite parent) {
            this.comboBox = new MyCCombo(parent, 0);
            this.comboBox.setFont(parent.getFont());
            this.comboBox.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ MyComboBoxCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    MyComboBoxCellEditor.access$601(this.this$1, e);
                }
            });
            this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ MyComboBoxCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    MyComboBoxCellEditor.access$702(this.this$1, MyComboBoxCellEditor.access$800(this.this$1).getSelectionIndex());
                    Object newValue = this.this$1.doGetValue();
                    boolean newValidState = MyComboBoxCellEditor.access$901(this.this$1, newValue);
                    if (newValidState) {
                        this.this$1.doSetValue(newValue);
                    } else {
                        MyComboBoxCellEditor.access$1101(this.this$1, MessageFormat.format(this.this$1.getErrorMessage(), MyComboBoxCellEditor.access$1000(this.this$1)[MyComboBoxCellEditor.access$700(this.this$1)]));
                    }
                    MyComboBoxCellEditor.access$1201(this.this$1);
                }
            });
            this.comboBox.addTraverseListener(new TraverseListener(this){
                private final /* synthetic */ MyComboBoxCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.comboBox.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ MyComboBoxCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyReleased(KeyEvent e) {
                    super.keyReleased(e);
                    if (e.keyCode == 0x1000002) {
                        int i = 0;
                        while (i < MyComboBoxCellEditor.access$1000(this.this$1).length) {
                            if (MyComboBoxCellEditor.access$1000(this.this$1)[i].equals(MyComboBoxCellEditor.access$1300(this.this$1))) {
                                return;
                            }
                            ++i;
                        }
                        if (MyComboBoxCellEditor.access$1300(this.this$1) != null) {
                            int i2 = 0;
                            while (i2 < MyComboBoxCellEditor.access$1000(this.this$1).length) {
                                if (MyComboBoxCellEditor.access$1000(this.this$1)[i2].startsWith(MyComboBoxCellEditor.access$1300(this.this$1))) {
                                    MyComboBoxCellEditor.access$800(this.this$1).setText(MyComboBoxCellEditor.access$1000(this.this$1)[i2]);
                                    MyComboBoxCellEditor.access$800(this.this$1).select(i2);
                                    MyComboBoxCellEditor.access$1302(this.this$1, MyComboBoxCellEditor.access$1000(this.this$1)[i2]);
                                    return;
                                }
                                ++i2;
                            }
                        }
                    }
                    MyComboBoxCellEditor.access$1302(this.this$1, MyComboBoxCellEditor.access$800(this.this$1).getText());
                }
            });
            return this.comboBox;
        }

        public void performCut() {
            this.comboBox.getTextControl().cut();
        }

        public void performCopy() {
            this.comboBox.getTextControl().copy();
        }

        public void performPaste() {
            this.comboBox.getTextControl().paste();
        }

        protected Object doGetValue() {
            if (this.comboBox.getSelectionIndex() >= 0) {
                return this.items[this.comboBox.getSelectionIndex()];
            }
            int i = 0;
            while (i < this.items.length) {
                String input = this.comboBox.getText().toLowerCase();
                if (this.items[i].startsWith(input)) {
                    return this.items[i];
                }
                ++i;
            }
            return "";
        }

        protected void doSetFocus() {
            this.comboBox.setFocus();
        }

        public CellEditor.LayoutData getLayoutData() {
            CellEditor.LayoutData layoutData = super.getLayoutData();
            layoutData.minimumWidth = 50;
            return layoutData;
        }

        protected void doSetValue(Object value) {
            Assert.isTrue((this.comboBox != null && value instanceof String ? 1 : 0) != 0);
            int i = 0;
            while (i < this.items.length) {
                if (this.items[i].compareTo(value) == 0) {
                    this.selection = i;
                    this.comboBox.select(this.selection);
                    break;
                }
                ++i;
            }
        }

        private void populateComboBoxItems() {
            if (this.comboBox != null && this.items != null) {
                int i = 0;
                while (i < this.items.length) {
                    this.comboBox.add(this.items[i], i);
                    ++i;
                }
                this.setValueValid(true);
            }
        }

        static /* synthetic */ void access$601(MyComboBoxCellEditor x0, KeyEvent x1) {
            super.keyReleaseOccured(x1);
        }

        static /* synthetic */ int access$702(MyComboBoxCellEditor x0, int x1) {
            x0.selection = x1;
            return x0.selection;
        }

        static /* synthetic */ MyCCombo access$800(MyComboBoxCellEditor x0) {
            return x0.comboBox;
        }

        static /* synthetic */ boolean access$901(MyComboBoxCellEditor x0, Object x1) {
            return super.isCorrect(x1);
        }

        static /* synthetic */ String[] access$1000(MyComboBoxCellEditor x0) {
            return x0.items;
        }

        static /* synthetic */ int access$700(MyComboBoxCellEditor x0) {
            return x0.selection;
        }

        static /* synthetic */ void access$1101(MyComboBoxCellEditor x0, String x1) {
            super.setErrorMessage(x1);
        }

        static /* synthetic */ void access$1201(MyComboBoxCellEditor x0) {
            super.fireApplyEditorValue();
        }

        static /* synthetic */ String access$1300(MyComboBoxCellEditor x0) {
            return x0.lastValue;
        }

        static /* synthetic */ String access$1302(MyComboBoxCellEditor x0, String x1) {
            x0.lastValue = x1;
            return x0.lastValue;
        }
    }

    private class StSelectDialog
    extends Dialog {
        private Combo combo = null;
        public ArrayList list = new ArrayList();
        public int selectedIndex = -1;

        public StSelectDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Select type");
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            layout.numColumns = 2;
            new Label(composite, 0).setText("Select simple type");
            this.combo = new Combo(composite, 4);
            int i = 0;
            while (i < this.list.size()) {
                this.combo.add((String)this.list.get(i));
                ++i;
            }
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ StSelectDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    this.this$1.selectedIndex = StSelectDialog.access$500(this.this$1).getSelectionIndex();
                }
            });
            return composite;
        }

        public void addSimpleType(String st) {
            this.list.add(st);
        }

        static /* synthetic */ Combo access$500(StSelectDialog x0) {
            return x0.combo;
        }
    }

    private class MyCellEditor
    extends DialogCellEditor {
        private Text testText;
        private DtSimpleType[] types;
        private int row;
        private int col;
        private boolean changed = false;
        private boolean mPackage = false;

        public MyCellEditor(Composite parent, int col, boolean lPackage) {
            super(parent);
            this.mPackage = lPackage;
            this.col = col;
            try {
                this.types = AbstractTableFieldsSectionForm.this.mDtDictionaryRoot.getSimpleTypes();
            }
            catch (Exception e) {
                tracer.error("create cell editor:", (Throwable)e);
            }
        }

        protected Control createContents(Composite cell) {
            this.testText = new Text(cell, 16384);
            this.testText.setFocus();
            this.testText.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ MyCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyReleased(KeyEvent e) {
                    if (e.character != '\t') {
                        MyCellEditor.access$102(this.this$1, true);
                    }
                    MyCellEditor.access$201(this.this$1, e);
                }
            });
            this.testText.addTraverseListener(new TraverseListener(this){
                private final /* synthetic */ MyCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        e.doit = false;
                    }
                    if (e.detail == 16) {
                        e.doit = false;
                        MyCellEditor.access$400(this.this$1).editNextEditableCell(MyCellEditor.access$300(this.this$1), true);
                    }
                    if (e.detail == 8) {
                        e.doit = false;
                        MyCellEditor.access$400(this.this$1).editNextEditableCell(MyCellEditor.access$300(this.this$1), false);
                    }
                }
            });
            cell.setFocus();
            this.testText.setFocus();
            return this.testText;
        }

        public void performCopy() {
            this.testText.copy();
        }

        public void performCut() {
            this.testText.cut();
        }

        public void performPaste() {
            this.testText.paste();
        }

        public void dispose() {
            super.dispose();
        }

        public void setRow(int row) {
            this.row = row;
            this.changed = false;
        }

        protected void doSetFocus() {
            super.doSetFocus();
            this.testText.setFocus();
            try {
                this.types = AbstractTableFieldsSectionForm.this.mDtDictionaryRoot.getSimpleTypes();
            }
            catch (Exception e) {
                tracer.error("get simple types:", (Throwable)e);
            }
        }

        protected Object doGetValue() {
            if (!this.changed) {
                return null;
            }
            String st = this.testText.getText();
            if (st.compareTo("@") == 0) {
                return null;
            }
            int i = 0;
            while (i < this.types.length) {
                if (this.types[i].getPackage() != null && !this.types[i].getPackage().equals("com.sap.dictionary") && !this.types[i].getPackage().equals("com.sap.ide.webdynpro.uielementdefinitions")) {
                    if (this.types[i].getQualifiedName().compareTo(st) == 0) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(this.types[i].getPackage(), this.row, 3);
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(this.types[i].getName(), this.row, 4);
                        return null;
                    }
                    if (!(this.mPackage || this.types[i].getPackage().compareTo(st) != 0 && this.types[i].getName().compareTo(st) != 0)) {
                        String lPackageName = (String)AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getValueAt(this.row, 3);
                        if (lPackageName != null && lPackageName.length() != 0) {
                            try {
                                DtSimpleType dtSt = AbstractTableFieldsSectionForm.this.mDtDictionaryRoot.getSimpleType(lPackageName, st);
                                if (dtSt != null && dtSt.hasLogicalDictionary()) {
                                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 3);
                                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 4);
                                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"SimpleType is imported from external dictionary. It can't be used as reference type");
                                    return null;
                                }
                                if (dtSt != null) {
                                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(lPackageName, this.row, 3);
                                    AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(st, this.row, 4);
                                    return null;
                                }
                            }
                            catch (LoadException e) {
                                tracer.error("couldn't get simple type", (Throwable)e);
                            }
                        }
                        StSelectDialog diag = new StSelectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        int j = 0;
                        while (j < this.types.length) {
                            if ((this.types[j].getPackage().equals(st) || this.types[j].getName().equals(st)) && this.types[j].getName().charAt(0) != '$' && !this.types[j].hasLogicalDictionary()) {
                                diag.addSimpleType(this.types[j].getQualifiedName());
                            }
                            ++j;
                        }
                        if (diag.open() == 0 && diag.selectedIndex >= 0) {
                            String selType = (String)diag.list.get(diag.selectedIndex);
                            String pack = selType.substring(0, selType.lastIndexOf("."));
                            String name = selType.substring(selType.lastIndexOf(".") + 1, selType.length());
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(pack, this.row, 3);
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(name, this.row, 4);
                        } else {
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 4);
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 3);
                        }
                        return null;
                    }
                }
                ++i;
            }
            if (!TableUtil.stringIsEmpty(this.testText.getText()) && !this.mPackage) {
                int i2 = AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount() - 1;
                while (i2 >= 0) {
                    String fieldName = (String)AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getValueAt(i2, 1);
                    Vector messages = TableUtil.checkFieldName(AbstractTableFieldsSectionForm.this.mTableFieldsTableModel, fieldName, i2, false);
                    if (messages != null) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.removeRow(i2);
                    }
                    --i2;
                }
                if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Simple Type", (String)MessagePool.getMessage((String)"Simple type does not exist. Do you want to create simple type &?", (String)this.testText.getText()))) {
                    String projectName = AbstractTableFieldsSectionForm.this.mEditor.mMetamodel.getName();
                    DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
                    Element element = manager.getSimpleTypesEntity();
                    String packageName = (String)AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getValueAt(this.row, 3);
                    if (packageName.length() > 0) {
                        manager.setSimpleTypeName(packageName + "." + this.testText.getText());
                    } else {
                        manager.setSimpleTypeName(this.testText.getText());
                    }
                    CreateSimpleTypeAction mSimpleTypeAction = new CreateSimpleTypeAction();
                    mSimpleTypeAction.setSelectedElement(element);
                    mSimpleTypeAction.run(null);
                    String newName = this.testText.getText();
                    String newStPackage = "";
                    String newStName = "";
                    if (newName.indexOf(".") >= 0) {
                        newStPackage = newName.substring(0, newName.lastIndexOf("."));
                        newStName = newName.substring(newName.lastIndexOf(".") + 1, newName.length());
                    } else {
                        newStName = newName;
                        newStPackage = packageName;
                    }
                    try {
                        if (AbstractTableFieldsSectionForm.this.mDtDictionaryRoot.getSimpleType(newStPackage, newStName) != null) {
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(newStName, this.row, 4);
                            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(newStPackage, this.row, 3);
                            return null;
                        }
                    }
                    catch (Exception e) {
                        tracer.error("get simple type:", (Throwable)e);
                    }
                }
            }
            if (this.mPackage) {
                AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(st, this.row, 3);
                return null;
            }
            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 4);
            AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt("", this.row, 3);
            return "";
        }

        public Text getTextField() {
            return this.testText;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            String name = "";
            SimpletypeSelection selection = new SimpletypeSelection(AbstractTableFieldsSectionForm.this.mDtDictionaryRoot, AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getShell());
            if (selection.open()) {
                String pack = selection.getSimpleType().getPackage();
                String st = selection.getSimpleType().getName();
                AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(pack, this.row, 3);
                AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(st, this.row, 4);
                this.changed = true;
                return "@";
            }
            this.changed = true;
            return "@";
        }

        protected void updateContents(Object value) {
            String tableSpace = (String)value;
            if (tableSpace == null) {
                tableSpace = "";
            }
            this.testText.setText(tableSpace);
        }

        static /* synthetic */ boolean access$102(MyCellEditor x0, boolean x1) {
            x0.changed = x1;
            return x0.changed;
        }

        static /* synthetic */ void access$201(MyCellEditor x0, KeyEvent x1) {
            super.keyReleaseOccured(x1);
        }

        static /* synthetic */ int access$300(MyCellEditor x0) {
            return x0.col;
        }

        static /* synthetic */ AbstractTableFieldsSectionForm access$400(MyCellEditor x0) {
            return x0.AbstractTableFieldsSectionForm.this;
        }
    }

    private class MyTextCellEditor
    extends TextCellEditor {
        int col = 1;
        int row;

        public MyTextCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)"");
        }

        public void setFocus() {
            super.setFocus();
            this.row = AbstractTableFieldsSectionForm.this.mTableFieldsTableSection.getTableViewer().getTable().getSelectionIndex();
        }

        protected Object doGetValue() {
            Object obj = super.doGetValue();
            if (this.checkColumnName(obj)) {
                return obj;
            }
            super.fireCancelEditor();
            return null;
        }

        protected void focusLost() {
            String value = this.text.getText();
            if (this.checkColumnName(value)) {
                super.focusLost();
            } else {
                super.fireCancelEditor();
            }
        }

        protected void fireApplyEditorValue() {
            String value = this.text.getText();
            if (this.checkColumnName(value)) {
                super.fireApplyEditorValue();
            } else {
                super.fireCancelEditor();
            }
        }

        protected void fireCancelEditor() {
            if (this.row > -1 && AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount() > this.row) {
                AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.removeRow(this.row);
            }
            super.fireCancelEditor();
        }

        private boolean isUpperCase(String str) {
            boolean doit = false;
            int i = 0;
            while (i < str.length()) {
                if (Character.isLowerCase(str.charAt(i))) {
                    doit = true;
                    break;
                }
                ++i;
            }
            return !doit;
        }

        private boolean checkColumnName(Object value) {
            if (value instanceof String) {
                boolean isUpperCase = this.isUpperCase((String)value);
                String v = ((String)value).toUpperCase();
                if (v.length() == 0) {
                    if (AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount() > this.row) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.removeRow(this.row);
                    }
                    this.deactivate();
                    return false;
                }
                Vector messages = TableUtil.checkFieldName(AbstractTableFieldsSectionForm.this.mTableFieldsTableModel, v, this.row, false);
                if (messages != null) {
                    String str = (String)messages.get(0);
                    if (AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount() > this.row) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.removeRow(this.row);
                        TableMessageHandler.sendErrorMessage(v, str);
                    }
                    return false;
                }
                if (AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.getRowCount() > this.row) {
                    if (isUpperCase) {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAt(v, this.row, this.col);
                    } else {
                        AbstractTableFieldsSectionForm.this.mTableFieldsTableModel.setValueAtWithoutTableChangedEvent(v, this.row, this.col);
                    }
                }
                return true;
            }
            return false;
        }
    }

    private class MyLengthDecimalsCellEditor
    extends CellEditor {
        Text text;

        public MyLengthDecimalsCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            this.text = new Text(parent, this.getStyle());
            this.text.addTraverseListener(new TraverseListener(this){
                private final /* synthetic */ MyLengthDecimalsCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.text.addKeyListener((KeyListener)new KeyAdapter(this){
                private final /* synthetic */ MyLengthDecimalsCellEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyPressed(KeyEvent e) {
                    MyLengthDecimalsCellEditor.access$001(this.this$1, e);
                }
            });
            return this.text;
        }

        protected Object doGetValue() {
            String obj = this.text.getText();
            try {
                return new Integer(obj);
            }
            catch (Exception e) {
                if (obj.trim().length() == 0) {
                    return new Integer("0");
                }
                return null;
            }
        }

        protected void doSetValue(Object value) {
            if (value == null) {
                this.text.setText("");
            } else if (value instanceof Integer) {
                this.text.setText(((Integer)value).toString());
            }
        }

        protected void focusLost() {
            super.focusLost();
            this.doSetValue(this.getValue());
            this.fireApplyEditorValue();
        }

        protected void doSetFocus() {
            this.text.setFocus();
        }

        static /* synthetic */ void access$001(MyLengthDecimalsCellEditor x0, KeyEvent x1) {
            super.keyReleaseOccured(x1);
        }
    }
}

