/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.databasewizard;

import com.sap.dictionary.tools.tableeditor.util.DatabaseVendorMapping;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class DatabaseWizardPage
extends WizardPage {
    private MyDefaultTableModel model = null;
    private ISapTableViewer viewer = null;
    private DtDbTable mDtDbTable = null;
    private String mIndexName = null;
    private static String[] tableColumnProperties = new String[]{"message", "done"};
    private ICellModifier cellModifier = null;

    protected DatabaseWizardPage(String pageName, DtDbTable table, String indexName) {
        super(pageName);
        this.setTitle("Database Wizard");
        if (indexName == null) {
            this.setDescription("Choose database systems where table should not be created");
        } else {
            this.setDescription("Choose database systems where index should not be created");
        }
        this.mDtDbTable = table;
        this.mIndexName = indexName;
        this.cellModifier = new ICellModifier(){

            public Object getValue(Object element, String property) {
                return element;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
            }
        };
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        root.setLayout((Layout)layout);
        this.setControl((Control)root);
        IGridLayoutPane pane = PaneFactory.createGridLayoutPane((Composite)root, (int)1, (IWidgetFactory)new LiteWidgetFactory());
        this.model = new MyDefaultTableModel();
        this.model.addColumn(new String(""));
        this.model.addColumn(new String("Database System"));
        this.model.addColumn(new String("Delete If Existing"));
        String[] vendors = DatabaseVendorMapping.getVendorTitles();
        int i = 0;
        while (i < vendors.length) {
            this.model.addRow(new Object[]{new Boolean(false), vendors[i], new Boolean(false)});
            ++i;
        }
        int i2 = 0;
        while (i2 < this.model.getRowCount()) {
            String db = DatabaseVendorMapping.toInternal((String)this.model.getValueAt(i2, 1));
            if (this.mIndexName == null) {
                DtNoCreateCondition database = this.mDtDbTable.getNoCreationOnDatabase(db);
                if (database != null) {
                    this.model.setValueAt(new Boolean(true), i2, 0);
                    if (database.getDeleteIfExisting()) {
                        this.model.setValueAt(new Boolean(true), i2, 2);
                    }
                }
            } else {
                DtDbIndex index = this.mDtDbTable.getDbIndex(this.mIndexName);
                DtNoCreateCondition database = index.getNoCreationOnDatabase(db);
                if (database != null) {
                    this.model.setValueAt(new Boolean(true), i2, 0);
                    if (database.getDeleteIfExisting()) {
                        this.model.setValueAt(new Boolean(true), i2, 2);
                    }
                }
            }
            ++i2;
        }
        this.viewer = pane.addSapTableViewer((TableModel)this.model, pane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.viewer.setBooleanColumnHandler(0);
        this.viewer.setBooleanColumnHandler(2);
        this.viewer.getTable().getColumn(0).setWidth(22);
        this.viewer.getTable().getColumn(1).setWidth(150);
        this.viewer.getTable().getColumn(2).setWidth(100);
        this.viewer.getTableViewer().getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point pt = new Point(event.x, event.y);
                TableItem item = DatabaseWizardPage.this.viewer.getTableViewer().getTable().getItem(pt);
                if (item == null) {
                    return;
                }
                int i = 0;
                while (i < 3) {
                    Rectangle rect = item.getBounds(i);
                    if (rect.contains(pt)) {
                        int index = DatabaseWizardPage.this.viewer.getTableViewer().getTable().indexOf(item);
                        if (i == 0 || i == 2) {
                            Boolean bool = (Boolean)DatabaseWizardPage.this.model.getValueAt(index, i);
                            if (!bool.booleanValue()) {
                                DatabaseWizardPage.this.model.setValueAt(new Boolean(true), index, i);
                            } else {
                                DatabaseWizardPage.this.model.setValueAt(new Boolean(false), index, i);
                            }
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public String[] getSelectedDBSystems() {
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < this.model.getRowCount()) {
            Boolean bool = (Boolean)this.model.getValueAt(i, 0);
            if (bool.booleanValue()) {
                String db = DatabaseVendorMapping.toInternal((String)this.model.getValueAt(i, 1));
                temp.add(db);
            }
            ++i;
        }
        String[] dbstr = temp.toArray(new String[0]);
        return dbstr;
    }

    public boolean getCheck(String db) {
        int i = 0;
        while (i < this.model.getRowCount()) {
            String item = DatabaseVendorMapping.toInternal((String)this.model.getValueAt(i, 1));
            if (item.compareTo(db) == 0) {
                Boolean bool = (Boolean)this.model.getValueAt(i, 2);
                return bool;
            }
            ++i;
        }
        return false;
    }

    private class MyDefaultTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

