/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.databasewizard;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.databasewizard.DatabaseWizardPage;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class DatabaseWizard
extends Wizard
implements INewWizard {
    private static final String C_INDEX_WIZARD_PAGE = "C_DBSYSTEM";
    private DtDbTable mDbTable = null;
    String mIndexName = null;
    AbstractTableFieldsTableModel mTFModel;

    public DatabaseWizard(DtDbTable table, String indexName, AbstractTableFieldsTableModel tfmodel) {
        this.addPage((IWizardPage)new DatabaseWizardPage(C_INDEX_WIZARD_PAGE, table, indexName));
        this.mDbTable = table;
        this.mIndexName = indexName;
        this.mTFModel = tfmodel;
    }

    public boolean performFinish() {
        String[] dbs = ((DatabaseWizardPage)this.getPage(C_INDEX_WIZARD_PAGE)).getSelectedDBSystems();
        if (this.mIndexName == null) {
            DtNoCreateCondition[] temp = this.mDbTable.getNoCreationOnDatabases();
            int i = 0;
            while (i < temp.length) {
                try {
                    temp[i].delete();
                }
                catch (DeleteException e) {
                    TableEditorPlugin.tracer.error("delete nocreation property", (Throwable)e);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < dbs.length) {
                try {
                    DtNoCreateCondition database = this.mDbTable.createNoCreationOnDatabase(dbs[i2]);
                    database.setDatabase(DatabaseEnum.valueOf((String)dbs[i2]));
                    database.setDeleteIfExisting(((DatabaseWizardPage)this.getPage(C_INDEX_WIZARD_PAGE)).getCheck(dbs[i2]));
                }
                catch (CreateException e) {
                    TableEditorPlugin.tracer.error("create no creation on database property", (Throwable)e);
                }
                ++i2;
            }
            this.mTFModel.refreshAllJdbcTypeInfos();
        } else {
            DtDbIndex index = this.mDbTable.getDbIndex(this.mIndexName);
            DtNoCreateCondition[] temp = index.getNoCreationOnDatabases();
            int i = 0;
            while (i < temp.length) {
                try {
                    temp[i].delete();
                }
                catch (DeleteException e) {
                    TableEditorPlugin.tracer.error("delete index " + this.mIndexName, (Throwable)e);
                }
                ++i;
            }
            int i3 = 0;
            while (i3 < dbs.length) {
                try {
                    DtNoCreateCondition database = index.createNoCreationOnDatabase(dbs[i3]);
                    database.setDatabase(DatabaseEnum.valueOf((String)dbs[i3]));
                    database.setDeleteIfExisting(((DatabaseWizardPage)this.getPage(C_INDEX_WIZARD_PAGE)).getCheck(dbs[i3]));
                }
                catch (CreateException e) {
                    TableEditorPlugin.tracer.error("create nocreationondatabase", (Throwable)e);
                }
                ++i3;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

