/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor.attributes;

import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.databasewizard.DatabaseWizard;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtNoCreateCondition;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.glpc.form.SectionForm;
import com.tssap.util.ui.glpc.section.SimpleSection;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class TableAttributesForm
extends SectionForm {
    private TableEditor mEditor = null;
    private DtDbTable mDtDbTable = null;
    private Label mErrorLabel = null;
    private Label mMarker = null;
    private TableFieldsTableModel mTableFieldsTableModel = null;

    public TableAttributesForm(IWidgetFactory widgetFactory, int columns, String title, TableEditor editor) {
        super(widgetFactory, columns, true, title);
        this.mEditor = editor;
        this.mDtDbTable = this.mEditor.mDtDbTable;
        this.mTableFieldsTableModel = (TableFieldsTableModel)this.mEditor.getTableForm().getTableFieldsTableModel();
    }

    public void initSectionForm(IGridLayoutPane glp) {
        this.createAttributesSection(glp);
    }

    private void createAttributesSection(IGridLayoutPane glp) {
        SimpleSection attrSection = new SimpleSection((IWidgetFactory)new LiteWidgetFactory(), 4, false, "Table Buffering", "Define technical attributes for the table");
        glp.addGridLayoutPaneContainer((IGridLayoutPaneContainer)attrSection, glp.createGridLayoutData(1, 1, 1, 1));
        final Button selBuf = attrSection.getClientArea().addCheckBox("Table buffering. Set key column count:");
        if (this.mEditor.isReadOnly()) {
            selBuf.setEnabled(false);
        }
        final Combo combo = attrSection.getClientArea().addComboBox(new String[0], true);
        combo.add("____________________________________");
        if (this.mDtDbTable.hasTechnicalSettings()) {
            if (this.mDtDbTable.getTechnicalSettings().getIsBuffered()) {
                combo.setEnabled(true);
                this.addKeyCountForTableBufferingInComboBox(combo);
                int keyCount = this.mDtDbTable.getTechnicalSettings().getGenKeyCount();
                combo.select(keyCount);
                selBuf.setSelection(true);
            } else {
                combo.setEnabled(false);
            }
        } else {
            combo.setEnabled(false);
        }
        if (this.mEditor.isReadOnly()) {
            combo.setEnabled(false);
        }
        combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                TableAttributesForm.this.addKeyCountForTableBufferingInComboBox(combo);
                if (TableAttributesForm.this.mDtDbTable.hasTechnicalSettings()) {
                    int keyCount = TableAttributesForm.this.mDtDbTable.getTechnicalSettings().getGenKeyCount();
                    combo.select(keyCount);
                }
            }
        });
        selBuf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                super.widgetSelected(arg0);
                if (selBuf.getSelection()) {
                    combo.setEnabled(true);
                    TableAttributesForm.this.addKeyCountForTableBufferingInComboBox(combo);
                    if (TableAttributesForm.this.mDtDbTable.hasTechnicalSettings()) {
                        TableAttributesForm.this.mDtDbTable.getTechnicalSettings().setIsBuffered(true);
                    } else {
                        try {
                            TableAttributesForm.this.mDtDbTable.createTechnicalSettings().setIsBuffered(true);
                        }
                        catch (CreateException e) {
                            TableMessageHandler.sendErrorMessage("Metadata API", "Technical settings could not be created");
                        }
                    }
                } else {
                    combo.setEnabled(false);
                    TableAttributesForm.this.mErrorLabel.setVisible(false);
                    TableAttributesForm.this.mDtDbTable.getTechnicalSettings().setIsBuffered(false);
                }
                TableAttributesForm.this.mEditor.setDataChanged();
            }
        });
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                int selIndex = combo.getSelectionIndex();
                TableAttributesForm.this.mDtDbTable.getTechnicalSettings().setGenKeyCount(selIndex);
            }
        });
        this.mMarker = attrSection.getClientArea().addImage(SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_ERROR_TSK"), false);
        this.mMarker.setVisible(false);
        this.mErrorLabel = attrSection.getClientArea().addTextLabel("Table buffering. Set key column count:");
        this.mErrorLabel.setVisible(false);
        Button advancedButton = attrSection.getClientArea().addPushButton("Advanced...");
        if (this.mEditor.isReadOnly()) {
            advancedButton.setEnabled(false);
        }
        attrSection.getClientArea().addTextLabel("");
        attrSection.getClientArea().addTextLabel("");
        attrSection.getClientArea().addTextLabel("");
        final Button sel = attrSection.getClientArea().addCheckBox("Do not create table on selected database systems");
        final Button edit = attrSection.getClientArea().addPushButton("Edit...");
        if (this.mDtDbTable.getNoCreationOnDatabaseCount() > 0) {
            edit.setEnabled(true);
            sel.setSelection(true);
        } else {
            edit.setEnabled(false);
            sel.setSelection(false);
        }
        if (this.mEditor.isReadOnly()) {
            edit.setEnabled(false);
            sel.setEnabled(false);
        }
        sel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (sel.getSelection()) {
                    edit.setEnabled(true);
                } else {
                    edit.setEnabled(false);
                    DtNoCreateCondition[] temp = TableAttributesForm.this.mDtDbTable.getNoCreationOnDatabases();
                    int i = 0;
                    while (i < temp.length) {
                        try {
                            temp[i].delete();
                        }
                        catch (DeleteException e2) {
                            TableEditorPlugin.tracer.error("delete no creations on database of " + TableAttributesForm.this.mDtDbTable.getName(), (Throwable)e2);
                        }
                        TableAttributesForm.this.mEditor.setDataChanged();
                        ++i;
                    }
                    TableAttributesForm.this.mTableFieldsTableModel.refreshAllJdbcTypeInfos();
                }
            }
        });
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                DatabaseWizard dbWizard = new DatabaseWizard(TableAttributesForm.this.mDtDbTable, null, TableAttributesForm.this.mTableFieldsTableModel);
                WizardDialog wizardDialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)dbWizard);
                wizardDialog.open();
                TableAttributesForm.this.mEditor.setDataChanged();
            }
        });
        attrSection.getClientArea().addTextLabel("");
        advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                super.widgetSelected(arg0);
                if (sel.isVisible()) {
                    sel.setVisible(false);
                    edit.setVisible(false);
                } else {
                    sel.setVisible(true);
                    edit.setVisible(true);
                }
            }
        });
        sel.setVisible(false);
        edit.setVisible(false);
    }

    private void addKeyCountForTableBufferingInComboBox(Combo combo) {
        combo.removeAll();
        combo.add("0 (Fully Buffered)");
        int maxKeyCount = 0;
        int i = 0;
        while (i < this.mTableFieldsTableModel.getRowCount()) {
            Boolean key = (Boolean)this.mTableFieldsTableModel.getValueAt(i, 2);
            if (key.booleanValue()) {
                ++maxKeyCount;
            }
            ++i;
        }
        int keyCount = 0;
        int i2 = 0;
        while (i2 < this.mTableFieldsTableModel.getRowCount()) {
            Boolean key = (Boolean)this.mTableFieldsTableModel.getValueAt(i2, 2);
            if (key.booleanValue()) {
                if (++keyCount < maxKeyCount) {
                    combo.add(String.valueOf(keyCount) + "  (Generic Area Buffered)");
                } else if (keyCount == maxKeyCount) {
                    combo.add(String.valueOf(keyCount) + " (Single Records Buffered)");
                }
            }
            ++i2;
        }
    }
}

