/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TableNewWizardPage
extends WizardPage {
    private ISelection mSelection;
    private Text mPackageName;
    private Text mTableName;
    private static final String PAGE_NAME = "New Database Table";
    private static final String PAGE_TITLE = "New Database Table";

    public TableNewWizardPage(ISelection selection) {
        super("New Database Table");
        this.setTitle("New Database Table");
        this.setDescription("Create a new database table");
        this.mSelection = selection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        composite.setLayoutData((Object)gridData);
        IGridLayoutPane gridLayoutPane = PaneFactory.createGridLayoutPane((Composite)composite, (int)2);
        gridLayoutPane.addTextLabel("Table");
        this.mTableName = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mTableName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableNewWizardPage.this.dialogChanged();
            }
        });
        gridLayoutPane.addTextLabel("Package");
        this.mPackageName = gridLayoutPane.addTextField("", false, gridLayoutPane.createGridLayoutData(4, 2, true, false, 1, 1));
        this.mPackageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TableNewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void initialize() {
        this.mTableName.setText("PREFIX_new_table");
    }

    private void dialogChanged() {
        String packageName = this.getPackageName();
        String tableName = this.getTableName();
        String suffix = null;
        String prefix = null;
        if (tableName.length() == 0) {
            this.updateStatus("Table must be specified");
            return;
        }
        if (packageName.length() == 0) {
            this.updateStatus("Package must be specified");
            return;
        }
        if (tableName.length() > 16) {
            this.updateStatus("Table name must not contain more than 16 characters ");
            return;
        }
        if (!Character.isLetter(tableName.charAt(0))) {
            this.updateStatus("Table name must start with a letter");
            return;
        }
        int index = tableName.indexOf("_");
        if (index == -1) {
            this.updateStatus("Table name must contain '_'");
            return;
        }
        prefix = tableName.substring(0, index);
        suffix = tableName.length() > index + 1 ? tableName.substring(index + 1) : "";
        if (prefix.length() < 3) {
            this.updateStatus("Prefix of table name must contain at least 3 characters");
            return;
        }
        int i = 0;
        while (i < prefix.length()) {
            if (!Character.isLetterOrDigit(prefix.charAt(i))) {
                this.updateStatus("Prefix of table name may only contain alphanumeric characters");
                return;
            }
            ++i;
        }
        if (TableUtil.stringIsEmpty(suffix)) {
            this.updateStatus("Table name must contain at least one more character after '_'");
            return;
        }
        int i2 = 0;
        while (i2 < suffix.length()) {
            if (!Character.isLetterOrDigit(suffix.charAt(i2)) && suffix.charAt(i2) != '_') {
                this.updateStatus("Suffix of table name may only contain alphanumeric characters and '_'");
                return;
            }
            ++i2;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getPackageName() {
        return this.mPackageName.getText();
    }

    public String getTableName() {
        return this.mTableName.getText();
    }
}

