/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.TableNewWizardPage;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.FieldTypeEnum;
import com.sap.ide.metamodel.dictionary.datatype.StructureTypeEnum;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.exception.CreateException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TableNewWizard
extends Wizard
implements INewWizard {
    private TableNewWizardPage mTableNewWizardPage;
    private ISelection mSelection;

    public TableNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mTableNewWizardPage = new TableNewWizardPage(this.mSelection);
        this.addPage((IWizardPage)this.mTableNewWizardPage);
    }

    public boolean performFinish() {
        String packageName = this.mTableNewWizardPage.getPackageName();
        String tableName = this.mTableNewWizardPage.getTableName();
        DtDbTable dtDbTable = null;
        DtField dtField = null;
        MetamodelManager metamodelManager = null;
        Metamodel metamodel = null;
        DtDictionaryRoot dtDictionaryRoot = null;
        Object dictType = null;
        Object dictSimpleTypes = null;
        try {
            metamodelManager = MetamodelManager.getMetamodelManager((String)"JavaProject01");
            metamodel = metamodelManager.getMetamodel();
            dtDictionaryRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel);
        }
        catch (Exception e) {
            TableMessageHandler.sendErrorMessage("Error", e.getMessage());
            return false;
        }
        if (!dtDictionaryRoot.hasTable(packageName, tableName)) {
            try {
                dtDbTable = dtDictionaryRoot.createTable(packageName, tableName);
            }
            catch (CreateException e) {
                TableMessageHandler.sendErrorMessage("Metadata API", "Table " + tableName + " could not be created");
                TableEditorPlugin.tracer.error("create table" + tableName, (Throwable)e);
                return false;
            }
        } else {
            TableMessageHandler.sendErrorMessage("Error in creating table", "Table " + tableName + " already exists");
            return false;
        }
        try {
            dtDbTable.setStructureType(StructureTypeEnum.FLAT);
            dtField = dtDbTable.createStructureElementAsDtField("NEW_COLUMN");
            dtField.setPosition(0);
            dtField.setFieldType(FieldTypeEnum.SIMPLE);
            metamodel.commitChanges();
        }
        catch (Exception e) {
            TableMessageHandler.sendErrorMessage("Error in creating table", e.getMessage());
            TableEditorPlugin.tracer.error("create table" + tableName, (Throwable)e);
            return false;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            TableMessageHandler.sendErrorMessage("Error in refreshing workspace", e.getMessage());
            return false;
        }
        String containerName = "/JavaProject01/" + packageName;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        try {
            if (!(resource instanceof IContainer) || resource != null && !resource.exists()) {
                TableMessageHandler.sendErrorMessage("Error", "Container \"" + containerName + "\" does not exist.");
            }
        }
        catch (Exception e) {
            TableMessageHandler.sendErrorMessage("Error", "Container \"" + containerName + "\" does not exist.");
            TableEditorPlugin.tracer.error("open table editor", (Throwable)e);
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(tableName + ".dtdbtable"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor(file);
                }
                catch (PartInitException e) {
                    TableEditorPlugin.tracer.error("open editor", (Throwable)e);
                }
            }
        });
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mSelection = selection;
    }
}

