/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditorPreferencePage;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TableEditorPlugin
extends AbstractUIPlugin {
    private static TableEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    public static TracerI tracer;
    private EditorPartListener mPartListener;
    private IPartService mPartService;
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$TableEditorPlugin;

    public TableEditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.dictionary.tools.tableeditor.TableEditorPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        IWorkbench workbench = TableEditorPlugin.getDefault().getWorkbench();
        this.mPartService = workbench.getActiveWorkbenchWindow().getPartService();
        this.mPartListener = new EditorPartListener();
        this.mPartService.addPartListener((IPartListener)this.mPartListener);
    }

    public static TableEditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TableEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static TableEditorPlugin getInstance() {
        return plugin;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        store.setDefault(TableEditorPreferencePage.key, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$TableEditorPlugin == null ? (class$com$sap$dictionary$tools$tableeditor$TableEditorPlugin = TableEditorPlugin.class$("com.sap.dictionary.tools.tableeditor.TableEditorPlugin")) : class$com$sap$dictionary$tools$tableeditor$TableEditorPlugin));
    }

    private class EditorPartListener
    implements IPartListener {
        private EditorPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof TableEditor) {
                TableEditor editor = (TableEditor)part;
                if (editor.getTableFieldsSectionForm() == null) {
                    return;
                }
                AbstractTableFieldsTableModel tableModel = editor.getTableFieldsSectionForm().getTableFieldsTableModel();
                if (editor.outlinePage != null) {
                    editor.outlinePage.tableModelChanged(tableModel);
                }
                int i = 0;
                while (i < tableModel.getRowCount()) {
                    String pack;
                    Object[] objects;
                    String st = (String)tableModel.getValueAt(i, 4);
                    if (st.length() > 0 && (objects = TableUtil.getSimpleTypeAttributes(pack = (String)tableModel.getValueAt(i, 3), st, editor.mDtDictionaryRoot)) != null) {
                        tableModel.setValueAtWithoutTableChangedEvent(objects[5], i, 5);
                        tableModel.setValueAtWithoutTableChangedEvent(objects[6], i, 6);
                        tableModel.setValueAtWithoutTableChangedEvent(objects[7], i, 7);
                        tableModel.setValueAtWithoutTableChangedEvent(objects[8], i, 8);
                        tableModel.setValueAtWithoutTableChangedEvent(objects[9], i, 9);
                        tableModel.setValueAtWithoutTableChangedEvent(objects[10], i, 10);
                    }
                    ++i;
                }
                if (AbstractTableEditor.mManager != null) {
                    AbstractTableEditor.mStatusItem.setVisible(true);
                    AbstractTableEditor.mManager.update(true);
                    if (editor.isReadOnly()) {
                        AbstractTableEditor.mStatusItem.setText("Read Only");
                    } else {
                        AbstractTableEditor.mStatusItem.setText("Writable");
                    }
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof TableEditor) {
                TableEditor editor = (TableEditor)part;
                if (AbstractTableEditor.mManager != null) {
                    AbstractTableEditor.mStatusItem.setVisible(false);
                    AbstractTableEditor.mManager.update(true);
                }
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part instanceof TableEditor) {
                TableEditor editor = (TableEditor)part;
                if (AbstractTableEditor.mManager != null) {
                    AbstractTableEditor.mStatusItem.setVisible(false);
                    AbstractTableEditor.mManager.update(true);
                }
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

