/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.CopyPasteColoumnsHelper;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.fields.TableColumnTransfer;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class TableEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;

    public TableEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        Display disp = Display.getCurrent();
        final IWorkbenchPage wpage = page;
        Action copAction = new Action(){

            public void run() {
                super.run();
                IEditorPart part = wpage.getActiveEditor();
                if (part instanceof AbstractTableEditor) {
                    AbstractTableEditor editor = (AbstractTableEditor)part;
                    CopyPasteColoumnsHelper.copyColumns(editor);
                }
            }
        };
        bars.setGlobalActionHandler("copy", (IAction)copAction);
        Action pastAction = new Action(){

            public void run() {
                super.run();
                IEditorPart part = wpage.getActiveEditor();
                if (part instanceof AbstractTableEditor) {
                    AbstractTableEditor editor = (AbstractTableEditor)part;
                    CopyPasteColoumnsHelper.pasteColumns(editor);
                }
            }
        };
        bars.setGlobalActionHandler("paste", (IAction)pastAction);
        Action cutAction = new Action(){

            public void run() {
                super.run();
                IEditorPart part = wpage.getActiveEditor();
                if (part instanceof AbstractTableEditor) {
                    AbstractTableEditor editor = (AbstractTableEditor)part;
                    CopyPasteColoumnsHelper.cutColumns(editor);
                }
            }
        };
        bars.setGlobalActionHandler("cut", (IAction)cutAction);
        Action selectAllAction = new Action(){

            public void run() {
                super.run();
                IEditorPart part = wpage.getActiveEditor();
                if (part instanceof TableEditor) {
                    TableEditor editor = (TableEditor)part;
                    if (editor.getCurrentTableEditorPage() != 0) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Select all ", (String)"This function works only with table columns view.");
                        return;
                    }
                    Table table = editor.getTableFieldsSectionForm().getTableSection().getTableViewer().getTable();
                    table.selectAll();
                }
            }
        };
        bars.setGlobalActionHandler("selectAll", (IAction)selectAllAction);
        bars.updateActionBars();
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
    }

    private void copyColumns(Display disp, TableEditor editor, int[] sel) {
        Clipboard clipboard = new Clipboard(disp);
        Object[] rows = new Vector[]{new Vector()};
        int i = 0;
        while (i < sel.length) {
            rows[0].add(Arrays.asList(editor.getTableFieldsSectionForm().getTableFieldsTableModel().getRow(sel[i])));
            ++i;
        }
        Transfer[] transferTypes = new Transfer[]{TableColumnTransfer.getInstance()};
        clipboard.setContents(rows, transferTypes);
        clipboard.dispose();
    }

    private void createActions() {
    }

    public void contributeToMenu(IMenuManager manager) {
    }

    public void contributeToToolBar(IToolBarManager manager) {
    }
}

