/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.attributes.TableAttributesForm;
import com.sap.dictionary.tools.tableeditor.attributes.TableDbPropertiesSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.TableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.indexes.TableIndexForm;
import com.sap.dictionary.tools.tableeditor.outline.OutlinePage;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.AdvancedTextInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.core.editor.IDevelopmentObjectEditor;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.DefaultWidgetFactory;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TableEditor
extends AbstractTableEditor
implements IDevelopmentObjectEditor {
    public DtDbTable mDtDbTable = null;
    public TableIndexForm mTableIndexForm = null;
    public TableDbPropertiesSectionForm mTableDbPropertiesSectionForm = null;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    protected void createPages() {
        this.readUserXMLFile();
        this.createFieldsPage();
        this.createIndexPage();
        this.createAttributesPage();
        this.readOnly = this.isReadOnly() ? 0 : 1;
        if (this.advancedGui) {
            this.createAdGui();
        }
    }

    protected void createAdGui() {
        Composite composite = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        final Combo combo = new Combo(composite, 4);
        combo.add(this.mDtDbTable.getAbsolutePath());
        DtDbIndex[] indexes = this.mDtDbTable.getDbIndexes();
        int i = 0;
        while (i < indexes.length) {
            combo.add(indexes[i].getAbsolutePath());
            ++i;
        }
        final TextViewer viewer = new TextViewer(composite, 768);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setEditable(false);
        viewer.setDocument((IDocument)new Document());
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        viewer.getTextWidget().setFont(font);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                try {
                    FileReader read = new FileReader(combo.getText());
                    BufferedReader reader = new BufferedReader(read);
                    StringBuffer buf = new StringBuffer();
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        buf.append(line + "\n");
                    }
                    viewer.getDocument().set(buf.toString());
                }
                catch (Exception e2) {
                    TableEditorPlugin.tracer.error("add combo box", (Throwable)e2);
                }
            }
        });
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Xml");
    }

    protected void createFieldsPage() {
        ScrolledComposite sc = new ScrolledComposite(this.getContainer(), 768);
        sc.setLayout((Layout)new FillLayout());
        sc.setAlwaysShowScrollBars(false);
        sc.getVerticalBar().setIncrement(10);
        sc.getVerticalBar().setPageIncrement(100);
        sc.getHorizontalBar().setIncrement(10);
        sc.getHorizontalBar().setPageIncrement(100);
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mTableFieldsSectionForm = new TableFieldsSectionForm((IWidgetFactory)new LiteWidgetFactory(), 1, "Edit table", this, this.mTableName, this.mDtDbTable, this.mDtDictionaryRoot);
        PaneFactory.establishGridLayoutPaneContainer((Composite)composite, (IGridLayoutPaneContainer)this.mTableFieldsSectionForm);
        if (this.isReadOnly()) {
            Table lTable = ((TableFieldsSectionForm)this.mTableFieldsSectionForm).getTableSection().getTableViewer().getTable();
            TableItem[] lItems = lTable.getItems();
            int i = 0;
            while (i < lItems.length) {
                lItems[i].setForeground(Display.getCurrent().getSystemColor(15));
                ++i;
            }
            Vector edits = this.mTableFieldsSectionForm.tableEditorDbDefaultInputFieldVector;
            int i2 = 0;
            while (i2 < edits.size()) {
                org.eclipse.swt.custom.TableEditor editor = (org.eclipse.swt.custom.TableEditor)edits.get(i2);
                AdvancedTextInput input = (AdvancedTextInput)editor.getEditor();
                input.setForeground(Display.getCurrent().getSystemColor(15));
                ++i2;
            }
        }
        composite.setSize(800, 600);
        int index = this.addPage((Control)sc);
        this.setPageText(index, "Columns");
    }

    private void createDbPropertiesPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mTableDbPropertiesSectionForm = new TableDbPropertiesSectionForm((IWidgetFactory)new DefaultWidgetFactory(), 1, "Edit table", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)composite, (IGridLayoutPaneContainer)this.mTableDbPropertiesSectionForm);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "DB Properties");
    }

    private void createIndexPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        this.mTableIndexForm = new TableIndexForm((IWidgetFactory)new LiteWidgetFactory(), 2, "Indexes", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)composite, (IGridLayoutPaneContainer)this.mTableIndexForm);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Indexes");
    }

    private void createAttributesPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        TableAttributesForm attrForm = new TableAttributesForm((IWidgetFactory)new LiteWidgetFactory(), 1, "Technical Settings", this);
        PaneFactory.establishGridLayoutPaneContainer((Composite)composite, (IGridLayoutPaneContainer)attrForm);
        int index = this.addPage((Control)composite);
        this.setPageText(index, "Technical Settings");
    }

    public boolean isReadOnly() {
        if (this.mDtDbTable == null) {
            AbstractTableEditor.tracer.error("mDtDbTable = null.");
            return true;
        }
        if (this.mDtDbTable.isReadOnly()) {
            return true;
        }
        String masterLanguage = this.mDtDbTable.getMasterLanguage();
        TextPool textPool = this.mDtDbTable.getTextPool();
        if (textPool != null && textPool.isReadOnly(masterLanguage)) {
            return true;
        }
        String predefinedAction = this.mDtDbTable.getPredefinedAction();
        return predefinedAction != null && predefinedAction.equals("DROP");
    }

    public boolean isDeleted() {
        String predefinedAction = this.mDtDbTable.getPredefinedAction();
        return predefinedAction != null && predefinedAction.equals("DROP");
    }

    protected void initMetamodelFile(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        String lFileName;
        IFile file = ((IFileEditorInput)editorInput).getFile();
        this.mTableName = lFileName = file.getFullPath().removeFileExtension().lastSegment();
        this.setTitle(lFileName);
        IProject project = file.getProject();
        String lProjectName = project.getName();
        if (!ServicesEclipse.projectHasDictionaryNature((String)lProjectName)) {
            throw new PartInitException(MessagePool.getMessage((String)"Project & does not have dictionary nature", (String)lProjectName));
        }
        try {
            this.mMetamodelManager = MetamodelManager.getMetamodelManager((String)lProjectName);
            this.mMetamodel = this.mMetamodelManager.getMetamodel();
            this.mDtDictionaryRoot = MetamodelServices.getDictionaryRoot((String)lProjectName);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new PartInitException(e.getMessage());
        }
        if (!this.mDtDictionaryRoot.hasTable("", this.mTableName)) {
            this.mDtDbTable = null;
        } else {
            try {
                this.mDtDbTable = this.mDtDictionaryRoot.getTable("", this.mTableName);
                if (this.mDtDbTable == null) {
                    throw new LoadException(MessagePool.getMessage((String)"Table & does not exist", (String)this.mTableName));
                }
            }
            catch (LoadException e) {
                TableMessageHandler.sendErrorMessage("Metadata API", e.getMessage());
                throw new PartInitException(e.getMessage());
            }
        }
    }

    protected void initMetamodelUml(IEditorInput editorInput) throws PartInitException {
        try {
            this.mMetamodel = ((EditDbTableInput)editorInput).metamodel;
            this.mDtDictionaryRoot = ((EditDbTableInput)editorInput).dictRoot;
            this.mDtDbTable = ((EditDbTableInput)editorInput).dictDbTable;
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage());
        }
        this.mTableName = this.mDtDbTable.getName();
        if (this.mTableName == null) {
            this.mTableName = "";
        }
    }

    public TableFieldsSectionForm getTableFieldsSectionForm() {
        return (TableFieldsSectionForm)this.mTableFieldsSectionForm;
    }

    public void setIndexPage(String indexName) {
        this.setActivePage(1);
        TableItem[] items = this.mTableIndexForm.indexSection.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (indexName.equals(items[i].getText())) {
                this.mTableIndexForm.indexSection.getTableViewer().getTable().setSelection(i);
                this.mTableIndexForm.fillIndexPage(i);
                break;
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = TableEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage) && this.mTableIndexForm != null) {
            this.outlinePage = new OutlinePage(this, ((TableFieldsSectionForm)this.mTableFieldsSectionForm).getTableFieldsTableModel());
            this.mTableIndexForm.indexFieldTableModel.setOutlinePage(this.outlinePage);
            this.mTableIndexForm.indexTableModel.setOutlinePage(this.outlinePage);
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public DtDbTable getDtDbTable() {
        return this.mDtDbTable;
    }

    protected DtStructure getStructure() {
        return this.mDtDbTable;
    }

    public TableFieldsSectionForm getTableForm() {
        return (TableFieldsSectionForm)this.mTableFieldsSectionForm;
    }

    public TableIndexForm getIndexForm() {
        return this.mTableIndexForm;
    }

    protected void refreshIndexPage(boolean setReadOnlyColors) {
        int idx = this.mTableIndexForm.getIndexSection().getSelectionIndex();
        this.mTableIndexForm.fillIndexPage(idx);
        if (setReadOnlyColors) {
            this.mTableIndexForm.setReadOnlyColors();
        }
    }

    protected AbstractUIPlugin getPluginInstance() {
        return TableEditorPlugin.getInstance();
    }

    protected DictionaryImage getDictionaryImage() {
        return DictionaryImage.ICON_OUTLINE_UITABLE;
    }

    public DevelopmentObject getDevelopmentObject() {
        return this.mDtDbTable;
    }

    public void updateUI() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

