/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.AbstractTableEditor;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.fields.TableColumnTransfer;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class CopyPasteColoumnsHelper {
    public static void copyColumns(AbstractTableEditor editor) {
        if (editor.getCurrentTableEditorPage() == 1) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy&Paste", (String)"Copy&Paste is only available in table columns page");
            return;
        }
        if (editor.getCurrentTableEditorPage() == 0) {
            if (editor.getSectionForm().getTableSection().getTableViewer().getTable().isFocusControl()) {
                if (!editor.isDeleted()) {
                    int[] sel = editor.getSectionForm().getTableSection().getTableViewer().getTable().getSelectionIndices();
                    if (sel.length > 0) {
                        CopyPasteColoumnsHelper.copyColumns(Display.getCurrent(), editor, sel);
                        editor.getSectionForm().getTableSection().getTableViewer().getTable().deselectAll();
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy", (String)"Select a column in table editor to be copied");
                    }
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy", (String)"Table is deleted. You cannot copy any columns of this table.");
                }
            } else if (editor.getSectionForm().mTableName.isFocusControl()) {
                editor.getSectionForm().mTableName.copy();
            } else if (editor.getSectionForm().mTableDescription.isFocusControl()) {
                editor.getSectionForm().mTableDescription.copy();
            } else {
                TableViewer viewer = editor.getSectionForm().getTableSection().getTableViewer().getTableViewer();
                if (viewer.isCellEditorActive()) {
                    CellEditor[] editors = viewer.getCellEditors();
                    int i = 0;
                    while (i < editors.length) {
                        if (editors[i].isActivated()) {
                            editors[i].performCopy();
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public static void pasteColumns(AbstractTableEditor editor) {
        AbstractTableFieldsTableModel model = editor.getSectionForm().getTableFieldsTableModel();
        if (editor.getCurrentTableEditorPage() == 1) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy&Paste", (String)"Copy&Paste is only available in table columns page");
            return;
        }
        if (editor.getCurrentTableEditorPage() == 0 && !editor.isReadOnly()) {
            if (editor.getSectionForm().getTableSection().getTableViewer().getTable().isFocusControl()) {
                CopyPasteColoumnsHelper.pasteToTable(editor);
            } else if (editor.getSectionForm().mTableName.isFocusControl()) {
                editor.getSectionForm().mTableName.paste();
            } else if (editor.getSectionForm().mTableDescription.isFocusControl()) {
                editor.getSectionForm().mTableDescription.paste();
            } else {
                TableViewer viewer = editor.getSectionForm().getTableSection().getTableViewer().getTableViewer();
                if (viewer.isCellEditorActive()) {
                    CellEditor[] editors = viewer.getCellEditors();
                    int i = 0;
                    while (i < editors.length) {
                        if (editors[i].isActivated()) {
                            editors[i].performPaste();
                            break;
                        }
                        ++i;
                    }
                } else {
                    CopyPasteColoumnsHelper.pasteToTable(editor);
                }
            }
        }
    }

    private static void pasteToTable(AbstractTableEditor editor) {
        AbstractTableFieldsTableModel model = editor.getSectionForm().getTableFieldsTableModel();
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Object obj = clipboard.getContents((Transfer)TableColumnTransfer.getInstance());
        if (obj instanceof Vector[]) {
            Vector[] data = (Vector[])obj;
            int i = 0;
            while (i < data.length) {
                String oldName;
                ArrayList<String> colList = new ArrayList<String>();
                int j = 0;
                while (j < model.getRowCount()) {
                    String fname = (String)model.getValueAt(j, 1);
                    colList.add(fname);
                    ++j;
                }
                String newName = oldName = (String)data[i].get(1);
                int counter = 1;
                while (colList.indexOf(newName) != -1) {
                    newName = "COPY" + counter + "_" + oldName;
                    ++counter;
                }
                data[i].set(1, newName);
                String stPackage = (String)data[i].get(3);
                String stName = (String)data[i].get(4);
                if (stPackage != null && stPackage.length() > 0) {
                    try {
                        DtSimpleType simpleType = model.getDictionaryRoot().getSimpleType(stPackage, stName);
                        if (simpleType == null) {
                            data[i].set(3, "");
                            data[i].set(4, "");
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                int idx = editor.getSectionForm().getTableSection().getTableViewer().getTable().getSelectionIndex();
                if (!editor.getSectionForm().getTableSection().getTableViewer().getTable().isFocusControl()) {
                    idx = -1;
                }
                if (idx == -1) {
                    model.addRow(data[i].toArray());
                } else {
                    model.insertRow(idx, data[i].toArray());
                }
                if (idx == -1) {
                    idx = model.getRowCount() - 1;
                }
                TableItem item = editor.getSectionForm().getTableSection().getTableViewer().getTable().getItem(idx);
                editor.getSectionForm().getTableSection().checkFieldName(model.getFieldName(idx), idx, item);
                ++i;
            }
        }
        clipboard.dispose();
    }

    public static void cutColumns(AbstractTableEditor editor) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        int[] sel = editor.getSectionForm().getTableSection().getTableViewer().getTable().getSelectionIndices();
                        if (editor.getCurrentTableEditorPage() == 1) {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy&Paste", (String)"Copy&Paste is only available in table columns page");
                            return;
                        }
                        if (editor.getCurrentTableEditorPage() != 0) break block9;
                        if (!editor.getSectionForm().getTableSection().getTableViewer().getTable().isFocusControl()) break block10;
                        if (!editor.isDeleted()) {
                            if (sel.length > 0) {
                                CopyPasteColoumnsHelper.copyColumns(Display.getCurrent(), editor, sel);
                                int k = sel.length - 1;
                                while (k >= 0) {
                                    String fieldName = (String)editor.getSectionForm().getTableFieldsTableModel().getValueAt(sel[k], 1);
                                    if (editor.getStructure() instanceof DtDbTable) {
                                        DtDbTable dtDbTable = (DtDbTable)editor.getStructure();
                                        TableUtil.dbIndexDeletionCheck(fieldName, dtDbTable);
                                    }
                                    editor.getSectionForm().getTableFieldsTableModel().removeRow(sel[k]);
                                    --k;
                                }
                            } else {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Cut", (String)"Select a column in table editor to be copied");
                            }
                        } else {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Cut", (String)"Table is deleted. You cannot copy any columns of this table.");
                        }
                        break block9;
                    }
                    if (!editor.getSectionForm().mTableName.isFocusControl()) break block11;
                    editor.getSectionForm().mTableName.cut();
                    break block9;
                }
                if (!editor.getSectionForm().mTableDescription.isFocusControl()) break block12;
                editor.getSectionForm().mTableDescription.cut();
                break block9;
            }
            TableViewer viewer = editor.getSectionForm().getTableSection().getTableViewer().getTableViewer();
            if (!viewer.isCellEditorActive()) break block9;
            CellEditor[] editors = viewer.getCellEditors();
            int i = 0;
            while (i < editors.length) {
                if (editors[i].isActivated()) {
                    editors[i].performCut();
                    break;
                }
                ++i;
            }
        }
    }

    private static void copyColumns(Display disp, AbstractTableEditor editor, int[] sel) {
        Clipboard clipboard = new Clipboard(disp);
        Object[] rows = new Vector[]{new Vector()};
        int i = 0;
        while (i < sel.length) {
            rows[0].add(Arrays.asList(editor.getSectionForm().getTableFieldsTableModel().getRow(sel[i])));
            ++i;
        }
        Transfer[] transferTypes = new Transfer[]{TableColumnTransfer.getInstance()};
        clipboard.setContents(rows, transferTypes);
        clipboard.dispose();
    }
}

