/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tableeditor;

import com.sap.dictionary.tools.tableeditor.ReadWriteStatusItem;
import com.sap.dictionary.tools.tableeditor.TableEditorPlugin;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsSectionForm;
import com.sap.dictionary.tools.tableeditor.fields.AbstractTableFieldsTableModel;
import com.sap.dictionary.tools.tableeditor.outline.OutlinePage;
import com.sap.dictionary.tools.tableeditor.util.TableMessageHandler;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditStructureInput;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractTableEditor
extends MultiPageEditorPart
implements IMetamodelSaveParticipant {
    protected AbstractTableFieldsSectionForm mTableFieldsSectionForm = null;
    public DtDictionaryRoot mDtDictionaryRoot;
    public Metamodel mMetamodel;
    protected MetamodelManager mMetamodelManager;
    protected AbstractTableFieldsTableModel mTableFieldsTableModel;
    protected IWorkspaceRoot mWorkspaceRoot = null;
    protected String mFilePath = null;
    protected String mFileContainer = null;
    protected String mFileName = null;
    protected String mRootPath = null;
    protected String mTableName = null;
    protected DtStructureElement[] mStructureElements = null;
    protected DtField[] mDtFields = null;
    protected String mStructureType = null;
    private Object[] mFieldsTableRow = new Object[11];
    private boolean dataChanged = false;
    public boolean isLoading = false;
    private boolean tableSaved = true;
    protected int readOnly = -1;
    public boolean superUser = false;
    protected boolean advancedGui = false;
    public OutlinePage outlinePage;
    public static ReadWriteStatusItem mStatusItem = null;
    public static IStatusLineManager mManager = null;
    protected static TracerI tracer = TracingManager.getTracer((Class)(class$com$sap$dictionary$tools$tableeditor$AbstractTableEditor == null ? (class$com$sap$dictionary$tools$tableeditor$AbstractTableEditor = AbstractTableEditor.class$("com.sap.dictionary.tools.tableeditor.AbstractTableEditor")) : class$com$sap$dictionary$tools$tableeditor$AbstractTableEditor));
    static /* synthetic */ Class class$com$sap$dictionary$tools$tableeditor$AbstractTableEditor;

    protected void createPages() {
        this.readUserXMLFile();
        this.createFieldsPage();
        this.readOnly = this.isReadOnly() ? 0 : 1;
        if (this.advancedGui) {
            this.createAdGui();
        }
    }

    public void setFocus() {
        super.setFocus();
        boolean temp = false;
        switch (this.readOnly) {
            case 0: {
                temp = true;
                break;
            }
            case 1: {
                temp = false;
                break;
            }
            default: {
                return;
            }
        }
        if (this.isReadOnly() != temp) {
            int activePage = this.getActivePage();
            this.setActivePage(0);
            int i = this.getPageCount() - 1;
            while (i >= 0) {
                this.removePage(i);
                --i;
            }
            this.readOnly = -1;
            try {
                this.createPages();
                this.setActivePage(activePage);
                if (activePage == 1) {
                    this.refreshIndexPage(false);
                }
                TableMessageHandler.sendInformationMessage("Information", "Read/write permission has been changed");
            }
            catch (Exception e) {
                tracer.error("Reopening pages: ", (Throwable)e);
            }
            this.readOnly = this.isReadOnly() ? 0 : 1;
        } else {
            int activePage = this.getActivePage();
            if (activePage == 1) {
                this.refreshIndexPage(true);
            }
        }
    }

    protected abstract void refreshIndexPage(boolean var1);

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 0) {
            if (this.isReadOnly()) {
                if (mStatusItem.isVisible()) {
                    mStatusItem.setText("Read-only");
                }
            } else if (mStatusItem.isVisible()) {
                mStatusItem.setText("Writable");
            }
        }
        if (newPageIndex == 1) {
            this.refreshIndexPage(false);
        }
    }

    protected abstract void createAdGui();

    protected abstract void createFieldsPage();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        IWorkbenchWindow wW;
        if (!(editorInput instanceof IFileEditorInput || editorInput instanceof EditDbTableInput || editorInput instanceof EditStructureInput)) {
            throw new PartInitException("Invalid input");
        }
        super.init(site, editorInput);
        this.initMetamodel(site, editorInput);
        if (mStatusItem == null && (wW = site.getWorkbenchWindow()) instanceof WorkbenchWindow) {
            WorkbenchWindow w = (WorkbenchWindow)wW;
            IActionBars bars = w.getActionBars();
            mManager = bars.getStatusLineManager();
            mStatusItem = new ReadWriteStatusItem();
            mManager.add((IContributionItem)mStatusItem);
        }
        this.setTitleImage(SapIdeUtilImages.getSapImage((ISapImage)this.getDictionaryImage()));
    }

    protected abstract DictionaryImage getDictionaryImage();

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean getDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged() {
        if (!this.dataChanged) {
            this.dataChanged = true;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public abstract boolean isReadOnly();

    public abstract boolean isDeleted();

    private void initMetamodel(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof EditDbTableInput || editorInput instanceof EditStructureInput) {
            this.deleteFileEditorInputEditors(editorInput);
            this.initMetamodelUml(editorInput);
        } else if (editorInput instanceof IFileEditorInput) {
            this.deleteEditInputEditors(editorInput);
            this.initMetamodelFile(site, editorInput);
        } else {
            throw new PartInitException("Invalid input");
        }
        this.setTitle(this.mTableName);
    }

    private void deleteEditInputEditors(IEditorInput editorInput) {
        IWorkbenchWindow dwindow;
        IWorkbenchPage page;
        IFile file = ((IFileEditorInput)editorInput).getFile();
        String lFileName = file.getFullPath().removeFileExtension().lastSegment();
        IProject project = file.getProject();
        String lProjectName = project.getName();
        DtDbTable mdo = null;
        if (ServicesEclipse.projectHasDictionaryNature((String)lProjectName)) {
            try {
                DtDictionaryRoot lDictRoot;
                IPackageFragment packageFragment;
                IPath fullFilePath = file.getParent().getFullPath();
                IJavaProject javaProject = AbstractTableEditor.getJavaProject(file.getProject());
                String packageName = "";
                if (javaProject != null && (packageFragment = javaProject.findPackageFragment(fullFilePath)) != null) {
                    packageName = packageFragment.getElementName();
                }
                if ((lDictRoot = MetamodelServices.getDictionaryRoot((String)lProjectName)).hasTable("", lFileName)) {
                    try {
                        mdo = lDictRoot.getTable("", lFileName);
                    }
                    catch (LoadException e) {
                        TableEditorPlugin.tracer.error("couldn't find table", (Throwable)e);
                    }
                } else if (lDictRoot.hasStructure(packageName, lFileName)) {
                    try {
                        mdo = lDictRoot.getStructure(packageName, lFileName);
                    }
                    catch (LoadException e) {
                        TableEditorPlugin.tracer.error("couldn't find structure", (Throwable)e);
                    }
                }
            }
            catch (JavaModelException e) {
                TableEditorPlugin.tracer.error("get packagename", (Throwable)e);
            }
        }
        if (mdo != null && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            IEditorReference[] ref = page.getEditorReferences();
            int j = 0;
            while (j < ref.length) {
                IEditorPart part = ref[j].getEditor(false);
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    if (input instanceof EditDbTableInput) {
                        if (((EditDbTableInput)input).dictDbTable == mdo) {
                            page.closeEditor(ref[j].getEditor(false), false);
                        }
                    } else if (input instanceof EditStructureInput && ((EditStructureInput)input).structure == mdo) {
                        page.closeEditor(ref[j].getEditor(false), false);
                    }
                }
                ++j;
            }
        }
    }

    private static IJavaProject getJavaProject(IProject project) {
        IProjectNature nature = null;
        IJavaProject javaProject = null;
        try {
            nature = project.getNature("org.eclipse.jdt.core.javanature");
            if (nature instanceof IJavaProject) {
                javaProject = (IJavaProject)nature;
            }
        }
        catch (CoreException e) {
            return null;
        }
        return javaProject;
    }

    private void deleteFileEditorInputEditors(IEditorInput editorInput) {
        DtDbTable mdo = null;
        if (editorInput instanceof EditDbTableInput) {
            mdo = ((EditDbTableInput)editorInput).dictDbTable;
        } else if (editorInput instanceof EditStructureInput) {
            mdo = (DtGeneralStructure)((EditStructureInput)editorInput).structure;
        }
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = dwindow.getActivePage();
        if (page != null) {
            IEditorReference[] ref = page.getEditorReferences();
            int j = 0;
            while (j < ref.length) {
                block17: {
                    IEditorInput input;
                    IEditorPart part = ref[j].getEditor(false);
                    if (part != null && (input = part.getEditorInput()) instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        String lFileName = file.getFullPath().removeFileExtension().lastSegment();
                        IProject project = file.getProject();
                        String lProjectName = project.getName();
                        if (ServicesEclipse.projectHasDictionaryNature((String)lProjectName)) {
                            try {
                                DtDictionaryRoot lDictRoot;
                                IPackageFragment packageFragment;
                                IPath fullFilePath = file.getParent().getFullPath();
                                IJavaProject javaProject = AbstractTableEditor.getJavaProject(file.getProject());
                                String packageName = "";
                                if (javaProject != null && (packageFragment = javaProject.findPackageFragment(fullFilePath)) != null) {
                                    packageName = packageFragment.getElementName();
                                }
                                if ((lDictRoot = MetamodelServices.getDictionaryRoot((String)lProjectName)).hasTable("", lFileName)) {
                                    try {
                                        DtDbTable ltable = lDictRoot.getTable("", lFileName);
                                        if (ltable == mdo) {
                                            page.closeEditor(ref[j].getEditor(false), false);
                                        }
                                        break block17;
                                    }
                                    catch (LoadException e) {
                                        TableEditorPlugin.tracer.error("couldn't find table", (Throwable)e);
                                    }
                                    break block17;
                                }
                                if (!lDictRoot.hasStructure(packageName, lFileName)) break block17;
                                try {
                                    DtGeneralStructure lStruct = lDictRoot.getStructure(packageName, lFileName);
                                    if (lStruct == mdo) {
                                        page.closeEditor(ref[j].getEditor(false), false);
                                    }
                                }
                                catch (LoadException e) {
                                    TableEditorPlugin.tracer.error("couldn't find structure", (Throwable)e);
                                }
                            }
                            catch (JavaModelException e2) {
                                TableEditorPlugin.tracer.error("get java package", (Throwable)e2);
                            }
                        }
                    }
                }
                ++j;
            }
        }
    }

    protected abstract void initMetamodelFile(IEditorSite var1, IEditorInput var2) throws PartInitException;

    protected abstract void initMetamodelUml(IEditorInput var1) throws PartInitException;

    public String getTabName() {
        return this.mFileName;
    }

    public String getTableName() {
        return this.mTableName;
    }

    public void setTableEditorPage(int index) {
        this.setActivePage(index);
    }

    public int getCurrentTableEditorPage() {
        return this.getActivePage();
    }

    public Metamodel getMetamodel() {
        return this.mMetamodel;
    }

    public void preSave() {
        CellEditor[] editors = this.mTableFieldsSectionForm.mTableFieldsTableSection.getTableViewer().getTableViewer().getCellEditors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].isActivated()) {
                editors[i].deactivate();
            }
            ++i;
        }
    }

    public void postSave() {
    }

    public void postRollback() {
        if (this.getStructure() == null || this.getStructure().isDeleted()) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
            return;
        }
        int activePage = this.getActivePage();
        this.setActivePage(0);
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            this.removePage(i);
            --i;
        }
        this.createPages();
        this.setActivePage(activePage);
        if (this.outlinePage != null) {
            this.outlinePage.refreshCompleteTree(this.mTableFieldsSectionForm.getTableFieldsTableModel());
        }
    }

    protected void readUserXMLFile() {
        try {
            File file = new File(this.getPluginInstance().getStateLocation() + "/user.xml");
            if (file.exists()) {
                new ConfXmlReader().readXml(file);
            } else {
                file.createNewFile();
                PrintWriter writer = new PrintWriter(new FileOutputStream(file));
                writer.println("<xml>");
                writer.println("<user");
                writer.println("\tadvanced=\"false\"");
                writer.println("/>");
                writer.println("</xml>");
                writer.flush();
                writer.close();
                System.out.println("Super user = false");
                this.superUser = false;
            }
        }
        catch (Exception e) {
            tracer.debug(e.getMessage());
        }
    }

    public AbstractTableFieldsSectionForm getSectionForm() {
        return this.mTableFieldsSectionForm;
    }

    protected abstract AbstractUIPlugin getPluginInstance();

    protected abstract DtStructure getStructure();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ConfXmlReader
    extends DefaultHandler {
        protected ConfXmlReader() {
        }

        public void readXml(File file) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    xmlReader.setContentHandler(this);
                    try {
                        xmlReader.parse(file.toURL().toString());
                    }
                    catch (Exception e) {
                        tracer.debug(e.getMessage());
                    }
                    Object var6_6 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                }
                catch (Exception e2) {
                    tracer.debug(e2.getMessage());
                    Object var6_7 = null;
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            super.startElement(arg0, arg1, arg2, arg3);
            int i = 0;
            while (i < arg3.getLength()) {
                if (arg3.getQName(i).compareTo("advanced") == 0) {
                    if (arg3.getValue(i).compareTo("false") == 0) {
                        System.out.println("superuser = false");
                        AbstractTableEditor.this.superUser = false;
                    } else {
                        System.out.println("superuser = true");
                        AbstractTableEditor.this.superUser = true;
                    }
                }
                if (arg3.getQName(i).compareTo("gui") == 0) {
                    if (arg3.getValue(i).compareTo("false") == 0) {
                        System.out.println("gui = false");
                        AbstractTableEditor.this.advancedGui = false;
                    } else {
                        System.out.println("gui = true");
                        AbstractTableEditor.this.advancedGui = true;
                    }
                }
                ++i;
            }
        }
    }
}

