/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.I18NHelper;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.RegisterClassEvent;
import javax.jdo.spi.RegisterClassListener;
import javax.jdo.spi.StateManager;

public class JDOImplHelper {
    private static Map registeredClasses = Collections.synchronizedMap(new HashMap());
    private static List listeners = new ArrayList();
    private static JDOImplHelper jdoImplHelper = new JDOImplHelper();
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");

    private JDOImplHelper() {
    }

    public static JDOImplHelper getInstance() throws SecurityException {
        SecurityManager sec = System.getSecurityManager();
        if (sec != null) {
            sec.checkPermission(JDOPermission.GET_METADATA);
        }
        return jdoImplHelper;
    }

    public String[] getFieldNames(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldNames();
    }

    public Class[] getFieldTypes(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldTypes();
    }

    public byte[] getFieldFlags(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getFieldFlags();
    }

    public Class getPersistenceCapableSuperclass(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        return meta.getPersistenceCapableSuperclass();
    }

    public PersistenceCapable newInstance(Class pcClass, StateManager sm) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewInstance(sm);
    }

    public PersistenceCapable newInstance(Class pcClass, StateManager sm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewInstance(sm, oid);
    }

    public Object newObjectIdInstance(Class pcClass) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewObjectIdInstance();
    }

    public Object newObjectIdInstance(Class pcClass, String str) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        return pcInstance == null ? null : pcInstance.jdoNewObjectIdInstance(str);
    }

    public void copyKeyFieldsToObjectId(Class pcClass, PersistenceCapable.ObjectIdFieldSupplier fm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", pcClass.getName()));
        }
        pcInstance.jdoCopyKeyFieldsToObjectId(fm, oid);
    }

    public void copyKeyFieldsFromObjectId(Class pcClass, PersistenceCapable.ObjectIdFieldConsumer fm, Object oid) {
        Meta meta = JDOImplHelper.getMeta(pcClass);
        PersistenceCapable pcInstance = meta.getPC();
        if (pcInstance == null) {
            throw new JDOFatalInternalException(msg.msg("ERR_AbstractClassNoIdentity", pcClass.getName()));
        }
        pcInstance.jdoCopyKeyFieldsFromObjectId(fm, oid);
    }

    public static void registerClass(Class pcClass, String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistenceCapableSuperclass, PersistenceCapable pc) {
        if (pcClass == null) {
            throw new NullPointerException();
        }
        Meta meta = new Meta(fieldNames, fieldTypes, fieldFlags, persistenceCapableSuperclass, pc);
        registeredClasses.put(pcClass, meta);
        List list = listeners;
        synchronized (list) {
            if (!listeners.isEmpty()) {
                RegisterClassEvent event = new RegisterClassEvent(jdoImplHelper, pcClass, fieldNames, fieldTypes, fieldFlags, persistenceCapableSuperclass);
                Iterator i = listeners.iterator();
                while (i.hasNext()) {
                    RegisterClassListener crl = (RegisterClassListener)i.next();
                    if (crl == null) continue;
                    crl.registerClass(event);
                }
            }
        }
    }

    public void addRegisterClassListener(RegisterClassListener crl) {
        HashSet alreadyRegisteredClasses = null;
        List list = listeners;
        synchronized (list) {
            listeners.add(crl);
            alreadyRegisteredClasses = new HashSet(registeredClasses.keySet());
        }
        Iterator it = alreadyRegisteredClasses.iterator();
        while (it.hasNext()) {
            Class pcClass = (Class)it.next();
            Meta meta = JDOImplHelper.getMeta(pcClass);
            RegisterClassEvent event = new RegisterClassEvent(this, pcClass, meta.getFieldNames(), meta.getFieldTypes(), meta.getFieldFlags(), meta.getPersistenceCapableSuperclass());
            crl.registerClass(event);
        }
    }

    public void removeRegisterClassListener(RegisterClassListener crl) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(crl);
        }
    }

    public Collection getRegisteredClasses() {
        return Collections.unmodifiableCollection(registeredClasses.keySet());
    }

    private static Meta getMeta(Class pcClass) {
        Meta ret = (Meta)registeredClasses.get(pcClass);
        if (ret == null) {
            throw new JDOFatalUserException(msg.msg("ERR_NoMetadata", pcClass.getName()));
        }
        return ret;
    }

    static class Meta {
        String[] fieldNames;
        Class[] fieldTypes;
        byte[] fieldFlags;
        Class persistenceCapableSuperclass;
        PersistenceCapable pc;

        Meta(String[] fieldNames, Class[] fieldTypes, byte[] fieldFlags, Class persistenceCapableSuperclass, PersistenceCapable pc) {
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
            this.fieldFlags = fieldFlags;
            this.persistenceCapableSuperclass = persistenceCapableSuperclass;
            this.pc = pc;
        }

        String[] getFieldNames() {
            return this.fieldNames;
        }

        Class[] getFieldTypes() {
            return this.fieldTypes;
        }

        byte[] getFieldFlags() {
            return this.fieldFlags;
        }

        Class getPersistenceCapableSuperclass() {
            return this.persistenceCapableSuperclass;
        }

        PersistenceCapable getPC() {
            return this.pc;
        }

        public String toString() {
            return "Meta-" + this.pc.getClass().getName();
        }
    }
}

