/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import javax.jdo.I18NHelper;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.PersistenceCapable;

public class JDOHelper {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    static /* synthetic */ Class class$java$util$Properties;

    public static PersistenceManager getPersistenceManager(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetPersistenceManager() : null;
    }

    public static void makeDirty(Object pc, String fieldName) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoMakeDirty(fieldName);
        }
    }

    public static Object getObjectId(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetObjectId() : null;
    }

    public static Object getTransactionalObjectId(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoGetObjectId() : null;
    }

    public static boolean isDirty(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsDirty() : false;
    }

    public static boolean isTransactional(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsTransactional() : false;
    }

    public static boolean isPersistent(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsPersistent() : false;
    }

    public static boolean isNew(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsNew() : false;
    }

    public static boolean isDeleted(Object pc) {
        return pc instanceof PersistenceCapable ? ((PersistenceCapable)pc).jdoIsDeleted() : false;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Properties props) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(props, cl);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Properties props, ClassLoader cl) {
        String pmfClassName = (String)((Hashtable)props).get("javax.jdo.PersistenceManagerFactoryClass");
        if (pmfClassName == null) {
            throw new JDOFatalUserException(msg.msg("EXC_NoClassNameProperty"));
        }
        try {
            Class<?> pmfClass = cl.loadClass(pmfClassName);
            Method pmfMethod = pmfClass.getMethod("getPersistenceManagerFactory", class$java$util$Properties == null ? (class$java$util$Properties = JDOHelper.class$("java.util.Properties")) : class$java$util$Properties);
            return (PersistenceManagerFactory)pmfMethod.invoke(null, props);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JDOFatalUserException(msg.msg("EXC_ClassNotFound", pmfClassName), cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new JDOFatalUserException(msg.msg("EXC_IllegalAccess", pmfClassName), iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new JDOFatalInternalException(msg.msg("ERR_NoSuchMethod"), nsme);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (nested instanceof JDOException) {
                throw (JDOException)nested;
            }
            throw new JDOFatalUserException(msg.msg("EXC_getPersistenceManagerFactory"), ite);
        }
        catch (Exception e) {
            throw new JDOFatalInternalException(msg.msg("ERR_UnexpectedException"), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

