/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.util;

import com.sap.security.util.Base64InputStream;
import com.sap.security.util.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public abstract class PropertiesPersistence {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void unmarshal(Properties p) throws Exception {
        String prefix = this.getPrefix();
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        int lPrefix = prefix.length();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            Object oValue;
            Class<?> type;
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String strValue = p.getProperty(key);
            Field field = this.getClass().getDeclaredField(key.substring(lPrefix));
            ((AccessibleObject)field).setAccessible(true);
            int modifiers = field.getModifiers();
            if ((modifiers & 0x10) != 0) {
                System.err.println("Ignoring " + key + "=" + strValue + ", field " + field.getName() + " is final");
                continue;
            }
            if ((class$java$lang$String == null ? PropertiesPersistence.class$("java.lang.String") : class$java$lang$String).equals(type = field.getType())) {
                oValue = strValue;
            } else if (Boolean.TYPE.equals(type)) {
                if ("1".equals(strValue)) {
                    oValue = Boolean.TRUE;
                } else {
                    if (!"0".equals(strValue)) throw new Exception("Can't unmarshal boolean from " + strValue);
                    oValue = Boolean.FALSE;
                }
            } else if ((array$B == null ? PropertiesPersistence.class$("[B") : array$B).equals(type)) {
                oValue = this.base64Decode(strValue);
            } else if ((array$C == null ? PropertiesPersistence.class$("[C") : array$C).equals(type)) {
                oValue = new String(this.base64Decode(strValue)).toCharArray();
            } else if (Integer.TYPE.equals(type)) {
                oValue = new Integer(Integer.parseInt(strValue));
            } else {
                if (!Long.TYPE.equals(type)) throw new Exception("Unmarshaling " + type.getName() + " not supported");
                oValue = new Long(Long.parseLong(strValue));
            }
            field.set(this, oValue);
        }
    }

    protected Properties marshal() throws Exception {
        String prefix = this.getPrefix();
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        Properties p = new Properties();
        Field[] fields = this.getClass().getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            ((AccessibleObject)fields[i]).setAccessible(true);
            int modifiers = fields[i].getModifiers();
            if ((modifiers & 0x80) == 0 && (modifiers & 0x10) == 0) {
                String key = prefix + fields[i].getName();
                Object oValue = fields[i].get(this);
                if (oValue != null) {
                    String strValue;
                    Class<?> type;
                    if ((class$java$lang$String == null ? PropertiesPersistence.class$("java.lang.String") : class$java$lang$String).equals(type = fields[i].getType())) {
                        strValue = (String)oValue;
                    } else if (Boolean.TYPE.equals(type)) {
                        strValue = fields[i].getBoolean(this) ? "1" : "0";
                    } else if ((array$B == null ? PropertiesPersistence.class$("[B") : array$B).equals(type)) {
                        strValue = this.base64Encode((byte[])oValue);
                    } else if ((array$C == null ? PropertiesPersistence.class$("[C") : array$C).equals(type)) {
                        strValue = this.base64Encode(new String((char[])oValue).getBytes());
                    } else if (Integer.TYPE.equals(type)) {
                        strValue = String.valueOf(fields[i].getInt(this));
                    } else if (Long.TYPE.equals(type)) {
                        strValue = String.valueOf(fields[i].getLong(this));
                    } else {
                        throw new Exception("Marshaling " + type.getName() + " not supported");
                    }
                    p.setProperty(key, strValue);
                }
            }
            ++i;
        }
        return p;
    }

    protected abstract String getPrefix();

    public static void main(String[] args) throws Exception {
        Test t1 = new Test();
        t1.init();
        Properties p = t1.marshal();
        Test t2 = new Test();
        t2.unmarshal(p);
        if (!t1.equals(t2)) {
            throw new Exception("Objects not equal:\nt1: " + t1 + "\n" + "Properties of t1: " + t1.marshal() + "\n" + "t2: " + t2 + "\n" + "Properties of t2: " + t2.marshal() + "\n");
        }
        System.out.println("Test succeeded");
    }

    private String base64Encode(byte[] in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream base64 = new Base64OutputStream(bos);
        base64.write(in);
        base64.flush();
        return bos.toString();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] base64Decode(String in) throws IOException {
        int read;
        Base64InputStream is = new Base64InputStream(new ByteArrayInputStream(in.getBytes()));
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = ((InputStream)is).read(buffer)) > 0) {
            void var3_5;
            bos.write(buffer, 0, (int)var3_5);
        }
        return bos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Test
    extends PropertiesPersistence {
        private int i;
        protected boolean b;
        String s;
        public byte[] ab;
        final String fs;
        static String ss;

        public Test() {
            this.fs = "Final Field";
        }

        public void init() {
            this.i = 1;
            this.b = true;
            this.s = "foo";
            this.ab = new byte[]{18, 35, 52, 69, 86, 120, -102, -85};
            ss = "Static Field";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Test)) {
                return false;
            }
            Test other = (Test)o;
            return this.i == other.i && this.b == other.b && (this.s != null && this.s.equals(other.s) || this.s == null && other.s == null) && (this.ab != null && other.ab != null && Arrays.equals(this.ab, other.ab) || this.ab == null && other.ab == null) && (ss != null && ss.equals(ss) || ss == null && ss == null);
        }

        protected String getPrefix() {
            return "test";
        }
    }
}

