/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.ticket.SimpleTicket;
import com.sap.security.ticket.TicketException;
import com.sap.security.util.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class Util {
    private static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_FOOTER = "-----END CERTIFICATE-----";
    private static char[] DELIMITERS = new char[]{'-', '/', ')', ' ', '\t'};
    static Random m_random = new Random();
    private static char[] RANDOM_PW_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};

    private Util() {
    }

    static String[] splitPhoneNumber(String composedNumber) {
        String number = null;
        String extension = null;
        int i = 0;
        while (i < DELIMITERS.length) {
            int delimPos = composedNumber.lastIndexOf(DELIMITERS[i]);
            if (delimPos != -1) {
                if (delimPos > 0) {
                    int numberLen = 0;
                    numberLen = DELIMITERS[i] == ')' ? delimPos + 1 : delimPos;
                    number = composedNumber.substring(0, numberLen).trim();
                } else {
                    number = null;
                }
                extension = delimPos < composedNumber.length() - 1 ? composedNumber.substring(delimPos + 1, composedNumber.length()).trim() : null;
                if (number != null && extension != null) break;
            }
            ++i;
        }
        if (number == null || extension == null) {
            return new String[]{composedNumber, ""};
        }
        return new String[]{number, extension};
    }

    public static void eraseCharArray(char[] target) {
        if (target != null) {
            int i = 0;
            while (i < target.length) {
                target[i] = 32;
                ++i;
            }
        }
    }

    public static char[] copyCharArray(char[] src) {
        if (src != null) {
            char[] copy = new char[src.length];
            System.arraycopy(src, 0, copy, 0, src.length);
            return copy;
        }
        return null;
    }

    public static String getRandomPassword(int len) {
        char[] randompw = new char[len];
        int i = 0;
        while (i < len) {
            randompw[i] = RANDOM_PW_CHARS[Math.abs(m_random.nextInt()) % RANDOM_PW_CHARS.length];
            ++i;
        }
        return new String(randompw);
    }

    public static String getCacheKey(String token) {
        MessageDigest mDigest = null;
        try {
            mDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
        }
        String key = null;
        MessageDigest messageDigest = mDigest;
        synchronized (messageDigest) {
            mDigest.reset();
            key = new String(mDigest.digest(token.getBytes()));
        }
        return key;
    }

    public static String stripUnwantedChars(String cert) {
        return Util.stripLineBreaksAndWhiteSpace(Util.stripCertificateHeaderAndFooter(cert));
    }

    public static String stripLineBreaksAndWhiteSpace(String src) {
        int srcLength = src.length();
        StringBuffer dest = new StringBuffer(srcLength);
        char c = '\u0000';
        int i = 0;
        while (i < srcLength) {
            c = src.charAt(i);
            if (c != '\n' && c != '\r' && c != '\f' && c != ' ' && c != '\t') {
                dest.append(c);
            }
            ++i;
        }
        return dest.toString();
    }

    public static String stripCertificateHeaderAndFooter(String b64certificate) {
        int headerStart = b64certificate.indexOf(CERT_HEADER);
        int footerStart = b64certificate.indexOf(CERT_FOOTER);
        int bodyStart = headerStart > -1 ? headerStart + CERT_HEADER.length() : 0;
        int bodyEnd = footerStart > -1 ? footerStart : b64certificate.length();
        return b64certificate.substring(bodyStart, bodyEnd);
    }

    public static String certificateToBase64(X509Certificate certificate) throws CertificateEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Base64OutputStream base64os = new Base64OutputStream(baos);
        Object base64cert = null;
        base64os.write(certificate.getEncoded());
        base64os.flush();
        base64os.close();
        return baos.toString();
    }

    public static X509Certificate base64ToCertificate(String b64certificate) throws IOException, CertificateException {
        X509Certificate certificate = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(b64certificate.getBytes());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        certificate = (X509Certificate)cf.generateCertificate(bais);
        bais.close();
        return certificate;
    }

    public static String getTicketFromCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        Object bufTicket = null;
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String ticket;
                if (cookies[i].getName().equals("MYSAPSSO2") && (ticket = cookies[i].getValue()) != null && !ticket.equals("")) {
                    ticket = Util.undoReplaceChar(ticket);
                    return ticket;
                }
                ++i;
            }
        }
        return null;
    }

    public static void setSSOCookie(HttpServletRequest request, HttpServletResponse response, String value, String domain, int validTime) {
        value = Util.replaceSpecialChar(value);
        Cookie replaced_cookie = new Cookie("MYSAPSSO2", value);
        if (domain != null) {
            replaced_cookie.setDomain(domain);
        }
        replaced_cookie.setPath("/");
        replaced_cookie.setSecure(false);
        replaced_cookie.setMaxAge(validTime);
        response.addCookie(replaced_cookie);
    }

    public static void deleteSSOCookie(HttpServletRequest request, HttpServletResponse response) {
        Util.setSSOCookie(request, response, "", Util.getCookieDomain(request), -1);
    }

    public static String replaceSpecialChar(String value) {
        StringBuffer replaced_cookie = new StringBuffer(value);
        int i = 0;
        while (i < replaced_cookie.length()) {
            if (replaced_cookie.charAt(i) == '+') {
                replaced_cookie.replace(i, i + 1, "%2B");
            } else if (replaced_cookie.charAt(i) == '/') {
                replaced_cookie.replace(i, i + 1, "%2F");
            } else if (replaced_cookie.charAt(i) == '=') {
                replaced_cookie.replace(i, i + 1, "%3D");
            }
            ++i;
        }
        return replaced_cookie.toString();
    }

    public static String undoReplaceChar(String value) {
        if (value.length() > 0) {
            while (value.indexOf(37) != -1) {
                value = URLDecoder.decode(value);
            }
        }
        return value;
    }

    public static String getCookieDomain(HttpServletRequest request) {
        String strUserAgent = null;
        String domain = request.getServerName();
        boolean bIsInternetExplorer = true;
        strUserAgent = request.getHeader("User-Agent");
        if (strUserAgent != null && strUserAgent.indexOf("Win") == -1 && strUserAgent.indexOf("win") == -1) {
            bIsInternetExplorer = false;
        }
        int firstdot = domain.indexOf(46);
        int lastdot = domain.lastIndexOf(46);
        if (firstdot == -1 && lastdot == -1) {
            domain = null;
        } else if (firstdot != -1 && firstdot < domain.length() - 1 && firstdot != lastdot) {
            domain = domain.substring(firstdot + (bIsInternetExplorer ? 1 : 0));
        }
        return domain;
    }

    public static SimpleTicket setTicket(String m_ticketString) {
        SimpleTicket ticket = new SimpleTicket();
        try {
            ticket.setTicket(m_ticketString);
        }
        catch (TicketException e) {
            System.err.println("[R3Authentication] Warning: creation of Ticket object failed. Ticket added to user credentials is not valid" + e.toString());
        }
        return ticket;
    }

    public static String maskCredentials(Map credentials) {
        StringBuffer sb = new StringBuffer();
        if (credentials != null && credentials.size() > 0) {
            sb.append("{");
            Iterator iter = credentials.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = credentials.get(key);
                String displayval = value != null ? value.getClass().getName() : null;
                sb.append(key.toString() + "=" + displayval);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

