/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.JCO;
import com.sap.security.um.r3.AbstractSearchHelp;
import com.sap.security.um.r3.ISearchHelp;
import com.sap.security.um.r3.StandAloneUtil;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.usermanagement.UserSearchFilter;
import java.util.HashMap;
import java.util.Map;

class UserAddrSearchHelp
extends AbstractSearchHelp
implements ISearchHelp {
    private static final String NAME = "USER_ADDR";
    private static final int UNKNOWN = -1;
    private int bnameStart = -1;
    private int bnameEnd = -1;
    private int firstnameStart = -1;
    private int firstnameEnd = -1;
    private int lastnameStart = -1;
    private int lastnameEnd = -1;
    private int departmentStart = -1;
    private int departmentEnd = -1;
    private int companyidStart = -1;
    private int companyidEnd = -1;
    private boolean descriptionProcessed = false;

    public String getName() {
        return NAME;
    }

    public void fillSelectionFromFilter(JCO.Table selection, UserSearchFilter filter) {
        if (filter.getUniqueID() != null) {
            this.appendRowsFromFilterValue(selection, StandAloneUtil.charWiseUpperCase(filter.getUniqueID()), "BNAME");
        }
        if (filter.getFirstName() != null) {
            this.appendRowsFromFilterValue(selection, StandAloneUtil.charWiseUpperCase(filter.getFirstName()), "MC_NAMEFIR");
        }
        if (filter.getLastName() != null) {
            this.appendRowsFromFilterValue(selection, StandAloneUtil.charWiseUpperCase(filter.getLastName()), "MC_NAMELAS");
        }
        if (filter.getDepartment() != null) {
            this.appendRowsFromFilterValue(selection, filter.getDepartment(), "DEPARTMENT");
        }
        if (filter.getCompanyId() != null) {
            this.appendRowsFromFilterValue(selection, StandAloneUtil.charWiseUpperCase(filter.getCompanyId()), "MC_NAME1");
        }
    }

    private static String extractResult(String row, int first, int last) {
        int rowLength = row.length();
        if (first >= rowLength) {
            return "";
        }
        int endPos = Math.min(rowLength, last);
        String resultNotClipped = row.substring(first, endPos);
        int i = resultNotClipped.length() - 1;
        while (i >= 0) {
            if (resultNotClipped.charAt(i) != ' ') break;
            --i;
        }
        if (i == -1) {
            return resultNotClipped;
        }
        return resultNotClipped.substring(0, i + 1);
    }

    public Map[] getSearchResult(JCO.Table helpvalues, JCO.Table description) {
        if (!this.descriptionProcessed) {
            this.processDescription(description);
        }
        Map[] results = new Map[helpvalues.getNumRows()];
        int i = 0;
        while (i < helpvalues.getNumRows()) {
            helpvalues.setRow(i);
            String row = helpvalues.getString(0);
            results[i] = new HashMap();
            results[i].put("m_uniqueid", UserAddrSearchHelp.extractResult(row, this.bnameStart, this.bnameEnd));
            results[i].put("m_firstname", UserAddrSearchHelp.extractResult(row, this.firstnameStart, this.firstnameEnd));
            results[i].put("m_lastname", UserAddrSearchHelp.extractResult(row, this.lastnameStart, this.lastnameEnd));
            results[i].put("m_department", UserAddrSearchHelp.extractResult(row, this.departmentStart, this.departmentEnd));
            results[i].put("m_companyid", UserAddrSearchHelp.extractResult(row, this.companyidStart, this.companyidEnd));
            ++i;
        }
        return results;
    }

    public void processDescription(JCO.Table description) {
        int i = 0;
        while (i < description.getNumRows()) {
            description.setRow(i);
            String fieldname = description.getString("FIELDNAME");
            if ("BNAME".equals(fieldname)) {
                this.bnameStart = description.getInt("OFFSET");
                this.bnameEnd = description.getInt("LENG") + this.bnameStart;
            } else if ("MC_NAMEFIR".equals(fieldname)) {
                this.firstnameStart = description.getInt("OFFSET");
                this.firstnameEnd = description.getInt("LENG") + this.firstnameStart;
            } else if ("MC_NAMELAS".equals(fieldname)) {
                this.lastnameStart = description.getInt("OFFSET");
                this.lastnameEnd = description.getInt("LENG") + this.lastnameStart;
            } else if ("DEPARTMENT".equals(fieldname)) {
                this.departmentStart = description.getInt("OFFSET");
                this.departmentEnd = description.getInt("LENG") + this.departmentStart;
            } else if ("MC_NAME1".equals(fieldname)) {
                this.companyidStart = description.getInt("OFFSET");
                this.companyidEnd = description.getInt("LENG") + this.companyidStart;
            }
            ++i;
        }
        if (this.bnameStart == -1) {
            throw new UMRuntimeException("Couldn't determine start index of attribute BNAME");
        }
        if (this.bnameEnd == -1) {
            throw new UMRuntimeException("Couldn't determine end index of attribute BNAME");
        }
        if (this.firstnameStart == -1) {
            throw new UMRuntimeException("Couldn't determine start index of attribute MC_NAMEFIR");
        }
        if (this.firstnameEnd == -1) {
            throw new UMRuntimeException("Couldn't determine end index of attribute MC_NAMEFIR");
        }
        if (this.lastnameStart == -1) {
            throw new UMRuntimeException("Couldn't determine start index of attribute MC_NAMELAS");
        }
        if (this.lastnameEnd == -1) {
            throw new UMRuntimeException("Couldn't determine end index of attribute MC_NAMELAS");
        }
        if (this.departmentStart == -1) {
            throw new UMRuntimeException("Couldn't determine start index of attribute DEPARTMENT");
        }
        if (this.departmentEnd == -1) {
            throw new UMRuntimeException("Couldn't determine end index of attribute DEPARTMENT");
        }
        if (this.companyidStart == -1) {
            throw new UMRuntimeException("Couldn't determine start index of attribute MC_NAME1");
        }
        if (this.companyidEnd == -1) {
            throw new UMRuntimeException("Couldn't determine end index of attribute MC_NAME1");
        }
        this.descriptionProcessed = true;
    }
}

