/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.JCO;
import com.sap.security.Security;
import com.sap.security.ticket.SimpleTicket;
import com.sap.security.um.ILookup;
import com.sap.security.um.r3.AbapExceptionKeys;
import com.sap.security.um.r3.BapiHVGetSearch;
import com.sap.security.um.r3.ISearch;
import com.sap.security.um.r3.LoginCheck;
import com.sap.security.um.r3.LoginResult;
import com.sap.security.um.r3.MappingTimeZoneStrategy;
import com.sap.security.um.r3.NoUserSearch;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserAccount;
import com.sap.security.um.r3.RfcOpenLoginCheck;
import com.sap.security.um.r3.SearchResult;
import com.sap.security.um.r3.ServiceUserLoginCheck;
import com.sap.security.um.r3.StandAloneUtil;
import com.sap.security.um.r3.TimeZoneStrategy;
import com.sap.security.um.r3.Util;
import com.sap.security.usermanagement.AuthenticationFailedException;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.ISearchResult;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.IUserAccount;
import com.sap.security.usermanagement.IUserAccountFactory;
import com.sap.security.usermanagement.IUserFactory;
import com.sap.security.usermanagement.IUserMaint;
import com.sap.security.usermanagement.InvalidIDException;
import com.sap.security.usermanagement.NoSuchUserException;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UMNestedException;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.usermanagement.UserAccountSearchFilter;
import com.sap.security.usermanagement.UserAlreadyExistsException;
import com.sap.security.usermanagement.UserLockedException;
import com.sap.security.usermanagement.UserSearchFilter;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class R3UserFactory
implements IUserFactory,
IUserAccountFactory,
ILookup,
AbapExceptionKeys {
    private static final int R3_UNAME_MAXLEN = 12;
    private static final int R3_PW_MAXLEN = 8;
    private static final String NO_SUCH_USER_MSGNO = "124";
    private static final String USER_EXISTS_MSGNO = "224";
    private static final String EXISTENCE_CONFIRMED_MSGNO = "088";
    private static final int BUGD_NONE = 0;
    private static final int BUGD_ACTIVITYGROUPS = 1;
    private static final int BUGC_ADDCOMREM = 2;
    private static final int BUGD_ADDFAX = 4;
    private static final int BUGD_ADDPAG = 8;
    private static final int BUGD_ADDPRT = 16;
    private static final int BUGD_ADDRFC = 32;
    private static final int BUGD_ADDRML = 64;
    private static final int BUGD_ADDSMTP = 128;
    private static final int BUGD_ADDSSF = 256;
    private static final int BUGD_ADDTEL = 512;
    private static final int BUGD_ADDTLX = 1024;
    private static final int BUGD_ADDTTX = 2048;
    private static final int BUGD_ADDURI = 4096;
    private static final int BUGD_ADDX400 = 8192;
    private static final int BUGD_GROUPS = 16384;
    private static final int BUGD_PARAMETER = 32768;
    private static final int BUGD_PARAMETER1 = 65536;
    private static final int BUGD_PROFILES = 131072;
    private static final String NOT_SHOWN = "NOT SHOWN";
    public static final String VERSION = "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/um/r3/R3UserFactory.java#1 $ from $DateTime: 2004/03/08 16:48:25 $ ($Change: 14740 $)";
    private static final String EOL = System.getProperty("line.separator");
    private static final String METHOD_PARAM = EOL + "[PARAM] ";
    private static final String RETURN_VAL = EOL + "[RETURNING] ";
    private static final String ENTERING = "Entering method";
    private static final String EXITING = "Exiting method";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$um$r3$R3UserFactory == null ? (class$com$sap$security$um$r3$R3UserFactory = R3UserFactory.class$("com.sap.security.um.r3.R3UserFactory")) : class$com$sap$security$um$r3$R3UserFactory));
    private Category m_category = Category.getCategory((String)"/Security/UserManagement");
    private SAPBasis m_sapBasis;
    private LoginCheck m_loginHandler;
    private ISearch m_searchHandler;
    private TimeZoneStrategy m_timeZoneHandler;
    private boolean m_initialized;
    private boolean m_timeStampSupported;
    private String m_referenceUser;
    private String m_description;
    private String m_key;
    static /* synthetic */ Class class$com$sap$security$um$r3$R3UserFactory;

    public R3UserFactory() {
        String method = "R3UserFactory";
        LOCATION.pathT("R3UserFactory", ENTERING);
        LOCATION.pathT("R3UserFactory", EXITING);
    }

    public R3UserFactory(SAPBasis sapBasis, Properties pOptions, String key) throws UMException {
        this(sapBasis, pOptions);
        Security.register(key, this);
        Security.register(key, this);
    }

    public R3UserFactory(SAPBasis sapBasis, Properties pOptions) throws UMException {
        String method = "R3UserFactory";
        LOCATION.pathT("R3UserFactory", ENTERING);
        LOCATION.debugT("R3UserFactory", METHOD_PARAM + "sapBasis = " + sapBasis + METHOD_PARAM + "pOptions = " + pOptions);
        try {
            if (sapBasis == null) {
                throw new UMException("sapBasis is null");
            }
            this.m_sapBasis = sapBasis;
            StringBuffer description = new StringBuffer();
            description.append(this.getClass().getName() + ":");
            description.append("\n   SAP Basis: " + sapBasis);
            this.processOptions(sapBasis, pOptions, description);
            this.m_description = description.toString();
            this.m_initialized = true;
        }
        catch (Exception e) {
            this.handleUMExceptionMethod("R3UserFactory", e);
        }
        LOCATION.pathT("R3UserFactory", EXITING);
    }

    public IUserAccount getNewUserAccount(String logonUid) throws UMException {
        String method = "getNewUserAccount";
        LOCATION.pathT("getNewUserAccount", ENTERING);
        LOCATION.debugT("getNewUserAccount", METHOD_PARAM + "logonUid = " + logonUid);
        R3UserAccount account = null;
        try {
            account = ((R3User)this.newUser(logonUid)).getImplicitUserAccount();
        }
        catch (Exception e) {
            this.handleUMExceptionMethod("getNewUserAccount", e);
        }
        LOCATION.pathT("getNewUserAccount", EXITING);
        LOCATION.debugT("getNewUserAccount", RETURN_VAL + "IUserAccount " + account);
        return account;
    }

    public IUserAccount getUserAccount(String logonUid) throws UMException {
        String method = "getUserAccount";
        LOCATION.pathT("getUserAccount", ENTERING);
        LOCATION.debugT("getUserAccount", METHOD_PARAM + "logonUid = " + logonUid);
        R3UserAccount account = null;
        try {
            account = ((R3User)this.getUser(logonUid)).getImplicitUserAccount();
        }
        catch (Exception e) {
            this.handleUMExceptionMethod("getUserAccount", e);
        }
        LOCATION.pathT("getUserAccount", EXITING);
        LOCATION.debugT("getUserAccount", "IUserAccount " + account);
        return account;
    }

    public IUserAccount getUserAccount(X509Certificate certificate) throws CertificateException, UMException {
        String method = "getUserAccount";
        LOCATION.pathT("getUserAccount", ENTERING);
        LOCATION.debugT("getUserAccount", METHOD_PARAM + "certificate = " + certificate);
        JCO.Client client = null;
        String logonuid = null;
        R3UserAccount account = null;
        try {
            block4: {
                try {
                    this.checkInitialized();
                    client = this.m_sapBasis.getClient();
                    logonuid = this.execSusrUserFromCertificateRfc(client, certificate);
                    if (logonuid == null) break block4;
                    account = this.getUser(client, logonuid, null).getImplicitUserAccount();
                }
                catch (Exception e) {
                    this.handleCertificateExceptionUMExceptionMethod("getUserAccount", e);
                    Object var8_7 = null;
                    this.m_sapBasis.releaseClient(client);
                }
            }
            Object var8_6 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("getUserAccount", EXITING);
        LOCATION.debugT("getUserAccount", RETURN_VAL + "IUserAccout " + account);
        return account;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IUserAccount getUserAccount(Map credentials) throws UMException, CertificateException {
        String method = "getUserAccount";
        LOCATION.pathT("getUserAccount", ENTERING);
        LOCATION.debugT("getUserAccount", METHOD_PARAM + "credentials = " + NOT_SHOWN);
        R3UserAccount account = null;
        JCO.Client client = null;
        try {
            block10: {
                try {
                    this.checkInitialized();
                    String logonuid = (String)credentials.get("com.sap.security.SAPUser");
                    Object ocertificate = credentials.get("javax.servlet.http.X509Certificate");
                    Object oticket = credentials.get("com.sap.security.SAPLogonTicket");
                    String b64ticket = null;
                    client = this.m_sapBasis.getClient();
                    if (oticket != null) {
                        if (!(oticket instanceof String)) throw new UMException("Credential \"com.sap.security.SAPLogonTicket\": expected java.lang.String, actual " + oticket.getClass().getName());
                        b64ticket = (String)oticket;
                    }
                    if (logonuid == null || logonuid.trim().equals("")) {
                        if (b64ticket != null) {
                            SimpleTicket ticket = new SimpleTicket();
                            ticket.setEnforceVerify(false);
                            ticket.setTicket(b64ticket);
                            logonuid = ticket.getUser();
                        } else {
                            if (ocertificate == null) throw new UMException("No supported credentials found in credentials map");
                            if (ocertificate instanceof X509Certificate) {
                                logonuid = this.execSusrUserFromCertificateRfc(client, (X509Certificate)ocertificate);
                            } else {
                                if (!(ocertificate instanceof String)) throw new UMException("Credential \"javax.servlet.http.X509Certificate\": expected java.lang.String or java.security.cert.X509Certificate, actual " + ocertificate.getClass().getName());
                                logonuid = this.execSusrUserFromCertificateRfc(client, (String)ocertificate);
                            }
                        }
                    }
                    if (logonuid == null) break block10;
                    account = this.getUser(client, logonuid, b64ticket).getImplicitUserAccount();
                }
                catch (Exception e) {
                    this.handleCertificateExceptionUMExceptionMethod("getUserAccount", e);
                    Object var11_12 = null;
                    this.m_sapBasis.releaseClient(client);
                }
            }
            Object var11_11 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("getUserAccount", EXITING);
        LOCATION.debugT("getUserAccount", "IUserAccount " + account);
        return account;
    }

    public IUserAccount getAuthenticatedUserAccount(Map credentials) throws UMException, AuthenticationFailedException, UserLockedException, CertificateException {
        String method = "getAuthenticatedUserAccount";
        LOCATION.pathT("getAuthenticatedUserAccount", ENTERING);
        LOCATION.debugT("getAuthenticatedUserAccount", METHOD_PARAM + "credentials = " + NOT_SHOWN);
        JCO.Client client = null;
        R3UserAccount account = null;
        try {
            try {
                this.checkInitialized();
                Object oticket = credentials.get("com.sap.security.SAPLogonTicket");
                Object ocertificate = credentials.get("javax.servlet.http.X509Certificate");
                String logonuid = (String)credentials.get("com.sap.security.SAPUser");
                String aliasuser = (String)credentials.get("com.sap.security.SAPAliasUser");
                String password = (String)credentials.get("com.sap.security.SAPPassword");
                String language = (String)credentials.get("com.sap.security.SAPLanguage");
                LoginResult loginresult = null;
                String b64ticket = null;
                if (oticket != null) {
                    if (oticket instanceof String) {
                        b64ticket = (String)oticket;
                    } else {
                        throw new UMException("Credential \"com.sap.security.SAPLogonTicket\": expected java.lang.String, actual " + oticket.getClass().getName());
                    }
                }
                if (this.m_sapBasis.acceptsTickets() && b64ticket != null) {
                    loginresult = this.m_loginHandler.checkTicket(b64ticket);
                } else if (logonuid != null && password != null) {
                    loginresult = this.m_loginHandler.checkUserPassword(logonuid, password, language);
                } else if (aliasuser != null && password != null) {
                    loginresult = this.m_loginHandler.checkAliasPassword(aliasuser, password, language);
                } else if (ocertificate != null) {
                    String b64certificate = null;
                    if (ocertificate instanceof String) {
                        b64certificate = (String)ocertificate;
                    } else if (ocertificate instanceof X509Certificate) {
                        b64certificate = Util.certificateToBase64((X509Certificate)ocertificate);
                    } else {
                        throw new UMException("Credential \"javax.servlet.http.X509Certificate\" expected java.lang.String or java.security.cert.X509Certificate, actual " + ocertificate.getClass().getName());
                    }
                    loginresult = this.m_loginHandler.checkUserCertificate(logonuid, b64certificate, language);
                } else {
                    throw new UMException("No supported credentials found");
                }
                if (b64ticket == null && loginresult.getTicket() != null) {
                    b64ticket = loginresult.getTicket();
                    credentials.put("com.sap.security.SAPLogonTicket", b64ticket);
                }
                client = this.m_sapBasis.getClient();
                account = this.getUser(client, loginresult.getUserName(), b64ticket).getImplicitUserAccount();
            }
            catch (Exception e) {
                this.handleCertificateExceptionUMExceptionMethod("getAuthenticatedUserAccount", e);
                Object var15_16 = null;
                this.m_sapBasis.releaseClient(client);
            }
            Object var15_15 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("getAuthenticatedUserAccount", EXITING);
        LOCATION.debugT("getAuthenticatedUserAccount", "IUserAccount " + account);
        return account;
    }

    public ISearchResult search(UserAccountSearchFilter uasf, int maxcount) {
        String method = "search";
        LOCATION.pathT("search", ENTERING);
        LOCATION.debugT("search", METHOD_PARAM + "uasf = " + uasf + METHOD_PARAM + "maxcount = " + maxcount);
        ISearchResult result = null;
        try {
            throw new FeatureNotAvailableException("search() is not available in this implementation");
        }
        catch (Exception e) {
            this.handleNoExceptionMethod("search", e);
            LOCATION.pathT("search", EXITING);
            LOCATION.debugT("search", RETURN_VAL + "ISearchResult " + result);
            return result;
        }
    }

    public void initialize(Properties pUserFactory) throws UMException {
        String method = "initialize(Properties)";
        LOCATION.pathT("initialize(Properties)", ENTERING);
        LOCATION.debugT("initialize(Properties)", METHOD_PARAM + "pUserFactory = " + pUserFactory);
        try {
            if (!this.m_initialized) {
                StringBuffer description = new StringBuffer();
                description.append(this.getClass().getName() + ":\n");
                String confVal = pUserFactory.getProperty("sapbasis");
                this.m_sapBasis = SAPBasis.getSAPBasis(confVal);
                if (this.m_sapBasis == null) {
                    throw new UMException("SAP Basis system \"" + confVal + "\" not found, " + "check trace location com.sap.security.util.SAPBasis " + "for errors during initialization");
                }
                description.append("\n   SAP Basis: " + this.m_sapBasis);
                this.processOptions(this.m_sapBasis, pUserFactory, description);
                this.m_description = description.toString();
                this.m_initialized = true;
            }
        }
        catch (Exception e) {
            this.handleUMExceptionMethod("initialize(Properties)", e);
        }
        LOCATION.pathT("initialize(Properties)", EXITING);
    }

    public IUser getUser(String uniqueID) throws NoSuchUserException {
        String method = "getUser";
        LOCATION.pathT("getUser", ENTERING);
        LOCATION.debugT("getUser", METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Client client = null;
        R3User user = null;
        try {
            try {
                this.checkInitialized();
                client = this.m_sapBasis.getClient();
                user = this.getUser(client, uniqueID, null);
            }
            catch (Exception e) {
                this.handleNoSuchUserExceptionMethod("getUser", e);
                Object var7_6 = null;
                this.m_sapBasis.releaseClient(client);
            }
            Object var7_5 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("getUser", EXITING);
        LOCATION.debugT("getUser", RETURN_VAL + "IUser " + user);
        return user;
    }

    public ISearchResult getUniqueIDs() {
        String method = "getUniqueIDs";
        LOCATION.pathT("getUniqueIDs", ENTERING);
        ISearchResult result = null;
        try {
            UserSearchFilter filter = new UserSearchFilter();
            filter.setUniqueID("*");
            result = this.searchUsers(filter);
            ArrayList<String> usernames = new ArrayList<String>(result.size());
            while (result.hasNext()) {
                usernames.add(((IUser)result.next()).getUniqueID());
            }
            result = new SearchResult(usernames);
        }
        catch (Exception e) {
            this.handleNoExceptionMethod("getUniqueIDs", e);
        }
        LOCATION.pathT("getUniqueIDs", EXITING);
        LOCATION.debugT("getUniqueIDs", RETURN_VAL + "ISearchResult " + result);
        return result;
    }

    public IUser[] getUsers(String[] uniqueIDs) throws NoSuchUserException {
        String method = "getUsers";
        LOCATION.pathT("getUsers", ENTERING);
        LOCATION.debugT("getUsers", METHOD_PARAM + "uniqueIDs = " + R3UserFactory.a2s(uniqueIDs));
        JCO.Client client = null;
        Object[] users = null;
        try {
            try {
                this.checkInitialized();
                client = this.m_sapBasis.getClient();
                users = new IUser[uniqueIDs.length];
            }
            catch (Exception e) {
                this.handleNoExceptionMethod("getUsers", e);
                Object var7_6 = null;
                this.m_sapBasis.releaseClient(client);
            }
            Object var7_5 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("getUsers", EXITING);
        LOCATION.debugT("getUsers", RETURN_VAL + "IUser[] " + R3UserFactory.a2s(users));
        return users;
    }

    public IUserMaint newUser(String uniqueID) throws InvalidIDException, UserAlreadyExistsException {
        String method = "newUser";
        LOCATION.pathT("newUser", ENTERING);
        LOCATION.debugT("newUser", METHOD_PARAM + "uniqueID = " + uniqueID);
        IUserMaint user = this.newUser(uniqueID, null);
        LOCATION.pathT("newUser", EXITING);
        LOCATION.debugT("newUser", RETURN_VAL + "IUserMaint " + user);
        return user;
    }

    public IUserMaint newUser(String uniqueID, IUser copyFrom) throws InvalidIDException, UserAlreadyExistsException {
        String method = "newUser";
        LOCATION.pathT("newUser", ENTERING);
        LOCATION.debugT("newUser", METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "copyFrom = " + copyFrom);
        IUserMaint user = null;
        JCO.Client client = null;
        try {
            try {
                this.checkInitialized();
                uniqueID = StandAloneUtil.charWiseUpperCase(uniqueID.trim());
                if (uniqueID.length() > 12) {
                    throw new InvalidIDException("The user name " + uniqueID + " is invalid (max. 12 chars)");
                }
                client = this.m_sapBasis.getClient();
                if (this.execBapiUserExistenceCheck(client, uniqueID)) {
                    throw new UserAlreadyExistsException("User " + uniqueID + " already exists");
                }
                HashMap<String, Object> databag = new HashMap<String, Object>();
                databag.put("m_newuser", Boolean.TRUE);
                databag.put("m_uniqueid", uniqueID);
                if (!this.m_timeStampSupported) {
                    databag.put("m_lastmodified", R3User.DATE_NOT_SUPPORTED);
                }
                if (copyFrom != null) {
                    databag.put("m_companyid", copyFrom.getCompanyId());
                    databag.put("m_title", copyFrom.getTitle());
                    databag.put("m_salutation", copyFrom.getSalutation());
                    databag.put("m_firstname", copyFrom.getFirstName());
                    databag.put("m_lastname", copyFrom.getLastName());
                    databag.put("m_department", copyFrom.getDepartment());
                    databag.put("m_jobtitle", copyFrom.getJobTitle());
                    databag.put("m_telephone", copyFrom.getTelephone());
                    databag.put("m_fax", copyFrom.getFax());
                    databag.put("m_email", copyFrom.getEmail());
                    databag.put("m_locale", copyFrom.getLocale());
                    databag.put("m_timezone", copyFrom.getTimeZone());
                }
                R3User r3user = new R3User(this, this.m_key);
                r3user.update(databag);
                user = r3user.prepare();
            }
            catch (Exception e) {
                LOCATION.errorT("newUser", "Caught Exception: " + R3UserFactory.t2s(e));
                if (e instanceof InvalidIDException) {
                    LOCATION.errorT("newUser", "Rethrowing original InvalidIDException");
                    throw (InvalidIDException)e;
                }
                if (e instanceof UserAlreadyExistsException) {
                    LOCATION.errorT("newUser", "Rethrowing original UserAlreadyExistsException");
                    throw (UserAlreadyExistsException)e;
                }
                UMRuntimeException re = new UMRuntimeException(e);
                LOCATION.errorT("newUser", "Throwing new UMRuntimeException: " + R3UserFactory.t2s(re));
                throw re;
            }
            Object var9_10 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("newUser", EXITING);
        LOCATION.debugT("newUser", RETURN_VAL + "IUserMaint " + user);
        return user;
    }

    public void deleteUser(String uniqueID) throws NoSuchUserException {
        String method = "deleteUser";
        LOCATION.pathT("deleteUser", ENTERING);
        LOCATION.debugT("deleteUser", METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Client client = null;
        try {
            try {
                this.checkInitialized();
                uniqueID = StandAloneUtil.charWiseUpperCase(uniqueID.trim());
                if (uniqueID.length() > 12) {
                    throw new NoSuchUserException("User " + uniqueID + "does not exist");
                }
                client = this.m_sapBasis.getClient();
                this.execBapiUserDelete(client, uniqueID);
                this.execBapiTransactionCommit(client);
                String msg = "User/account " + uniqueID + " deleted";
                LOCATION.infoT(this.m_category, "deleteUser", msg);
            }
            catch (Exception e) {
                this.execBapiTransactionRollback(client);
                this.handleNoSuchUserExceptionMethod("deleteUser", e);
                Object var6_7 = null;
                this.m_sapBasis.releaseClient(client);
            }
            Object var6_6 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("deleteUser", EXITING);
    }

    public void commitUsers(IUserMaint[] users) throws UMException {
        String method = "commitUsers";
        LOCATION.pathT("commitUsers", ENTERING);
        LOCATION.debugT("commitUsers", METHOD_PARAM + "users = " + R3UserFactory.a2s(users));
        try {
            int i = 0;
            while (i < users.length) {
                users[i].commit();
                ++i;
            }
        }
        catch (Exception e) {
            this.handleUMExceptionMethod("commitUsers", e);
        }
        LOCATION.pathT("commitUsers", EXITING);
    }

    public void rollbackUsers(IUserMaint[] users) {
        String method = "rollbackUsers";
        LOCATION.pathT("rollbackUsers", ENTERING);
        LOCATION.debugT("rollbackUsers", "users = " + R3UserFactory.a2s(users));
        try {
            int i = 0;
            while (i < users.length) {
                users[i].rollback();
                ++i;
            }
        }
        catch (Exception e) {
            this.handleNoExceptionMethod("rollbackUsers", e);
        }
        LOCATION.pathT("rollbackUsers", EXITING);
    }

    public ISearchResult searchUsers(UserSearchFilter filter) {
        String method = "searchUsers";
        LOCATION.pathT("searchUsers", ENTERING);
        LOCATION.debugT("searchUsers", METHOD_PARAM + "filter = " + filter);
        ISearchResult result = null;
        try {
            result = this.m_searchHandler.searchUsers(filter);
        }
        catch (Exception e) {
            this.handleNoExceptionMethod("searchUsers", e);
        }
        LOCATION.pathT("searchUsers", EXITING);
        LOCATION.debugT("searchUsers", RETURN_VAL + "ISearchResult " + result);
        return result;
    }

    public IUserMaint newUser() {
        String method = " newUser";
        LOCATION.pathT(" newUser", ENTERING);
        IUserMaint user = null;
        try {
            throw new FeatureNotAvailableException("newUser() is not available in this implementation");
        }
        catch (Exception e) {
            this.handleNoExceptionMethod(" newUser", e);
            LOCATION.pathT(" newUser", EXITING);
            LOCATION.debugT(" newUser", RETURN_VAL + "IUserMaint " + user);
            return user;
        }
    }

    public IUserMaint newUser(IUser copyFrom) {
        String method = "newUser";
        LOCATION.pathT("newUser", ENTERING);
        LOCATION.debugT("newUser", METHOD_PARAM + "copyFrom = " + copyFrom);
        IUserMaint user = null;
        try {
            throw new FeatureNotAvailableException("newUser(com.sap.security.usermanagement.IUser) is not available in this implementation");
        }
        catch (Exception e) {
            this.handleNoExceptionMethod("newUser", e);
            LOCATION.pathT("newUser", EXITING);
            LOCATION.debugT("newUser", RETURN_VAL + "IUserMaint " + user);
            return user;
        }
    }

    public void setKey(String key) {
        String method = "setKey";
        LOCATION.pathT("setKey", ENTERING);
        LOCATION.debugT("setKey", METHOD_PARAM + "key = " + key);
        this.m_key = key;
        LOCATION.pathT("setKey", EXITING);
    }

    public String getKey() {
        String method = "getKey";
        LOCATION.pathT("getKey", ENTERING);
        String key = this.m_key;
        LOCATION.pathT("getKey", EXITING);
        LOCATION.debugT("getKey", RETURN_VAL + "String " + key);
        return key;
    }

    public boolean isInitialized() {
        String method = "isInitialized";
        LOCATION.pathT("isInitialized", ENTERING);
        boolean result = this.m_initialized;
        LOCATION.pathT("isInitialized", EXITING);
        LOCATION.debugT("isInitialized", RETURN_VAL + "boolean " + result);
        return result;
    }

    public String toString() {
        if (this.m_description != null) {
            return this.m_description;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + ": not initialized");
        return sb.toString();
    }

    protected final SAPBasis getSAPBasis() {
        String method = "getSAPBasis";
        LOCATION.pathT("getSAPBasis", ENTERING);
        SAPBasis sapBasis = this.m_sapBasis;
        LOCATION.pathT("getSAPBasis", EXITING);
        LOCATION.debugT("getSAPBasis", "SAPBasis " + sapBasis);
        return sapBasis;
    }

    void commitUser(R3User r3user) throws UMException {
        block9: {
            String method = "commitUser";
            LOCATION.pathT("commitUser", ENTERING);
            LOCATION.debugT("commitUser", METHOD_PARAM + "r3user = " + r3user);
            try {
                this.checkInitialized();
                if (r3user.isNewUser()) {
                    this.createUserWithAccount(r3user);
                    break block9;
                }
                JCO.Client client = null;
                try {
                    try {
                        client = this.m_sapBasis.getClient();
                        this.execBapiUserChange(client, r3user);
                        this.execBapiTransactionCommit(client);
                        String msg = "User data of " + r3user.getUniqueID() + " saved successfully";
                        LOCATION.infoT(this.m_category, "commitUser", msg);
                    }
                    catch (Exception e) {
                        this.execBapiTransactionRollback(client);
                        throw e;
                    }
                    Object var6_7 = null;
                    this.m_sapBasis.releaseClient(client);
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.m_sapBasis.releaseClient(client);
                    throw throwable;
                }
                HashMap<String, Object> databag = new HashMap<String, Object>();
                if (!this.m_timeStampSupported) {
                    databag.put("m_lastmodified", R3User.DATE_NOT_SUPPORTED);
                } else {
                    databag.put("m_lastmodified", new Date());
                }
                databag.put("m_companyid", r3user.getCompanyId());
                databag.put("m_title", r3user.getTitle());
                databag.put("m_salutation", r3user.getSalutation());
                databag.put("m_firstname", r3user.getFirstName());
                databag.put("m_lastname", r3user.getLastName());
                databag.put("m_department", r3user.getDepartment());
                databag.put("m_jobtitle", r3user.getJobTitle());
                databag.put("m_telephone", r3user.getTelephone());
                databag.put("m_fax", r3user.getFax());
                databag.put("m_email", r3user.getEmail());
                databag.put("m_locale", r3user.getLocale());
                databag.put("m_timezone", r3user.getTimeZone());
                r3user.update(databag);
            }
            catch (Exception e) {
                this.handleUMExceptionMethod("commitUser", e);
            }
        }
        LOCATION.pathT("commitUser", EXITING);
    }

    void commitAccount(R3UserAccount account) throws UMException {
        block16: {
            String method = "commitAccount";
            LOCATION.pathT("commitAccount", ENTERING);
            LOCATION.debugT("commitAccount", METHOD_PARAM + "account = " + account);
            try {
                this.checkInitialized();
                if (account.getImplicitUser().isNewUser()) {
                    this.createUserWithAccount(account.getImplicitUser());
                    break block16;
                }
                JCO.Client client = null;
                String oldpw = account.getOldPassword();
                String productivepw = account.getProductivePassword();
                HashMap<String, Comparable<Boolean>> databag = new HashMap<String, Comparable<Boolean>>();
                try {
                    try {
                        String msg;
                        client = this.m_sapBasis.getClient();
                        this.execBapiUserChange(client, account);
                        if (oldpw != null && productivepw != null) {
                            this.execSusrUserChangePasswordRfc(client, account.getLogonUid(), oldpw, productivepw);
                            msg = "Password of account " + account.getLogonUid() + " changed successfully";
                            LOCATION.infoT(this.m_category, "commitAccount", msg);
                            databag.put("m_pwchangerequired", Boolean.FALSE);
                        } else {
                            if (oldpw == null && productivepw != null) {
                                throw new UMException("Current password not supplied for password change");
                            }
                            if (oldpw != null && productivepw == null) {
                                throw new UMException("New password not supplied for password change");
                            }
                        }
                        if (account.isModified("m_locked")) {
                            if (account.isLocked()) {
                                this.execBapiUserLock(client, account.getLogonUid());
                                msg = "Account " + account.getLogonUid() + " locked successfully";
                                LOCATION.infoT(this.m_category, "commitAccount", msg);
                            } else {
                                this.execBapiUserUnlock(client, account.getLogonUid());
                                msg = "Account " + account.getLogonUid() + " unlocked successfully";
                                LOCATION.infoT(this.m_category, "commitAccount", msg);
                            }
                        }
                        this.execBapiTransactionCommit(client);
                    }
                    catch (Exception e) {
                        this.execBapiTransactionRollback(client);
                        throw e;
                    }
                    Object var9_10 = null;
                    account.clearPasswords();
                    this.m_sapBasis.releaseClient(client);
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    account.clearPasswords();
                    this.m_sapBasis.releaseClient(client);
                    throw throwable;
                }
                if (!this.m_timeStampSupported) {
                    databag.put("m_lastmodified", R3User.DATE_NOT_SUPPORTED);
                } else {
                    databag.put("m_lastmodified", new Date());
                }
                databag.put("m_validfrom", account.getValidFromDate());
                databag.put("m_validto", account.getValidToDate());
                databag.put("m_locked", account.isLocked() ? Boolean.TRUE : Boolean.FALSE);
                account.update(databag);
                account.getImplicitUser().update(databag);
            }
            catch (Exception e) {
                this.handleUMExceptionMethod("commitAccount", e);
            }
        }
        LOCATION.pathT("commitAccount", EXITING);
    }

    boolean checkPassword(String logonUid, String password) {
        boolean retval;
        block10: {
            String method = "checkPassword";
            LOCATION.pathT("checkPassword", ENTERING);
            LOCATION.debugT("checkPassword", METHOD_PARAM + "logonUid = " + logonUid + METHOD_PARAM + "password = " + NOT_SHOWN);
            JCO.Client client = null;
            retval = false;
            try {
                this.checkInitialized();
                try {
                    try {
                        client = this.m_sapBasis.getClient();
                        this.execSusrLoginCheckRfc(client, logonUid, password);
                        retval = true;
                    }
                    catch (JCO.AbapException ae) {
                        if ("NO_CHECK_FOR_THIS_USER".equals(ae.getKey()) || "USER_LOCKED".equals(ae.getKey()) || "USER_NOT_ACTIVE".equals(ae.getKey()) || "WRONG_PASSWORD".equals(ae.getKey())) {
                            retval = false;
                            String msg = "Password check for account " + logonUid + " failed";
                            LOCATION.warningT(this.m_category, "checkPassword", msg);
                        } else if ("PASSWORD_EXPIRED".equals(ae.getKey())) {
                            retval = true;
                        } else {
                            throw ae;
                        }
                        Object var9_7 = null;
                        this.m_sapBasis.releaseClient(client);
                        break block10;
                    }
                    Object var9_6 = null;
                    this.m_sapBasis.releaseClient(client);
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    this.m_sapBasis.releaseClient(client);
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.handleNoExceptionMethod("checkPassword", e);
            }
        }
        LOCATION.pathT("checkPassword", EXITING);
        LOCATION.debugT("checkPassword", RETURN_VAL + "boolean " + retval);
        return retval;
    }

    private void execBapiUserGetDetail(JCO.Client client, String uniqueID, Map databag, int getTables) throws Exception {
        String method = "execBapiUserGetDetail";
        String rfcFunc = "BAPI_USER_GET_DETAIL";
        LOCATION.pathT("execBapiUserGetDetail", ENTERING);
        LOCATION.debugT("execBapiUserGetDetail", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "databag = " + NOT_SHOWN + METHOD_PARAM + "getTables = " + getTables);
        JCO.Function getdetail = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_GET_DETAIL").getFunction();
        getdetail.getImportParameterList().setValue(uniqueID, "USERNAME");
        JCO.ParameterList tables = getdetail.getTableParameterList();
        int fieldCnt = tables.getFieldCount();
        int i = 0;
        while (i < fieldCnt) {
            tables.setActive(false, i);
            ++i;
        }
        tables.setActive((getTables & 1) != 0, "ACTIVITYGROUPS");
        client.execute(getdetail);
        JCO.Structure expAddress = getdetail.getExportParameterList().getStructure("ADDRESS");
        JCO.Structure expCompany = getdetail.getExportParameterList().getStructure("COMPANY");
        JCO.Structure expLogonData = getdetail.getExportParameterList().getStructure("LOGONDATA");
        JCO.Table tabReturn = tables.getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserGetDetail", "BAPI_USER_GET_DETAIL", tabReturn);
        databag.put("m_companyid", expCompany.getString("COMPANY"));
        databag.put("m_title", expAddress.getString("TITLE_ACA1"));
        databag.put("m_salutation", expAddress.getString("TITLE_P"));
        databag.put("m_firstname", expAddress.getString("FIRSTNAME"));
        databag.put("m_lastname", expAddress.getString("LASTNAME"));
        databag.put("m_department", expAddress.getString("DEPARTMENT"));
        databag.put("m_jobtitle", expAddress.getString("FUNCTION"));
        String telephone = expAddress.getString("TEL1_NUMBR") + "-" + expAddress.getString("TEL1_EXT");
        if (telephone.trim().equals("-")) {
            databag.put("m_telephone", "");
        } else {
            databag.put("m_telephone", telephone);
        }
        String fax = expAddress.getString("FAX_NUMBER") + "-" + expAddress.getString("FAX_EXTENS");
        if (fax.trim().equals("-")) {
            databag.put("m_fax", "");
        } else {
            databag.put("m_fax", fax);
        }
        databag.put("m_email", expAddress.getString("E_MAIL"));
        String localelanguage = expAddress.getString("LANGUP_ISO").toLowerCase();
        String localecountry = expAddress.getString("NAMCOUNTRY");
        Locale locale = null;
        if (!"".equals(localelanguage) || !"".equals(localecountry)) {
            locale = new Locale(localelanguage, localecountry);
        }
        databag.put("m_locale", locale);
        databag.put("m_timezone", this.m_timeZoneHandler.getJavaTimeZone(expLogonData.getString("TZONE")));
        databag.put("m_validfrom", expLogonData.getDate("GLTGV"));
        databag.put("m_validto", expLogonData.getDate("GLTGB"));
        if ((getTables & 1) != 0) {
            JCO.Table roleTable = tables.getTable("ACTIVITYGROUPS");
            int roleCount = roleTable.getNumRows();
            String[] roleNames = new String[roleCount];
            int i2 = 0;
            while (i2 < roleCount) {
                roleTable.setRow(i2);
                roleNames[i2] = roleTable.getString("AGR_NAME");
                ++i2;
            }
            databag.put("EXTERNAL_ROLES", roleNames);
        }
        LOCATION.pathT("execBapiUserGetDetail", EXITING);
    }

    private void execBapiUserChange(JCO.Client client, R3User r3user) throws Exception {
        String method = "execBapiUserChange";
        String rfcFunc = "BAPI_USER_CHANGE";
        LOCATION.pathT("execBapiUserChange", ENTERING);
        LOCATION.debugT("execBapiUserChange", METHOD_PARAM + "client = " + client + METHOD_PARAM + "r3user = " + r3user);
        JCO.Function changeuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_CHANGE").getFunction();
        JCO.ParameterList imports = changeuser.getImportParameterList();
        imports.setValue(r3user.getUniqueID(), "USERNAME");
        this.fillBapiLogonData(imports.getStructure("LOGONDATA"), imports.getStructure("LOGONDATAX"), r3user);
        this.fillBapiAddress(imports.getStructure("ADDRESS"), imports.getStructure("ADDRESSX"), r3user);
        if (r3user.isModified("m_companyid")) {
            imports.getStructure("COMPANYX").setValue("X", "COMPANY");
            imports.getStructure("COMPANY").setValue(r3user.getCompanyId(), "COMPANY");
        }
        client.execute(changeuser);
        JCO.Table tabReturn = changeuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserChange", "BAPI_USER_CHANGE", tabReturn);
        LOCATION.pathT("execBapiUserChange", EXITING);
    }

    private void execBapiUserChange(JCO.Client client, R3UserAccount account) throws Exception {
        String method = "execBapiUserChange";
        String rfcFunc = "BAPI_USER_CHANGE";
        LOCATION.pathT("execBapiUserChange", ENTERING);
        LOCATION.debugT("execBapiUserChange", METHOD_PARAM + "client = " + client + METHOD_PARAM + "account = " + account);
        JCO.Function changeuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_CHANGE").getFunction();
        JCO.ParameterList imports = changeuser.getImportParameterList();
        imports.setValue(account.getLogonUid(), "USERNAME");
        this.fillBapiLogonData(imports.getStructure("LOGONDATA"), imports.getStructure("LOGONDATAX"), account);
        String initialpw = account.getInitialPassword();
        if (initialpw != null) {
            imports.getStructure("PASSWORD").setValue(StandAloneUtil.charWiseUpperCase(initialpw), "BAPIPWD");
            imports.getStructure("PASSWORDX").setValue("X", "BAPIPWD");
            String msg = "Password of account " + account.getLogonUid() + " reset";
            LOCATION.infoT(this.m_category, "execBapiUserChange", msg);
        }
        client.execute(changeuser);
        JCO.Table tabReturn = changeuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserChange", "BAPI_USER_CHANGE", tabReturn);
        LOCATION.pathT("execBapiUserChange", EXITING);
    }

    private void execBapiUserCreate1(JCO.Client client, R3User r3user, String initialpw) throws Exception {
        String method = "execBapiUserCreate1";
        String rfcFunc = "BAPI_USER_CREATE1";
        LOCATION.pathT("execBapiUserCreate1", ENTERING);
        LOCATION.debugT("execBapiUserCreate1", METHOD_PARAM + "client = " + client + METHOD_PARAM + "r3user = " + r3user + METHOD_PARAM + "initialpw = " + NOT_SHOWN);
        JCO.Function createuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_CREATE1").getFunction();
        JCO.ParameterList imports = createuser.getImportParameterList();
        JCO.Structure logondata = imports.getStructure("LOGONDATA");
        imports.setValue(r3user.getUniqueID(), "USERNAME");
        if (initialpw != null) {
            imports.getStructure("PASSWORD").setValue(StandAloneUtil.charWiseUpperCase(initialpw), "BAPIPWD");
        } else {
            logondata.setValue("X", "CODVN");
        }
        this.fillBapiAddress(imports.getStructure("ADDRESS"), null, r3user);
        this.fillBapiLogonData(logondata, null, r3user);
        this.fillBapiLogonData(logondata, null, r3user.getImplicitUserAccount());
        if (this.m_referenceUser != null) {
            imports.getStructure("REF_USER").setValue(this.m_referenceUser, "REF_USER");
        }
        if (r3user.isModified("m_companyid")) {
            imports.getStructure("COMPANY").setValue(r3user.getCompanyId(), "COMPANY");
        }
        client.execute(createuser);
        JCO.Table tabReturn = createuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserCreate1", "BAPI_USER_CREATE1", tabReturn);
        LOCATION.pathT("execBapiUserCreate1", EXITING);
    }

    private void execSusrUserChangePasswordRfc(JCO.Client client, String uniqueID, String oldPassword, String newPassword) throws Exception {
        String method = "execSusrUserChangePasswordRfc";
        String rfcFunc = "SUSR_USER_CHANGE_PASSWORD_RFC";
        LOCATION.pathT("execSusrUserChangePasswordRfc", ENTERING);
        LOCATION.debugT("execSusrUserChangePasswordRfc", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "oldPassword = " + NOT_SHOWN + METHOD_PARAM + "newPassword = " + NOT_SHOWN);
        try {
            JCO.Function changepassword = this.m_sapBasis.getRepository().getFunctionTemplate("SUSR_USER_CHANGE_PASSWORD_RFC").getFunction();
            JCO.ParameterList imports = changepassword.getImportParameterList();
            imports.setValue(uniqueID, "BNAME");
            imports.setValue(StandAloneUtil.charWiseUpperCase(oldPassword), "PASSWORD");
            imports.setValue(StandAloneUtil.charWiseUpperCase(newPassword), "NEW_PASSWORD");
            client.execute(changepassword);
        }
        catch (JCO.AbapException ae) {
            if ("CHANGE_NOT_ALLOWED".equals(ae.getKey()) || "PASSWORD_NOT_ALLOWED".equals(ae.getKey())) {
                throw new UMException(ae.getKey());
            }
            throw ae;
        }
        LOCATION.pathT("execSusrUserChangePasswordRfc", EXITING);
    }

    private void execFsusrGetTimeStamp(JCO.Client client, String uniqueID, Map databag) throws Exception {
        String method = "execFsusrGetTimeStamp";
        String rfcFunc = "FSUSR_GET_TIMESTAMP";
        LOCATION.pathT("execFsusrGetTimeStamp", ENTERING);
        LOCATION.debugT("execFsusrGetTimeStamp", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "databag = " + NOT_SHOWN);
        if (!this.m_timeStampSupported) {
            databag.put("m_lastmodified", R3User.DATE_NOT_SUPPORTED);
            LOCATION.infoT("execFsusrGetTimeStamp", "RFC Function module FSUSR_GET_TIMESTAMP not available at " + this.m_sapBasis);
        } else {
            try {
                JCO.Function gettimestamp = this.m_sapBasis.getRepository().getFunctionTemplate("FSUSR_GET_TIMESTAMP").getFunction();
                JCO.ParameterList imports = gettimestamp.getImportParameterList();
                imports.setValue(uniqueID, "USERNAME");
                client.execute(gettimestamp);
                JCO.ParameterList exports = gettimestamp.getExportParameterList();
                Date moddate = exports.getDate("MODDATE");
                Date modtime = exports.getDate("MODTIME");
                if (moddate == null || modtime == null) {
                    databag.put("m_lastmodified", null);
                    String msg = "User time stamp not fully maintained: BNAME=" + uniqueID + ", MODDATE=" + moddate + ", MODTIME=" + modtime;
                    LOCATION.warningT(this.m_category, "execFsusrGetTimeStamp", msg);
                } else {
                    Calendar moddatecal = Calendar.getInstance();
                    Calendar modtimecal = Calendar.getInstance();
                    moddatecal.setTime(moddate);
                    modtimecal.setTime(modtime);
                    moddatecal.set(11, modtimecal.get(11));
                    moddatecal.set(12, modtimecal.get(12));
                    moddatecal.set(13, modtimecal.get(13));
                    Date lastmodified = moddatecal.getTime();
                    databag.put("m_lastmodified", lastmodified);
                }
            }
            catch (JCO.AbapException ae) {
                if ("USERNAME_ERROR".equals(ae.getKey())) {
                    throw new NoSuchUserException("User " + uniqueID + " does not exist");
                }
                throw ae;
            }
        }
        LOCATION.pathT("execFsusrGetTimeStamp", EXITING);
    }

    private void execBapiUserLock(JCO.Client client, String uniqueID) throws Exception {
        String method = "execBapiUserLock";
        String rfcFunc = "BAPI_USER_LOCK";
        LOCATION.pathT("execBapiUserLock", ENTERING);
        LOCATION.debugT("execBapiUserLock", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Function lockuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_LOCK").getFunction();
        lockuser.getImportParameterList().setValue(uniqueID, "USERNAME");
        client.execute(lockuser);
        JCO.Table tabReturn = lockuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserLock", "BAPI_USER_LOCK", tabReturn);
        LOCATION.pathT("execBapiUserLock", EXITING);
    }

    private void execBapiUserUnlock(JCO.Client client, String uniqueID) throws Exception {
        String method = "execBapiUserUnlock";
        String rfcFunc = "BAPI_USER_UNLOCK";
        LOCATION.pathT("execBapiUserUnlock", ENTERING);
        LOCATION.debugT("execBapiUserUnlock", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Function unlockuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_UNLOCK").getFunction();
        unlockuser.getImportParameterList().setValue(uniqueID, "USERNAME");
        client.execute(unlockuser);
        JCO.Table tabReturn = unlockuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserUnlock", "BAPI_USER_UNLOCK", tabReturn);
        LOCATION.pathT("execBapiUserUnlock", EXITING);
    }

    private void execBapiTransactionCommit(JCO.Client client) throws Exception {
        String method = "execBapiTransactionCommit";
        String rfcFunc = "BAPI_TRANSACTION_COMMIT";
        LOCATION.pathT("execBapiTransactionCommit", ENTERING);
        LOCATION.debugT("execBapiTransactionCommit", METHOD_PARAM + "client = " + client);
        JCO.Function commit = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_TRANSACTION_COMMIT").getFunction();
        commit.getImportParameterList().setValue("X", "WAIT");
        client.execute(commit);
        JCO.Structure structReturn = commit.getExportParameterList().getStructure("RETURN");
        this.handleBapiRet2Struct("execBapiTransactionCommit", "BAPI_TRANSACTION_COMMIT", structReturn);
        LOCATION.pathT("execBapiTransactionCommit", EXITING);
    }

    private void execBapiTransactionRollback(JCO.Client client) {
        String method = "execBapiTransactionRollback";
        String rfcFunc = "BAPI_TRANSACTION_ROLLBACK";
        LOCATION.pathT("execBapiTransactionRollback", ENTERING);
        LOCATION.debugT("execBapiTransactionRollback", METHOD_PARAM + "client = " + client);
        SAPBasis sapBasis = this.m_sapBasis;
        LOCATION.debugT("execBapiTransactionRollback", "sapBasis = " + sapBasis);
        if (client != null && sapBasis != null) {
            try {
                JCO.Function rollback = sapBasis.getRepository().getFunctionTemplate("BAPI_TRANSACTION_ROLLBACK").getFunction();
                client.execute(rollback);
                JCO.Structure structReturn = rollback.getExportParameterList().getStructure("RETURN");
                this.handleBapiRet2Struct("execBapiTransactionRollback", "BAPI_TRANSACTION_ROLLBACK", structReturn);
            }
            catch (Exception e) {
                LOCATION.errorT("execBapiTransactionRollback", "Caught Exception: " + R3UserFactory.t2s(e));
            }
        }
        LOCATION.pathT("execBapiTransactionRollback", EXITING);
    }

    private void execBapiUserDelete(JCO.Client client, String uniqueID) throws Exception {
        String method = "execBapiUserDelete";
        String rfcFunc = "BAPI_USER_DELETE";
        LOCATION.pathT("execBapiUserDelete", ENTERING);
        LOCATION.debugT("execBapiUserDelete", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Function deleteuser = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_DELETE").getFunction();
        deleteuser.getImportParameterList().setValue(uniqueID, "USERNAME");
        client.execute(deleteuser);
        JCO.Table tabReturn = deleteuser.getTableParameterList().getTable("RETURN");
        this.handleBapiRet2Table("execBapiUserDelete", "BAPI_USER_DELETE", tabReturn);
        LOCATION.pathT("execBapiUserDelete", EXITING);
    }

    private boolean execBapiUserExistenceCheck(JCO.Client client, String uniqueID) throws Exception {
        String method = "execBapiUserExistenceCheck";
        String rfcFunc = "BAPI_USER_EXISTENCE_CHECK";
        LOCATION.pathT("execBapiUserExistenceCheck", ENTERING);
        LOCATION.debugT("execBapiUserExistenceCheck", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID);
        boolean retval = false;
        JCO.Function existencecheck = this.m_sapBasis.getRepository().getFunctionTemplate("BAPI_USER_EXISTENCE_CHECK").getFunction();
        existencecheck.getImportParameterList().setValue(uniqueID, "USERNAME");
        client.execute(existencecheck);
        JCO.Structure structReturn = existencecheck.getExportParameterList().getStructure("RETURN");
        if (structReturn.getString("TYPE").equals("I") && structReturn.getString("NUMBER").equals(EXISTENCE_CONFIRMED_MSGNO)) {
            retval = true;
        }
        LOCATION.pathT("execBapiUserExistenceCheck", EXITING);
        LOCATION.debugT("execBapiUserExistenceCheck", RETURN_VAL + "boolean " + retval);
        return retval;
    }

    private String execSusrUserFromCertificateRfc(JCO.Client client, X509Certificate certificate) throws Exception {
        String method = "execSusrUserFromCertificateRfc";
        LOCATION.pathT("execSusrUserFromCertificateRfc", ENTERING);
        LOCATION.debugT("execSusrUserFromCertificateRfc", METHOD_PARAM + "client = " + client + METHOD_PARAM + "certificate = " + certificate);
        String b64certificate = null;
        b64certificate = Util.certificateToBase64(certificate);
        String uniqueID = this.execSusrUserFromCertificateRfc(client, b64certificate);
        LOCATION.pathT("execSusrUserFromCertificateRfc", EXITING);
        LOCATION.debugT("execSusrUserFromCertificateRfc", RETURN_VAL + "String " + uniqueID);
        return uniqueID;
    }

    private String execSusrUserFromCertificateRfc(JCO.Client client, String b64certificate) throws Exception {
        String method = "execSusrUserFromCertificateRfc";
        String rfcFunc = "SUSR_USER_FROM_CERTIFICATE_RFC";
        LOCATION.pathT("execSusrUserFromCertificateRfc", ENTERING);
        LOCATION.debugT("execSusrUserFromCertificateRfc", METHOD_PARAM + "client = " + client + METHOD_PARAM + "b64certificate = " + b64certificate);
        String logonuid = null;
        try {
            JCO.Function userfromcert = this.m_sapBasis.getRepository().getFunctionTemplate("SUSR_USER_FROM_CERTIFICATE_RFC").getFunction();
            JCO.ParameterList imports = userfromcert.getImportParameterList();
            b64certificate = Util.stripUnwantedChars(b64certificate);
            imports.setValue(b64certificate.length(), "EXTID_LENGTH");
            imports.setValue("1", "EXTID_TYPE");
            JCO.Table extiddata = userfromcert.getTableParameterList().getTable("EXTID_DATA");
            int linelen = extiddata.getLength("LINE");
            int beginIndex = 0;
            int linetype = extiddata.getType("LINE");
            if (linetype == 0) {
                while (beginIndex < b64certificate.length()) {
                    extiddata.appendRow();
                    int endIndex = beginIndex + linelen < b64certificate.length() ? beginIndex + linelen : b64certificate.length();
                    String utfline = b64certificate.substring(beginIndex, endIndex);
                    extiddata.setValue(utfline, "LINE");
                    beginIndex += linelen;
                }
            } else if (linetype == 4) {
                byte[] asciicertificate = b64certificate.getBytes();
                byte[] rawline = new byte[linelen];
                while (beginIndex < asciicertificate.length) {
                    extiddata.appendRow();
                    int numbytes = asciicertificate.length - beginIndex < linelen ? asciicertificate.length - beginIndex : linelen;
                    System.arraycopy(asciicertificate, beginIndex, rawline, 0, numbytes);
                    extiddata.setValue(rawline, "LINE");
                    beginIndex += linelen;
                }
            } else {
                throw new UMException("Table EXTID_DATA has unexpected line type (" + extiddata.getTypeAsString("LINE") + ")");
            }
            client.execute(userfromcert);
            logonuid = StandAloneUtil.charWiseUpperCase(userfromcert.getExportParameterList().getString("BNAME").trim());
        }
        catch (JCO.AbapException ae) {
            if ("NO_USER_ASSIGNED".equals(ae.getKey())) {
                logonuid = null;
            }
            if ("MULTIPLE_USERS_ASSIGNED".equals(ae.getKey())) {
                throw new UMException(ae.getKey());
            }
            if ("USER_INACTIVE".equals(ae.getKey())) {
                throw new UserLockedException(ae.getKey());
            }
            if ("CERTIFICATE_INVALID".equals(ae.getKey())) {
                throw new CertificateException(ae.getKey());
            }
            throw ae;
        }
        LOCATION.pathT("execSusrUserFromCertificateRfc", EXITING);
        LOCATION.debugT("execSusrUserFromCertificateRfc", RETURN_VAL + "String " + logonuid);
        return logonuid;
    }

    private void execSusrLoginCheckRfc(JCO.Client client, String uniqueID, String password) throws Exception {
        String method = "execSusrLoginCheckRfc";
        String rfcFunc = "SUSR_LOGIN_CHECK_RFC";
        LOCATION.pathT("execSusrLoginCheckRfc", ENTERING);
        LOCATION.debugT("execSusrLoginCheckRfc", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "password = " + NOT_SHOWN);
        JCO.Function checklogin = this.m_sapBasis.getRepository().getFunctionTemplate("SUSR_LOGIN_CHECK_RFC").getFunction();
        if (uniqueID != null) {
            checklogin.getImportParameterList().setValue(uniqueID, "BNAME");
        }
        if (password != null) {
            checklogin.getImportParameterList().setValue(StandAloneUtil.charWiseUpperCase(password), "PASSWORD");
        }
        client.execute(checklogin);
        LOCATION.pathT("execSusrLoginCheckRfc", EXITING);
    }

    private void createUserWithAccount(R3User r3user) throws Exception {
        String method = "createUserWithAccount";
        LOCATION.pathT("createUserWithAccount", ENTERING);
        LOCATION.debugT("createUserWithAccount", METHOD_PARAM + "r3user = " + r3user);
        JCO.Client client = null;
        boolean usercreated = false;
        R3UserAccount account = r3user.getImplicitUserAccount();
        IUserAccount extaccount = r3user.getUserAccount();
        if (extaccount != null && extaccount != account) {
            extaccount.prepare();
            extaccount.save();
            extaccount.commit();
        }
        String initialpw = account.getInitialPassword();
        String productivepw = account.getProductivePassword();
        if ((initialpw == null || "".equals(initialpw)) && productivepw != null && !"".equals(productivepw)) {
            initialpw = Util.getRandomPassword(8);
        }
        if ("".equals(r3user.getLastName())) {
            r3user.setLastName(r3user.getUniqueID());
        }
        HashMap<String, Object> databag = new HashMap<String, Object>();
        try {
            try {
                client = this.m_sapBasis.getClient();
                this.execBapiUserCreate1(client, r3user, initialpw);
                this.execBapiTransactionCommit(client);
                usercreated = true;
                if (productivepw != null) {
                    this.execSusrUserChangePasswordRfc(client, r3user.getUniqueID(), initialpw, productivepw);
                    databag.put("m_pwchangerequired", Boolean.FALSE);
                }
                if (account.isLocked()) {
                    this.execBapiUserLock(client, r3user.getUniqueID());
                }
                this.execBapiTransactionCommit(client);
                account.clearPasswords();
                String msg = "User/account " + r3user.getUniqueID() + " created";
                LOCATION.infoT(this.m_category, "createUserWithAccount", msg);
            }
            catch (Exception e1) {
                if (usercreated) {
                    try {
                        this.execBapiTransactionRollback(client);
                        this.execBapiUserDelete(client, r3user.getUniqueID());
                        this.execBapiTransactionCommit(client);
                    }
                    catch (Exception e2) {
                        LOCATION.errorT("createUserWithAccount", "Caught Exception: " + R3UserFactory.t2s(e2));
                    }
                }
                throw e1;
            }
            Object var13_12 = null;
            this.m_sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.m_sapBasis.releaseClient(client);
            throw throwable;
        }
        if (!this.m_timeStampSupported) {
            databag.put("m_lastmodified", R3User.DATE_NOT_SUPPORTED);
        } else {
            databag.put("m_lastmodified", new Date());
        }
        databag.put("m_newuser", Boolean.FALSE);
        databag.put("m_companyid", r3user.getCompanyId());
        databag.put("m_title", r3user.getTitle());
        databag.put("m_salutation", r3user.getSalutation());
        databag.put("m_firstname", r3user.getFirstName());
        databag.put("m_lastname", r3user.getLastName());
        databag.put("m_department", r3user.getDepartment());
        databag.put("m_jobtitle", r3user.getJobTitle());
        databag.put("m_telephone", r3user.getTelephone());
        databag.put("m_fax", r3user.getFax());
        databag.put("m_email", r3user.getEmail());
        databag.put("m_locale", r3user.getLocale());
        databag.put("m_timezone", r3user.getTimeZone());
        databag.put("m_validfrom", account.getValidFromDate());
        databag.put("m_validto", account.getValidToDate());
        databag.put("m_locked", new Boolean(account.isLocked()));
        r3user.update(databag);
        r3user.rollback();
        account.update(databag);
        LOCATION.pathT("createUserWithAccount", EXITING);
    }

    private void fillBapiAddress(JCO.Structure bapiaddr3, JCO.Structure bapiaddr3x, R3User r3user) throws Exception {
        String[] numberextension;
        String method = "fillBapiAddress";
        LOCATION.pathT("fillBapiAddress", ENTERING);
        LOCATION.debugT("fillBapiAddress", METHOD_PARAM + "bapiaddr3 = " + bapiaddr3 + METHOD_PARAM + "bapiaddr3x = " + bapiaddr3x + METHOD_PARAM + "r3user = " + r3user);
        if (r3user.isModified("m_salutation")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "TITLE_P");
            }
            bapiaddr3.setValue(r3user.getSalutation(), "TITLE_P");
        }
        if (r3user.isModified("m_title")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "TITLE_ACA1");
            }
            bapiaddr3.setValue(r3user.getTitle(), "TITLE_ACA1");
        }
        if (r3user.isModified("m_jobtitle")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "FUNCTION");
            }
            bapiaddr3.setValue(r3user.getJobTitle(), "FUNCTION");
        }
        if (r3user.isModified("m_department")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "DEPARTMENT");
            }
            bapiaddr3.setValue(r3user.getDepartment(), "DEPARTMENT");
        }
        if (r3user.isModified("m_firstname")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "FIRSTNAME");
            }
            bapiaddr3.setValue(r3user.getFirstName(), "FIRSTNAME");
        }
        if (r3user.isModified("m_lastname")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "LASTNAME");
            }
            bapiaddr3.setValue(r3user.getLastName(), "LASTNAME");
        }
        if (r3user.isModified("m_telephone")) {
            numberextension = Util.splitPhoneNumber(r3user.getTelephone());
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "TEL1_NUMBR");
                bapiaddr3x.setValue("X", "TEL1_EXT");
            }
            bapiaddr3.setValue(numberextension[0], "TEL1_NUMBR");
            bapiaddr3.setValue(numberextension[1], "TEL1_EXT");
        }
        if (r3user.isModified("m_fax")) {
            numberextension = Util.splitPhoneNumber(r3user.getFax());
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "FAX_NUMBER");
                bapiaddr3x.setValue("X", "FAX_EXTENS");
            }
            bapiaddr3.setValue(numberextension[0], "FAX_NUMBER");
            bapiaddr3.setValue(numberextension[1], "FAX_EXTENS");
        }
        if (r3user.isModified("m_email")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "E_MAIL");
            }
            bapiaddr3.setValue(r3user.getEmail(), "E_MAIL");
        }
        if (r3user.isModified("m_locale")) {
            if (bapiaddr3x != null) {
                bapiaddr3x.setValue("X", "NAMCOUNTRY");
                bapiaddr3x.setValue("X", "LANGUP_ISO");
                bapiaddr3x.setValue("X", "LANGU_P");
            }
            Locale locale = r3user.getLocale();
            String isoCountry = null;
            String isoLanguage = null;
            if (locale != null) {
                isoCountry = locale.getCountry();
                isoLanguage = StandAloneUtil.charWiseUpperCase(locale.getLanguage());
            } else {
                isoCountry = "";
                isoLanguage = "";
            }
            bapiaddr3.setValue(isoCountry, "NAMCOUNTRY");
            bapiaddr3.setValue(isoLanguage, "LANGUP_ISO");
        }
        LOCATION.pathT("fillBapiAddress", EXITING);
    }

    private void fillBapiLogonData(JCO.Structure bapilogond, JCO.Structure bapilogonx, R3User r3user) throws Exception {
        String method = "fillBapiLogonData";
        LOCATION.pathT("fillBapiLogonData", ENTERING);
        LOCATION.debugT("fillBapiLogonData", METHOD_PARAM + "bapilogond = " + bapilogond + METHOD_PARAM + "bapilogonx = " + bapilogonx + METHOD_PARAM + "r3user = " + r3user);
        if (r3user.isModified("m_timezone")) {
            bapilogond.setValue(this.m_timeZoneHandler.getSAPTimeZone(r3user.getTimeZone()), "TZONE");
            if (bapilogonx != null) {
                bapilogonx.setValue("X", "TZONE");
            }
        }
        LOCATION.pathT("fillBapiLogonData", EXITING);
    }

    private void fillBapiLogonData(JCO.Structure bapilogond, JCO.Structure bapilogonx, R3UserAccount account) throws Exception {
        String msg;
        String method = "fillBapiLogonData";
        LOCATION.pathT("fillBapiLogonData", ENTERING);
        LOCATION.debugT("fillBapiLogonData", METHOD_PARAM + "bapilogond = " + bapilogond + METHOD_PARAM + "bapilogonx = " + bapilogonx + METHOD_PARAM + "account = " + account);
        if (account.isModified("m_validfrom")) {
            if (account.getValidFromDate() != null) {
                bapilogond.setValue((Object)account.getValidFromDate(), "GLTGV");
                msg = "Valid From date of account " + account.getLogonUid() + " changed";
                LOCATION.infoT(this.m_category, "fillBapiLogonData", msg);
            }
            if (bapilogonx != null) {
                bapilogonx.setValue("X", "GLTGV");
            }
        }
        if (account.isModified("m_validto")) {
            if (account.getValidToDate() != null) {
                bapilogond.setValue((Object)account.getValidToDate(), "GLTGB");
                msg = "Valid To date of account " + account.getLogonUid() + " changed";
                LOCATION.infoT(this.m_category, "fillBapiLogonData", msg);
            }
            if (bapilogonx != null) {
                bapilogonx.setValue("X", "GLTGB");
            }
        }
        LOCATION.pathT("fillBapiLogonData", EXITING);
    }

    private void processOptions(SAPBasis sapBasis, Properties pOptions, StringBuffer description) throws Exception {
        String confVal;
        String method = "processOptions";
        LOCATION.pathT("processOptions", ENTERING);
        LOCATION.debugT("processOptions", METHOD_PARAM + "sapBasis = " + sapBasis + METHOD_PARAM + "pOptions = " + pOptions + METHOD_PARAM + "description = " + description);
        String string = confVal = pOptions != null ? pOptions.getProperty("logcategory") : null;
        if (confVal != null && !"".equals(confVal)) {
            this.m_category = Category.getCategory((String)confVal);
        }
        description.append("\n   Log Category: ");
        description.append(this.m_category.getName());
        this.m_loginHandler = this.getLoginHandler(sapBasis);
        description.append("\n   Login Handler: " + this.m_loginHandler);
        confVal = pOptions != null ? pOptions.getProperty("timezonemap") : null;
        InputStream is = null;
        Properties pTimeZones = new Properties();
        if (confVal != null && !"".equals(confVal)) {
            is = new BufferedInputStream(new FileInputStream(confVal));
            description.append("\n   Time Zone Map: " + confVal);
        } else {
            is = this.getClass().getResourceAsStream("/properties/timezone.properties");
            description.append("\n   Time Zone Map: built-in");
        }
        pTimeZones.load(is);
        is.close();
        this.m_timeZoneHandler = new MappingTimeZoneStrategy(pTimeZones);
        this.m_timeStampSupported = this.isTimeStampSupported(sapBasis);
        description.append("\n   Time Stamp Support: " + this.m_timeStampSupported);
        this.m_searchHandler = this.getSearchHandler(sapBasis);
        description.append("\n   Search Handler: " + this.m_searchHandler);
        String string2 = confVal = pOptions != null ? pOptions.getProperty("referenceuser") : null;
        if (confVal != null && !"".equals(confVal)) {
            confVal = StandAloneUtil.charWiseUpperCase(confVal);
            this.checkReferenceUser(sapBasis, confVal);
            this.m_referenceUser = confVal;
        } else {
            this.m_referenceUser = null;
        }
        description.append("\n   Reference User: " + this.m_referenceUser + "\n");
        LOCATION.pathT("processOptions", EXITING);
    }

    private R3User getUser(JCO.Client client, String uniqueID, String ticket) throws Exception {
        String method = "getUser";
        LOCATION.pathT("getUser", ENTERING);
        LOCATION.debugT("getUser", METHOD_PARAM + "client = " + client + METHOD_PARAM + "uniqueID = " + uniqueID + METHOD_PARAM + "ticket = " + NOT_SHOWN);
        uniqueID = StandAloneUtil.charWiseUpperCase(uniqueID.trim());
        HashMap<String, Object> databag = new HashMap<String, Object>();
        databag.put("m_uniqueid", uniqueID);
        if (ticket != null) {
            databag.put("SAPLogonTicket", ticket);
        }
        this.execBapiUserGetDetail(client, uniqueID, databag, 1);
        this.execFsusrGetTimeStamp(client, uniqueID, databag);
        try {
            this.execSusrLoginCheckRfc(client, uniqueID, null);
        }
        catch (JCO.AbapException ae) {
            if ("PASSWORD_EXPIRED".equals(ae.getKey())) {
                databag.put("m_pwchangerequired", Boolean.TRUE);
            }
            if ("USER_LOCKED".equals(ae.getKey())) {
                databag.put("m_locked", Boolean.TRUE);
            }
            if ("NO_CHECK_FOR_THIS_USER".equals(ae.getKey())) {
                LOCATION.debugT("getUser", "Password status of account " + uniqueID + " cannot be retrieved from ABAP: " + R3UserFactory.t2s(ae));
            }
            throw ae;
        }
        R3User r3user = new R3User(this, this.m_key);
        r3user.update(databag);
        r3user.getImplicitUserAccount().update(databag);
        LOCATION.pathT("getUser", EXITING);
        LOCATION.debugT("getUser", RETURN_VAL + "R3User " + r3user);
        return r3user;
    }

    private void checkInitialized() throws Exception {
        String method = "checkInitialized";
        LOCATION.pathT("checkInitialized", ENTERING);
        if (!this.m_initialized) {
            throw new UMException("This factory instance is not intialized. Call initialize(java.util.Properties) first.");
        }
        LOCATION.pathT("checkInitialized", EXITING);
    }

    private ISearch getSearchHandler(SAPBasis sapBasis) throws Exception {
        String method = "getSearchHandler";
        LOCATION.pathT("getSearchHandler", ENTERING);
        LOCATION.debugT("getSearchHandler", METHOD_PARAM + "sapBasis = " + sapBasis);
        boolean searchSupported = false;
        ISearch search = null;
        try {
            searchSupported = sapBasis.getRepository().getFunctionInterface("SUSR_BAPI_F4_AUTHORITY") != null;
        }
        catch (JCO.Exception e) {
            LOCATION.debugT("getSearchHandler", "Getting the function interface of SUSR_BAPI_F4_AUTHORITY resulted in an exception: " + R3UserFactory.t2s(e));
        }
        if (searchSupported) {
            search = new BapiHVGetSearch(this, sapBasis);
            String msg = "Searching for user and account data: ENABLED";
            LOCATION.infoT(this.m_category, "getSearchHandler", msg);
        } else {
            search = new NoUserSearch();
            String msg = "Searching for user and account data: DISABLED";
            LOCATION.warningT(this.m_category, "getSearchHandler", msg);
        }
        LOCATION.pathT("getSearchHandler", EXITING);
        LOCATION.debugT("getSearchHandler", RETURN_VAL + "ISearch " + search);
        return search;
    }

    private LoginCheck getLoginHandler(SAPBasis sapBasis) throws Exception {
        String method = "getLoginHandler";
        LOCATION.pathT("getLoginHandler", ENTERING);
        LOCATION.debugT("getLoginHandler", METHOD_PARAM + "sapBasis = " + sapBasis);
        LoginCheck loginHandler = null;
        try {
            IMetaData functionInterface = sapBasis.getRepository().getFunctionInterface("SUSR_CHECK_LOGON_DATA");
            if (functionInterface == null) {
                throw new Exception();
            }
            loginHandler = new ServiceUserLoginCheck(sapBasis);
            String msg = "Login check: via function module";
            LOCATION.infoT(this.m_category, "getLoginHandler", msg);
        }
        catch (Exception e) {
            LOCATION.debugT("getLoginHandler", "Getting the function interface of SUSR_CHECK_LOGON_DATA resulted in an exception: " + R3UserFactory.t2s(e));
            String msg = "Login check: via RfcOpenEx";
            loginHandler = new RfcOpenLoginCheck(sapBasis);
            LOCATION.infoT(this.m_category, "getLoginHandler", msg);
        }
        LOCATION.pathT("getLoginHandler", EXITING);
        LOCATION.debugT("getLoginHandler", "LoginCheck " + loginHandler);
        return loginHandler;
    }

    private boolean isTimeStampSupported(SAPBasis sapBasis) throws Exception {
        String method = "isTimeStampSupported";
        LOCATION.pathT("isTimeStampSupported", ENTERING);
        LOCATION.debugT("isTimeStampSupported", METHOD_PARAM + "sapBasis = " + sapBasis);
        JCO.Client client = null;
        boolean timeStampSupported = false;
        try {
            block5: {
                try {
                    IFunctionTemplate template = sapBasis.getRepository().getFunctionTemplate("FSUSR_GET_TIMESTAMP");
                    if (template == null) break block5;
                    JCO.Function function = template.getFunction();
                    function.getImportParameterList().setValue("DUMMY", "USERNAME");
                    client = sapBasis.getPoolManager().getClient(sapBasis.getPoolID());
                    client.execute(function);
                    timeStampSupported = true;
                }
                catch (JCO.Exception e) {
                    LOCATION.debugT("isTimeStampSupported", "Test execution of function module FSUSR_GET_TIMESTAMP resulted in an exception: " + R3UserFactory.t2s(e));
                    if ("USERNAME_ERROR".equals(e.getKey())) {
                        timeStampSupported = true;
                    }
                    Object var8_9 = null;
                    sapBasis.releaseClient(client);
                }
            }
            Object var8_8 = null;
            sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            sapBasis.releaseClient(client);
            throw throwable;
        }
        String msg = null;
        msg = timeStampSupported ? "User time stamps: ENABLED" : "User time stamps: DISABLED";
        LOCATION.infoT(this.m_category, "isTimeStampSupported", msg);
        LOCATION.pathT("isTimeStampSupported", EXITING);
        LOCATION.debugT("isTimeStampSupported", RETURN_VAL + "boolean " + timeStampSupported);
        return timeStampSupported;
    }

    private void checkReferenceUser(SAPBasis sapBasis, String uniqueID) throws Exception {
        String method = "checkReferenceUser";
        LOCATION.pathT("checkReferenceUser", ENTERING);
        LOCATION.debugT("checkReferenceUser", METHOD_PARAM + "sapBasis = " + sapBasis + METHOD_PARAM + "uniqueID = " + uniqueID);
        JCO.Client client = null;
        try {
            client = sapBasis.getClient();
            if (!this.execBapiUserExistenceCheck(client, uniqueID)) {
                throw new UMException("Reference user " + uniqueID + " does not exist");
            }
            Object var6_5 = null;
            sapBasis.releaseClient(client);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            sapBasis.releaseClient(client);
            throw throwable;
        }
        LOCATION.pathT("checkReferenceUser", EXITING);
    }

    private void handleBapiRet2Table(String callingMethod, String rfcFunc, JCO.Table tabBapiRet2) throws Exception {
        boolean warningOccured = false;
        int i = 0;
        while (i < tabBapiRet2.getNumRows()) {
            tabBapiRet2.setRow(i);
            String msgType = tabBapiRet2.getString("TYPE");
            if ("E".equals(msgType) || "A".equals(msgType)) {
                LOCATION.errorT(callingMethod, "Errors during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.table2s(tabBapiRet2));
                String msgNum = tabBapiRet2.getString("NUMBER");
                String msg = tabBapiRet2.getString("MESSAGE");
                if (NO_SUCH_USER_MSGNO.equals(msgNum)) {
                    throw new NoSuchUserException(msg);
                }
                if (USER_EXISTS_MSGNO.equals(msgNum)) {
                    throw new UserAlreadyExistsException(msg);
                }
                throw new UMException(msg);
            }
            if ("W".equals(msgType)) {
                warningOccured = true;
            }
            ++i;
        }
        if (warningOccured) {
            LOCATION.warningT(callingMethod, "Warnings during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.table2s(tabBapiRet2));
        }
    }

    private void handleBapiRet2Struct(String callingMethod, String rfcFunc, JCO.Structure structBapiRet2) throws Exception {
        String msgType = structBapiRet2.getString("TYPE");
        if ("E".equals(msgType) || "A".equals(msgType)) {
            LOCATION.errorT(callingMethod, "Errors during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.record2s((JCO.Record)structBapiRet2));
            String msgNum = structBapiRet2.getString("NUMBER");
            String msg = structBapiRet2.getString("MESSAGE");
            if (NO_SUCH_USER_MSGNO.equals(msgNum)) {
                throw new NoSuchUserException(msg);
            }
            if (USER_EXISTS_MSGNO.equals(msgNum)) {
                throw new UserAlreadyExistsException(msg);
            }
            throw new UMException(msg);
        }
        if ("W".equals(msgType)) {
            LOCATION.warningT(callingMethod, "Warnings during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.record2s((JCO.Record)structBapiRet2));
        }
    }

    private void handleBapiReturnStruct(String callingMethod, String rfcFunc, JCO.Structure structBapiReturn) throws Exception {
        String msgType = structBapiReturn.getString("TYPE");
        if ("E".equals(msgType) || "A".equals(msgType)) {
            LOCATION.errorT(callingMethod, "Errors during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.record2s((JCO.Record)structBapiReturn));
            throw new UMException(structBapiReturn.getString("MESSAGE"));
        }
        if ("W".equals(msgType)) {
            LOCATION.warningT(callingMethod, "Warnings during execution of " + rfcFunc + " in system " + this.m_sapBasis + EOL + R3UserFactory.record2s((JCO.Record)structBapiReturn));
        }
    }

    private void handleUMExceptionMethod(String callingMethod, Exception e) throws UMException {
        LOCATION.errorT(callingMethod, "Caught Exception: " + R3UserFactory.t2s(e));
        if (e instanceof UMException) {
            LOCATION.errorT(callingMethod, "Rethrowing original UMException");
            throw (UMException)e;
        }
        UMNestedException ume = new UMNestedException(e);
        LOCATION.errorT(callingMethod, "Throwing new nested UMException: " + R3UserFactory.t2s(ume));
        throw ume;
    }

    private void handleCertificateExceptionUMExceptionMethod(String callingMethod, Exception e) throws CertificateException, UMException {
        LOCATION.errorT(callingMethod, "Caught Exception: " + R3UserFactory.t2s(e));
        if (e instanceof CertificateException) {
            LOCATION.errorT(callingMethod, "Rethrowing original CertificateException");
            throw (CertificateException)e;
        }
        if (e instanceof UMException) {
            LOCATION.errorT(callingMethod, "Rethrowing original UMException");
            throw (UMException)e;
        }
        UMNestedException ume = new UMNestedException(e);
        LOCATION.errorT(callingMethod, "Throwing new nested UMException: " + R3UserFactory.t2s(ume));
        throw ume;
    }

    private void handleNoSuchUserExceptionMethod(String callingMethod, Exception e) throws NoSuchUserException, RuntimeException {
        LOCATION.errorT(callingMethod, "Caught Exception: " + R3UserFactory.t2s(e));
        if (e instanceof NoSuchUserException) {
            LOCATION.errorT(callingMethod, "Rethrowing original NoSuchUserException");
            throw (NoSuchUserException)e;
        }
        UMRuntimeException re = new UMRuntimeException(e);
        LOCATION.errorT(callingMethod, "Throwing new UMRuntimeException: " + R3UserFactory.t2s(re));
        throw re;
    }

    private void handleNoExceptionMethod(String callingMethod, Exception e) throws RuntimeException {
        LOCATION.errorT(callingMethod, "Caught Exception: " + R3UserFactory.t2s(e));
        if (e instanceof RuntimeException) {
            LOCATION.errorT(callingMethod, "Rethrowing original RuntimeException");
            throw (RuntimeException)e;
        }
        UMRuntimeException re = new UMRuntimeException(e);
        LOCATION.errorT(callingMethod, "Throwing new UMRuntimeException: " + R3UserFactory.t2s(re));
        throw re;
    }

    private static String table2s(JCO.Table table) {
        StringBuffer sb = new StringBuffer();
        int rowIn = table.getRow();
        sb.append("Table: ");
        sb.append(table.getName());
        sb.append(EOL);
        int i = 0;
        while (i < table.getNumRows()) {
            table.setRow(i);
            sb.append(i).append(':');
            sb.append(R3UserFactory.record2s((JCO.Record)table));
            sb.append(EOL);
            ++i;
        }
        table.setRow(rowIn);
        return sb.toString();
    }

    private static String record2s(JCO.Record record) {
        StringBuffer sb = new StringBuffer();
        JCO.FieldIterator iter = record.fields();
        boolean enumNotEmpty = iter.hasMoreElements();
        sb.append('[');
        while (iter.hasMoreElements()) {
            JCO.Field field = iter.nextField();
            sb.append(field.getName());
            sb.append('=');
            sb.append(field.getValue());
            sb.append(", ");
        }
        if (enumNotEmpty) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    private static String t2s(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static String a2s(Object[] ao) {
        if (null == ao) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(ao).append(EOL);
        sb.append('{').append(EOL);
        int i = 0;
        while (i < ao.length) {
            sb.append("  [").append(i).append("] ").append(ao[i]).append(EOL);
            ++i;
        }
        sb.append('}').append(EOL);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION.debugT("<clinit>", VERSION);
    }
}

