/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.um.r3.ModifyTracker;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserFactory;
import com.sap.security.usermanagement.FeatureNotAvailableException;
import com.sap.security.usermanagement.IUnique;
import com.sap.security.usermanagement.IUserAccount;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UMRuntimeException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;

public class R3UserAccount
implements Serializable,
IUserAccount,
IUnique {
    static final String VALIDFROM = "m_validfrom";
    static final String VALIDTO = "m_validto";
    static final String PWCHANGEREQUIRED = "m_pwchangerequired";
    static final String LOCKED = "m_locked";
    static final Date DATE_NOT_SUPPORTED = new Date(Long.MAX_VALUE);
    private R3User m_implicitUser;
    private transient String m_oldpw;
    private transient String m_initialpw;
    private transient String m_productivepw;
    private final ModifyTracker m_validfrom = new ModifyTracker(null, null);
    private final ModifyTracker m_validto = new ModifyTracker(null, null);
    private final ModifyTracker m_locked = new ModifyTracker(null, Boolean.FALSE);
    private boolean m_pwchangerequired = false;

    public R3UserAccount(R3User implicitUser) {
        this.m_implicitUser = implicitUser;
    }

    public R3User getImplicitUser() {
        return this.m_implicitUser;
    }

    public Date getValidFromDate() {
        return (Date)this.m_validfrom.getValue();
    }

    public void setValidFromDate(Date validFrom) {
        this.m_validfrom.setValue(validFrom);
    }

    public Date getValidToDate() {
        return (Date)this.m_validto.getValue();
    }

    public void setValidToDate(Date validTo) {
        this.m_validto.setValue(validTo);
    }

    public boolean isPasswordChangeRequired() {
        return this.m_pwchangerequired;
    }

    public void setPassword(String initialPassword) {
        this.clearPasswords();
        if (initialPassword != null) {
            this.m_initialpw = initialPassword;
            this.m_pwchangerequired = true;
        }
    }

    public void setPassword(String oldPassword, String newPassword) {
        this.clearPasswords();
        if (oldPassword != null) {
            this.m_oldpw = oldPassword;
            this.m_pwchangerequired = false;
        }
        if (newPassword != null) {
            this.m_productivepw = newPassword;
        }
    }

    String getInitialPassword() {
        return this.m_initialpw;
    }

    String getOldPassword() {
        return this.m_oldpw;
    }

    String getProductivePassword() {
        return this.m_productivepw;
    }

    void clearPasswords() {
        this.m_initialpw = null;
        this.m_oldpw = null;
        this.m_productivepw = null;
    }

    void update(Map updatedValues) {
        if (updatedValues.containsKey(LOCKED)) {
            this.m_locked.reset(updatedValues.get(LOCKED));
        }
        if (updatedValues.containsKey(VALIDFROM)) {
            this.m_validfrom.reset(updatedValues.get(VALIDFROM));
        }
        if (updatedValues.containsKey(VALIDTO)) {
            this.m_validto.reset(updatedValues.get(VALIDTO));
        }
        if (updatedValues.containsKey(PWCHANGEREQUIRED)) {
            this.m_pwchangerequired = (Boolean)updatedValues.get(PWCHANGEREQUIRED);
        }
    }

    boolean isModified(String fieldname) {
        try {
            Object o = this.getClass().getDeclaredField(fieldname).get(this);
            if (o instanceof ModifyTracker) {
                return ((ModifyTracker)o).isModified();
            }
            return false;
        }
        catch (Exception e) {
            throw new UMRuntimeException(e, "while trying to check if field \"" + fieldname + "\" is modified");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + ":\n");
        sb.append("   Logon Uid:                \"" + this.getLogonUid() + "\"\n");
        sb.append("   Locked:                   \"" + this.m_locked + "\"\n");
        sb.append("   Valid From:               \"" + this.m_validfrom + "\"\n");
        sb.append("   Valid To:                 \"" + this.m_validto + "\"\n");
        sb.append("   Password Change Required: \"" + this.m_pwchangerequired + "\"\n");
        return sb.toString();
    }

    public String getUniqueID() {
        return this.m_implicitUser.getUniqueID();
    }

    public Date created() {
        return this.m_implicitUser.created();
    }

    public Date lastModified() {
        return this.m_implicitUser.lastModified();
    }

    public String getLogonUid() {
        return this.m_implicitUser.getDisplayName();
    }

    public boolean isLocked() {
        return (Boolean)this.m_locked.getValue();
    }

    public void setLocked(boolean lock, int reason) {
        this.m_locked.setValue(new Boolean(lock));
    }

    public int getLockReason() {
        throw new FeatureNotAvailableException("getLockReason() is not available in this implementation");
    }

    public Date getLastFailedLogonDate() {
        throw new FeatureNotAvailableException("getLastFailedLogonDate() is not available in this implementation");
    }

    public void setLastFailedLogonDate(Date timeStamp) {
        throw new FeatureNotAvailableException("setLastFailedLogonDate() is not available in this implementation");
    }

    public int getFailedLogonAttempts() {
        throw new FeatureNotAvailableException("getFailedLogonAttempts() is not available in this implementation");
    }

    public void setFailedLogonAttempts(int i) {
        throw new FeatureNotAvailableException("getFailedLogonAttempts() is not available in this implementation");
    }

    public void incrementFailedLogonAttempts() {
        throw new FeatureNotAvailableException("incrementFailedLogonAttempts() is not available in this implementation");
    }

    public void resetFailedLogonAttempts() {
        throw new FeatureNotAvailableException("resetFailedLogonAttempts() is not available in this implementation");
    }

    public Date getLastSuccessfulLogonDate() {
        throw new FeatureNotAvailableException("getLastSuccessfulLogonDate() is not available in this implementation");
    }

    public void setLastSuccessfulLogonDate(Date timeStamp) {
        throw new FeatureNotAvailableException("setLastSuccessfulLogonDate() is not available in this implementation");
    }

    public int getSuccessfulLogonCounts() {
        throw new FeatureNotAvailableException("getSuccessfulLogonCounts() is not available in this implementation");
    }

    public void incrementSuccessfulLogonCounts() {
        throw new FeatureNotAvailableException("incrementSuccessfulLogonCounts() is not available in this implementation");
    }

    public void setSuccessfulLogonCounts(int i) {
        throw new FeatureNotAvailableException("setSuccessfulLogonCounts() is not available in this implementation");
    }

    public Date getLastPasswordChangedDate() {
        throw new FeatureNotAvailableException("getLastPasswordChangedDate() is not available in this implementation");
    }

    public void setPasswordChangeRequired(boolean chng) {
        throw new FeatureNotAvailableException("setPasswordChangeRequired() is not available in this implementation");
    }

    public void save() {
    }

    public void delete() throws UMException {
        R3UserFactory factory = (R3UserFactory)this.m_implicitUser.getUserFactory();
        factory.deleteUser(this.m_implicitUser.getUniqueID());
    }

    public X509Certificate[] getCertificates() {
        throw new FeatureNotAvailableException("getCertificates() is not available in this implementation");
    }

    public void setCertificates(X509Certificate[] certificate) {
        throw new FeatureNotAvailableException("getCertificates() is not available in this implementation");
    }

    public boolean checkPassword(String password) {
        R3UserFactory factory = (R3UserFactory)this.m_implicitUser.getUserFactory();
        return factory.checkPassword(this.getLogonUid(), password);
    }

    public void prepare() {
    }

    public void commit() throws UMException {
        R3UserFactory factory = (R3UserFactory)this.m_implicitUser.getUserFactory();
        factory.commitAccount(this);
    }

    public void rollback() {
    }

    public void setApprove(boolean approved, String companyname) {
        throw new FeatureNotAvailableException("setApprove() is not available in this implementation");
    }
}

